/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.targetScheme;

import java.util.Collection;
import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class TargetSchemeSaveOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.saveMemberQuote(e.getDataEntities());
    }

    private void saveMemberQuote(DynamicObject[] targetSchemes) {
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        IModelCacheHelper modelCache = null;
        for (DynamicObject _targetScheme : targetSchemes) {
            String accountIds;
            String periodIds;
            Object[] ids;
            String ctIds;
            Long currencyId;
            Long atId;
            Long versionId;
            Dimension dimension;
            Long schemeId = _targetScheme.getLong("id");
            Long modelId = _targetScheme.getLong("model_id");
            if (modelCache == null || modelId.compareTo(modelCache.getModelobj().getId()) != 0) {
                modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            }
            Long bizModelId = _targetScheme.getLong("bizmodel_id");
            Long dtId = _targetScheme.getLong("datatype_id");
            if (IDUtils.isNotNull((Long)dtId)) {
                dimension = modelCache.getDimension(SysDimensionEnum.DataType.getNumber());
                quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), dtId, MemberQuoteResourceEnum.TargetScheme, schemeId));
            }
            if (IDUtils.isNotNull((Long)(versionId = Long.valueOf(_targetScheme.getLong("version_id"))))) {
                dimension = modelCache.getDimension(SysDimensionEnum.Version.getNumber());
                quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), versionId, MemberQuoteResourceEnum.TargetScheme, schemeId));
            }
            if (IDUtils.isNotNull((Long)(atId = Long.valueOf(_targetScheme.getLong("audittrail_id"))))) {
                dimension = modelCache.getDimension(SysDimensionEnum.AuditTrail.getNumber());
                quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), atId, MemberQuoteResourceEnum.TargetScheme, schemeId));
            }
            if (IDUtils.isNotNull((Long)(currencyId = Long.valueOf(_targetScheme.getLong("currency_id"))))) {
                dimension = modelCache.getDimension(SysDimensionEnum.Currency.getNumber());
                quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), currencyId, MemberQuoteResourceEnum.TargetScheme, schemeId));
            }
            if (StringUtils.isNotEmpty((String)(ctIds = _targetScheme.getString("changetype")))) {
                dimension = modelCache.getDimension(SysDimensionEnum.ChangeType.getNumber());
                ids = ctIds.split(",");
                if (ids.length > 0) {
                    quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), (Collection)IDUtils.toLongs((Object[])ids), MemberQuoteResourceEnum.TargetScheme, schemeId));
                }
            }
            if (StringUtils.isNotEmpty((String)(periodIds = _targetScheme.getString("budgetperiod")))) {
                dimension = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                ids = periodIds.split(",");
                if (ids.length > 0) {
                    quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), (Collection)IDUtils.toLongs((Object[])ids), MemberQuoteResourceEnum.TargetScheme, schemeId));
                }
            }
            if (!StringUtils.isNotEmpty((String)(accountIds = _targetScheme.getString("account")))) continue;
            dimension = modelCache.getDimension(SysDimensionEnum.Account.getNumber());
            ids = periodIds.split(",");
            if (ids.length <= 0) continue;
            quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), (Collection)IDUtils.toLongs((Object[])ids), MemberQuoteResourceEnum.TargetScheme, schemeId));
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }
}

