/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.task;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.NameCheckUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;

public abstract class AbstractBgValidator
extends AbstractValidator {
    private String entityNumber = null;
    private boolean checkNumber = true;
    private boolean checkName = true;

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setCheckNumber(boolean checkNumber) {
        this.checkNumber = checkNumber;
    }

    public boolean isCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckName(boolean checkName) {
        this.checkName = checkName;
    }

    public boolean isCheckName() {
        return this.checkName;
    }

    public void validate() {
        this.setEntityInfo();
        if (this.isCheckNumber()) {
            this.checkNumber();
        }
        if (this.isCheckName()) {
            this.checkName();
        }
    }

    protected abstract void setEntityInfo();

    protected void checkNumber() {
        if (StringUtils.isEmpty((String)this.getEntityNumber())) {
            throw new NullPointerException("entityNumber is null.");
        }
        StringBuilder msg = new StringBuilder();
        ExtendedDataEntity[] datas = this.getDataEntities();
        if (datas != null && datas.length > 0) {
            boolean exist;
            DynamicObject obj = datas[0].getDataEntity();
            String check = this.checkNumberRule(obj);
            if (StringUtils.isNotEmpty((String)check)) {
                msg.append(check);
            }
            if (msg.length() == 0 && (exist = this.checkNumber(this.getEntityNumber(), obj))) {
                msg.append(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractBgValidator_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }

    protected String checkNumberRule(DynamicObject obj) {
        if (obj == null) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractBgValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[0]);
        }
        return NumberCheckUtils.checkNumberRule((String)obj.getString("number"));
    }

    protected boolean checkNumber(String entityNumber, DynamicObject obj) {
        if (StringUtils.isEmpty((String)entityNumber) || obj == null) {
            return true;
        }
        Long id = obj.getLong("id");
        String number = obj.getString("number");
        return NumberCheckUtils.checkNumberExist((String)this.getEntityNumber(), (String)number, (String)String.valueOf(id));
    }

    protected void checkName() {
        if (StringUtils.isEmpty((String)this.getEntityNumber())) {
            throw new NullPointerException("entityNumber is null.");
        }
        StringBuilder msg = new StringBuilder();
        ExtendedDataEntity[] datas = this.getDataEntities();
        if (datas != null && datas.length > 0) {
            boolean exist;
            DynamicObject obj = datas[0].getDataEntity();
            if (obj == null || StringUtils.isEmpty((String)obj.getString("name"))) {
                msg.append(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"AbstractBgValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (msg.length() == 0 && (exist = this.checkName(obj))) {
                msg.append(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractBgValidator_3", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }

    protected boolean checkName(DynamicObject obj) {
        Long id = obj.getLong("id");
        String name = obj.getString("name");
        return NameCheckUtils.checkNameExist((String)this.getEntityNumber(), (Long)id, (String)name);
    }
}

