/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.task;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.task.BgTaskServiceHelper;
import kd.epm.eb.opplugin.task.AbstractBgValidator;

public class TaskValidator
extends AbstractBgValidator {
    @Override
    public void validate() {
        super.validate();
        this.checkTime();
        this.checkRely();
        this.checkRefTemplate();
    }

    @Override
    protected void setEntityInfo() {
        this.setEntityNumber("eb_task");
    }

    @Override
    protected String checkNumberRule(DynamicObject obj) {
        if (obj != null && StringUtils.isEmpty((String)obj.getString("number"))) {
            obj.set("number", (Object)("BgTask-" + System.currentTimeMillis()));
        }
        return super.checkNumberRule(obj);
    }

    @Override
    protected boolean checkNumber(String entityNumber, DynamicObject obj) {
        if (StringUtils.isEmpty((String)entityNumber) || obj == null) {
            return true;
        }
        Long id = obj.getLong("id");
        Long taskPackId = obj.getLong("tasklist.id");
        String number = obj.getString("number");
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("tasklist", "=", (Object)taskPackId));
        builder.add(new QFilter("number", "=", (Object)number));
        return NumberCheckUtils.checkNumberExist((String)this.getEntityNumber(), (QFilter[])builder.toArrays(), (Long)id);
    }

    protected void checkTime() {
        ExtendedDataEntity[] datas;
        DynamicObject task = null;
        Long taskId = null;
        Date begin = null;
        Date deadline = null;
        Date currDate = CalendarHelper.clearTime((Date)new Date());
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            task = data.getDataEntity();
            taskId = task.getLong("id");
            begin = CalendarHelper.clearTime((Date)task.getDate("begintime"));
            deadline = CalendarHelper.clearTime((Date)task.getDate("deadline"));
            if (!taskId.equals(0L)) {
                Date oldBegin = this.getOldBeginTime(taskId);
                if (begin.compareTo(currDate) >= 0 || begin.compareTo(oldBegin) >= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u5c0f\u4e8e\u65e7\u5f00\u59cb\u65e5\u671f\u548c\u5f53\u524d\u65e5\u671f", (String)"TaskValidator_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (deadline.compareTo(begin) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f", (String)"TaskValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (begin.compareTo(currDate) >= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f", (String)"TaskValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }

    protected Date getOldBeginTime(Long taskId) {
        DynamicObject oldTask = QueryServiceHelper.queryOne((String)"eb_task", (String)"id,number,begintime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (oldTask != null) {
            return oldTask.getDate("begintime");
        }
        return null;
    }

    protected void checkRely() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        Long taskPackId = 0L;
        DynamicObject _task = null;
        DynamicObjectCollection _relys = null;
        HashMap<Long, HashMap<Object, DynamicObject>> taskPackMap = new HashMap<Long, HashMap<Object, DynamicObject>>();
        HashMap<Object, DynamicObject> taskMap = null;
        for (ExtendedDataEntity data : datas) {
            _task = data.getDataEntity();
            _relys = _task.getDynamicObjectCollection("relytasks");
            if (_relys == null || _relys.isEmpty()) continue;
            taskPackId = _task.getDynamicObject("tasklist").getLong("id");
            taskMap = (HashMap<Object, DynamicObject>)taskPackMap.get(taskPackId);
            if (taskMap == null) {
                taskMap = new HashMap<Object, DynamicObject>();
                taskPackMap.put(taskPackId, taskMap);
                Map _tmpMap = BgTaskServiceHelper.loadFromCache((Long)taskPackId, (String)"id, relytasks");
                if (_tmpMap != null) {
                    taskMap.putAll(_tmpMap);
                }
            }
            this.checkRely(_task, null, taskMap, new HashSet<Long>());
        }
    }

    private void checkRely(DynamicObject task, DynamicObject parent, Map<Object, DynamicObject> taskMap, Set<Long> taskIds) {
        if (task == null || taskMap == null || taskIds == null) {
            return;
        }
        if (taskIds.contains(task.getLong("id"))) {
            if (parent != null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u4e0e  (%1 : %2) \u7684\u4efb\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5", (String)"TaskValidator_7", (String)"epm-eb-opplugin", (Object[])new Object[]{parent.getString("number"), parent.getString("name")}));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskValidator_5", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        taskIds.add(task.getLong("id"));
        DynamicObjectCollection relys = task.getDynamicObjectCollection("relytasks");
        for (DynamicObject rely : relys) {
            DynamicObject _rely = taskMap.get(rely.getDynamicObject("fbasedataid").getLong("id"));
            this.checkRely(_rely, task, taskMap, taskIds);
        }
    }

    @Override
    protected boolean checkName(DynamicObject obj) {
        if (obj == null) {
            throw new NullPointerException("dynamic Object is null.");
        }
        Long id = obj.getLong("id");
        Long taskPackId = obj.getLong("tasklist.id");
        String name = obj.getString("name");
        if (StringUtils.isEmpty((String)name)) {
            throw new NullPointerException("name is null.");
        }
        boolean check = false;
        QFBuilder builder = new QFBuilder();
        if (id != null && id != 0L) {
            builder.add(new QFilter("id", "=", (Object)id));
            DynamicObjectCollection result = QueryServiceHelper.query((String)"eb_task", (String)"id", (QFilter[])builder.toArrays());
            check = result == null || result.size() == 0 ? false : (result.size() == 1 ? id.longValue() != ((DynamicObject)result.get(0)).getLong("id") : true);
        } else {
            builder.add(new QFilter("tasklist", "=", (Object)taskPackId));
            builder.add(new QFilter("name", "=", (Object)name));
            check = QueryServiceHelper.exists((String)"eb_task", (QFilter[])builder.toArrays());
        }
        return check;
    }

    protected void checkRefTemplate() {
        ExtendedDataEntity[] datas;
        DynamicObject task = null;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            task = data.getDataEntity();
            if (task.getDynamicObjectCollection("entryentity") != null && !task.getDynamicObjectCollection("entryentity").isEmpty()) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u62a5\u8868\u6a21\u677f", (String)"TaskValidator_6", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }
}

