/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.taskflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.event.NodeUpdateEvent;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.taskflow.TaskTransRelation;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.taskflow.graph.TaskFlowNode;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.opplugin.taskflow.TaskFlowSaveValidator;

public class TaskFlowSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(TaskFlowSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskFlowSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        TaskFlowGraph taskFlowGraph = TaskFlowServiceHelper.getTaskFlowGraph((DynamicObject)dataEntity);
        Collection values = taskFlowGraph.getNodeMap().values();
        for (TaskFlowNode node : values) {
            if (node.isStartNode() || node.isEndNode()) continue;
            List nodePreRelLine = taskFlowGraph.getNodePreRelLine(node.getNumber());
            List nextLineByNode = taskFlowGraph.getNextLineByNode(node.getNumber());
            if (!CollectionUtils.isEmpty((Collection)nodePreRelLine) && !CollectionUtils.isEmpty((Collection)nextLineByNode)) continue;
            DynamicObjectCollection nodeEntry = dataEntity.getDynamicObjectCollection("nodeentry");
            Optional<DynamicObject> findFirst = nodeEntry.stream().filter(n -> StringUtils.equals((String)node.getNumber(), (String)n.getString("nodenumber"))).findFirst();
            if (findFirst.isPresent()) {
                if (CollectionUtils.isEmpty((Collection)nodePreRelLine)) {
                    e.setCancelMessage(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4efb\u52a1\u8282\u70b9\u672a\u7ef4\u62a4\u8f6c\u6362\u5173\u7cfb\u5173\u8054\u524d\u7f6e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskFlowSaveOp_1", (String)"epm-eb-opplugin", (Object[])new Object[]{findFirst.get().getInt("seq")}));
                } else if (CollectionUtils.isEmpty((Collection)nextLineByNode)) {
                    e.setCancelMessage(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4efb\u52a1\u8282\u70b9\u672a\u7ef4\u62a4\u8f6c\u6362\u5173\u7cfb\u5173\u8054\u540e\u7f6e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskFlowSaveOp_2", (String)"epm-eb-opplugin", (Object[])new Object[]{findFirst.get().getInt("seq")}));
                }
            }
            e.setCancel(true);
        }
        log.info("taskFlowGraph: " + SerializationUtils.toJsonString((Object)taskFlowGraph));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        if (!dataEntity.getBoolean("status")) {
            return;
        }
        TaskFlowGraph oldTaskFlowGraph = this.getOldTaskFlowGraph(dataEntity);
        TaskFlowGraph taskFlowGraph = TaskFlowServiceHelper.getTaskFlowGraph((DynamicObject)dataEntity);
        if (oldTaskFlowGraph != null && !oldTaskFlowGraph.isStatus() && dataEntity.getBoolean("status")) {
            TaskFlowServiceHelper.startTaskFlow((TaskFlowGraph)taskFlowGraph);
        } else {
            this.doNodeUpdate(oldTaskFlowGraph, taskFlowGraph);
        }
        dataEntity.set("oldtaskflowgraph", (Object)SerializationUtils.toJsonString((Object)taskFlowGraph));
    }

    private void doNodeUpdate(TaskFlowGraph oldTaskFlowGraph, TaskFlowGraph taskFlowGraph) {
        Map<String, List<NodeInstance>> upNodeInstances = this.getUpdateNodeInstances(oldTaskFlowGraph, taskFlowGraph);
        List<String> upLineKeys = this.getUpdateLineKeys(oldTaskFlowGraph, taskFlowGraph);
        if (upNodeInstances.isEmpty() && upLineKeys.isEmpty()) {
            return;
        }
        NodeUpdateEvent nodeUpdateEvent = new NodeUpdateEvent();
        nodeUpdateEvent.setFlowId(taskFlowGraph.getId());
        nodeUpdateEvent.setFirstSave(oldTaskFlowGraph == null);
        nodeUpdateEvent.setCheckInstance(true);
        nodeUpdateEvent.setUpNodeInstances(upNodeInstances);
        nodeUpdateEvent.setUpLineKeys(upLineKeys);
        TaskFlowServiceHelper.executeTaskFlowNodeUpdate((NodeUpdateEvent)nodeUpdateEvent);
    }

    private Map<String, List<NodeInstance>> getUpdateNodeInstances(TaskFlowGraph oldTaskFlowGraph, TaskFlowGraph taskFlowGraph) {
        List<TaskFlowNode> updateNodes = this.getUpdateNodes(oldTaskFlowGraph, taskFlowGraph);
        Map<Long, Map<Long, Set<Long>>> taskToOrgProcessMap = this.getTaskToOrgProcessMap(updateNodes, taskFlowGraph);
        return TaskFlowServiceHelper.getNodeInstancesMap(taskToOrgProcessMap, updateNodes);
    }

    private Map<Long, Map<Long, Set<Long>>> getTaskToOrgProcessMap(List<TaskFlowNode> updateNodes, TaskFlowGraph taskFlowGraph) {
        HashSet subTaskIds = new HashSet(16);
        updateNodes.forEach(e -> {
            List ids = e.getSubTaskIds();
            if (ids != null) {
                subTaskIds.addAll(ids);
            }
        });
        return TaskFlowServiceHelper.getTaskToOrgProcessMap(subTaskIds, (Long)taskFlowGraph.getModelId(), (Long)taskFlowGraph.getYearId(), (Long)taskFlowGraph.getDataTypeId(), (Long)taskFlowGraph.getVersionId());
    }

    private List<TaskFlowNode> getUpdateNodes(TaskFlowGraph oldTaskFlowGraph, TaskFlowGraph taskFlowGraph) {
        if (oldTaskFlowGraph == null) {
            ArrayList<TaskFlowNode> taskFlowNodes = new ArrayList<TaskFlowNode>(taskFlowGraph.getNodeMap().values());
            taskFlowNodes.removeIf(e -> e.isStartNode() || e.isEndNode());
            return taskFlowNodes;
        }
        Map oldNodeMap = oldTaskFlowGraph.getNodeMap();
        Map newNodeMap = taskFlowGraph.getNodeMap();
        ArrayList<TaskFlowNode> updateNodeList = new ArrayList<TaskFlowNode>(10);
        oldNodeMap.forEach((nodeNum, node) -> {
            if (!newNodeMap.containsKey(nodeNum)) {
                node.setSubTaskIds(null);
                updateNodeList.add((TaskFlowNode)node);
            }
        });
        newNodeMap.forEach((nodeNum, node) -> {
            TaskFlowNode oldNode = (TaskFlowNode)oldNodeMap.get(nodeNum);
            if (oldNode == null) {
                updateNodeList.add((TaskFlowNode)node);
            } else {
                List oldNodeSubTaskIds = oldNode.getSubTaskIds();
                List subTaskIds = node.getSubTaskIds();
                if (!(oldNodeSubTaskIds == null || subTaskIds == null || oldNodeSubTaskIds.size() == subTaskIds.size() && subTaskIds.containsAll(oldNodeSubTaskIds))) {
                    updateNodeList.add((TaskFlowNode)node);
                }
            }
        });
        return updateNodeList;
    }

    private List<String> getUpdateLineKeys(TaskFlowGraph oldTaskFlowGraph, TaskFlowGraph taskFlowGraph) {
        if (oldTaskFlowGraph == null) {
            return new ArrayList<String>(0);
        }
        Map oldLineMap = oldTaskFlowGraph.getLineMap();
        Map lineMap = taskFlowGraph.getLineMap();
        ArrayList<String> upLineKeys = new ArrayList<String>(10);
        for (Map.Entry entry : lineMap.entrySet()) {
            String num = (String)entry.getKey();
            TaskFlowLine line = (TaskFlowLine)entry.getValue();
            TaskFlowLine oldLine = (TaskFlowLine)oldLineMap.get(num);
            if (oldLine == null) continue;
            TaskTransRelation transRelation = line.getTransRelation();
            TaskTransRelation oldTransRelation = oldLine.getTransRelation();
            if (transRelation == null && oldTransRelation == null) continue;
            if (transRelation != null && oldTransRelation != null) {
                if (StringUtils.equals((String)SerializationUtils.toJsonString((Object)transRelation.getDetailList()), (String)SerializationUtils.toJsonString((Object)oldTransRelation.getDetailList()))) continue;
                upLineKeys.add(line.getNumber());
                continue;
            }
            upLineKeys.add(line.getNumber());
        }
        return upLineKeys;
    }

    private TaskFlowGraph getOldTaskFlowGraph(DynamicObject dataEntity) {
        String oldTaskFlowGraph = dataEntity.getString("oldTaskFlowGraph");
        if (StringUtils.isNotEmpty((String)oldTaskFlowGraph)) {
            return (TaskFlowGraph)SerializationUtils.fromJsonString((String)oldTaskFlowGraph, TaskFlowGraph.class);
        }
        return null;
    }
}

