/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.taskflow;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;

public class TaskFlowSaveValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject dataEntity;
        ExtendedDataEntity extendedDataEntity = this.getDataEntities()[0];
        if (this.checkNumber(extendedDataEntity, dataEntity = extendedDataEntity.getDataEntity())) {
            return;
        }
        this.checkTaskFlowGraph(extendedDataEntity, dataEntity);
    }

    public boolean checkNumber(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        long id = dataEntity.getLong("id");
        long model_id = dataEntity.getLong("model_id");
        String number = dataEntity.getString("number");
        String name = dataEntity.getString("name");
        if (!CheckStringsUtil.checkAllowNumStart((String)number)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u7ec4\u6210\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TaskFlowSaveValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"eb_bgmtaskflow", (QFilter[])new QFilter("model", "=", (Object)model_id).and("number", "=", (Object)number).and("id", "!=", (Object)id).toArray())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TaskFlowSaveValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isEmpty((String)name)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskFlowSaveValidator_10", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkTaskFlowGraph(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObjectCollection nodeEntries = dataEntity.getDynamicObjectCollection("nodeentry");
        DynamicObjectCollection lineEntry = dataEntity.getDynamicObjectCollection("lineentry");
        List<DynamicObject> nodeEntry = nodeEntries.stream().filter(e -> StringUtils.isNotEmpty((String)e.getString("nodenumber"))).collect(Collectors.toList());
        if (nodeEntry.size() < 2) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u5236\u987a\u5e8f\u81f3\u5c11\u8bbe\u7f6e\u4e24\u4e2a\u8282\u70b9\u3002", (String)"TaskFlowSaveValidator_3", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (nodeEntry.stream().map(e -> e.getInt("orderseq")).distinct().count() == 1L) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u5236\u987a\u5e8f\u4e2d\u6267\u884c\u987a\u5e8f\u4e0d\u80fd\u5168\u90e8\u8bbe\u7f6e\u4e3a\u76f8\u540c\u7684\u3002", (String)"TaskFlowSaveValidator_6", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.checkSameNodes(nodeEntry)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u591a\u884c\u5206\u5f55\u5b50\u4efb\u52a1\u4e0d\u80fd\u5b8c\u5168\u91cd\u590d", (String)"TaskFlowSaveValidator_11", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        List noTaskRowIndex = nodeEntry.stream().filter(e -> CollectionUtils.isEmpty((Collection)e.getDynamicObjectCollection("subtasks"))).map(s -> s.getInt("seq")).collect(Collectors.toList());
        if (!noTaskRowIndex.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5b50\u4efb\u52a1\u672a\u8bbe\u7f6e\u3002", (String)"TaskFlowSaveValidator_12", (String)"epm-eb-opplugin", (Object[])new Object[]{StringUtils.join((Object[])noTaskRowIndex.toArray(), (String)",")}));
            return true;
        }
        return this.checkTaskLineValid(extendedDataEntity, nodeEntry, lineEntry);
    }

    private boolean checkSameNodes(Collection<DynamicObject> nodeEntry) {
        HashSet<String> taskIdSets = new HashSet<String>(16);
        for (DynamicObject object : nodeEntry) {
            List taskIds;
            String taskIdSet;
            DynamicObjectCollection subTasks = object.getDynamicObjectCollection("subtasks");
            if (!CollectionUtils.isNotEmpty((Collection)subTasks) || taskIdSets.add(taskIdSet = SerializationUtils.toJsonString(taskIds = subTasks.stream().map(e -> e.getLong("fbasedataid_id")).sorted().collect(Collectors.toList())))) continue;
            return true;
        }
        return false;
    }

    private boolean checkTaskLineValid(ExtendedDataEntity extendedDataEntity, Collection<DynamicObject> nodeEntry, DynamicObjectCollection lineEntry) {
        Map<String, Integer> nodeOrderMap = nodeEntry.stream().filter(s -> StringUtils.isNotEmpty((String)s.getString("nodenumber"))).collect(Collectors.toMap(e -> e.getString("nodenumber"), e -> e.getInt("orderseq")));
        Set linePairSet = lineEntry.stream().filter(o -> o.get("transrelation") != null).map(e -> new Pair((Object)e.getString("sourcenodenum"), (Object)e.getString("targetnodenum"))).collect(Collectors.toSet());
        for (Pair pair : linePairSet) {
            Integer pre = nodeOrderMap.get(pair.p1);
            Integer next = nodeOrderMap.get(pair.p2);
            if (pre == null || next == null || !pre.equals(next) && pre <= next) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u5236\u987a\u5e8f\u4e2d\uff0c\u5b58\u5728\u6267\u884c\u987a\u5e8f\u76f8\u540c\u6216\u5927\u5230\u5c0f\u7684\u4efb\u52a1\u6d41\u8f6c\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskFlowSaveValidator_9", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

