/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.taskflow;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.epm.eb.common.utils.CollectionUtils;

public class TaskTransRelationSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        String number = dataEntity.getString("number");
        String name = dataEntity.getString("name");
        if (number == null || number.trim().length() == 0) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskTransformRelationSaveOp_4", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return;
        }
        if (name == null || name.trim().length() == 0) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskTransformRelationSaveOp_5", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection relationList = dataEntity.getDynamicObjectCollection("entryentity");
        HashMap rowOrgIdMap = new HashMap(16);
        for (int i = 0; i < relationList.size(); ++i) {
            DynamicObject transformRelation = (DynamicObject)relationList.get(i);
            DynamicObjectCollection inputOrgList = transformRelation.getDynamicObjectCollection("taskinput");
            if (CollectionUtils.isEmpty((Collection)inputOrgList)) {
                this.addErrorMessage(dataEntities[0], ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u4efb\u52a1\u6d41\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskTransformRelationSaveOp_1", (String)"epm-eb-opplugin", (Object[])new Object[]{i + 1}));
                return;
            }
            DynamicObjectCollection outputOrgList = transformRelation.getDynamicObjectCollection("taskoutput");
            if (CollectionUtils.isEmpty((Collection)outputOrgList)) {
                this.addErrorMessage(dataEntities[0], ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u4efb\u52a1\u6d41\u51fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskTransformRelationSaveOp_2", (String)"epm-eb-opplugin", (Object[])new Object[]{i + 1}));
                return;
            }
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (DynamicObject outputOrg : outputOrgList) {
                Long orgId = outputOrg.getLong("fbasedataid_id");
                orgIds.add(orgId);
            }
            for (Map.Entry entry : rowOrgIdMap.entrySet()) {
                int row = (Integer)entry.getKey();
                Set rowOrgIds = (Set)entry.getValue();
                Set intersection = rowOrgIds.stream().filter(item -> orgIds.contains(item)).collect(Collectors.toSet());
                if (intersection.isEmpty()) continue;
                this.addErrorMessage(dataEntities[0], ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u4efb\u52a1\u6d41\u51fa\u4fe1\u606f\uff08\u7ef4\u5ea6\u6210\u5458\uff09\u4e0d\u80fd\u5b58\u5728\u4ea4\u53c9\u5173\u7cfb\uff0c\u8bf7\u8c03\u6574\u3002", (String)"TaskTransformRelationSaveOp_3", (String)"epm-eb-opplugin", (Object[])new Object[]{row + 1, i + 1}));
                return;
            }
            rowOrgIdMap.put(i, orgIds);
        }
    }
}

