/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.whiteList;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.constant.BgBaseConstant;

public class WhiteListSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add("bill");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String sql = "delete from t_eb_whitebill where fid in (select fid from t_eb_dimmembermapping where fisfreetype = '1')";
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, null);
        DynamicObject[] whiteLists = e.getDataEntities();
        if (whiteLists == null || whiteLists.length == 0) {
            return;
        }
        LinkedHashSet billTypes = Sets.newLinkedHashSet();
        for (DynamicObject whiteList : whiteLists) {
            DynamicObjectCollection bills = whiteList.getDynamicObjectCollection("bill");
            if (bills == null) continue;
            for (DynamicObject bill : bills) {
                DynamicObject billType = bill.getDynamicObject("fbasedataid");
                Long billId = billType.getLong("id");
                String billNumber = billType.getString("number");
                String billName = billType.getString("name");
                if (billTypes.add(billId)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a(%1)\u7684\u767d\u540d\u5355\u5f15\u7528\u4e86\u91cd\u590d\u7684\u5355\u636e\u7c7b\u578b(%1)\u3002", (String)"WhiteListSaveOp_0", (String)"epm-eb-opplugin", (Object[])new Object[]{billNumber + '-' + billName}));
            }
        }
    }
}

