/**
 * 规则执行脚本统一放在这里进行管理，请增加或修改时增加注释。
 */

var ctx = outline.getComputingContext();

function isNull(arg){
  return arg === null || arg ==="" || arg === undefined;
}

function scope(){
    var length=arguments.length;
    var tempScope = __builtin__.create(arguments[0]);
    for(var i=1;i<length;i++){
        tempScope = tempScope.scope(arguments[i])
    }
    return tempScope;
}

function factorList(){
    return __builtin__.createScriptFactorList();
}

function runRule(scope) {
    var length = arguments.length;
    if (length === 1) {
        ruleNumber = arguments[0];
    }else{
        ruleNumber = arguments[1];
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.runRule(scope, ruleNumber);
}

function runConvert() {
    var length = arguments.length;
    var scope;
    var scrCurrency,targetCurrency;
    if (length === 3) {
        scope = arguments[0];
        scrCurrency = arguments[1];
        targetCurrency = arguments[2];
    }else if(length === 2){
        scrCurrency = arguments[0];
        targetCurrency = arguments[1];
    }else{
    	throw "折算公式参数设置错误!";
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.runConvert(scope, scrCurrency, targetCurrency);
}

function runConsolidate(scope) {
    var length = arguments.length;
    if (length === 1) {
        calCondition = arguments[0];
    } else {
        calCondition = arguments[1];
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.runConsolidate(scope, calCondition);
}

function run() {
    var length = arguments.length;
	var args = __builtin__.createObjectArray(length);
	for(var i = 0;i<length;i++){
		args[i] = arguments[i];
	}
	var objects = __builtin__.transParamsWithScope(args);
	expressions = __builtin__.createStringArray(objects.length-1);
	for(var i = 1; i < objects.length; i++) {
        __builtin__.addString(expressions,i-1,objects[i]);
    }
    var scope = objects[0];
    __builtin__.computeSerial('fel','',scope,expressions);
}

function runs() {
	var length = arguments.length;
	var args = __builtin__.createObjectArray(length);
	for(var i = 0;i<length;i++){
		args[i] = arguments[i];
	}
	var objects = __builtin__.transParamsWithScope(args);
	expressions = __builtin__.createStringArray(objects.length-1);
	for(var i = 1; i < objects.length; i++) {
        __builtin__.addString(expressions,i-1,objects[i]);
    }
    var scope = objects[0];
    __builtin__.computeSerial('fel','',scope,expressions);
}

// scope范围生效以就近原则，靠近调用方则scope内容有优先权
function getRuntimeScope(scope){
    return ctx.getRuntimeScope(scope);
}

// scope片段作用范围定义，以endFix结束，开始会压入scope栈队列中，结束后会弹出栈
function fix(scopeItems){
    var newScope = __builtin__.create(scopeItems);
    ctx.pushScope(newScope);
}

function endFix(){
    ctx.popScope();
}

function isInstanceofScope(arg){
  return __builtin__.isInstanceofScope(arg);
}

function agg(scope) {
    var length = arguments.length;
    var members;
    if (length === 1) {
        members = __builtin__.createStringArray(1);
        __builtin__.addString(members, 0, arguments[0]);
    } else {
        members = __builtin__.createStringArray(length - 1);
        for (var i = 1; i < length; i++) {
            __builtin__.addString(members, i - 1, arguments[i])
        }
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.agg(scope, members);
}


/**
 * 新版本的v函数
 * @param expression 表达式或范围对象
 * @param defaultValue 为空时默认返回值
 */
function v(expression,defaultValue) {
    if(typeof(expression)=='string'){  //保证原有v函数的兼容性
        return __builtin__.evalOld(getRuntimeScope(null), expression);
    }else{
        if(!defaultValue){
             defaultValue=null;
        }
        //这里expression为scope对象，因为需要校验维度是否已指定，getRuntimeScope在放到eval里调用
        return __builtin__.eval(expression,defaultValue);
    }
}

/**
 * 单元格值的保存
 */
function save(scope,value){
    //因为需要校验维度是否已指定，getRuntimeScope在放到save里调用
    return __builtin__.save(scope,value);
}

/**
 * 获取cellSet集
 */
function getCellSet(scope){
    return __builtin__.getCellSet(getRuntimeScope(scope));
}

function ismember(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isMember(arg, mergeScope);
}

function properties() {
    var length = arguments.length;
    var mergeScope = getRuntimeScope(null);
    if (length == 2) {
        return outline.searchProperties(arguments[0], CE, arguments[1], mergeScope);
    } else if (length == 3) {
        return outline.searchProperties(arguments[0], arguments[1], arguments[2], mergeScope);
    }
    var errMsg = 'invalid param ';
    for(var j = 0; j < length; j++) {
        errMsg  += arguments[j] + ','
    }
    throw errMsg;
}

function idescendants(dimension, name) {
    return outline.searchIdesc(dimension, name);
}

function descendants(dimension, name) {
    return outline.searchDescendants(dimension, name);
}

function isparent(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isParent(arg, mergeScope);
}

function isiparent(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIparent(arg, mergeScope);
}

function isancest(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isAncest(arg, mergeScope);
}

function isiancest(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIancest(arg, mergeScope);
}

function ischild(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isChild(arg, mergeScope);
}

function isichild(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIchild(arg, mergeScope);
}

function isdescendants(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isDescendants(arg, mergeScope);
}

function isidescendant(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIdescendant(arg, mergeScope);
}

function issibling(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isSibling(arg, mergeScope);
}

function isisibling(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIsibling(arg, mergeScope);
}

function isproperties(dimension, properity, value) {
    var mergeScope = getRuntimeScope(null);
    return outline.isProperties(dimension, properity, value, mergeScope);
}

Math.sum = function () {
    var sum = 0;
    var length = arguments.length;
    for (var i = 0; i < length; i++) {
        sum +=arguments[i];
    }
    return sum;
}

Math.avg = function() {
    var sum = 0;
    var length = arguments.length;
    for (var i = 0; i < length; i++) {
        sum +=arguments[i];
    }
    return sum/length;
};