/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.fi.cas.formplugin.common.CasBillEdit;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class AccountCashEdit
extends CasBillEdit {
    public void initialize() {
        super.initialize();
        this.addOrgListener();
        this.addDefaultCurrencyListener();
        this.addCurrencyListener();
        this.addClickListeners(new String[]{"btn_save"});
    }

    private void addOrgListener() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_accountcash", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgList);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit openOrgF7 = (BasedataEdit)this.getControl("openorg");
        openOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgIds = OrgHelper.getAuthAcctOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_accountcash", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            Object acctCashID;
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_accountcash");
            List refsList = BaseDataRefrenceHelper.getAllRefs((BasedataEntityType)((BasedataEntityType)entityType), (Object)(acctCashID = this.getModel().getValue("id")));
            if (refsList != null && refsList.size() > 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"opendate"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        }
        if (((Boolean)this.getValue("isbycurrency")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultcurrency"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultcurrency"});
        }
    }

    private void addCurrencyListener() {
        BasedataEdit defaultCurrencyF7 = (BasedataEdit)this.getControl("currency");
        defaultCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter = qFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void addDefaultCurrencyListener() {
        BasedataEdit defaultCurrencyF7 = (BasedataEdit)this.getControl("defaultcurrency");
        defaultCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection currencyCol = (DynamicObjectCollection)this.getModel().getValue("currency");
            HashSet<Long> currencyIDs = new HashSet<Long>();
            for (DynamicObject prop : currencyCol) {
                currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
            }
            QFilter qFilter = new QFilter("id", "in", currencyIDs);
            qFilter = qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter = qFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountOrg = OrgHelper.getAccountOrgByFundsOrg((DynamicObject)org);
        if (accountOrg != null) {
            this.getModel().setValue("openorg", (Object)accountOrg.getLong("id"));
        }
        this.setDefaultAdmin();
        this.setValue("opendate", new Date());
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultcurrency"});
        this.setValue("accountproperty", 183705600155241472L);
    }

    private void setDefaultAdmin() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("entryentity.dpt", "=", org.getPkValue());
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{filter, new QFilter("id", "=", (Object)userId)});
        if (user == null) {
            user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{filter});
        }
        this.setValue("admin", user);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        if ("currency".equals(propName)) {
            this.currencyChange(propValue);
        }
    }

    protected void currencyChange(Object propValue) {
        DynamicObjectCollection props = (DynamicObjectCollection)propValue;
        if (props.size() == 1) {
            for (DynamicObject currency : props) {
                this.setValue("defaultcurrency", ((DataEntityBase)currency.get("fbasedataid")).getPkValue());
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultcurrency"});
            this.setValue("isbycurrency", "1");
        } else {
            this.setValue("defaultcurrency", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultcurrency"});
            this.setValue("isbycurrency", "0");
        }
        this.getCurrencyName(props);
    }

    private void getCurrencyName(DynamicObjectCollection props) {
        StringBuilder currencyStr = new StringBuilder(20);
        for (DynamicObject currency : props) {
            if (currencyStr.length() == 0) {
                currencyStr.append(currency.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue());
                continue;
            }
            currencyStr.append(',');
            currencyStr.append(currency.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue());
        }
        this.setValue("currencyname", currencyStr.toString());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btn_save".equals(c.getKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject openorg = (DynamicObject)this.getModel().getValue("openorg");
            if (openorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u6ca1\u6709\u7ef4\u62a4\u5f00\u6237\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6570\u636e\u5347\u7ea7\u3002", (String)"AccountCashEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject accountOrg = OrgHelper.getAccountOrgByFundsOrg((DynamicObject)org);
            if (accountOrg != null && !accountOrg.getPkValue().equals(openorg.getPkValue())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8de8\u6cd5\u4eba\u5f00\u6237\uff1f\u786e\u5b9a\u7ee7\u7eed\u4fdd\u5b58\uff0c\u53d6\u6d88\u8bf7\u4fee\u6539\u5f00\u6237\u516c\u53f8\u9009\u9879\u3002", (String)"AccountCashEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("saveCallBack", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("save");
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("saveCallBack".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().invokeOperation("save");
        }
    }
}

