/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class AgentPayBillBotpPlugin
extends AbstractConvertPlugIn {
    private static final String BD_ADMIN_DIVISION_SELECT = "id, name, level, iscity, basedatafield.id, basedatafield.name, parent.id, parent.name";

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey("cas_agentpaybill")) {
            DynamicObject agentPayBill = entity.getDataEntity();
            DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalLocalAmount = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                totalAmount = totalAmount.add(row.getBigDecimal("e_amount"));
                totalLocalAmount = totalLocalAmount.add(row.getBigDecimal("e_localamt"));
                DynamicObject payeeBank = row.getDynamicObject("payeebank");
                if (payeeBank == null) continue;
                row.set("payeebanknumber", (Object)payeeBank.getString("number"));
                if (!CasHelper.isEmpty((Object)row.get("recprovince")) && !CasHelper.isEmpty((Object)row.get("reccity"))) continue;
                this.setPayeeAdminDivision(row);
            }
            agentPayBill.set("count", (Object)entry.size());
            agentPayBill.set("payamount", (Object)totalAmount);
            agentPayBill.set("localamt", (Object)totalLocalAmount);
            agentPayBill.set("bizdate", (Object)new Date());
            DynamicObject acctBank = agentPayBill.getDynamicObject("payeracctbank");
            if (acctBank == null) continue;
            agentPayBill.set("payerbank", (Object)acctBank.getDynamicObject("bank"));
        }
    }

    private void setPayeeAdminDivision(DynamicObject entryRow) {
        DynamicObject payeeBank = entryRow.getDynamicObject("payeebank");
        if (payeeBank == null) {
            return;
        }
        DynamicObject adminDivision = payeeBank.getDynamicObject("basedatafield1");
        if (adminDivision != null) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)adminDivision.getLong("id"), (String)"bd_admindivision", (String)BD_ADMIN_DIVISION_SELECT);
            int level = obj.getInt("level");
            if (level == 1) {
                entryRow.set("recprovince", (Object)obj.getString("name"));
            } else if (level == 2) {
                entryRow.set("reccity", (Object)obj.getString("name"));
                entryRow.set("recprovince", (Object)obj.getString("parent.name"));
            } else if (level == 3) {
                entryRow.set("reccity", (Object)obj.getString("name"));
                DynamicObject city = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("parent.id"), (String)"bd_admindivision", (String)BD_ADMIN_DIVISION_SELECT);
                entryRow.set("recprovince", (Object)city.getString("parent.name"));
            }
        }
    }
}

