/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.IPrintScriptable;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.plugin.args.OutputElementArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;

public class AgentPayBillPrintPlugin
extends AbstractPrintServicePlugin {
    private boolean isEncryption = false;
    private int scale = 2;
    private final List<Boolean> encryptList = new ArrayList<Boolean>(10);

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        block0: for (DynamicObject info : e.getDataEntities()) {
            if (info.getDataEntityType() instanceof EntryType || !"cas_agentpaybill".equals(info.getDataEntityType().getName())) continue;
            DynamicObject agentPayBill = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"cas_agentpaybill", (String)"payeetype,isencryption,currency");
            String payeeType = agentPayBill.getString("payeetype");
            this.encryptList.add(agentPayBill.getBoolean("isencryption"));
            DynamicObject currency = agentPayBill.getDynamicObject("currency");
            if (currency != null) {
                this.scale = currency.getInt("priceprecision");
            }
            if ("other".equals(payeeType)) {
                info.set("payeetypelist", (Object)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AgentPayBillPrintPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                continue;
            }
            ItemClassTypeProp property = (ItemClassTypeProp)((DynamicObjectType)info.getDataEntityType()).getProperty("payeetype");
            List comboItems = property.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!item.getValue().equals(payeeType)) continue;
                info.set("payeetypelist", (Object)item.getName());
                continue block0;
            }
        }
    }

    public void afterOutputElement(OutputElementArgs e) {
        super.afterOutputElement(e);
        if (e.getKey() != null) {
            String value;
            String fieldKey;
            if ("agentpaybill".equals(e.getKey())) {
                this.isEncryption = this.encryptList.get(0);
                this.encryptList.remove(0);
            }
            if (e.getKey().equals("txtencryptamount") && this.isEncryption) {
                this.setValue(e, "**.**");
            }
            if (e.getKey().equals("txtamount1") || e.getKey().equals("txtcurrencysign")) {
                if (this.isEncryption) {
                    this.setValue(e, "");
                } else if (e.getKey().equals("txtamount1")) {
                    fieldKey = "e_encryptamount";
                    value = e.getDataHelper().getValue("entry", fieldKey).toString();
                    String amount = AgentPayBillHelper.decodeAmount((String)value).toString();
                    BigDecimal amountScale = new BigDecimal(amount).setScale(this.scale, RoundingMode.DOWN);
                    this.setValue(e, amountScale.toString());
                }
            }
            if (e.getKey().equals("txtpayeeacctbank")) {
                fieldKey = "payeeacctbank";
                value = Optional.ofNullable(e.getDataHelper().getValue("entry", fieldKey)).orElse("").toString();
                if (this.isEncryption) {
                    this.setValue(e, AccountBankHelper.getBankNumberEncryptDisplay((String)value));
                }
            }
        }
    }

    private void setValue(OutputElementArgs e, String value) {
        IPrintScriptable apw = e.getOutput();
        apw.setValue((Object)value);
    }
}

