/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;

public class AgentPayBillPrintPluginNew
extends AbstractPrintPlugin {
    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        List list = evt.getDataRowSets();
        int scale = 2;
        for (DataRowSet d : list) {
            DynamicObject agentPayBill = BusinessDataServiceHelper.loadSingle((Object)d.getField("id").getValue(), (String)"cas_agentpaybill", (String)"payeetype,isencryption,currency");
            String payeeType = agentPayBill.getString("payeetype");
            boolean isEncryption = agentPayBill.getBoolean("isencryption");
            DynamicObject currency = agentPayBill.getDynamicObject("currency");
            if (currency != null) {
                scale = currency.getInt("priceprecision");
            }
            if ("other".equals(payeeType)) {
                d.put("payeetypelist", (Field)new TextField(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AgentPayBillPrintPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            } else {
                ItemClassTypeProp property = (ItemClassTypeProp)((DynamicObjectType)agentPayBill.getDataEntityType()).getProperty("payeetype");
                List comboItems = property.getComboItems();
                for (ValueMapItem item : comboItems) {
                    if (!item.getValue().equals(payeeType)) continue;
                    d.put("payeetypelist", (Field)new TextField(item.getName().toString()));
                    break;
                }
            }
            CollectionField entry = d.getCollectionField("entry");
            for (DataRowSet d0 : entry.getValue()) {
                Object value;
                if (isEncryption) {
                    d0.put("e_encryptamount", (Field)new TextField("**.**"));
                    d0.put("currency.sign", (Field)new TextField(""));
                    value = d0.getField("payeeacctbank").getValue();
                    d0.put("payeeacctbank", (Field)new TextField(AccountBankHelper.getBankNumberEncryptDisplay((String)String.valueOf(value))));
                    continue;
                }
                value = d0.getField("e_encryptamount").getValue();
                String amount = AgentPayBillHelper.decodeAmount((String)value.toString()).toString();
                BigDecimal amountScale = new BigDecimal(amount).setScale(scale, RoundingMode.DOWN);
                d0.put("e_encryptamount", (Field)new TextField(amountScale.toString()));
            }
        }
    }
}

