/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;

public class AgentRepayConvertPlugin
extends AbstractConvertPlugIn {
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        Set rowIdSet;
        super.afterGetSourceData(e);
        List sourceRows = e.getSourceRows();
        Set agentRepayId = sourceRows.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (agentRepayId.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] agentRepayArr = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billno,billstatus,isrepulsed,entry,entry.e_issuccess,entry.e_isrepaid,entry.e_isrefund", (QFilter[])new QFilter[]{new QFilter("id", "in", agentRepayId)});
        DynamicObject agentRepay = agentRepayArr[0];
        String billNo = agentRepay.getString("billno");
        DynamicObjectCollection entry = agentRepay.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u5b58\u5728\u5206\u5f55\u3002", (String)"AgentRepayConvertPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        String billStatus = agentRepay.getString("billstatus");
        boolean repulsed = agentRepay.getBoolean("isrepulsed");
        HashMap<Long, Integer> validFailEntry = new HashMap<Long, Integer>(entry.size());
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            boolean e_success = row.getBoolean("e_issuccess");
            boolean e_repaid = row.getBoolean("e_isrepaid");
            boolean e_refund = row.getBoolean("e_isrefund");
            if (BillStatusEnum.PAY.getValue().equals(billStatus) && repulsed && !e_success && !e_repaid && !e_refund) continue;
            validFailEntry.put(row.getLong("id"), i);
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(entry.size());
        if (validFailEntry.size() == entry.size()) {
            ArrayList seqList = new ArrayList(validFailEntry.values());
            Collections.sort(seqList);
            for (Integer index : seqList) {
                String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5206\u5f55\u7b2c%2$s\u884c\uff1a\u4e0d\u5b58\u5728\u4ea4\u6613\u5931\u8d25\u7684\u5206\u5f55\u6216\u5df2\u7ecf\u8fdb\u884c\u8fc7\u5931\u8d25\u91cd\u4ed8\u6216\u8005\u6ca1\u6709\u88ab\u6253\u56de\u3002", (String)"AgentRepayConvertPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo, index + 1);
                errorMsgList.add(errorMsg);
            }
            if (errorMsgList.size() > 0) {
                String errorMsg = String.join((CharSequence)"\r\n", errorMsgList);
                throw new KDBizException(errorMsg);
            }
        }
        if ((rowIdSet = validFailEntry.keySet()).size() > 0) {
            Map fldProperties = e.getFldProperties();
            Iterator iterator = sourceRows.iterator();
            while (iterator.hasNext()) {
                DynamicObject sourceRow = (DynamicObject)iterator.next();
                Long entryId = sourceRow.getLong((IDataEntityProperty)fldProperties.get("entry.id"));
                if (!rowIdSet.contains(entryId)) continue;
                iterator.remove();
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] targetBills;
        for (ExtendedDataEntity agentPayBill : targetBills = e.getTargetExtDataEntitySet().FindByEntityKey("cas_agentpaybill")) {
            DynamicObject bill = agentPayBill.getDataEntity();
            bill.set("payeetype", (Object)bill.getString("payeetypelist"));
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal localAmountSum = BigDecimal.ZERO;
            for (DynamicObject row : entrys) {
                if (row.getString("e_encryptamount") != null) {
                    String encryptAmount = row.getString("e_encryptamount");
                    BigDecimal amount = AgentPayBillHelper.decodeAmount((String)encryptAmount);
                    row.set("e_amount", (Object)amount);
                    amountSum = amountSum.add(amount);
                } else {
                    amountSum = amountSum.add(row.getBigDecimal("e_amount"));
                }
                if (row.getString("e_encryptlocalamt") != null) {
                    String encryptLocalAmount = row.getString("e_encryptlocalamt");
                    BigDecimal localAmount = AgentPayBillHelper.decodeAmount((String)encryptLocalAmount);
                    row.set("e_localamt", (Object)localAmount);
                    localAmountSum = localAmountSum.add(localAmount);
                } else {
                    localAmountSum = localAmountSum.add(row.getBigDecimal("e_localamt"));
                }
                row.set("e_localamt2", (Object)"****");
                row.set("e_amount2", (Object)"****");
            }
            bill.set("payamount", (Object)amountSum);
            bill.set("localamt", (Object)localAmountSum);
        }
    }
}

