/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class AttentionSettingForm
extends DynamicFormPlugin {
    private static final Log logger = LogFactory.getLog(AttentionSettingForm.class);
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String ADD_ACCOUNT = "addaccount";
    private static final String MOVE_TOP = "movetop";
    private static final String MOVE_BOTTOM = "movebottom";
    private static final String ADD_ACCOUNT_VIEW = "addAccountView";
    private static final String ENTRYS = "entrys";
    private static final String BTNOK = "btnok";
    private static final String CAS_ATTENTIONSETTING = "cas_attentionsetting";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        this.addClickListeners(new String[]{BTNOK});
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.setEntryData((List<DynamicObject>)this.getUserSetting(), true);
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.saveAttentionSetting();
                this.getView().close();
                break;
            }
        }
        super.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "addaccount": {
                this.showAddAcctBankView();
                break;
            }
            case "movetop": {
                this.entryRowMove(MOVE_TOP);
                break;
            }
            case "movebottom": {
                this.entryRowMove(MOVE_BOTTOM);
                break;
            }
        }
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "addAccountView": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (!EmptyUtil.isNoEmpty((Object)returnData)) break;
                this.updateEntrys(returnData);
                this.saveAttentionSetting();
                break;
            }
        }
        super.closedCallBack(closedCallBackEvent);
    }

    private DynamicObjectCollection getUserSetting() {
        Long userId = RequestContext.get().getCurrUserId();
        String selectors = "user,accountbank,currency,order";
        Object[] userSettings = BusinessDataServiceHelper.load((String)CAS_ATTENTIONSETTING, (String)selectors, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        DynamicObjectCollection attentionSettings = new DynamicObjectCollection();
        if (EmptyUtil.isNoEmpty((Object[])userSettings)) {
            attentionSettings.addAll(Arrays.asList(userSettings));
        }
        return attentionSettings;
    }

    protected QFilter[] getAcctFilter(Set<Long> orgPks) {
        QFilter[] accountFilter = new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    private void showAddAcctBankView() {
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set idList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"am_accountbank", (String)"47150e89000000ac");
        if (idList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6ca1\u6709\u6709\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"PaymentCalendarPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] acctFilter = this.getAcctFilter(idList);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)true, (int)2);
        showParameter.setIsolationOrg(false);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(acctFilter));
        this.setF7SelectedItem(showParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_ACCOUNT_VIEW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void entryRowMove(String moveType) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYS);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AttentionSettingForm_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYS);
        if (MOVE_TOP.equals(moveType)) {
            this.getModel().setEntryRowTop(ENTRYS, new int[]{entryCurrentRowIndex});
        } else {
            this.getModel().setEntryRowBottom(ENTRYS, new int[]{entryCurrentRowIndex});
        }
        this.getView().updateView(ENTRYS);
    }

    private void setEntryData(List<DynamicObject> entrys, boolean isInit) {
        if (EmptyUtil.isEmpty(entrys)) {
            return;
        }
        this.getModel().deleteEntryData(ENTRYS);
        for (DynamicObject row : entrys) {
            DynamicObject accountBank = null;
            DynamicObject currency = null;
            DynamicObject bank = null;
            DynamicObject openorg = null;
            if (isInit) {
                accountBank = row.getDynamicObject("accountbank");
                if (accountBank == null) {
                    logger.info(String.format(ResManager.loadKDString((String)"\u8d26\u6237\u88ab\u5220\u9664\uff0c\u7528\u6237ID\uff1a%1$s\uff0c\u5361\u7247\u987a\u5e8f\uff1a%2$s\u3002", (String)"AttentionSettingForm_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.getDynamicObject("user").getString("id"), row.getString("order")));
                    continue;
                }
                currency = row.getDynamicObject("currency");
                bank = accountBank.getDynamicObject("bank");
                openorg = accountBank.getDynamicObject("openorg");
            }
            int index = this.getModel().createNewEntryRow(ENTRYS);
            this.getModel().setValue("accountbank", (Object)(isInit ? (accountBank == null ? "" : accountBank.getString("bankaccountnumber")) : row.getString("bankaccountnumber")), index);
            this.getModel().setValue("accountbankname", (Object)(isInit ? (accountBank == null ? "" : accountBank.getString("name")) : row.getString("name")), index);
            this.getModel().setValue("companyname", (Object)(isInit ? (accountBank == null ? "" : accountBank.getString("company.name")) : row.getString("companyname")), index);
            this.getModel().setValue("currency", (Object)(isInit ? (currency == null ? "" : currency.getString("name")) : row.getString("defaultcurrency.name")), index);
            this.getModel().setValue("accountbankid", (Object)(isInit ? (accountBank == null ? "" : accountBank.getString("id")) : row.getString("id")), index);
            this.getModel().setValue("currencyid", (Object)(isInit ? (currency == null ? "" : currency.getString("id")) : row.getString("defaultcurrency")), index);
            this.getModel().setValue("bank", (Object)(isInit ? (bank == null ? "" : bank.getString("name")) : row.getString("bankname")), index);
            this.getModel().setValue("openorg", (Object)(isInit ? (openorg == null ? "" : openorg.getString("name")) : row.getString("openorgname")), index);
            this.getModel().setValue("acctstatus", (Object)(isInit ? (accountBank == null ? "" : accountBank.getString("acctstatus")) : row.getString("acctstatus")), index);
        }
        this.getView().updateView(ENTRYS);
    }

    private void setF7SelectedItem(ListShowParameter showParameter) {
        DynamicObjectCollection userSetting = this.getUserSetting();
        if (EmptyUtil.isNoEmpty((Object)userSetting)) {
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            for (DynamicObject dynamicObject : userSetting) {
                DynamicObject accountbank = dynamicObject.getDynamicObject("accountbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)accountbank)) continue;
                long accountbankId = accountbank.getLong("id");
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)accountbankId);
                listSelectedRows.add((Object)listSelectedRow);
            }
            showParameter.setListSelectedRowCollection(listSelectedRows);
        }
    }

    private void updateEntrys(ListSelectedRowCollection returnData) {
        Set accountBankIds = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String acctSelect = "id,bankaccountnumber,name,company.name companyname,defaultcurrency,defaultcurrency.name, bank.name bankname, openorg.name openorgname, acctstatus";
        DynamicObjectCollection accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)acctSelect, (QFilter[])new QFilter[]{new QFilter("id", "in", accountBankIds)});
        Map accountBankMap = accountBanks.stream().collect(Collectors.toMap(acctBank -> acctBank.getLong("id"), Function.identity()));
        ArrayList<DynamicObject> updateAccts = new ArrayList<DynamicObject>(returnData.size());
        for (ListSelectedRow row : returnData) {
            Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
            updateAccts.add((DynamicObject)accountBankMap.get(primaryKeyValue));
        }
        this.setEntryData(updateAccts, false);
    }

    private void saveAttentionSetting() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYS);
        DynamicObject[] attentionItems = new DynamicObject[entrys.size()];
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject attentionItem = BusinessDataServiceHelper.newDynamicObject((String)CAS_ATTENTIONSETTING);
            attentionItem.set("user", (Object)userId);
            attentionItem.set("accountbank", (Object)entry.getString("accountbankid"));
            attentionItem.set("currency", (Object)entry.getString("currencyid"));
            attentionItem.set("order", (Object)entry.getString("seq"));
            attentionItems[i] = attentionItem;
        }
        DeleteServiceHelper.delete((String)CAS_ATTENTIONSETTING, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        SaveServiceHelper.save((DynamicObject[])attentionItems);
        this.getView().updateView(ENTRYS);
    }
}

