/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.CheckedResultSourceEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.CreateExcelUtil;
import kd.fi.cas.util.EmptyUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BalanceAdjustListPlugin
extends AbstractListPlugin {
    private boolean orgChange = true;
    private List<Object> selectedOrgIdList = new ArrayList<Object>();
    private String cacheOrgIdNotInit = null;
    private FilterContainerInitArgs initArgs;
    private static final Log logger = LogFactory.getLog(BalanceAdjustListPlugin.class);
    private static final int maxLength = 50;
    private static final String FORMNAME = "cas_balanceadjust";
    protected static final String[] exportFieldSheet1 = new String[]{"org.number", "org.name", "bizdate", "bankaccount.name", "bankaccount.bankaccountnumber", "bankcgsetting.name", "currency.name", "journalbalamt", "bankgotamt", "bankpayedamt", "adjustjournalamt", "statmntbalamt", "entprgotamt", "entprpayedamt", "adjuststatementamt", "diffamount"};
    private static final String[] exportFieldSheet2 = new String[]{"org.number", "org.name", "bizdate", "bankaccount.name", "bankaccount.bankaccountnumber", "bankcgsetting.name", "currency.name", "value_1", "source", "enter_bizdate", "bookdate", "pddate", "value_2", "value_3", "enter_description", "bankvouvherno", "bank_vouchernumber", "enter_settletype", "trans_property", "enter_reason", "beizhu", "enter_settlenumber"};
    private static final String[] exportFieldSheet3 = new String[]{"org.number", "org.name", "bizdate", "bankaccount.name", "bankaccount.bankaccountnumber", "bankcgsetting.name", "currency.name", "value_1", "billsource", "bank_bizdate", "bank_bookdate", "pddate", "value_2", "value_3", "bank_description", "bank_billnumber", "bank_vouchernumber", "bank_settletype", "trans_property", "bank_reason", "beizhu", "bank_settlenumber"};

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter bizdateFilter = new QFilter("period", "!=", (Object)0);
        for (QFilter qFilter : qFilters) {
            if (!"period.id".equals(qFilter.getProperty())) continue;
            Object pkValue = qFilter.getValue();
            if (qFilter.getValue() instanceof List) {
                ArrayList valueIds = (ArrayList)qFilter.getValue();
                QFilter arrayBizdateFilter = null;
                if (((ArrayList)qFilter.getValue()).size() > 0) {
                    for (Long valueId : valueIds) {
                        DynamicObject adjust = BusinessDataServiceHelper.loadSingle((Object)valueId, (String)"bd_period");
                        Date beginDate = adjust.getDate("begindate");
                        Date endDate = adjust.getDate("enddate");
                        if (arrayBizdateFilter == null) {
                            arrayBizdateFilter = new QFilter("bizdate", ">=", (Object)beginDate).and(new QFilter("bizdate", "<=", (Object)endDate));
                            continue;
                        }
                        arrayBizdateFilter = arrayBizdateFilter.or(new QFilter("bizdate", ">=", (Object)beginDate).and(new QFilter("bizdate", "<=", (Object)endDate)));
                    }
                    if (arrayBizdateFilter != null) {
                        bizdateFilter = bizdateFilter.and(arrayBizdateFilter);
                    }
                }
            } else {
                DynamicObject adjust = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(pkValue.toString()), (String)"bd_period");
                Date beginDate = adjust.getDate("begindate");
                Date endDate = adjust.getDate("enddate");
                bizdateFilter = bizdateFilter.and(new QFilter("bizdate", ">=", (Object)beginDate).and(new QFilter("bizdate", "<=", (Object)endDate)));
            }
            qFilters.remove(qFilter);
            break;
        }
        if (bizdateFilter != null) {
            qFilters.add(bizdateFilter);
        }
        qFilters.add(BalanceAdjustListPlugin.notVirtualAcctToBillQf());
    }

    public static QFilter notVirtualAcctToBillQf() {
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("isvirtual", "=", (Object)"1")});
        if (loads.length > 0) {
            List collect = Arrays.stream(loads).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            return new QFilter("bankaccount", "not in", collect);
        }
        return new QFilter("id", "!=", (Object)0);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        List<Object> defaultOrg = null;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        AccountBankHelper.initOrgForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if ("org.id".equals(commonFilterColumn.getFieldName())) {
                defaultOrg = filterColumn.getDefaultValues();
                if (this.getPageCache().get("defaultOrg") == null) {
                    this.cacheSelectedOrgIdList(defaultOrg);
                }
                this.getPageCache().put("defaultOrg", "1");
                List listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                ArrayList<ComboItem> orgItem = new ArrayList<ComboItem>();
                List<Map<String, Object>> org = this.getOrgList();
                if (org == null || org.size() != 0) {
                    for (int i = 0; i < org.size(); ++i) {
                        Map<String, Object> orginfo = org.get(i);
                        String name = orginfo.get("name").toString();
                        String orgid = orginfo.get("id").toString();
                        orgItem.add(new ComboItem(new LocaleString(name), orgid));
                    }
                }
                commonFilterColumn.setComboItems(orgItem);
            }
            if ("bankaccount.id".equals(commonFilterColumn.getFieldName())) {
                if (this.selectedOrgIdList.size() > 0) {
                    defaultOrg = this.selectedOrgIdList;
                }
                List<Map<String, Object>> acctbank = this.getAccountBank(defaultOrg);
                ArrayList<ComboItem> accountItem = new ArrayList<ComboItem>(acctbank.size());
                for (int i = 0; i < acctbank.size(); ++i) {
                    Map<String, Object> acctbankinfo = acctbank.get(i);
                    String banknumber = null == acctbankinfo.get("name") ? "" : acctbankinfo.get("name").toString();
                    String bankaccid = null == acctbankinfo.get("id") ? "" : acctbankinfo.get("id").toString();
                    accountItem.add(new ComboItem(new LocaleString(banknumber), bankaccid));
                }
                List acctcomitem = commonFilterColumn.getComboItems();
                acctcomitem.clear();
                commonFilterColumn.setComboItems(accountItem);
            }
            if (!"period.name".equals(commonFilterColumn.getFieldName())) continue;
            List<ComboItem> period = this.getPeriod();
            List acctcomitem = commonFilterColumn.getComboItems();
            acctcomitem.clear();
            commonFilterColumn.setComboItems(period);
            if (period.size() <= 0) continue;
            commonFilterColumn.setDefaultValue(period.get(0).getValue());
        }
        if (this.isTrack()) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if (!Arrays.asList("org.id", "bankaccount.id", "period.name", "billstatus").contains(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        }
        AccountBankHelper.initForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        this.initPageFilterValueCache((FilterColumnSetFilterEvent)args);
    }

    private void initPageFilterValueCache(FilterColumnSetFilterEvent args) {
        List filterFieldValues = args.getCommonFilterValue("org.id");
        if (CollectionUtils.isEmpty((Collection)filterFieldValues)) {
            this.getPageCache().put("filterFields", null);
        } else {
            this.getPageCache().put("filterFields", filterFieldValues.get(0).toString());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        DynamicObject[] selectedData = this.getSelectedData();
        switch (key) {
            case "exportexcel": {
                String appId = this.getView().getFormShowParameter().getAppId();
                boolean hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)FORMNAME, (String)"4FSKFL+9K26Z");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4f59\u989d\u8c03\u8282\u8868\u201d\u7684\u201c\u4f59\u989d\u53ca\u672a\u8fbe\u660e\u7ec6\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BalanceAdjustListPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (selectedData == null || selectedData.length == 0) {
                    BillList s = (BillList)this.getView().getControl("billlistap");
                    s.selectAllRows();
                    selectedData = this.getSelectedData();
                    s.clearSelection();
                    s.refresh();
                    if (selectedData == null || selectedData.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"ExportExcelErrorCode_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                this.exportExcelFile(selectedData);
            }
        }
    }

    protected static String[] getExportHeadTitle1() {
        String[] exportTitle = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"BalanceAdjustListPlugin_ExportExcel1_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BalanceAdjustListPlugin_ExportExcel1_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f", (String)"BalanceAdjustListPlugin_ExportExcel1_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"BalanceAdjustListPlugin_ExportExcel1_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"BalanceAdjustListPlugin_ExportExcel1_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"BalanceAdjustListPlugin_ExportExcel1_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BalanceAdjustListPlugin_ExportExcel1_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26\u4f59\u989d", (String)"BalanceAdjustListPlugin_ExportExcel1_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52a0\uff1a\u94f6\u884c\u5df2\u6536\u4f01\u4e1a\u672a\u6536", (String)"BalanceAdjustListPlugin_ExportExcel1_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51cf\uff1a\u94f6\u884c\u5df2\u4ed8\u4f01\u4e1a\u672a\u4ed8", (String)"BalanceAdjustListPlugin_ExportExcel1_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8c03\u6574\u540e\u65e5\u8bb0\u8d26\u4f59\u989d", (String)"BalanceAdjustListPlugin_ExportExcel1_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u4f59\u989d", (String)"BalanceAdjustListPlugin_ExportExcel1_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52a0\uff1a\u4f01\u4e1a\u5df2\u6536\u94f6\u884c\u672a\u6536", (String)"BalanceAdjustListPlugin_ExportExcel1_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51cf\uff1a\u4f01\u4e1a\u5df2\u4ed8\u94f6\u884c\u672a\u4ed8", (String)"BalanceAdjustListPlugin_ExportExcel1_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5bf9\u8d26\u5355\u4f59\u989d", (String)"BalanceAdjustListPlugin_ExportExcel1_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5dee\u5f02", (String)"BalanceAdjustListPlugin_ExportExcel1_15", (String)"fi-cas-formplugin", (Object[])new Object[0])};
        return exportTitle;
    }

    protected static String[] getExportHeadTitle2() {
        String[] exportTitle = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"BalanceAdjustListPlugin_ExportExcel1_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BalanceAdjustListPlugin_ExportExcel1_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f", (String)"BalanceAdjustListPlugin_ExportExcel1_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"BalanceAdjustListPlugin_ExportExcel1_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"BalanceAdjustListPlugin_ExportExcel1_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"BalanceAdjustListPlugin_ExportExcel1_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BalanceAdjustListPlugin_ExportExcel1_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u8fbe\u7c7b\u578b", (String)"BalanceAdjustListPlugin_ExportExcel2_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u6765\u6e90", (String)"BalanceAdjustListPlugin_ExportExcel2_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f/\u4ea4\u6613\u65e5\u671f", (String)"BalanceAdjustListPlugin_ExportExcel2_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f", (String)"BalanceAdjustListPlugin_ExportExcel2_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f", (String)"BalanceAdjustListPlugin_ExportExcel2_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d26\u9f84", (String)"BalanceAdjustListPlugin_ExportExcel2_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u989d", (String)"BalanceAdjustListPlugin_ExportExcel2_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6458\u8981", (String)"BalanceAdjustListPlugin_ExportExcel2_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7/\u94f6\u884c\u6d41\u6c34\u53f7", (String)"BalanceAdjustListPlugin_ExportExcel2_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"BalanceAdjustListPlugin_ExportExcel2_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"BalanceAdjustListPlugin_ExportExcel2_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ea4\u6613\u6027\u8d28", (String)"BalanceAdjustListPlugin_ExportExcel2_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u8fbe\u539f\u56e0", (String)"BalanceAdjustListPlugin_ExportExcel2_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BalanceAdjustListPlugin_ExportExcel2_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u53f7", (String)"BalanceAdjustListPlugin_ExportExcel2_14", (String)"fi-cas-formplugin", (Object[])new Object[0])};
        return exportTitle;
    }

    public void exportExcelFile(DynamicObject[] selectedData) {
        DynamicObject[] dynamicObjects;
        SXSSFWorkbook wb = new SXSSFWorkbook(-1);
        String[] exportTitleSheet1 = BalanceAdjustListPlugin.getExportHeadTitle1();
        String[] exportTitleSheet2 = BalanceAdjustListPlugin.getExportHeadTitle2();
        ArrayList exportEntitySheet1 = new ArrayList(selectedData.length);
        ArrayList exportEntitySheet2 = new ArrayList(selectedData.length);
        List idList = Arrays.stream(selectedData).map(s -> s.getPkValue()).collect(Collectors.toList());
        for (DynamicObject exportDetail : dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)FORMNAME))) {
            String tempStr;
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(exportFieldSheet1.length);
            for (String str : exportFieldSheet1) {
                Object res = exportDetail.get(str);
                if (res == null) {
                    details.put(str, null);
                    continue;
                }
                details.put(str, res);
            }
            DynamicObject currency = exportDetail.getDynamicObject("currency");
            int amtPrecision = 0;
            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                amtPrecision = currency.getInt("amtprecision");
                details.put("amtprecision", amtPrecision);
            }
            exportEntitySheet1.add(details);
            Object res = null;
            DynamicObjectCollection dynamicObjectCollection1 = exportDetail.getDynamicObjectCollection("enter_entry");
            for (DynamicObject dynObj1 : dynamicObjectCollection1) {
                LinkedHashMap details1 = new LinkedHashMap(exportFieldSheet2.length);
                int count = 0;
                for (Map.Entry entry : details.entrySet()) {
                    if (count++ > 6) break;
                    details1.put(entry.getKey(), entry.getValue());
                }
                tempStr = "";
                block35: for (int i = 7; i < exportFieldSheet2.length; ++i) {
                    String str = exportFieldSheet2[i];
                    try {
                        res = dynObj1.get(str);
                    }
                    catch (ORMDesignException e) {
                        res = null;
                        logger.error((Throwable)e);
                    }
                    BigDecimal bigDecimal = null;
                    switch (str) {
                        case "value_1": {
                            bigDecimal = dynObj1.getBigDecimal("enter_debitamount");
                            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                                details1.put(str, ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u6536\u4f01\u4e1a\u672a\u6536", (String)"BalanceAdjustListPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                continue block35;
                            }
                            details1.put(str, ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u4ed8\u4f01\u4e1a\u672a\u4ed8", (String)"BalanceAdjustListPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            continue block35;
                        }
                        case "source": {
                            tempStr = dynObj1.getString("source");
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.BNKK_TRANSDOWNLOAD.getValue())) {
                                tempStr = CheckedResultSourceEnum.BNKK_TRANSDOWNLOAD.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.INNER_FIN_DOWNLOAD.getValue())) {
                                tempStr = CheckedResultSourceEnum.INNER_FIN_DOWNLOAD.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.INTRODUCE_BYHAND.getValue())) {
                                tempStr = CheckedResultSourceEnum.INTRODUCE_BYHAND.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.ADD_BYHAND.getValue())) {
                                tempStr = CheckedResultSourceEnum.ADD_BYHAND.getName();
                            }
                            details1.put(str, tempStr);
                            continue block35;
                        }
                        case "value_2": {
                            int longOfTwoDate = this.longOfTwoDate(dynObj1.getDate("enter_bizdate"), exportDetail.getDate("bizdate")) + 1;
                            tempStr = longOfTwoDate + "";
                            details1.put(str, tempStr);
                            continue block35;
                        }
                        case "value_3": {
                            bigDecimal = dynObj1.getBigDecimal("enter_debitamount");
                            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                                details1.put(str, dynObj1.getBigDecimal("enter_creditamount"));
                                continue block35;
                            }
                            details1.put(str, bigDecimal);
                            continue block35;
                        }
                        default: {
                            details1.put(str, res);
                        }
                    }
                }
                details1.put("amtprecision", amtPrecision);
                exportEntitySheet2.add(details1);
            }
            DynamicObjectCollection dynamicObjectCollection2 = exportDetail.getDynamicObjectCollection("bank_entry");
            for (DynamicObject dynObj1 : dynamicObjectCollection2) {
                LinkedHashMap details1 = new LinkedHashMap(exportFieldSheet3.length);
                tempStr = "";
                int count = 0;
                for (Map.Entry entry : details.entrySet()) {
                    if (count++ > 6) break;
                    details1.put(entry.getKey(), entry.getValue());
                }
                block38: for (int i = 7; i < exportFieldSheet3.length; ++i) {
                    String str = exportFieldSheet3[i];
                    try {
                        res = dynObj1.get(str);
                    }
                    catch (ORMDesignException e) {
                        res = null;
                    }
                    BigDecimal bigDecimal = null;
                    switch (str) {
                        case "value_1": {
                            bigDecimal = dynObj1.getBigDecimal("bank_debitamount");
                            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                                details1.put(str, ResManager.loadKDString((String)"\u4f01\u4e1a\u5df2\u4ed8\u94f6\u884c\u672a\u4ed8", (String)"BalanceAdjustListPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                continue block38;
                            }
                            details1.put(str, ResManager.loadKDString((String)"\u4f01\u4e1a\u5df2\u6536\u94f6\u884c\u672a\u6536", (String)"BalanceAdjustListPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            continue block38;
                        }
                        case "billsource": {
                            tempStr = dynObj1.getString("bank_billtype");
                            if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.PAYBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.PAYBILL.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.RECBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.RECBILL.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.AGENTPAYBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.AGENTPAYBILL.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.VOUCHER.getValue())) {
                                tempStr = SourceBillTypeEnum.VOUCHER.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.EXCHANGEBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.EXCHANGEBILL.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.TRANSUPBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.TRANSUPBILL.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.TRANSDOWNBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.TRANSDOWNBILL.getName();
                            } else if (StringUtils.equals((CharSequence)tempStr, (CharSequence)SourceBillTypeEnum.DRAFTTRADEBILL.getValue())) {
                                tempStr = SourceBillTypeEnum.DRAFTTRADEBILL.getName();
                            }
                            details1.put(str, tempStr);
                            continue block38;
                        }
                        case "value_2": {
                            int longOfTwoDate = this.longOfTwoDate(dynObj1.getDate("bank_bookdate"), exportDetail.getDate("bizdate")) + 1;
                            tempStr = longOfTwoDate + "";
                            details1.put(str, tempStr);
                            continue block38;
                        }
                        case "value_3": {
                            bigDecimal = dynObj1.getBigDecimal("bank_debitamount");
                            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                                details1.put(str, dynObj1.getBigDecimal("bank_creditamount"));
                                continue block38;
                            }
                            details1.put(str, bigDecimal);
                            continue block38;
                        }
                        default: {
                            details1.put(str, res);
                        }
                    }
                }
                details1.put("amtprecision", amtPrecision);
                exportEntitySheet2.add(details1);
            }
        }
        String fileUrl = null;
        CreateExcelUtil.createExcelFile((SXSSFWorkbook)wb, (String)ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868", (String)"BalanceAdjustListPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), (String[])exportTitleSheet1, exportEntitySheet1);
        CreateExcelUtil.createExcelFile((SXSSFWorkbook)wb, (String)ResManager.loadKDString((String)"\u672a\u8fbe\u660e\u7ec6\u8868", (String)"BalanceAdjustListPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), (String[])exportTitleSheet2, exportEntitySheet2);
        try {
            String excelName = ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868\u53ca\u672a\u8fbe\u660e\u7ec6", (String)"BalanceAdjustListPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            excelName = CreateExcelUtil.getTempFilename1((String)excelName);
            fileUrl = CreateExcelUtil.writeFile((SXSSFWorkbook)wb, (String)excelName);
        }
        catch (KDException e) {
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        this.getView().download(fileUrl);
    }

    private int longOfTwoDate(Date first, Date second) {
        if (first == null || second == null) {
            return 0;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String s1 = format.format(first);
        String s2 = format.format(second);
        try {
            first = format.parse(s1);
            second = format.parse(s2);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(first);
        int cnt = 0;
        while (calendar.getTime().compareTo(second) < 0) {
            calendar.add(5, 1);
            ++cnt;
        }
        return cnt;
    }

    private DynamicObject[] getSelectedData() {
        List<Long> idList = this.getSelectedIdList();
        if (idList == null || idList.size() == 0) {
            return null;
        }
        String orderBys = "bizdate desc,org.number desc,bankcgsetting.name desc,bankaccount.bankaccountnumber desc";
        return BusinessDataServiceHelper.load((String)FORMNAME, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)orderBys);
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow listSelectedRowValue : selectedRows) {
            idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
        }
        return idList;
    }

    private List<ComboItem> getPeriod() {
        long orgId;
        DynamicObject systemStatusCtrol;
        ArrayList<ComboItem> accountItem = new ArrayList<ComboItem>();
        String filterCache = this.getPageCache().get("filterFields");
        if (!StringUtils.isEmpty((CharSequence)filterCache) && !filterCache.equals(this.cacheOrgIdNotInit) && (systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol((long)(orgId = Long.parseLong(filterCache)))) != null) {
            try {
                List nearstPeriods = PeriodHelper.getOriginPeriods((long)orgId);
                for (DynamicObject period : nearstPeriods) {
                    accountItem.add(new ComboItem(new LocaleString(period.getString("name")), period.getString("id")));
                }
            }
            catch (Exception e) {
                this.cacheOrgIdNotInit = filterCache;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BalanceAdjustListPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
        return accountItem;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filtervalue = args.getSearchClickEvent().getFilterValues();
        List selectedOrgIds = args.getSearchClickEvent().getFilterModel().getSelectedMainOrgIds();
        if (selectedOrgIds.size() > 0) {
            this.selectedOrgIdList = new ArrayList<Object>(selectedOrgIds.size());
            for (int i = 0; i < selectedOrgIds.size(); ++i) {
                this.selectedOrgIdList.add(selectedOrgIds.get(i));
            }
            List<Object> orgList = this.getCachedOrgList();
            this.orgChange = null == orgList ? false : this.isEqualList(orgList, this.selectedOrgIdList);
            this.cacheSelectedOrgIdList(this.selectedOrgIdList);
            if (null != orgList && !this.orgChange) {
                List customfilterList = (List)filtervalue.get("customfilter");
                ArrayList<Map> newFilterList = new ArrayList<Map>();
                for (Map map : customfilterList) {
                    if ("bankaccount.id".equals(((List)map.get("FieldName")).get(0)) || "period.id".equals(((List)map.get("FieldName")).get(0))) continue;
                    newFilterList.add(map);
                }
                filtervalue.put("customfilter", newFilterList);
            }
            this.filterContainerInit(this.initArgs);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("org.id".equals(fieldName)) {
            Long userPK = RequestContext.get().getCurrUserId();
            String appId = this.getView() == null ? "" : this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgIds = OrgHelper.getAuthBankOrgIds((Long)userPK, (String)appId, (String)FORMNAME, (String)"47150e89000000ac");
            QFilter idsFilter = new QFilter("id", "in", (Object)orgIds);
            args.getQfilters().add(idsFilter);
        }
        if ("bankaccount.id".equals(fieldName)) {
            List orgIdList = this.getCachedOrgList().stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
            QFilter idsFilter = AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgIdList);
            idsFilter.and(VisibleVirtualAcctHelper.notVirtualAcctQf());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(idsFilter);
            args.setQfilters(qFilters);
        }
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    private void cacheSelectedOrgIdList(List<Object> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    private List<Map<String, Object>> getOrgList() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgSet = OrgHelper.getAuthBankOrgIds((Long)userId, (String)appId, (String)FORMNAME, (String)"47150e89000000ac");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (orgSet.size() > 0) {
            List isFinishInitList = SystemStatusCtrolHelper.getBatchSystemStatusControl((Set)orgSet);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrg", (String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgSet)}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    if (!isFinishInitList.contains(row.getLong("id"))) continue;
                    HashMap<String, Object> temp = new HashMap<String, Object>(2);
                    temp.put("id", row.getLong("id"));
                    temp.put("name", row.getString("name"));
                    result.add(temp);
                }
            }
        }
        return result;
    }

    private List<Map<String, Object>> getAccountBank(List<Object> orgPks) {
        List orgIdList = orgPks.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
        QFilter accountAuthAssignFilter = AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgIdList);
        QFilter[] filters = new QFilter[]{accountAuthAssignFilter, VisibleVirtualAcctHelper.notVirtualAcctQf()};
        DynamicObject[] accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,name", (QFilter[])filters);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(accountBank.length);
        HashMap<String, Object> temp = null;
        for (DynamicObject account : accountBank) {
            temp = new HashMap<String, Object>(2);
            temp.put("id", account.getLong("id"));
            temp.put("name", account.getString("name"));
            result.add(temp);
        }
        return result;
    }

    private boolean isEqualList(List<Object> src, List<Object> target) {
        List<Long> srcList = src.stream().map(Object::toString).map(Long::parseLong).collect(Collectors.toList());
        List<Long> targeList = target.stream().map(Object::toString).map(Long::parseLong).collect(Collectors.toList());
        if (src.size() == target.size()) {
            if (src.size() == 0) {
                return true;
            }
            this.sortList(srcList);
            this.sortList(targeList);
            int sLen = src.size();
            for (int i = 0; i < sLen; ++i) {
                if (srcList.get(i).longValue() == targeList.get(i).longValue()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void sortList(List<Long> list) {
        list.sort((arg0, arg1) -> arg0 > arg1 ? 1 : (arg0 < arg1 ? -1 : 0));
    }

    public boolean isTrack() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isTrack = formShowParameter.getCustomParam("isTrack");
        return EmptyUtil.isEmpty((Object)isTrack) ? false : (Boolean)isTrack;
    }
}

