/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementDownloadEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BankStatementDownloadEdit.class);
    private static final String ORG = "org";
    private static final String ACCOUNTBANK = "accountbank";
    private static final String BEGINDATE = "begindate";
    private static final String ENDDATE = "enddate";
    private long beginTime = 0L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setF7SelectListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(ENDDATE, (Object)new Date());
        Long defaultOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("defaultorg").toString());
        QFilter[] filter = new QFilter[]{new QFilter(ORG, "=", (Object)defaultOrgId)};
        DynamicObject obj = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id,currentperiod.id,currentperiod.begindate,startperiod.id,startperiod.begindate", (QFilter[])filter);
        if (obj != null) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)defaultOrgId, (String)"bos_org");
            DynamicObjectCollection orgCol = MultiBaseDataHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG, (DynamicObject[])new DynamicObject[]{org});
            this.getModel().setValue(ORG, (Object)orgCol);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "org": {
                this.getModel().setValue(ACCOUNTBANK, null);
                this.getModel().setValue(BEGINDATE, null);
                break;
            }
            case "enddate": {
                this.endDateChanged(newValue, oldValue);
                break;
            }
        }
    }

    private void endDateChanged(Object newValue, Object oldValue) {
        if (CasHelper.isEmpty((Object)newValue)) {
            return;
        }
        Date date = (Date)newValue;
        if (date.after(new Date())) {
            this.getModel().setValue(ENDDATE, oldValue);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"BankStatementDownloadEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("download".equals(op.getOperateKey())) {
            this.beginTime = System.currentTimeMillis();
            if (!this.verify()) {
                args.cancel = true;
            }
        }
    }

    public boolean verify() {
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORG);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgCol)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"BankStatementDownloadEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date beginDate = (Date)this.getModel().getValue(BEGINDATE);
        Date endDate = (Date)this.getModel().getValue(ENDDATE);
        if (beginDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"BankStatementDownloadEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (endDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f\u3002", (String)"BankStatementDownloadEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (beginDate.after(endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"BankStatementDownloadEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("download".equals(op.getOperateKey()) && (result = args.getOperationResult()).isSuccess()) {
            HashSet errorPkIds;
            int successCount = result.getSuccessPkIds().size() - 1;
            int failCount = 0;
            ValidateResultCollection validateResult = result.getValidateResult();
            if (validateResult != null && (errorPkIds = validateResult.getErrorPkIds()) != null) {
                failCount = errorPkIds.size();
            }
            int acctBankCount = 0;
            DynamicObjectCollection acctBanks = (DynamicObjectCollection)this.getModel().getValue(ACCOUNTBANK);
            if (!acctBanks.isEmpty()) {
                acctBankCount = acctBanks.size();
            } else {
                DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORG);
                if (orgCol != null) {
                    Set ids = orgCol.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    QFilter filter = new QFilter(ORG, "in", ids);
                    DynamicObject[] acctBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filter});
                    acctBankCount = acctBank.length;
                }
            }
            String noCasInitTip = result.getMessage();
            String message = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u94f6\u884c\u8d26\u6237\uff0c\u4e0b\u8f7d\u6210\u529f%2$s\u7b14\u8bb0\u5f55\uff0c\u5931\u8d25%3$s\u7b14\u8bb0\u5f55\u3002", (String)"BankStatementDownloadEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBankCount, successCount, failCount);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().getParentView().showSuccessNotification(noCasInitTip + message, Integer.valueOf(6000));
            this.getView().close();
            long time = System.currentTimeMillis() - this.beginTime;
            logger.info(String.format("\u4e0b\u8f7d\u6210\u529f%s\u7b14\u5bf9\u8d26\u5355\uff0c\u8017\u65f6%sms", successCount, time));
        }
    }

    private void setF7SelectListener() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl(ORG);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,org.id", (QFilter[])new QFilter[0]);
        List orgInitIds = Arrays.stream(objects).map(o -> o.get("org.id")).collect(Collectors.toList());
        orgCtrl.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            Long userId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cas_bankstatement", (String)"4730fc9f000007ae");
            orgInitIds.retainAll(orgIds);
            QFilter filter = new QFilter("id", "in", (Object)orgInitIds);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit acctCtr = (BasedataEdit)this.getControl(ACCOUNTBANK);
        acctCtr.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORG);
            Set ids = orgCol.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(ids)) {
                QFilter usableAccountFilter = AccountBankHelper.getAccountBankFilterByOrg(ids);
                ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
                filters.add(usableAccountFilter);
                showParameter.setIsolationOrg(false);
                showParameter.getListFilterParameter().setQFilters(filters);
            }
        });
    }
}

