/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.RecDecInitHelper;

public class BankStatementEdit
extends BillEditPlugin {
    private static final String SOURCE_THREE = "3";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"accountbank"});
        this.initF7();
    }

    private void initF7() {
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("accountbank");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            showParameter.getListFilterParameter().setQFilters(qFilters);
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isCheck = (Boolean)this.getModel().getValue("ischeck");
        if (isCheck) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_del"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_del"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        BigDecimal creditAmount;
        super.afterImportData(e);
        Long orgPk = this.getPk("org");
        Date bizDdate = (Date)this.getValue("bizdate");
        if (orgPk == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5199\u7684\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"BankStatementEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject period = PeriodHelper.getPeriodByDate((long)orgPk, (Date)bizDdate);
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u65e5\u671f\u5339\u914d\u7ec4\u7ec7\u671f\u95f4\u3002", (String)"BankStatementEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        BigDecimal debitAmount = (BigDecimal)this.getValue("debitamount");
        if (debitAmount == null) {
            debitAmount = BigDecimal.ZERO;
        }
        if ((creditAmount = (BigDecimal)this.getValue("creditamount")) == null) {
            creditAmount = BigDecimal.ZERO;
        }
        if (creditAmount.compareTo(BigDecimal.ZERO) == 0 && debitAmount.compareTo(BigDecimal.ZERO) == 0 || creditAmount.compareTo(BigDecimal.ZERO) != 0 && debitAmount.compareTo(BigDecimal.ZERO) != 0) {
            String msg = ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u7684\u501f\u8d37\u91d1\u989d\u4e0d\u5408\u6cd5,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.setValue("period", period);
        this.setValue("isvalid", RecDecInitHelper.getValid((Long)orgPk, (Date)bizDdate));
        this.setValue("source", SOURCE_THREE);
    }
}

