/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementPrintPlugin
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>();
        String dataSourceName = e.getDataSourceName();
        Object billId = e.getPKId();
        Set customFields = e.getCustomFields();
        if (dataSourceName.equals("cas_bankstatement")) {
            DynamicObject bankstatement = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"cas_bankstatement");
            String acctNo = bankstatement.getString("accountbank.bankaccountnumber");
            String currName = bankstatement.getString("currency.name");
            String orgName = bankstatement.getString("org.name");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement");
            DynamicObjectType cloneType = null;
            try {
                cloneType = (DynamicObjectType)dataEntityType.clone();
                for (String customField : customFields) {
                    DynamicSimpleProperty demoProp = new DynamicSimpleProperty(customField, String.class, (Object)"");
                    cloneType.registerSimpleProperty(demoProp);
                }
                DynamicObject item = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)cloneType, (Object)bankstatement);
                item.set("org", bankstatement.get("org"));
                item.set("accountbank", bankstatement.get("accountbank"));
                item.set("currency", bankstatement.get("currency"));
                if (bankstatement.getBigDecimal("debitamount").compareTo(BigDecimal.ZERO) == 0) {
                    item.set("debit", (Object)0);
                    item.set("credit", (Object)1);
                } else {
                    item.set("debit", (Object)1);
                    item.set("credit", (Object)0);
                }
                item.set("acct", (Object)(acctNo + "," + currName + "," + orgName));
                item.set("date", (Object)DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                newDataEntities.add(item);
            }
            catch (CloneNotSupportedException e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u514b\u9686\u5c5e\u6027\u51fa\u9519\uff01%s", (String)"BankStatementPrintPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), e1.getMessage()));
            }
        } else if (dataSourceName.equals("entryentity")) {
            DynamicObject receipt = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"cas_bankstatement", (String)"bankcheckflag");
            String bankcheckflag = receipt.getString("bankcheckflag");
            ArrayList<DynamicObject> customDataEntites = new ArrayList<DynamicObject>();
            if (bankcheckflag != null && EmptyUtil.isNoEmpty((String)bankcheckflag)) {
                this.getDataEntities(customDataEntites, "cas_agentpaybill", "billno,payamount", bankcheckflag, ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"BankStatementPrintPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getDataEntities(customDataEntites, "cas_recbill", "billno,actrecamt", bankcheckflag, ResManager.loadKDString((String)"\u6536\u6b3e\u5355", (String)"BankStatementPrintPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getDataEntities(customDataEntites, "cas_paybill", "billno,actpayamt", bankcheckflag, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"BankStatementPrintPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            newDataEntities.addAll(customDataEntites);
        }
        e.setDataEntities(newDataEntities);
    }

    private void getDataEntities(List<DynamicObject> customDataEntites, String entity, String selector, Object bankcheckflag, String billType) {
        DynamicObjectCollection objects = QueryServiceHelper.query((String)entity, (String)selector, (QFilter[])new QFilter[]{new QFilter("bankcheckflag_tag", "=", bankcheckflag)});
        for (DynamicObject obj : objects) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_elecreceipt");
            DynamicObjectType cloneType = null;
            try {
                cloneType = (DynamicObjectType)dataEntityType.clone();
                DynamicObject item = new DynamicObject(cloneType);
                DynamicSimpleProperty billtype = new DynamicSimpleProperty("billtype", String.class, (Object)"");
                item.getDynamicObjectType().registerSimpleProperty(billtype);
                DynamicSimpleProperty billno = new DynamicSimpleProperty("billno", String.class, (Object)"");
                item.getDynamicObjectType().registerSimpleProperty(billno);
                DynamicSimpleProperty amount = new DynamicSimpleProperty("billamount", String.class, (Object)"");
                item.getDynamicObjectType().registerSimpleProperty(amount);
                item.set("billtype", (Object)billType);
                item.set("billno", obj.get(selector.split(",")[0]));
                item.set("billamount", obj.get(selector.split(",")[1]));
                customDataEntites.add(item);
            }
            catch (CloneNotSupportedException e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u514b\u9686\u5c5e\u6027\u51fa\u9519\uff01%s", (String)"BankStatementPrintPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), e1.getMessage()));
            }
        }
    }
}

