/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.ObjectField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.util.DateUtils;

public class BankStatementPrintPluginNew
extends AbstractPrintPlugin {
    public void loadCustomData(CustomDataLoadEvent evt) {
        Object bankcheckflag;
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        Object billId = dataSource.getPkId();
        List newDataEntities = evt.getCustomDataRows();
        DynamicObject bankStatement = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"cas_bankstatement");
        if ("tableHead".equals(dataSourceName)) {
            String acctNo = bankStatement.getString("accountbank.bankaccountnumber");
            String currName = bankStatement.getString("currency.name");
            String orgName = bankStatement.getString("org.name");
            DataRowSet item = new DataRowSet();
            if (bankStatement.getBigDecimal("debitamount").compareTo(BigDecimal.ZERO) == 0) {
                item.put("debit", (Field)new IntegerField(Integer.valueOf(0)));
                item.put("credit", (Field)new IntegerField(Integer.valueOf(1)));
            } else {
                item.put("debit", (Field)new IntegerField(Integer.valueOf(1)));
                item.put("credit", (Field)new IntegerField(Integer.valueOf(0)));
            }
            item.put("acct", (Field)new TextField(acctNo + "," + currName + "," + orgName));
            item.put("date", (Field)new TextField(DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")));
            newDataEntities.add(item);
        } else if ("tableData".equals(dataSourceName) && (bankcheckflag = bankStatement.get("bankcheckflag")) != null) {
            this.getDataEntities(newDataEntities, "cas_agentpaybill", "billno,payamount", bankcheckflag, ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"BankStatementPrintPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getDataEntities(newDataEntities, "cas_recbill", "billno,actrecamt", bankcheckflag, ResManager.loadKDString((String)"\u6536\u6b3e\u5355", (String)"BankStatementPrintPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getDataEntities(newDataEntities, "cas_paybill", "billno,actpayamt", bankcheckflag, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"BankStatementPrintPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void getDataEntities(List<DataRowSet> newDataEntities, String entity, String selector, Object bankcheckflag, String billType) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)entity, (String)selector, (QFilter[])new QFilter[]{new QFilter("bankcheckflag_tag", "=", bankcheckflag)});
        if (objects == null || objects.length == 0) {
            return;
        }
        for (DynamicObject obj : objects) {
            DataRowSet d = new DataRowSet();
            d.put("billtype", (Field)new ObjectField((Object)billType));
            d.put("billno", (Field)new ObjectField(obj.get(selector.split(",")[0])));
            d.put("billamount", (Field)new ObjectField(obj.get(selector.split(",")[1])));
            newDataEntities.add(d);
        }
    }
}

