/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementTreeList
extends StandardTreeListPlugin {
    public static final int MAX_LEVEL = 99;
    private static final String FILTER_ORGID = "org.id";
    private static final String FILTER_BANKACCTID = "accountbank.id";
    private static final String FILTER_CURRENCYID = "currency.id";
    private static final String TREEFILTER = "treeFilter";
    private static final Log logger = LogFactory.getLog(BankStatementTreeList.class);

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("showtype".equalsIgnoreCase(propertyName)) {
            String showType = (String)this.getModel().getValue("showtype");
            this.getPageCache().put("showType", showType);
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
            this.getTreeListView().refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            String fieldName = ((List)currentCommonFilter.get("FieldName")).get(0).toString();
            List value = (List)currentCommonFilter.get("Value");
            StringBuilder valueStr = new StringBuilder();
            for (Object obj : value) {
                if (null == obj || obj.toString().equals("")) continue;
                valueStr.append(obj).append(',');
            }
            if (fieldName.equals(FILTER_ORGID)) {
                fieldName = fieldName + "%";
                if (!valueStr.toString().equals(this.getPageCache().get(fieldName))) {
                    this.getPageCache().put("isorgchange", "true");
                } else {
                    this.getPageCache().put("isorgchange", "false");
                }
            }
            this.getPageCache().put(fieldName, valueStr.toString());
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
            this.getTreeListView().refresh();
        }
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11", "flexpanel_treebtn"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        e.setChildNodes(this.getChildNodes());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.equals("refresh") || operateKey.equals("save")) {
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
            this.getTreeListView().refresh();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        String pNodeId = (String)e.getParentNodeId();
        if (StringUtils.isEmpty((CharSequence)pNodeId)) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        String rootNodeId = this.getTreeModel().getRoot().getId();
        QFilter treeFilter = rootNodeId.equals(pNodeId) ? this.getOrgFilter(currNodeId) : this.getBankFilter(currNodeId);
        this.getPageCache().put("pNodeId", pNodeId);
        this.getPageCache().put("currNodeId", currNodeId);
        this.getPageCache().put("rootNodeId", rootNodeId);
        if (treeFilter != null) {
            String serialStr = treeFilter.toSerializedString();
            logger.info("cache\u524d" + serialStr);
            this.getPageCache().put(TREEFILTER, treeFilter.toSerializedString());
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String treeFilterStr = this.getPageCache().get(TREEFILTER);
        logger.info("cache\u540e" + treeFilterStr);
        this.getPageCache().remove(TREEFILTER);
        String pNodeId = this.getPageCache().get("pNodeId");
        String currNodeId = this.getPageCache().get("currNodeId");
        String rootNodeId = this.getPageCache().get("rootNodeId");
        QFilter treeFilter = null;
        if (CasHelper.isEmpty((Object)treeFilterStr)) {
            return;
        }
        if (rootNodeId != null && rootNodeId.equals(pNodeId)) {
            treeFilter = this.getOrgFilter(currNodeId);
        } else if (CasHelper.isNotEmpty((Object)currNodeId)) {
            treeFilter = this.getBankFilter(currNodeId);
        }
        if (null != treeFilter) {
            e.addQFilter(treeFilter);
        }
    }

    public List<TreeNode> getChildNodes() {
        List filterOrgIds = this.getControlFilters().getFilter(FILTER_ORGID);
        TreeNode currNode = this.getTreeModel().getRoot();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        IPageCache pageCache = this.getPageCache();
        String orgIdStr = pageCache.get("org.id%");
        String isOrgChange = pageCache.get("isorgchange");
        List<Object> cacheOrg = new ArrayList(16);
        if (StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
            String[] orgs = orgIdStr.split(",");
            cacheOrg = Arrays.asList(orgs);
        }
        String bankacctIdStr = "";
        if (StringUtils.isNotEmpty((CharSequence)isOrgChange) && isOrgChange.equals("true") || !CollectionUtils.isEmpty(cacheOrg) && !filterOrgIds.equals(cacheOrg)) {
            bankacctIdStr = "";
            pageCache.put(FILTER_BANKACCTID, "");
        } else {
            bankacctIdStr = pageCache.get(FILTER_BANKACCTID);
        }
        this.getPageCache().put("isorgchange", "");
        String currencyIdStr = pageCache.get(FILTER_CURRENCYID);
        Set currencyIdSet = null;
        if (EmptyUtil.isNoEmpty((String)currencyIdStr)) {
            currencyIdSet = Arrays.stream(currencyIdStr.split(",")).map(Long::valueOf).collect(Collectors.toSet());
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List authOrgIds = !CollectionUtils.isEmpty((Collection)filterOrgIds) && EmptyUtil.isNoEmpty(filterOrgIds.get(0)) ? filterOrgIds.stream().filter(i -> StringUtils.isNotEmpty((CharSequence)String.valueOf(i))).map(i -> Long.valueOf(String.valueOf(i))).collect(Collectors.toList()) : OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_bankstatement", (String)"47150e89000000ac");
        List orgIdList = null;
        if (!StringUtils.isEmpty((CharSequence)orgIdStr)) {
            orgIdList = Arrays.stream(orgIdStr.split(",")).map(Long::valueOf).collect(Collectors.toList());
            authOrgIds = authOrgIds.stream().filter(orgIdList::contains).collect(Collectors.toList());
        }
        qfilters.add(AccountBankHelper.getUseAuthAccountBankFilterByOrg(authOrgIds));
        if (!StringUtils.isEmpty((CharSequence)bankacctIdStr)) {
            List bankacctIdList = Arrays.stream(bankacctIdStr.split(",")).map(Long::valueOf).collect(Collectors.toList());
            qfilters.add(new QFilter("id,currency", "in", bankacctIdList));
        }
        qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        Object[] bankAccts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,company,name,currency", (QFilter[])qfilters.toArray(new QFilter[0]));
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        HashSet<String> childNodeSet = new HashSet<String>();
        HashSet allOrgIdSet = new HashSet(16);
        if (EmptyUtil.isNoEmpty(orgIdList)) {
            authOrgIds.removeAll(orgIdList);
            authOrgIds.addAll(orgIdList);
        }
        allOrgIdSet.addAll(authOrgIds);
        QFilter orgFilter = new QFilter("id", "in", allOrgIdSet);
        orgFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Map idAndOrgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{orgFilter});
        Map useAuthOrgMap = new HashMap(16);
        if (EmptyUtil.isNoEmpty((Object[])bankAccts)) {
            useAuthOrgMap = AccountBankHelper.getUseAuthorityOrgByAccIds((Object[])Arrays.stream(bankAccts).map(data -> data.getLong("id")).toArray());
        }
        String showType = this.getPageCache().get("showType");
        for (Object data2 : bankAccts) {
            HashSet tempOrgIdSet = new HashSet(allOrgIdSet);
            DynamicObject org = data2.getDynamicObject("company");
            if (EmptyUtil.isEmpty((DynamicObject)org)) continue;
            String accountOrgId = org.getPkValue().toString();
            long longOrgId = Long.parseLong(accountOrgId);
            Set<String> loopOrgSet = new HashSet<String>(16);
            if (EmptyUtil.isEmpty(allOrgIdSet) || !allOrgIdSet.contains(longOrgId)) {
                Set useAuthOrgIdSet = (Set)useAuthOrgMap.get(data2.getLong("id"));
                if (EmptyUtil.isNoEmpty((Object)useAuthOrgIdSet)) {
                    tempOrgIdSet.retainAll(useAuthOrgIdSet);
                    loopOrgSet = tempOrgIdSet.stream().map(Object::toString).collect(Collectors.toSet());
                }
            } else {
                loopOrgSet.add(accountOrgId);
            }
            for (String orgId : loopOrgSet) {
                DynamicObject useAuthOrg = (DynamicObject)idAndOrgMap.get(Long.parseLong(orgId));
                if (nodeMap.get(orgId) == null) {
                    TreeNode node = new TreeNode();
                    node.setText(EmptyUtil.isNoEmpty((DynamicObject)useAuthOrg) ? useAuthOrg.getString("name") : org.getString("name"));
                    node.setId(orgId);
                    node.setParentid(currNode.getId());
                    nodes.add(node);
                    nodeMap.put(orgId, node);
                }
                String pkValue = data2.getString("id");
                DynamicObjectCollection currencys = data2.getDynamicObjectCollection("currency");
                for (DynamicObject obj : currencys) {
                    DynamicObject currency = obj.getDynamicObject("fbasedataid");
                    if (null == currency) continue;
                    String currencyId = currency.getString("id");
                    String currencyName = currency.getString("name");
                    if (null != currencyIdSet && null != currencyId && !currencyIdSet.contains(Long.parseLong(currencyId)) || childNodeSet.contains(orgId + pkValue + currencyId)) continue;
                    TreeNode node = new TreeNode();
                    if ("1".equalsIgnoreCase(showType)) {
                        node.setText(data2.getString("name") + ' ' + currencyName);
                    } else {
                        node.setText(data2.getString("bankaccountnumber") + ' ' + currencyName);
                    }
                    node.setId(pkValue + "," + currencyId);
                    node.setParentid(orgId);
                    node.setLeaf(true);
                    ((TreeNode)nodeMap.get(orgId)).addChild(node);
                    childNodeSet.add(orgId + pkValue + currencyId);
                }
            }
        }
        return nodes;
    }

    protected TreeNode getNodeById(Object nodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode((String)nodeId, 99);
        return currNode;
    }

    private QFilter getOrgFilter(String nodeId) {
        return new QFilter("org", "=", (Object)Long.valueOf(nodeId));
    }

    private QFilter getBankFilter(String nodeId) {
        if (CasHelper.isEmpty((Object)nodeId) || !nodeId.contains(",")) {
            return null;
        }
        String[] values = nodeId.split(",");
        if (values.length != 2) {
            return null;
        }
        return new QFilter("accountbank", "=", (Object)Long.valueOf(values[0])).and(new QFilter("currency", "=", (Object)Long.valueOf(values[1])));
    }
}

