/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.formplugin.UnreachBaseFormRpt;
import kd.fi.cas.formplugin.helper.UnReachHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;

public class BankUnreachFormRpt
extends UnreachBaseFormRpt {
    public BankUnreachFormRpt() {
        this.sourceEntity = "cas_bankunreach";
    }

    @Override
    protected QFilter[] getAcctFilter() {
        String queryOrgType = (String)this.getModel().getValue("queryorgtype");
        QFilter[] accountFilter = null;
        if ("org".equals(queryOrgType)) {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            accountFilter = new QFilter[]{AccountBankHelper.getUseAuthAccountBankFilterByOrg(this.getIdList(orgColl))};
        } else {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("openorg");
            accountFilter = new QFilter[]{new QFilter("openorg", "in", this.getIdList(orgColl))};
        }
        return accountFilter;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    @Override
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.queryOrgTypeChange((String)this.getModel().getValue("queryorgtype"), true);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String queryOrgType = (String)this.getModel().getValue("queryorgtype");
        this.queryOrgTypeChange(queryOrgType, false);
    }

    @Override
    protected Boolean verifyInitRecDecOrg(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        String queryOrgType = filterInfo.getString("queryorgtype");
        if ("openorg".equals(queryOrgType)) {
            Date endDate;
            DynamicObjectCollection openOrgs = filterInfo.getDynamicObjectCollection("openorg");
            List<Long> filterOrgIds = UnReachHelper.getOrgIds(openOrgs, endDate = filterInfo.getDate("enddate"));
            if (filterOrgIds.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u8303\u56f4\u5185\u7684\u7ec4\u7ec7\u5747\u672a\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u529f\u80fd\u6216\u622a\u6b62\u65e5\u671f\u65e9\u4e8e\u5bf9\u8d26\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u672a\u8fbe\u8d26\u9879\u3002", (String)"BankUnreachFormRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return false;
            }
            List orgIds = OrgHelper.getIdList((DynamicObjectCollection)openOrgs);
            if (orgIds.size() != filterOrgIds.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u5185\u90e8\u5206\u7ec4\u7ec7\u672a\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u529f\u80fd\u6216\u622a\u6b62\u65e5\u671f\u5c0f\u4e8e\u5bf9\u8d26\u542f\u7528\u671f\u95f4\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u8fc7\u6ee4\u3002\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4ec5\u4e3a\u6709\u6548\u6570\u636e\u3002", (String)"BankUnreachFormRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else {
            Date endDate;
            DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("org");
            List<Long> filterOrgIds = UnReachHelper.getOrgIds(orgs, endDate = filterInfo.getDate("enddate"));
            if (filterOrgIds.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u8303\u56f4\u5185\u7684\u7ec4\u7ec7\u5747\u672a\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u529f\u80fd\u6216\u622a\u6b62\u65e5\u671f\u65e9\u4e8e\u5bf9\u8d26\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u672a\u8fbe\u8d26\u9879\u3002", (String)"BankUnreachFormRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return false;
            }
            List orgIds = OrgHelper.getIdList((DynamicObjectCollection)orgs);
            if (orgIds.size() != filterOrgIds.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u5185\u90e8\u5206\u7ec4\u7ec7\u672a\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u529f\u80fd\u6216\u622a\u6b62\u65e5\u671f\u5c0f\u4e8e\u5bf9\u8d26\u542f\u7528\u671f\u95f4\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u8fc7\u6ee4\u3002\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4ec5\u4e3a\u6709\u6548\u6570\u636e\u3002", (String)"BankUnreachFormRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if ("queryorgtype".equals(name)) {
            this.queryOrgTypeChange((String)newValue, true);
        } else if ("openorg".equals(name)) {
            this.openOrgChange();
        }
    }

    private void initF7() {
        BasedataEdit openOrgCtrl = (BasedataEdit)this.getControl("openorg");
        openOrgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter;
            QFilter uFilter = openOrgCtrl.getQFilter();
            if (uFilter == null) {
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                showParameter = F7FilterUtil.accountingOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)this.sourceEntity, (String)"47150e89000000ac", null);
            } else {
                showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(uFilter);
            }
            showParameter.setIsolationOrg(false);
        });
    }

    private void queryOrgTypeChange(String queryOrgType, Boolean needDefaultOrg) {
        if ("org".equals(queryOrgType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"org"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"openorg"});
            this.getModel().setValue("openorg", null);
            if (needDefaultOrg.booleanValue()) {
                this.defaultOrg();
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"org"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"openorg"});
            this.getModel().setValue("org", null);
            if (needDefaultOrg.booleanValue()) {
                this.defaultOpenOrg();
            }
        }
    }

    protected void openOrgChange() {
        this.getModel().setValue("accountbank", null);
        this.getModel().setValue("currency", null);
    }

    @Override
    protected String getOrgControlName() {
        String orgControlName = "org";
        if ("openorg".equals((String)this.getModel().getValue("queryorgtype"))) {
            orgControlName = "openorg";
        }
        return orgControlName;
    }

    private void defaultOpenOrg() {
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set openOrgList = OrgHelper.getAuthAcctOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.sourceEntity, (String)"47150e89000000ac");
        if (openOrgList.size() > 0) {
            long currentOrgId = RequestContext.get().getOrgId();
            long openOrgId = (Long)openOrgList.toArray()[0];
            if (openOrgList.contains(currentOrgId)) {
                openOrgId = currentOrgId;
            }
            Object[] arrObj = new Object[]{openOrgId};
            this.getModel().setValue("openorg", (Object)arrObj);
        }
    }
}

