/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.UnreachBaseListDataRpt;
import kd.fi.cas.formplugin.UnreachParam;
import kd.fi.cas.formplugin.helper.UnReachHelper;
import kd.fi.cas.helper.AccountBankHelper;

public class BankUnreachListDataRpt
extends UnreachBaseListDataRpt {
    public BankUnreachListDataRpt() {
        this.sourceEntity = "cas_bankjournal";
    }

    @Override
    protected DataSet getRptListDataSet(UnreachParam param) {
        QFilter[] qfilters = param.getQFilter();
        QFilter queryQFilter = this.getQueryQFilter(param);
        if (qfilters == null || qfilters.length == 0) {
            qfilters = new QFilter[]{queryQFilter};
        } else {
            qfilters[0].and(queryQFilter);
        }
        DataSet detailset = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getRptListDataSet"), (String)this.sourceEntity, (String)(this.getQueryFiled(param) + ",0 as rowtype"), (QFilter[])qfilters, null);
        detailset = detailset.orderBy(new String[]{"orgid", "openorgid", "bankaccountid", "currencyid"});
        GroupbyDataSet groupdataset = detailset.groupBy(new String[]{"orgid", "openorgid", "bankaccountid", "currencyid"}).sum("debitamount").sum("creditamount");
        DataSet sumset = groupdataset.finish();
        sumset = sumset.select(new String[]{"orgid", "openorgid", "bankaccountid", "currencyid", "debitamount", "creditamount"}).addNullField("orgname").addNullField("bankaccountname").addField("currencyid", "currencyname").addNullField("currencyname1").addField("'" + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"BankUnreachListDataRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]) + "'", "description").addNullField("bizdate").addNullField("settlementtype").addNullField("settlementnumber").addNullField("sourcebilltype").addNullField("sourcebillnumber").addNullField("bookdate").addNullField("pddate").addNullField("avddate").addNullField("createtime").addNullField("preparationdate").addNullField("isCheck").addNullField("source").addNullField("cashier").addNullField("feepayer").addNullField("id").addNullField("openorgname").addNullField("isvalid").addNullField("oppunit").addNullField("oppacctnumber").addNullField("oppbank");
        sumset = this.addField(sumset).addField("1", "rowtype");
        DataSet totalSet = detailset.union(sumset).orderBy(new String[]{"orgid", "openorgid", "bankaccountid", "currencyid", "rowtype"});
        return totalSet;
    }

    @Override
    protected List<Field> getRowMetaField() {
        List<Field> list = super.getRowMetaField();
        list.add(new Field("sourcebilltype", (DataType)DataType.StringType));
        list.add(new Field("sourcebillnumber", (DataType)DataType.StringType));
        list.add(new Field("bookdate", (DataType)DataType.TimestampType));
        list.add(new Field("pddate", (DataType)DataType.TimestampType));
        list.add(new Field("avddate", (DataType)DataType.TimestampType));
        list.add(new Field("createtime", (DataType)DataType.TimestampType));
        list.add(new Field("preparationdate", (DataType)DataType.TimestampType));
        list.add(new Field("isCheck", (DataType)DataType.StringType));
        list.add(new Field("vouchernum", (DataType)DataType.StringType));
        list.add(new Field("source", (DataType)DataType.StringType));
        list.add(new Field("cashier", (DataType)DataType.StringType));
        list.add(new Field("feepayer", (DataType)DataType.StringType));
        list.add(new Field("id", (DataType)DataType.LongType));
        list.add(new Field("openorgname", (DataType)DataType.StringType));
        list.add(new Field("oppunit", (DataType)DataType.StringType));
        list.add(new Field("oppacctnumber", (DataType)DataType.StringType));
        list.add(new Field("oppbank", (DataType)DataType.StringType));
        return list;
    }

    @Override
    protected String getQueryFiled(UnreachParam param) {
        String queryFiled = super.getQueryFiled(param);
        if (queryFiled != null) {
            queryFiled = queryFiled + " ,openorg.name as openorgname,sourcebilltype, sourcebillnumber,bookdate,pddate,avddate,createtime,preparationdate,isCheck,source,cashier,feepayer,id, isvalid, oppunit, oppacctnumber, oppbank";
        }
        return queryFiled;
    }

    @Override
    protected DataSet addField(DataSet sumset) {
        return sumset;
    }

    @Override
    protected QFilter getQueryQFilter(UnreachParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (param.getQueryOrgType() != null && "openorg".equals(param.getQueryOrgType())) {
            ArrayList<QFilter> acctFilters = new ArrayList<QFilter>();
            acctFilters.addAll(Arrays.asList(AccountBankHelper.getAccountFilterForOwn(UnReachHelper.getOrgIds(param.getOpenOrgs(), param.getEndDate()))));
            acctFilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])acctFilters.toArray(new QFilter[0]));
            ArrayList<Long> accbidList = new ArrayList<Long>(10);
            if (queryResult != null && queryResult.size() > 0) {
                for (DynamicObject acct : queryResult) {
                    accbidList.add(acct.getLong("id"));
                }
            }
            filters.add(new QFilter("accountbank", "in", accbidList));
        } else {
            filters.add(new QFilter("org", "in", UnReachHelper.getOrgIds(param.getOrgs(), param.getEndDate())));
        }
        return (QFilter)filters.get(0);
    }
}

