/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasBillDraftInfoPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String billType = this.getModel().getDataEntityType().getName();
        String key = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        int index = data[0].getRowIndex();
        switch (key) {
            case "draftbill": 
            case "entry_draftbill": {
                DynamicObjectCollection draftbillColl = (DynamicObjectCollection)data[0].getNewValue();
                this.updateDraftInfo(draftbillColl, billType, index);
                if (!"cas_paybill".equals(billType)) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_draftinfo");
                this.updateDraftTotalAmount(entryEntity, billType, index);
                break;
            }
            case "transamount": {
                DynamicObjectCollection entryEntityData;
                long draftId;
                QFilter[] filters;
                String entityName;
                boolean isExists;
                BigDecimal transamount = (BigDecimal)data[0].getNewValue();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_draftinfo");
                BigDecimal standardbillamount = ((DynamicObject)entryEntity.get(index)).getDynamicObject("draftbillinfo").getBigDecimal("standardbillamount");
                DynamicObject draftDy = ((DynamicObject)entryEntity.get(index)).getDynamicObject("draftbillinfo");
                DynamicObjectCollection draftColl = new DynamicObjectCollection(draftDy.getDynamicObjectType(), null);
                draftColl.add((Object)draftDy);
                Map draftAndAmountMap = DraftHelper.getNewestAvailamountMap((DynamicObjectCollection)draftColl, (String)"draft");
                BigDecimal availableAmount = (BigDecimal)draftAndAmountMap.get(draftDy.getLong("id"));
                HashMap draftIdDealAmountMapDB = new HashMap(10);
                String billNoStr = (String)this.getModel().getValue("billno");
                if (EmptyUtil.isNotEmpty((String)billNoStr) && (isExists = QueryServiceHelper.exists((String)(entityName = billType.equals("cas_payapplybill") ? "cas_payapplybill" : "cas_paybill"), (QFilter[])(filters = new QFilter[]{new QFilter("billno", "=", (Object)billNoStr)})))) {
                    DynamicObject payBill = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])filters);
                    DynamicObjectCollection entrysDB = payBill.getDynamicObjectCollection("cas_draftinfo");
                    draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                }
                BigDecimal avaAmountRow = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty(draftIdDealAmountMapDB) && draftIdDealAmountMapDB.size() > 0 && null == (avaAmountRow = (BigDecimal)draftIdDealAmountMapDB.get(draftId = ((DynamicObject)(entryEntityData = this.getModel().getEntryEntity("cas_draftinfo")).get(index)).getDynamicObject("draftbillinfo").getLong("id")))) {
                    avaAmountRow = BigDecimal.ZERO;
                }
                BigDecimal oldAmount = (BigDecimal)data[0].getOldValue();
                BigDecimal rowSumAmount = avaAmountRow.add(availableAmount);
                if (standardbillamount.compareTo(transamount) > 0 || rowSumAmount.compareTo(transamount) < 0) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6587\u6848\u4e3a\uff1a\u8f6c\u8ba9\u91d1\u989d\u8303\u56f4\u4e3a0.01~%s\u3002", (String)"CasBillDraftInfoPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowSumAmount));
                    this.getModel().setValue("transamount", (Object)oldAmount, index);
                }
                this.updateDraftTotalAmount(entryEntity, billType, index);
                break;
            }
        }
    }

    private void updateDraftTotalAmount(DynamicObjectCollection entryEntity, String billType, int index) {
        if ("cas_paybill".equals(billType)) {
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && entryEntity.size() > 0) {
                BigDecimal eActAmt;
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                BigDecimal draftAmountSum = entryEntity.stream().map(d -> d.getBigDecimal("transamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (Objects.nonNull(currency)) {
                    String sign = currency.getString("sign");
                    FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
                    fobj.getCurrencyFormat().setCurrencySymbols(sign);
                    fobj.getCurrencyFormat().setMinimumFractionDigits(currency.getInt("amtprecision"));
                    Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
                    ((Label)this.getControl("draftamttotal")).setText(currencyFormat.format(draftAmountSum));
                } else {
                    ((Label)this.getControl("draftamttotal")).setText(draftAmountSum.toString());
                }
                BigDecimal ePayableAmt = (BigDecimal)this.getModel().getValue("e_payableamt", 0);
                if (ePayableAmt != null && ePayableAmt.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("e_payableamt", (Object)draftAmountSum, 0);
                }
                if ((eActAmt = (BigDecimal)this.getModel().getValue("e_actamt", 0)) != null && eActAmt.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("e_actamt", (Object)draftAmountSum, 0);
                }
            }
        } else if ("cas_payapplybill".equals(billType)) {
            HashMap<Integer, BigDecimal> money = new HashMap<Integer, BigDecimal>();
            for (DynamicObject entry : entryEntity) {
                Integer srcindex = entry.getInt("srcbillindex");
                BigDecimal totalmoney = BigDecimal.ZERO;
                if (!money.containsKey(srcindex)) {
                    totalmoney = entry.getBigDecimal("transamount");
                    money.put(entry.getInt("srcbillindex"), totalmoney);
                    continue;
                }
                totalmoney = entry.getBigDecimal("transamount").add((BigDecimal)money.get(srcindex));
                money.put(entry.getInt("srcbillindex"), totalmoney);
            }
            Integer srcbillindex = ((DynamicObject)this.getModel().getEntryEntity("cas_draftinfo").get(index)).getInt("srcbillindex");
            int payinfoIndex = srcbillindex - 1;
            BigDecimal draftamttotal = (BigDecimal)money.get(srcbillindex);
            this.getModel().setValue("entry_draftamttotal", (Object)draftamttotal, payinfoIndex);
            Object payeeamount = this.getModel().getValue("entry_payeeamount", payinfoIndex);
            if (payeeamount == null || BigDecimal.ZERO.compareTo(new BigDecimal(payeeamount.toString())) == 0) {
                this.getModel().setValue("entry_payeeamount", (Object)draftamttotal, payinfoIndex);
                Object entry_applyid = this.getModel().getValue("entry_applyid", payinfoIndex);
                if (entry_applyid != null) {
                    DynamicObjectCollection payApplyEntry = this.getModel().getEntryEntity("cas_payapplyentry");
                    for (int i = 0; i < payApplyEntry.size(); ++i) {
                        if (!((DynamicObject)payApplyEntry.get(i)).get("e_splitid").equals(entry_applyid)) continue;
                        this.getModel().setValue("e_payeeamount", (Object)draftamttotal, i);
                        break;
                    }
                }
            }
            this.getView().updateView("cas_payinfo", payinfoIndex);
        }
    }

    private void updateDraftInfo(DynamicObjectCollection draftbillColl, String billType, int index) {
        QFilter[] filters;
        String entityName;
        boolean isExists;
        ArrayList<Integer> deleteEntryRowsList = new ArrayList<Integer>(10);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)draftbillColl) || draftbillColl.size() < 1) {
            if ("cas_payapplybill".equals(billType)) {
                DynamicObjectCollection draftinfos = this.getModel().getEntryEntity("cas_draftinfo");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)draftinfos) || draftinfos.size() < 1) {
                    this.getModel().deleteEntryData("cas_draftinfo");
                    return;
                }
            } else if ("cas_paybill".equals(billType)) {
                this.getModel().deleteEntryData("cas_draftinfo");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                BigDecimal draftAmountSum = BigDecimal.ZERO;
                if (Objects.nonNull(currency)) {
                    String sign = currency.getString("sign");
                    FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
                    fobj.getCurrencyFormat().setCurrencySymbols(sign);
                    fobj.getCurrencyFormat().setMinimumFractionDigits(currency.getInt("amtprecision"));
                    Format currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
                    ((Label)this.getControl("draftamttotal")).setText(currencyFormat.format(draftAmountSum));
                } else {
                    ((Label)this.getControl("draftamttotal")).setText(draftAmountSum.toString());
                }
                return;
            }
        }
        Integer entryindex = null;
        if ("cas_paybill".equals(billType)) {
            entryindex = Integer.valueOf("1");
        } else if ("cas_payapplybill".equals(billType)) {
            DynamicObjectCollection payinfo = this.getModel().getEntryEntity("cas_payinfo");
            entryindex = (Integer)((DynamicObject)payinfo.get(index)).get("Seq");
        }
        if ("cas_payapplybill".equals(billType)) {
            DynamicObjectCollection draftInfos = this.getModel().getEntryEntity("cas_draftinfo");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos) && draftInfos.size() > 0) {
                for (int i = 0; i < draftInfos.size(); ++i) {
                    int srcbillindex = ((DynamicObject)draftInfos.get(i)).getInt("srcbillindex");
                    DynamicObject draftbillinfo = ((DynamicObject)draftInfos.get(i)).getDynamicObject("draftbillinfo");
                    if (!EmptyUtil.isEmpty((DynamicObject)draftbillinfo) && srcbillindex - 1 != index) continue;
                    deleteEntryRowsList.add(i);
                }
                int[] delRowIndexArr = deleteEntryRowsList.stream().mapToInt(Integer::valueOf).toArray();
                this.getModel().deleteEntryRows("cas_draftinfo", delRowIndexArr);
            }
        } else if ("cas_paybill".equals(billType)) {
            this.getModel().deleteEntryData("cas_draftinfo");
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbillinfo", new Object[0]);
        vs.addField("paybillcurrency", new Object[0]);
        vs.addField("transamount", new Object[0]);
        vs.addField("draftbilllogid", new Object[0]);
        vs.addField("srcbilltype", new Object[0]);
        vs.addField("srcbillindex", new Object[0]);
        HashMap draftIdDealAmountMapDB = new HashMap(10);
        HashMap draftIdLogIdMapDB = new HashMap(10);
        String billNo = (String)this.getModel().getValue("billno");
        if (EmptyUtil.isNotEmpty((String)billNo) && (isExists = QueryServiceHelper.exists((String)(entityName = billType.equals("cas_payapplybill") ? "cas_payapplybill" : "cas_paybill"), (QFilter[])(filters = new QFilter[]{new QFilter("billno", "=", (Object)billNo)})))) {
            DynamicObject payBill = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])filters);
            DynamicObjectCollection entrysDB = payBill.getDynamicObjectCollection("cas_draftinfo");
            draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
        }
        Map draftIdAndAvailaAmountMap = DraftHelper.getNewestAvailamountMap((DynamicObjectCollection)draftbillColl, (String)"settlenumber");
        for (DynamicObject entryInfo : draftbillColl) {
            long draftaId = entryInfo.getDynamicObject("fbasedataid").getLong("id");
            BigDecimal savedTransamount = (BigDecimal)draftIdDealAmountMapDB.get(draftaId);
            Long draftBillLogId = (Long)draftIdLogIdMapDB.get(draftaId);
            BigDecimal displayTransamount = EmptyUtil.isEmpty((BigDecimal)savedTransamount) ? (BigDecimal)draftIdAndAvailaAmountMap.get(draftaId) : savedTransamount;
            long displayLogId = EmptyUtil.isEmpty((Long)draftBillLogId) ? 0L : draftBillLogId;
            vs.addRow(new Object[]{draftaId, entryInfo.getDynamicObject("fbasedataid").getDynamicObject("currency").getLong("id"), displayTransamount, displayLogId, billType, entryindex});
        }
        model.batchCreateNewEntryRow("cas_draftinfo", vs);
        model.endInit();
        this.getView().updateView("cas_draftinfo");
    }
}

