/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.JournalBaseFormRpt;
import kd.fi.cas.formplugin.journalprintall.JournalPrintHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.ViewUtils;

public class CashJournalFormRpt
extends JournalBaseFormRpt {
    private static final String CUSTOMSORTENTRY = "customsortentry";
    private static final String FIELDCOMBO = "fieldcombo";
    private static final String SORTCOMBO = "sortcombo";

    public CashJournalFormRpt() {
        this.rptEntity = "cas_cashjournalformrpt";
        this.acctEntity = "cas_accountcash";
        this.acctControlName = "accountcash";
        this.journalEntity = "cas_cashjournal";
    }

    @Override
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParam("fromAEF") != null) {
            return;
        }
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"showtype"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("cashfiltergridap");
        filterGrid.setEntityNumber("cas_cashjournal");
        this.setCashJournalFilterFields(filterGrid);
    }

    private void setCashJournalFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(17);
        filterFileds.add("bookdate");
        filterFileds.add("description");
        filterFileds.add("sourcebilltype");
        filterFileds.add("billno");
        filterFileds.add("debitamount");
        filterFileds.add("creditamount");
        filterFileds.add("oppunit");
        filterFileds.add("oppacctnumber");
        filterFileds.add("cashier.number");
        filterFileds.add("source");
        filterGrid.setFilterFieldKeys(filterFileds);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        Map<String, Map> filterColumnsTemp = entityTypeUtil.createFilterColumns((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cas_cashjournal"), false).stream().filter(m -> filterFileds.contains(m.get("fieldName"))).collect(Collectors.toMap(m -> (String)m.get("fieldName"), m -> m));
        ArrayList<Map> filterColumns = new ArrayList<Map>(filterFileds.size());
        Map filterColumn = null;
        String filterName = "";
        for (String string : filterFileds) {
            filterColumn = filterColumnsTemp.get(string);
            if (string.contains(".number")) {
                filterName = (String)filterColumn.get("fieldCaption");
                filterColumn.put("fieldCaption", filterName.substring(0, filterName.indexOf(46)));
            }
            if (string.equals("billno")) {
                filterColumn.put("fieldCaption", ResManager.loadKDString((String)"\u5355\u636e\u53f7", (String)"CashJournalFormRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
    }

    @Override
    protected QFilter[] getAcctFilter(List<Long> orgPks) {
        if (this.containsClosed()) {
            return AccountCashHelper.getAccountFilter(orgPks);
        }
        return AccountCashHelper.getUsableAccountFilter(orgPks);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_new".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_cashjournaledit");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm(showParameter);
        }
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filter = event.getQueryParam().getFilter();
        boolean exportexcel = filter.getBoolean("exportallacc");
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn col = (ReportColumn)column;
            String key = col.getFieldKey();
            if ((key.equals("acctname") || key.equals("currencyfield")) && !exportexcel) {
                col.setHide(true);
            } else {
                col.setHide(false);
            }
            if (!key.equals("datatype") && !key.equals("id") && !key.equals("sourcebillid")) continue;
            col.setHide(true);
        }
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("exportallacc", (Object)false);
        FilterItemInfo filterShowType = filter.getFilterItem("showType");
        String showType = (String)this.getModel().getValue("showtype");
        if (filterShowType != null) {
            filterShowType.setValue((Object)showType);
        } else {
            filter.addFilterItem("showType", (Object)showType);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("exportallacc".equals(key)) {
            this.exportAllToExcel();
        } else if ("addnew".equals(key)) {
            this.openManualJournalNewViewBy("cas_manualcashjournal");
        }
    }

    private void exportAllToExcel() {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList list = (ReportList)this.getControl("reportlistap");
        queryParam.getFilter().getFilterItem("exportallacc").setValue((Object)true);
        String taskId = Uuid16.create().toString();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(taskId, queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)list.getReportModel();
        reportModel.setPageId(taskId);
        boolean isAsynQuery = list.isAsynQuery();
        list.setAsynQuery(true);
        String nodes_cahce = JournalPrintHelper.getLeftNodesFromCache(queryParam);
        if (StringUtils.isBlank((CharSequence)nodes_cahce)) {
            nodes_cahce = this.buildNodeIdStr(this.getQueryParam());
        }
        list.submitTask(queryParam, (Object)nodes_cahce);
        String url = list.exportExcel();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            IClientViewProxy clientProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientProxy.addAction("download", (Object)url);
        }
        reportModel.close();
        reportModel.setPageId(this.getView().getPageId());
        list.setAsynQuery(isAsynQuery);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if ("showtype".equalsIgnoreCase(name)) {
            this.getView().refresh();
        }
    }

    public String buildNodeIdStr(ReportQueryParam queryParam) {
        StringBuilder sb = new StringBuilder();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgColl = filterInfo.getDynamicObjectCollection("org");
        DynamicObjectCollection acctColl = filterInfo.getDynamicObjectCollection("accountbank");
        DynamicObjectCollection currencyColl = filterInfo.getDynamicObjectCollection("currency");
        DynamicObjectCollection acctPlainColl = this.getAcctPlainColl(orgColl, acctColl, filterInfo);
        for (int i = 0; i < orgColl.size(); ++i) {
            DynamicObject org = (DynamicObject)orgColl.get(i);
            for (int j = 0; j < acctPlainColl.size(); ++j) {
                DynamicObject acct = (DynamicObject)acctPlainColl.get(j);
                if (acct.getLong("orgid") != org.getLong("id")) continue;
                if (currencyColl != null) {
                    if (!this.isContains(currencyColl, acct.getLong("currencyid"))) continue;
                    sb.append(acct.getString("currencyid")).append('-').append(acct.getString("id")).append('-').append(acct.getString("orgid")).append('-').append(acct.getString("acctname")).append('%');
                    continue;
                }
                sb.append(acct.getString("currencyid")).append('-').append(acct.getString("id")).append('-').append(acct.getString("orgid")).append('-').append(acct.getString("acctname")).append('%');
            }
        }
        return sb.toString();
    }

    public DynamicObjectCollection getAcctPlainColl(DynamicObjectCollection orgColl, DynamicObjectCollection acctColl, FilterInfo filterInfo) {
        QFilter filter = acctColl != null ? new QFilter("id", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)acctColl)) : new QFilter("org", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)orgColl));
        boolean isContainClosed = filterInfo.getBoolean("iscontainclosed");
        int type = filterInfo.getInt("datetype");
        if (orgColl.size() > 1 && type == 1) {
            DynamicObject periodType = filterInfo.getDynamicObject("periodtype");
            for (int i = orgColl.size() - 1; i >= 0; --i) {
                DynamicObject org = (DynamicObject)orgColl.get(i);
                long orgId = (Long)org.getPkValue();
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                if (periodTypeId == periodType.getLong("id")) continue;
                orgColl.remove(i);
            }
        }
        if (!isContainClosed) {
            filter = filter.and(new QFilter("closestatus", "=", (Object)"0"));
        } else {
            Date beginDate = null;
            Date endDate = null;
            if (type == 1) {
                DynamicObject beginPeriodDo = filterInfo.getDynamicObject("beginperiod");
                DynamicObject endPeriodDo = filterInfo.getDynamicObject("endperiod");
                if (beginPeriodDo != null) {
                    beginDate = beginPeriodDo.getDate("begindate");
                }
                if (endPeriodDo != null) {
                    endDate = endPeriodDo.getDate("enddate");
                }
            } else {
                endDate = filterInfo.getDate("enddate");
                beginDate = filterInfo.getDate("begindate");
            }
            QFilter qFilter = QFilter.of((String)"closedate = null or (closedate >= ? and closedate <= ?)", (Object[])new Object[]{DateUtils.getDataFormat((Date)beginDate, (boolean)true), DateUtils.getDataFormat((Date)endDate, (boolean)false)});
            filter.and(qFilter);
        }
        DynamicObjectCollection acctPlainColl = QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".getAcctPlainColl"), (String)"cas_accountcash", (String)"id,name as acctname,number as acctnumber,org.id as orgid,org.name as orgname,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname", (QFilter[])filter.toArray(), null);
        return acctPlainColl;
    }

    protected boolean isContains(DynamicObjectCollection coll, long id) {
        boolean flag = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject object = (DynamicObject)coll.get(i);
            if (object.getLong("id") != id) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection sortEntry;
        boolean verifyQuery = super.verifyQuery(queryParam);
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashSet<String> fieldSet = new HashSet<String>(10);
            for (DynamicObject sortRow : sortEntry) {
                if (fieldSet.add(sortRow.getString(FIELDCOMBO))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d", (String)"SubsiDiaryTreeFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            this.setOtherEntryFilter(queryParam.getFilter());
        }
        return verifyQuery;
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection sortEntry;
        super.setOtherEntryFilter(filterInfo);
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashMap otherEntryFilter = new HashMap();
            ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
            for (DynamicObject sortRow : sortEntry) {
                saveEntrys.add(sortRow);
            }
            otherEntryFilter.put(CUSTOMSORTENTRY, saveEntrys);
            filterInfo.setOtherEntryFilter(otherEntryFilter);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        DynamicObjectCollection sortEntry;
        super.loadOtherEntryFilter(scheme);
        if (scheme.getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && (sortEntry = scheme.getDynamicObjectCollection(CUSTOMSORTENTRY)) != null && !sortEntry.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(CUSTOMSORTENTRY);
            model.batchCreateNewEntryRow(CUSTOMSORTENTRY, sortEntry.size());
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sortRow = (DynamicObject)sortEntry.get(i);
                model.setValue(FIELDCOMBO, (Object)sortRow.getString(FIELDCOMBO), i);
                model.setValue(SORTCOMBO, (Object)sortRow.getString(SORTCOMBO), i);
            }
            model.endInit();
            this.getView().updateView(CUSTOMSORTENTRY);
        }
    }
}

