/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.formplugin.init.CasInitHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.GLBusinessHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.NumberUtils;
import kd.fi.cas.util.ViewUtils;

public class CashMgtInitEdit
extends BillEditPlugin {
    private boolean isSetValueSilent = false;
    private long assignOrgId = 0L;
    private List<Long> orgList = null;
    public static final String ORG_LIST = "ORG_LIST";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        if (this.orgList == null) {
            String orgListStr = this.getPageCache().get(ORG_LIST);
            if (orgListStr == null) {
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                this.orgList = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_cashmgtinit", (String)"47150e89000000ac");
                this.getPageCache().put(ORG_LIST, SerializationUtils.toJsonString(this.orgList));
            } else {
                this.orgList = new ArrayList<Long>();
                List deserialOrgList = (List)SerializationUtils.fromJsonString((String)orgListStr, List.class);
                for (int i = 0; i < deserialOrgList.size(); ++i) {
                    if (deserialOrgList.get(i) instanceof Integer) {
                        this.orgList.add(new BigDecimal((Integer)deserialOrgList.get(i)).longValue());
                        continue;
                    }
                    if (deserialOrgList.get(i) instanceof Long) {
                        this.orgList.add((Long)deserialOrgList.get(i));
                        continue;
                    }
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b\uff1a%s\u3002", (String)"CashMgtInitEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), deserialOrgList.get(i).getClass()));
                }
            }
        }
        this.initF7();
    }

    private void initF7() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getView().getControl("org");
        orgCtrl.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                QFilter qFilter = new QFilter("id", "in", (Object)CashMgtInitEdit.this.orgList);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
        BasedataEdit startPeriodCtrl = (BasedataEdit)this.getView().getControl("startperiod");
        startPeriodCtrl.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                long orgId = CashMgtInitEdit.this.assignOrgId == 0L ? (Long)CashMgtInitEdit.this.orgList.get(0) : CashMgtInitEdit.this.assignOrgId;
                QFilter qFilter = new QFilter("isadjustperiod", "=", (Object)"0").and(new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId((long)orgId)));
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_adjustedbalance".equals(key.toLowerCase(Locale.ENGLISH))) {
            try {
                this.jumpToBalAdjTable();
            }
            catch (Throwable e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if ("bar_bankunreach".equals(key.toLowerCase(Locale.ENGLISH))) {
            if (!this.validateSelectEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\uff0c\u624d\u80fd\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.validateSelectSingleEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u884c\u5206\u5f55\uff0c\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBankUnreachForm();
        }
        if ("bar_companyunreach".equals(key.toLowerCase(Locale.ENGLISH))) {
            if (!this.validateSelectEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\uff0c\u624d\u80fd\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.validateSelectSingleEntry()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u884c\u5206\u5f55\uff0c\u8fdb\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CashMgtInitEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showCompanyUnreachForm();
        } else if ("bar_checkgl".equals(key.toLowerCase(Locale.ENGLISH))) {
            Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            Long startPeriodId = ((DynamicObject)this.getModel().getValue("startperiod")).getLong("id");
            GLBusinessHelper.checkAndShowWithGL((IFormView)this.getView(), (Long)orgId, (Long)startPeriodId, (Boolean)Boolean.TRUE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrybank");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(0L, 0L);
        Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(0L, 0L);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("finishinit".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.assignOrgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            this.afterCreateNewData(null);
            this.getModel().setDataChanged(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"CashMgtInitEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("antiinit".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.assignOrgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            this.afterCreateNewData(null);
            this.getModel().setDataChanged(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"CashMgtInitEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("finishinit".equals(operateKey) && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            int rowCount = this.getModel().getEntryRowCount("entrybank");
            for (int i = 0; i < rowCount; ++i) {
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryEntity.get(i)).getDynamicObject("bank_accountbank"), (DynamicObject)org)) continue;
                this.calcJournalBalanceAdj(i, statementMap);
                this.calcStatementBalanceAdj(i, journalMap);
                this.getView().updateView("bank_journalbalanceadj", i);
                this.getView().updateView("bank_journalsumbalanceadj", i);
                this.getView().updateView("bank_statementbalanceadj", i);
                this.getView().updateView("bank_equal", i);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("orgid") != null) {
            this.assignOrgId = Long.parseLong(customParams.get("orgid").toString());
            DynamicObject cashMgtInit = this.getCashMgtInit(this.assignOrgId);
            if (CasHelper.isNotEmpty((Object)cashMgtInit)) {
                this.initLoad(cashMgtInit);
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.getDataEntityState().setBizChanged(false);
            DynamicObjectCollection entryBanks = dataEntity.getDynamicObjectCollection("entrybank");
            for (DynamicObject bank : entryBanks) {
                bank.getDataEntityState().setBizChanged(false);
            }
            DynamicObjectCollection entryCashs = dataEntity.getDynamicObjectCollection("entrycash");
            for (DynamicObject cash : entryCashs) {
                cash.getDataEntityState().setBizChanged(false);
            }
        }
        if (null != (org = this.getModel().getDataEntity().getDynamicObject("org"))) {
            this.fillToolBar(org.getLong("id"), (Boolean)this.getModel().getValue("isfinishinit"));
        }
    }

    private DynamicObject getCashMgtInit(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
    }

    private void initLoad(DynamicObject cashMgtInit) {
        this.isSetValueSilent = true;
        DynamicObject org = cashMgtInit.getDynamicObject("org");
        long orgId = org.getLong("id");
        boolean isInit = cashMgtInit.getBoolean("isfinishinit");
        this.getView().setStatus(OperationStatus.EDIT);
        IDataModel dataModel = this.getModel();
        BillModel model = (BillModel)dataModel;
        model.load((Object)cashMgtInit.getLong("id"));
        dataModel.deleteEntryData("entrycash");
        dataModel.deleteEntryData("entrybank");
        this.setValue("startperiod", cashMgtInit.getDynamicObject("startperiod"));
        if (!isInit) {
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "!=", (Object)"1")};
            Map accountCashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])filters);
            for (Object accountCash : accountCashMap.values()) {
                DynamicObjectCollection currencyList = accountCash.getDynamicObjectCollection("currency");
                for (DynamicObject currency : currencyList) {
                    int cashEntryIndex = dataModel.createNewEntryRow("entrycash");
                    this.setValue("cash_accountcash", accountCash, cashEntryIndex);
                    this.setValue("cash_accountcashnumber", CashMgtInitEdit.getAccountCashDisplay((DynamicObject)accountCash), cashEntryIndex);
                    this.setValue("cash_currency", currency.get("fbasedataid"), cashEntryIndex);
                    this.setValue("cash_yeardebit", new BigDecimal(0), cashEntryIndex);
                    this.setValue("cash_yearcredit", new BigDecimal(0), cashEntryIndex);
                    this.setValue("cash_balance", new BigDecimal(0), cashEntryIndex);
                }
            }
            DynamicObjectCollection cashEntryList = cashMgtInit.getDynamicObjectCollection("entrycash");
            for (DynamicObject cashEntry : cashEntryList) {
                DynamicObject accountcash = cashEntry.getDynamicObject("cash_accountcash");
                DynamicObject cashCurrency = cashEntry.getDynamicObject("cash_currency");
                if (accountcash == null || cashCurrency == null) continue;
                long initAccountCashId = accountcash.getLong("id");
                long initCurrencyId = cashCurrency.getLong("id");
                int size = dataModel.getEntryRowCount("entrycash");
                for (int i = 0; i < size; ++i) {
                    long entryAccountCashId = this.getPk("cash_accountcash", i);
                    long entryCurrencyId = this.getPk("cash_currency", i);
                    if (initAccountCashId != entryAccountCashId || initCurrencyId != entryCurrencyId) continue;
                    this.setValue("cash_yeardebit", cashEntry.getBigDecimal("cash_yeardebit"), i);
                    this.setValue("cash_yearcredit", cashEntry.getBigDecimal("cash_yearcredit"), i);
                    this.setValue("cash_balance", cashEntry.getBigDecimal("cash_balance"), i);
                }
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            orgIds.add(orgId);
            QFilter accountBankFilterByOrg = AccountBankHelper.getAccountBankFilterByOrg(orgIds);
            boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
            if (!isShowInnerAccount) {
                accountBankFilterByOrg.and(new QFilter("finorgtype", "!=", (Object)Character.valueOf('1')));
            }
            accountBankFilterByOrg.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
            Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{accountBankFilterByOrg});
            for (Object accountbank : accountBankMap.values()) {
                DynamicObjectCollection currencyList = accountbank.getDynamicObjectCollection("currency");
                for (DynamicObject currency : currencyList) {
                    if (CasHelper.isEmpty((Object)currency) || CasHelper.isEmpty((Object)currency.get("fbasedataid"))) continue;
                    int cashEntryIndex = dataModel.createNewEntryRow("entrybank");
                    this.setValue("bank_accountbank", accountbank.getPkValue(), cashEntryIndex);
                    this.setValue("bank_openorg", accountbank.getDynamicObject("openorg").getPkValue(), cashEntryIndex);
                    this.setValue("bank_bankaccountnumber", CashMgtInitEdit.getAccountBankDisplay((DynamicObject)accountbank), cashEntryIndex);
                    this.setValue("bank_currency", currency.get("fbasedataid"), cashEntryIndex);
                    this.setValue("bank_journaldebit", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_journalcredit", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_journalbalance", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_journalbalanceadj", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_statementdebit", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_statementcredit", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_statementbalance", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_statementbalanceadj", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_journalsumbalanceadj", new BigDecimal(0), cashEntryIndex);
                    this.setValue("bank_equal", "1", cashEntryIndex);
                }
            }
            DynamicObjectCollection bankEntryList = cashMgtInit.getDynamicObjectCollection("entrybank");
            for (DynamicObject bankEntry : bankEntryList) {
                int size = dataModel.getEntryRowCount("entrybank");
                for (int i = 0; i < size; ++i) {
                    if (CasHelper.isEmpty((Object)bankEntry.getDynamicObject("bank_accountbank"))) continue;
                    long initAccountBankId = bankEntry.getDynamicObject("bank_accountbank").getLong("id");
                    long initCurrencyId = bankEntry.getDynamicObject("bank_currency").getLong("id");
                    long entryAccountBankId = this.getPk("bank_accountbank", i);
                    long entryCurrencyId = this.getPk("bank_currency", i);
                    if (initAccountBankId != entryAccountBankId || initCurrencyId != entryCurrencyId) continue;
                    this.setValue("bank_journaldebit", bankEntry.getBigDecimal("bank_journaldebit"), i);
                    this.setValue("bank_journalcredit", bankEntry.getBigDecimal("bank_journalcredit"), i);
                    this.setValue("bank_journalbalance", bankEntry.getBigDecimal("bank_journalbalance"), i);
                    this.setValue("bank_journalbalanceadj", bankEntry.getBigDecimal("bank_journalbalanceadj"), i);
                    this.setValue("bank_statementdebit", bankEntry.getBigDecimal("bank_statementdebit"), i);
                    this.setValue("bank_statementcredit", bankEntry.getBigDecimal("bank_statementcredit"), i);
                    this.setValue("bank_statementbalance", bankEntry.getBigDecimal("bank_statementbalance"), i);
                    this.setValue("bank_statementbalanceadj", bankEntry.getBigDecimal("bank_statementbalanceadj"), i);
                    this.setValue("bank_journalsumbalanceadj", this.getUseOrgJournalAmount(i), i);
                    this.setValue("bank_equal", bankEntry.getString("bank_equal"), i);
                }
            }
            Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(0L, 0L);
            Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(0L, 0L);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrybank");
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            ArrayList<Integer> journalIndexs = new ArrayList<Integer>();
            int rowCount = this.getModel().getEntryRowCount("entrybank");
            for (int i = 0; i < rowCount; ++i) {
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryEntity.get(i)).getDynamicObject("bank_accountbank"), (DynamicObject)org)) {
                    ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
                    lstFilters.add(new QFilter("org", "=", (Object)((DynamicObject)entryEntity.get(i)).getDynamicObject("bank_accountbank").getDynamicObject("createorg").getLong("id")));
                    lstFilters.add(new QFilter("isfinishinit", "=", (Object)"1"));
                    DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id", (QFilter[])lstFilters.toArray(new QFilter[0]));
                    if (cashmgtInitDy != null && cashmgtInitDy.length > 0) {
                        journalIndexs.add(i);
                    } else {
                        this.calcJournalBalanceAdj(i, statementMap);
                    }
                    this.setValue("bank_statementdebit", new BigDecimal(0), i);
                    this.setValue("bank_statementcredit", new BigDecimal(0), i);
                    this.setValue("bank_statementbalance", new BigDecimal(0), i);
                    this.setValue("bank_statementbalanceadj", new BigDecimal(0), i);
                    this.setValue("bank_journalsumbalanceadj", new BigDecimal(0), i);
                    this.setValue("bank_equal", "0", i);
                    indexs.add(i);
                    continue;
                }
                this.calcJournalBalanceAdj(i, statementMap);
                this.calcStatementBalanceAdj(i, journalMap);
            }
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"cash_yeardebit", "cash_yearcredit", "cash_balance", "bank_journaldebit", "bank_journalcredit", "bank_journalbalance", "bank_statementdebit", "bank_statementcredit", "bank_statementbalance"});
            if (indexs.size() > 0) {
                CashMgtInitEdit.setEnable((AbstractFormPlugin)this, false, indexs, "bank_statementdebit", "bank_statementcredit", "bank_statementbalance");
            }
            if (journalIndexs.size() > 0) {
                CashMgtInitEdit.setEnable((AbstractFormPlugin)this, false, journalIndexs, "bank_journaldebit", "bank_journalcredit", "bank_journalbalance");
            }
        } else {
            dataModel.setValue("currentperiod", (Object)cashMgtInit.getDynamicObject("currentperiod"));
            DynamicObjectCollection cashEntryList = cashMgtInit.getDynamicObjectCollection("entrycash");
            for (DynamicObject cashEntry : cashEntryList) {
                int cashEntryIndex = dataModel.createNewEntryRow("entrycash");
                this.setValue("cash_accountcash", cashEntry.getDynamicObject("cash_accountcash"), cashEntryIndex);
                this.setValue("cash_accountcashnumber", CashMgtInitEdit.getAccountCashDisplay(cashEntry.getDynamicObject("cash_accountcash")), cashEntryIndex);
                this.setValue("cash_currency", cashEntry.getDynamicObject("cash_currency"), cashEntryIndex);
                this.setValue("cash_yeardebit", cashEntry.getBigDecimal("cash_yeardebit"), cashEntryIndex);
                this.setValue("cash_yearcredit", cashEntry.getBigDecimal("cash_yearcredit"), cashEntryIndex);
                this.setValue("cash_balance", cashEntry.getBigDecimal("cash_balance"), cashEntryIndex);
            }
            DynamicObjectCollection bankEntryList = cashMgtInit.getDynamicObjectCollection("entrybank");
            boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
            for (DynamicObject bankEntry : bankEntryList) {
                if (!isShowInnerAccount && Objects.equals(bankEntry.getDynamicObject("bank_accountbank").getString("finorgtype"), "1")) continue;
                int cashEntryIndex = dataModel.createNewEntryRow("entrybank");
                this.setValue("bank_accountbank", bankEntry.getDynamicObject("bank_accountbank"), cashEntryIndex);
                this.setValue("bank_openorg", bankEntry.getDynamicObject("bank_openorg"), cashEntryIndex);
                this.setValue("bank_bankaccountnumber", CashMgtInitEdit.getAccountBankDisplay(bankEntry.getDynamicObject("bank_accountbank")), cashEntryIndex);
                this.setValue("bank_currency", bankEntry.getDynamicObject("bank_currency"), cashEntryIndex);
                this.setValue("bank_journaldebit", bankEntry.getBigDecimal("bank_journaldebit"), cashEntryIndex);
                this.setValue("bank_journalcredit", bankEntry.getBigDecimal("bank_journalcredit"), cashEntryIndex);
                this.setValue("bank_journalbalance", bankEntry.getBigDecimal("bank_journalbalance"), cashEntryIndex);
                this.setValue("bank_journalbalanceadj", bankEntry.getBigDecimal("bank_journalbalanceadj"), cashEntryIndex);
                this.setValue("bank_statementdebit", bankEntry.getBigDecimal("bank_statementdebit"), cashEntryIndex);
                this.setValue("bank_statementcredit", bankEntry.getBigDecimal("bank_statementcredit"), cashEntryIndex);
                this.setValue("bank_statementbalance", bankEntry.getBigDecimal("bank_statementbalance"), cashEntryIndex);
                this.setValue("bank_statementbalanceadj", bankEntry.getBigDecimal("bank_statementbalanceadj"), cashEntryIndex);
                this.setValue("bank_journalsumbalanceadj", bankEntry.getBigDecimal("bank_journalsumbalanceadj"), cashEntryIndex);
                this.setValue("bank_equal", bankEntry.getString("bank_equal"), cashEntryIndex);
            }
            ViewUtils.setEnable((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"cash_yeardebit", "cash_yearcredit", "cash_balance", "bank_journaldebit", "bank_journalcredit", "bank_journalbalance", "bank_statementdebit", "bank_statementcredit", "bank_statementbalance"});
            this.getView().updateView("currentperiod");
        }
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        if (null == startPeriod) {
            return;
        }
        int periodNumber = PeriodHelper.getPeriodById((long)startPeriod.getLong("id")).getInt("periodnumber");
        if (periodNumber == 1) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"cash_yeardebit", "cash_yearcredit", "bank_journaldebit", "bank_journalcredit", "bank_statementdebit", "bank_statementcredit"});
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"cash_yeardebit", "cash_yearcredit", "bank_journaldebit", "bank_journalcredit", "bank_statementdebit", "bank_statementcredit"});
        }
        this.isSetValueSilent = false;
    }

    public static void setEnable(AbstractFormPlugin plugin, boolean enable, List<Integer> indexs, String ... ctrlId) {
        for (int i = 0; i < ctrlId.length; ++i) {
            CashMgtInitEdit.innerSetEnable(plugin, enable, ctrlId[i], indexs);
        }
    }

    private static void innerSetEnable(AbstractFormPlugin plugin, boolean enable, String ctrlId, List<Integer> indexs) {
        Control ctrl = plugin.getView().getControl(ctrlId);
        if (ctrl == null || ctrl instanceof Button) {
            plugin.getView().setEnable(Boolean.valueOf(enable), new String[]{ctrlId});
        } else if (ctrl instanceof FieldEdit) {
            FieldEdit edit = (FieldEdit)ctrl;
            if (edit.getProperty().getParent() instanceof EntryType) {
                for (int i : indexs) {
                    edit.setEnable("", enable, i);
                }
            } else {
                edit.setEnable("", enable, 0);
            }
        } else {
            throw new RuntimeException("control error");
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrybank");
        final CashMgtInitEdit $this = this;
        final IFormView view = this.getView();
        entryGrid.addCellClickListener(new CellClickListener(){

            public void cellDoubleClick(CellClickEvent doubleEvt) {
            }

            public void cellClick(CellClickEvent singEvt) {
                DynamicObject org;
                int index = singEvt.getRow();
                Object value = view.getModel().getValue("bank_accountbank", index);
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)value), (DynamicObject)(org = view.getModel().getDataEntity().getDynamicObject("org")))) {
                    ViewUtils.setEnable((AbstractFormPlugin)$this, (boolean)false, (String[])new String[]{"bar_bankunreach", "bar_companyunreach", "bar_adjustedbalance"});
                } else {
                    ViewUtils.setEnable((AbstractFormPlugin)$this, (boolean)true, (String[])new String[]{"bar_bankunreach", "bar_companyunreach", "bar_adjustedbalance"});
                }
            }
        });
        entryGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
                String fieldName = hyperLinkClickEvent.getFieldName();
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"bank_journalsumbalanceadj")) {
                    Object value = $this.getModel().getValue("bank_accountbank", hyperLinkClickEvent.getRowIndex());
                    DynamicObject startPeriod = (DynamicObject)$this.getModel().getValue("startperiod");
                    DynamicObject org = view.getModel().getDataEntity().getDynamicObject("org");
                    Object currency = $this.getModel().getValue("bank_currency", hyperLinkClickEvent.getRowIndex());
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("cas_totalamount");
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setCustomParam("accountbankId", ((DynamicObject)value).getPkValue());
                    parameter.setCustomParam("currencyId", ((DynamicObject)currency).getPkValue());
                    parameter.setCustomParam("orgId", org.getPkValue());
                    parameter.setCustomParam("orgname", (Object)org.getLocaleString("name").getLocaleValue());
                    parameter.setCustomParam("modifytime", (Object)startPeriod.getDate("begindate"));
                    parameter.setCustomParam("journalbalance", $this.getModel().getValue("bank_journalbalance", hyperLinkClickEvent.getRowIndex()));
                    parameter.setCustomParam("journalbalanceadj", $this.getModel().getValue("bank_journalbalanceadj", hyperLinkClickEvent.getRowIndex()));
                    $this.getView().showForm(parameter);
                }
            }
        });
    }

    private static String getAccountBankDisplay(DynamicObject accountBank) {
        if (accountBank == null) {
            return "";
        }
        if (accountBank.getString("bankaccountnumber") != null && !accountBank.getString("bankaccountnumber").trim().equals("")) {
            return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
        }
        accountBank = AccountBankHelper.getAccountBankById((long)accountBank.getLong("id"));
        return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
    }

    private static String getAccountCashDisplay(DynamicObject accountCash) {
        if (accountCash == null) {
            return "";
        }
        if (accountCash.getString("number") != null && !accountCash.getString("number").trim().equals("")) {
            return accountCash.getString("number") + "\n" + accountCash.getString("name");
        }
        accountCash = AccountCashHelper.getAccountCashById((long)accountCash.getLong("id"));
        return accountCash.getString("number") + "\n" + accountCash.getString("name");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.isSetValueSilent) {
            return;
        }
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("bank_journalbalance")) {
            int entryIndex = e.getChangeSet()[0].getRowIndex();
            Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
            Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
            Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(rowAcctbankId, rowCurrencyId);
            this.calcJournalBalanceAdj(entryIndex, statementMap);
        } else if (propertyName.equals("bank_statementbalance")) {
            int entryIndex = e.getChangeSet()[0].getRowIndex();
            Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
            Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
            Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(rowAcctbankId, rowCurrencyId);
            this.calcStatementBalanceAdj(entryIndex, journalMap);
        }
    }

    private void calcJournalBalanceAdj(int entryIndex, Map<String, Map<String, BigDecimal>> statementMap) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
        Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
        BigDecimal journalBalance = (BigDecimal)this.getModel().getValue("bank_journalbalance", entryIndex);
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (statementMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal journalBalanceAdj = journalBalance.add(creditAmount).subtract(debitAmount);
        this.setValue("bank_journalbalanceadj", journalBalanceAdj, entryIndex);
        BigDecimal sumBalanceAdj = this.getUseOrgJournalAmount(entryIndex);
        BigDecimal statementBalanceAdj = (BigDecimal)this.getModel().getValue("bank_statementbalanceadj", entryIndex);
        if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)this.getModel().getValue("bank_accountbank", entryIndex)), (DynamicObject)org)) {
            this.setValue("bank_journalsumbalanceadj", BigDecimal.ZERO, entryIndex);
            this.setValue("bank_equal", "0", entryIndex);
        } else {
            this.setValue("bank_journalsumbalanceadj", sumBalanceAdj, entryIndex);
            this.setValue("bank_equal", NumberUtils.equals((BigDecimal)sumBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0", entryIndex);
        }
    }

    private BigDecimal getUseOrgJournalAmount(int entryIndex) {
        BigDecimal totalAmount = new BigDecimal(0);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject createOegStartPeriod = dataEntity.getDynamicObject("startperiod");
        long accountbankId = ((DynamicObject)this.getModel().getValue("bank_accountbank", entryIndex)).getLong("id");
        long currencyId = ((DynamicObject)this.getModel().getValue("bank_currency", entryIndex)).getLong("id");
        DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,startperiod,currentperiod,isfinishinit,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_journalbalance,entrybank.bank_journalbalanceadj", (QFilter[])new QFilter[]{new QFilter("entrybank.bank_accountbank", "=", (Object)accountbankId)});
        boolean isSave = false;
        for (DynamicObject dyObj : cashmgtInitDy) {
            if (dyObj.getDynamicObject("org").getLong("id") == org.getLong("id")) {
                isSave = true;
                totalAmount = totalAmount.add((BigDecimal)this.getModel().getValue("bank_journalbalanceadj", entryIndex));
                continue;
            }
            if (!dyObj.getBoolean("isfinishinit")) continue;
            DynamicObjectCollection bankCollection = dyObj.getDynamicObjectCollection("entrybank");
            for (DynamicObject dyObj1 : bankCollection) {
                Date createOrgBeginDate;
                long accountBankId1 = dyObj1.getDynamicObject("bank_accountbank").getLong("id");
                long currencyId1 = dyObj1.getDynamicObject("bank_currency").getLong("id");
                if (accountBankId1 != accountbankId || currencyId1 != currencyId) continue;
                DynamicObject useorgStartPeriod = dyObj.getDynamicObject("startperiod");
                Date useOrgBeginDate = useorgStartPeriod.getDate("begindate");
                if (useOrgBeginDate.compareTo(createOrgBeginDate = createOegStartPeriod.getDate("begindate")) < 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(createOrgBeginDate);
                    calendar.add(5, -1);
                    Date endDate = calendar.getTime();
                    BalanceCountService balanceCountService = new BalanceCountService();
                    BigDecimal accountBalance = balanceCountService.getJournalBalance(dyObj, Long.valueOf(dyObj.getDynamicObject("org").getLong("id")), Long.valueOf(accountBankId1), Long.valueOf(currencyId1), endDate);
                    totalAmount = totalAmount.add(accountBalance);
                    continue;
                }
                BigDecimal journalbalance1 = dyObj1.getBigDecimal("bank_journalbalanceadj");
                totalAmount = totalAmount.add(journalbalance1);
            }
        }
        if (!isSave) {
            totalAmount = totalAmount.add((BigDecimal)this.getModel().getValue("bank_journalbalanceadj", entryIndex));
        }
        return totalAmount;
    }

    private void calcStatementBalanceAdj(int entryIndex, Map<String, Map<String, BigDecimal>> journalMap) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Long rowAcctbankId = this.getPk("bank_accountbank", entryIndex);
        Long rowCurrencyId = this.getPk("bank_currency", entryIndex);
        BigDecimal statementBalance = (BigDecimal)this.getModel().getValue("bank_statementbalance", entryIndex);
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (journalMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal statementBalanceAdj = statementBalance.add(debitAmount).subtract(creditAmount);
        BigDecimal journalBalanceAdj = (BigDecimal)this.getModel().getValue("bank_journalsumbalanceadj", entryIndex);
        if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)this.getModel().getValue("bank_accountbank", entryIndex)), (DynamicObject)org)) {
            this.setValue("bank_statementbalanceadj", BigDecimal.ZERO, entryIndex);
            this.setValue("bank_equal", "0", entryIndex);
        } else {
            this.setValue("bank_statementbalanceadj", statementBalanceAdj, entryIndex);
            this.setValue("bank_equal", NumberUtils.equals((BigDecimal)journalBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0", entryIndex);
        }
    }

    private Map<String, Map<String, BigDecimal>> getBankJournal(long bankacctId, long currencyId) {
        Long orgId = this.getPk("org");
        String selectors = "accountbank as faccountbankid,currency as fcurrencyid,debitamount,creditamount";
        QFilter[] filters = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)0L);
        if (bankacctId != 0L) {
            QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankacctId);
            QFilter currencyFilter = new QFilter("currency", "=", (Object)currencyId);
            filters = new QFilter[]{orgFilter, periodFilter, accountFilter, currencyFilter};
        } else {
            filters = new QFilter[]{orgFilter, periodFilter};
        }
        HashMap<String, Map<String, BigDecimal>> mapJournal = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet bankStatementDataSet = QueryServiceHelper.queryDataSet((String)"cas.cashmgtinit.bankjournal", (String)"cas_bankjournal", (String)selectors, (QFilter[])filters, null);
             DataSet groupByDataSet = bankStatementDataSet.groupBy(new String[]{"faccountbankid", "fcurrencyid"}).sum("debitamount").sum("creditamount").finish();){
            groupByDataSet.forEach(row -> {
                Long rowAcctbankId = (Long)row.get("faccountbankid");
                Long rowCurrencyId = (Long)row.get("fcurrencyid");
                BigDecimal debitamount = (BigDecimal)row.get("debitamount");
                BigDecimal creditamount = (BigDecimal)row.get("creditamount");
                HashMap<String, BigDecimal> rowData = new HashMap<String, BigDecimal>();
                rowData.put("debitamount", debitamount);
                rowData.put("creditamount", creditamount);
                mapJournal.put(rowAcctbankId + "-" + rowCurrencyId, rowData);
            });
        }
        return mapJournal;
    }

    private Map<String, Map<String, BigDecimal>> getBankStatement(long bankacctId, long currencyId) {
        Long orgId = this.getPk("org");
        String selectors = "accountbank as faccountbankid,currency as fcurrencyid,debitamount,creditamount";
        QFilter[] filters = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)0L);
        QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
        if (bankacctId != 0L) {
            QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankacctId);
            QFilter currencyFilter = new QFilter("currency", "=", (Object)currencyId);
            filters = new QFilter[]{orgFilter, periodFilter, accountFilter, currencyFilter, validFilter};
        } else {
            filters = new QFilter[]{orgFilter, periodFilter, validFilter};
        }
        HashMap<String, Map<String, BigDecimal>> mapStatement = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet bankStatementDataSet = QueryServiceHelper.queryDataSet((String)"cas.cashmgtinit.bankstatement", (String)"cas_bankstatement", (String)selectors, (QFilter[])filters, null);
             DataSet groupByDataSet = bankStatementDataSet.groupBy(new String[]{"faccountbankid", "fcurrencyid"}).sum("debitamount").sum("creditamount").finish();){
            groupByDataSet.forEach(row -> {
                Long rowAcctbankId = (Long)row.get("faccountbankid");
                Long rowCurrencyId = (Long)row.get("fcurrencyid");
                BigDecimal debitamount = (BigDecimal)row.get("debitamount");
                BigDecimal creditamount = (BigDecimal)row.get("creditamount");
                HashMap<String, BigDecimal> rowData = new HashMap<String, BigDecimal>();
                rowData.put("debitamount", debitamount);
                rowData.put("creditamount", creditamount);
                mapStatement.put(rowAcctbankId + "-" + rowCurrencyId, rowData);
            });
        }
        return mapStatement;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jumpToBalAdjTable() throws Throwable {
        ShowType showType;
        EntryGrid entryBank = (EntryGrid)this.getControl("entrybank");
        int[] rowIndexs = entryBank.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5206\u5f55\uff0c\u518d\u67e5\u770b\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"CashMgtInitEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("entrybank");
        DynamicObject cashmgtinitbank = this.getModel().getEntryRowEntity("entrybank", index);
        Long acct = (Long)cashmgtinitbank.getDynamicObject("bank_accountbank").getPkValue();
        Long currency = (Long)cashmgtinitbank.getDynamicObject("bank_currency").getPkValue();
        BigDecimal journal = cashmgtinitbank.getBigDecimal("bank_journalbalance");
        BigDecimal statem = cashmgtinitbank.getBigDecimal("bank_statementbalance");
        Object startPeriod = this.getModel().getValue("startperiod");
        Long startPeriodId = 0L;
        if (startPeriod != null) {
            startPeriodId = ((DynamicObject)startPeriod).getLong("id");
        }
        Long orgId = this.getPk("org");
        if (((Boolean)this.getModel().getValue("isfinishinit")).booleanValue()) {
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and(new QFilter("bankaccount", "=", (Object)acct));
            filter.and(new QFilter("currency", "=", (Object)currency)).and("period", "=", (Object)0);
            DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id", (QFilter[])new QFilter[]{filter});
            if (balances != null && balances.length > 0) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cas_balanceadjust");
                parameter.setCustomParam("isinit", (Object)"1");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(balances[0].getPkValue());
                this.getView().showForm((FormShowParameter)parameter);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u65f6\u672a\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\uff01", (String)"CashMgtInitEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Date begindate = this.getModel().getDataEntity().getDynamicObject("startperiod").getDate("begindate");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cas_balanceadjust");
        parameter.setCustomParam("org", (Object)orgId);
        parameter.setCustomParam("accountbank", (Object)acct);
        parameter.setCustomParam("currency", (Object)currency);
        parameter.setCustomParam("enddate", (Object)DateUtils.getLastDay((Date)begindate, (int)1));
        parameter.setCustomParam("isinit", (Object)"1");
        parameter.setCustomParam("journal", (Object)journal);
        parameter.setCustomParam("startPeriod", (Object)startPeriodId);
        parameter.setCustomParam("statem", (Object)statem);
        parameter.setCustomParam("acct", (Object)acct);
        parameter.setCustomParam("acct", (Object)acct);
        ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (parentshowType == ShowType.Modal) {
            showType = ShowType.Modal;
        } else {
            showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(parameter);
    }

    private boolean validateSelectEntry() {
        EntryGrid entryBank = (EntryGrid)this.getControl("entrybank");
        int[] rowIndexs = entryBank.getSelectRows();
        return rowIndexs != null && rowIndexs.length != 0;
    }

    private boolean validateSelectSingleEntry() {
        EntryGrid entryBank = (EntryGrid)this.getControl("entrybank");
        int[] rowIndexs = entryBank.getSelectRows();
        return rowIndexs != null && rowIndexs.length == 1;
    }

    private void showBankUnreachForm() {
        ShowType showType;
        Long orgid = this.getPk("org");
        Long periodid = this.getPk("startperiod");
        int index = this.getModel().getEntryCurrentRowIndex("entrybank");
        DynamicObject cashmgtinitbank = this.getModel().getEntryRowEntity("entrybank", index);
        Long accountbankid = (Long)cashmgtinitbank.getDynamicObject("bank_accountbank").getPkValue();
        Long currencyid = (Long)cashmgtinitbank.getDynamicObject("bank_currency").getPkValue();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cas_bankunreachedit");
        parameter.setCustomParam("orgid", (Object)orgid);
        parameter.setCustomParam("periodid", (Object)periodid);
        parameter.setCustomParam("accountbankid", (Object)accountbankid);
        parameter.setCustomParam("currencyid", (Object)currencyid);
        ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (parentshowType == ShowType.Modal) {
            showType = ShowType.Modal;
        } else {
            showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calcBankUnreach"));
        this.getView().showForm(parameter);
    }

    private void showCompanyUnreachForm() {
        ShowType showType;
        Long orgid = this.getPk("org");
        Long periodid = this.getPk("startperiod");
        int index = this.getModel().getEntryCurrentRowIndex("entrybank");
        DynamicObject cashmgtinitbank = this.getModel().getEntryRowEntity("entrybank", index);
        Long accountbankid = (Long)cashmgtinitbank.getDynamicObject("bank_accountbank").getPkValue();
        Long currencyid = (Long)cashmgtinitbank.getDynamicObject("bank_currency").getPkValue();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cas_companyunreachedit");
        parameter.setCustomParam("orgid", (Object)orgid);
        parameter.setCustomParam("periodid", (Object)periodid);
        parameter.setCustomParam("accountbankid", (Object)accountbankid);
        parameter.setCustomParam("currencyid", (Object)currencyid);
        ShowType parentshowType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        if (parentshowType == ShowType.Modal) {
            showType = ShowType.Modal;
        } else {
            showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calcCompanyUnreach"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        block3: {
            block2: {
                super.closedCallBack(e);
                if (!"calcBankUnreach".equals(e.getActionId())) break block2;
                Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(0L, 0L);
                int rowCount = this.getModel().getEntryRowCount("entrybank");
                for (int i = 0; i < rowCount; ++i) {
                    this.calcStatementBalanceAdj(i, journalMap);
                }
                break block3;
            }
            if (!"calcCompanyUnreach".equals(e.getActionId())) break block3;
            Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(0L, 0L);
            int rowCount = this.getModel().getEntryRowCount("entrybank");
            for (int i = 0; i < rowCount; ++i) {
                this.calcJournalBalanceAdj(i, statementMap);
            }
        }
    }

    private void fillToolBar(Long orgId, boolean isfinishinit) {
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"bar_save", "casimport", "bar_finishinit", "bar_antiinit", "bar_bankunreach", "bar_companyunreach", "currentperiod"});
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)GLBusinessHelper.needCheckWithGL((long)orgId), (String[])new String[]{"bar_checkgl"});
        if (isfinishinit) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"bar_save", "casimport", "bar_finishinit", "bar_bankunreach", "bar_companyunreach", "bar_checkgl"});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"currentperiod"});
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"bar_antiinit", "currentperiod"});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"currentperiod"});
        }
    }

    public List<Map<String, Object>> getCasInitCashByBatchNo() {
        String sortNo = RequestContext.get().getUserId();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        List<Map<String, Object>> list = CasInitHelper.getCashImportData(org, sortNo);
        if (!CasHelper.isEmpty(list)) {
            CasInitHelper.casInitDeleteCash(sortNo);
        }
        return list;
    }

    public List<Map<String, Object>> getCasInitBankByBatchNo() {
        String batchno = RequestContext.get().getUserId();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        List<Map<String, Object>> list = CasInitHelper.getBankImportData(org, batchno);
        if (!CasHelper.isEmpty(list)) {
            CasInitHelper.casInitDeleteBank(batchno);
        }
        return list;
    }

    public void afterBindData(EventObject e) {
        List<Map<String, Object>> bankList;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        List<Map<String, Object>> cashList = this.getCasInitCashByBatchNo();
        if (!CasHelper.isEmpty(cashList)) {
            block0: for (Map<String, Object> cashMap : cashList) {
                Long acctId = Long.valueOf(String.valueOf(cashMap.get("faccountcashid")));
                Long currId = Long.valueOf(String.valueOf(cashMap.get("currency")));
                for (int i = 0; i < model.getEntryRowCount("entrycash"); ++i) {
                    DynamicObject acct = (DynamicObject)model.getValue("cash_accountcash", i);
                    DynamicObject curr = (DynamicObject)model.getValue("cash_currency", i);
                    if (CasHelper.isEmpty((Object)acct) || acct.getLong("id") != acctId.longValue() || CasHelper.isEmpty((Object)curr) || curr.getLong("id") != currId.longValue()) continue;
                    this.setValue("cash_balance", cashMap.get("fbalance"), i);
                    this.setValue("cash_yeardebit", cashMap.get("fyeardebit"), i);
                    this.setValue("cash_yearcredit", cashMap.get("fyearcredit"), i);
                    continue block0;
                }
            }
        }
        if (!CasHelper.isEmpty(bankList = this.getCasInitBankByBatchNo())) {
            block2: for (Map<String, Object> bankMap : bankList) {
                Long acctId = Long.valueOf(String.valueOf(bankMap.get("faccountcashid")));
                Long currId = Long.valueOf(String.valueOf(bankMap.get("currency")));
                for (int i = 0; i < model.getEntryRowCount("entrybank"); ++i) {
                    DynamicObject acct = (DynamicObject)model.getValue("bank_accountbank", i);
                    DynamicObject curr = (DynamicObject)model.getValue("bank_currency", i);
                    if (CasHelper.isEmpty((Object)acct) || acct.getLong("id") != acctId.longValue() || CasHelper.isEmpty((Object)curr) || curr.getLong("id") != currId.longValue()) continue;
                    this.setValue("bank_journaldebit", bankMap.get("journaldebit"), i);
                    this.setValue("bank_journalcredit", bankMap.get("journalcredit"), i);
                    this.setValue("bank_journalbalance", bankMap.get("journalbalance"), i);
                    this.setValue("bank_statementdebit", bankMap.get("statementdebit"), i);
                    this.setValue("bank_statementcredit", bankMap.get("statementcredit"), i);
                    this.setValue("bank_statementbalance", bankMap.get("statementbalance"), i);
                    continue block2;
                }
            }
        }
    }
}

