/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class ChangePayInfoChgPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sourceId = formShowParameter.getCustomParam("sourceId");
        Object sourceType = formShowParameter.getCustomParam("sourceType");
        Map recBillMap = BFTrackerServiceHelper.findSourceBills((String)(null != sourceType ? String.valueOf(sourceType) : "cas_paybill"), (Long[])new Long[]{(Long)sourceId});
        for (Map.Entry recBillI : recBillMap.entrySet()) {
            HashSet sourceIds = (HashSet)recBillI.getValue();
            if (CollectionUtils.isEmpty((Collection)sourceIds)) continue;
            Long id = (Long)sourceIds.iterator().next();
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)((String)recBillI.getKey()));
            Object creator = sourceBill.get("creator");
            RequestContext requestContext = RequestContext.get();
            String currentUserID = requestContext.getUserId();
            DynamicObject creatorObj = (DynamicObject)creator;
            if (EmptyUtil.isNoEmpty((DynamicObject)creatorObj) && currentUserID.equals(creatorObj.getPkValue().toString())) continue;
            Object billNo = sourceBill.get("billno");
            Object createTime = sourceBill.get("createtime");
            LocaleString billName = EntityMetadataCache.getDataEntityType((String)((String)recBillI.getKey())).getDisplayName();
            int rowIdx = model.createNewEntryRow("entryentity");
            model.setEntryCurrentRowIndex("entryentity", rowIdx);
            model.setValue("billno", billNo, rowIdx);
            model.setValue("billname", (Object)billName, rowIdx);
            model.setValue("createtime", createTime, rowIdx);
            model.setValue("creator", creator, rowIdx);
            this.getView().updateView("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"comfirm"});
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object id = formShowParameter.getCustomParam("id");
        if (source instanceof Button && "comfirm".equals(key = (button = (Button)source).getKey())) {
            DynamicObject payChgBillObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paychgbill");
            Object btnGroup = this.getModel().getValue("btngroup");
            Object userField = this.getModel().getValue("userfield");
            Object changeCause = this.getModel().getValue("changecause");
            Object billNo = null;
            Object billName = null;
            Object creator = null;
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            int row = grid.getEntryState().getFocusRow();
            if ("B".equals(btnGroup) && row < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4eba\u8fdb\u884c\u901a\u77e5\u3002", (String)"ChangePayInfoChgPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject billNoObj = model.getEntryRowEntity("entryentity", row);
            if (null != billNoObj) {
                billNo = billNoObj.get("billno");
                billName = billNoObj.get("billname");
                creator = billNoObj.get("creator");
            }
            if ("C".equals(btnGroup) && null == userField) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4eba\u8fdb\u884c\u901a\u77e5\u3002", (String)"ChangePayInfoChgPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (("B".equals(btnGroup) || "C".equals(btnGroup)) && StringUtils.isEmpty((String)((String)changeCause))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChangePayInfoChgPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            payChgBillObj.set("remark", changeCause);
            Object alterationUser = "B".equals(btnGroup) ? creator : userField;
            payChgBillObj.set("alterationuser", alterationUser);
            payChgBillObj.set("billname", billName);
            payChgBillObj.set("billscode", billNo);
            payChgBillObj.set("chgdate", (Object)DateUtils.getCurrentDate());
            OperationResult operationResult = OperateServiceHelper.execOperate((String)"save", (String)"cas_paychgbill", (DynamicObject[])new DynamicObject[]{payChgBillObj}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                HashMap<String, Object> payChgMap = new HashMap<String, Object>();
                payChgMap.put("id", id);
                payChgMap.put("btnGroup", btnGroup);
                payChgMap.put("changeCause", changeCause);
                payChgMap.put("alterationUser", alterationUser);
                payChgMap.put("billName", billName);
                payChgMap.put("billNo", billNo);
                Long messageId = PayInfoChgHelper.sendNoticeMessage(payChgMap);
                if (null != messageId) {
                    HashMap<String, Long> resultMap = new HashMap<String, Long>();
                    resultMap.put("messageId", messageId);
                    this.getView().returnDataToParent(resultMap);
                }
            }
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().close();
        }
    }
}

