/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public class CompanyUnreachEditPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap", "entrytoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_addrow".equals(itemKey)) {
            this.addrow();
        }
        if ("bar_deleterow".equals(itemKey)) {
            this.delrow();
        }
        if ("bar_save".equals(itemKey)) {
            StringBuffer errorMsg = this.dataValidate();
            if (errorMsg != null && errorMsg.toString().length() > 0) {
                this.getView().showErrorNotification(errorMsg.toString());
                return;
            }
            this.saveData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        QFilter qfilterFive;
        QFilter qfilterFour;
        DynamicObjectCollection bankstatementCol;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.get("orgid") == null || customParams.get("currencyid") == null || customParams.get("periodid") == null || customParams.get("accountbankid") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u3001\u542f\u7528\u671f\u95f4\u3001\u8d26\u6237\u3001\u5e01\u79cd\u6570\u636e\uff0c\u518d\u8fdb\u884c\u94f6\u884c\u672a\u8fbe\u8d26\u5f55\u5165\u3002", (String)"CompanyUnreachEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qfilterOne = null;
        QFilter qfilterTwo = null;
        QFilter qfilterThree = null;
        QFilter qfilterSix = null;
        if (customParams.get("orgid") != null && !customParams.get("orgid").toString().equals("")) {
            long orgId = Long.parseLong(customParams.get("orgid").toString());
            this.getModel().setValue("org", (Object)orgId);
            qfilterOne = new QFilter("org", "=", (Object)orgId);
        }
        if (customParams.get("periodid") != null && !customParams.get("periodid").toString().equals("")) {
            long periodid = Long.parseLong(customParams.get("periodid").toString());
            this.getModel().setValue("period", (Object)periodid);
            qfilterSix = new QFilter("recinitperiod", "=", (Object)periodid);
        }
        if (customParams.get("accountbankid") != null && !customParams.get("accountbankid").toString().equals("")) {
            long accountbankid = Long.parseLong(customParams.get("accountbankid").toString());
            this.getModel().setValue("accountbank", (Object)accountbankid);
            qfilterTwo = new QFilter("accountbank", "=", (Object)accountbankid);
        }
        if (customParams.get("currencyid") != null && !customParams.get("currencyid").toString().equals("")) {
            long currencyid = Long.parseLong(customParams.get("currencyid").toString());
            this.getModel().setValue("currency", (Object)currencyid);
            qfilterThree = new QFilter("currency", "=", (Object)currencyid);
        }
        if (qfilterOne != null && qfilterTwo != null && qfilterThree != null && (bankstatementCol = QueryServiceHelper.query((String)"cas_bankstatement", (String)"id,bizdate,description,settlementtype,settlementnumber,debitamount,creditamount", (QFilter[])new QFilter[]{qfilterOne, qfilterTwo, qfilterThree, qfilterFour = new QFilter("period", "=", (Object)0), qfilterFive = new QFilter("ischeck", "=", (Object)"0"), qfilterSix}, (String)"bizdate")) != null && bankstatementCol.size() > 0) {
            this.bindData(bankstatementCol);
        }
    }

    private void bindData(DynamicObjectCollection bankstatementCol) {
        if (bankstatementCol != null && bankstatementCol.size() > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("bizdate", new Object[0]);
            vs.addField("description", new Object[0]);
            vs.addField("settlementtype", new Object[0]);
            vs.addField("settlementnumber", new Object[0]);
            vs.addField("creditamount", new Object[0]);
            vs.addField("debitamount", new Object[0]);
            vs.addField("statementid", new Object[0]);
            for (DynamicObject statement : bankstatementCol) {
                Object[] rowData = new Object[]{statement.getDate("bizdate"), statement.getString("description"), statement.getLong("settlementtype"), statement.getString("settlementnumber"), statement.getBigDecimal("creditamount"), statement.getBigDecimal("debitamount"), statement.getLong("id")};
                vs.addRow(rowData);
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        int currenctIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if ("debitamount".equals(name)) {
            this.amountChanged(name, newValue, currenctIndex);
        } else if ("creditamount".equals(name)) {
            this.amountChanged(name, newValue, currenctIndex);
        } else {
            return;
        }
    }

    protected void amountChanged(String name, Object newValue, int rowIndex) {
        BigDecimal value = (BigDecimal)newValue;
        if (value.intValue() != 0) {
            if ("debitamount".equals(name)) {
                this.getModel().setValue("creditamount", (Object)0.0, rowIndex);
            } else {
                this.getModel().setValue("debitamount", (Object)0.0, rowIndex);
            }
        }
    }

    private void addrow() {
        this.initRowData(this.getModel().createNewEntryRow("entryentity"));
    }

    private void delrow() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("entryentity").getSelectedRows();
        if (rowIndexs.length > 0) {
            Set<Long> delStatementIds = new HashSet();
            if (this.getPageCache().get("delStatementIds") != null && !this.getPageCache().get("delStatementIds").equals("")) {
                delStatementIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("delStatementIds"), Set.class);
            }
            for (int i = 0; i < rowIndexs.length; ++i) {
                DynamicObject rowData = this.getModel().getEntryRowEntity("entryentity", rowIndexs[i]);
                long statementid = rowData.getLong("statementid");
                if (statementid <= 0L) continue;
                delStatementIds.add(statementid);
            }
            this.getPageCache().put("delStatementIds", SerializationUtils.toJsonString(delStatementIds));
            this.getModel().deleteEntryRows("entryentity", rowIndexs);
        }
    }

    protected void initRowData(int index) {
        this.getModel().setValue("bizdate", (Object)this.getDefaultDate(), index);
    }

    private Date getDefaultDate() {
        Date defaultDate = new Date();
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
        long periodid = 0L;
        if (period != null) {
            periodid = period.getLong("id");
        }
        if (periodid > 0L) {
            DynamicObject lastPeriod = PeriodHelper.getPrevPeriod((long)periodid);
            if (lastPeriod != null) {
                defaultDate = DateUtils.getDataFormat((Date)lastPeriod.getDate("enddate"), (boolean)true);
            } else if (period != null && period.getDate("begindate") != null) {
                defaultDate = DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)period.getDate("begindate"), (int)1), (boolean)true);
            }
        }
        return defaultDate;
    }

    private StringBuffer dataValidate() {
        StringBuffer errorMsg = new StringBuffer();
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
        long periodid = period.getLong("id");
        DynamicObject startPeriod = PeriodHelper.getPeriodById((long)periodid);
        Date firstDay = startPeriod.getDate("begindate");
        int size = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < size; ++i) {
            DynamicObject rowData = this.getModel().getEntryRowEntity("entryentity", i);
            if (rowData.getDate("bizdate").compareTo(firstDay) >= 0) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u542f\u7528\u671f\u95f4\u7b2c\u4e00\u5929\u3002%n", (String)"CompanyUnreachEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (rowData.getBigDecimal("debitamount").compareTo(new BigDecimal("0.00")) != 0 || rowData.getBigDecimal("creditamount").compareTo(new BigDecimal("0.00")) != 0) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u96f6\u3002%n", (String)"CompanyUnreachEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), i + 1));
        }
        return errorMsg;
    }

    private void saveData() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        long orgid = org.getLong("id");
        DynamicObject accountbank = dataEntity.getDynamicObject("accountbank");
        long accountbankid = accountbank.getLong("id");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        long currencyid = currency.getLong("id");
        if (this.getModel().getEntryRowCount("entryentity") > 0) {
            DynamicObject recinitperiod = dataEntity.getDynamicObject("period");
            int rowcount = this.getModel().getEntryRowCount("entryentity");
            Object[] bookEntities = new Object[rowcount];
            ArrayList<Long> editStatementIds = new ArrayList<Long>();
            for (int i = 0; i < rowcount; ++i) {
                DynamicObject entryDO = this.getModel().getEntryRowEntity("entryentity", i);
                DynamicObject statementInfo = new DynamicObject((DynamicObjectType)entityType);
                if (entryDO.get("statementid") != null && entryDO.getLong("statementid") > 0L) {
                    editStatementIds.add(entryDO.getLong("statementid"));
                }
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"org", (Object)org);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"isbank", (Object)"1");
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"source", (Object)"4");
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"accountbank", (Object)accountbank);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"currency", (Object)currency);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"bizdate", (Object)entryDO.getDate("bizdate"));
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"description", (Object)entryDO.getString("description"));
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"settlementtype", (Object)entryDO.getDynamicObject("settlementtype"));
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"settlementnumber", (Object)entryDO.getString("settlementnumber"));
                if (entryDO.getBigDecimal("debitamount").compareTo(new BigDecimal("0")) > 0) {
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"debitamount", (Object)entryDO.getBigDecimal("debitamount"));
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"creditamount", (Object)new BigDecimal("0.00"));
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"direction", (Object)"1");
                }
                if (entryDO.getBigDecimal("creditamount").compareTo(new BigDecimal("0")) > 0) {
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"creditamount", (Object)entryDO.getBigDecimal("creditamount"));
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"debitamount", (Object)new BigDecimal("0.00"));
                    DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"direction", (Object)"2");
                }
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"period", null);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"recinitperiod", (Object)recinitperiod);
                DynamicObjectHelper.setValue((DynamicObject)statementInfo, (String)"isvalid", (Object)"0");
                bookEntities[i] = statementInfo;
            }
            if (editStatementIds != null && editStatementIds.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])editStatementIds.toArray());
            }
            SaveServiceHelper.save((IDataEntityType)entityType, (Object[])bookEntities);
        }
        if (this.getPageCache().get("delStatementIds") != null && !this.getPageCache().get("delStatementIds").equals("")) {
            Set delStatementIds = new HashSet();
            delStatementIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("delStatementIds"), Set.class);
            if (delStatementIds != null && delStatementIds.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])delStatementIds.toArray());
            }
        }
        this.getModel().deleteEntryData("entryentity");
        this.afterCreateNewData(null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompanyUnreachEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("delStatementIds", null);
    }
}

