/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DataLockList
extends AbstractListPlugin {
    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject info = e.getRowData();
        String entityKey = info.getString("entitykey.number");
        AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
        String columnName = column.getFieldKey();
        if ("operationname".equals(columnName)) {
            Map opMap = EntityMetadataCache.getDataEntityOperate((String)entityKey, (String)info.getString("operationkey"));
            if (opMap != null) {
                e.setFormatValue(((Map)opMap.get("name")).get(Locale.getDefault().toString()));
            } else {
                e.setFormatValue((Object)info.getString("operationkey"));
            }
        }
        if ("objectname".equals(columnName)) {
            String formatValue = null;
            String objectID = info.getString("objectid");
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityKey);
            if (dt instanceof BillEntityType) {
                BillEntityType entity = (BillEntityType)dt;
                if (StringUtils.isNotBlank((CharSequence)entity.getBillNo())) {
                    DynamicObject entityObj = BusinessDataServiceHelper.loadSingle((Object)objectID, (String)entity.getName(), (String)entity.getBillNo());
                    formatValue = entityObj != null ? entityObj.getString(entity.getBillNo()) : objectID;
                }
            } else if (dt instanceof BasedataEntityType) {
                BasedataEntityType entity = (BasedataEntityType)dt;
                if (StringUtils.isNotBlank((CharSequence)entity.getNumberProperty())) {
                    DynamicObject entityObj = BusinessDataServiceHelper.loadSingleFromCache((Object)objectID, (String)entity.getName(), (String)entity.getNumberProperty());
                    formatValue = entityObj != null ? entityObj.getString(entity.getNumberProperty()) : objectID;
                }
            } else {
                formatValue = objectID;
            }
            if (formatValue != null) {
                e.setFormatValue((Object)formatValue);
            }
        }
    }
}

