/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;

public class FinalCheckOutList
extends AbstractListPlugin {
    private List<Long> selectedOrgIdList = new ArrayList<Long>();
    private long defaultOrgId;
    private FilterContainerInitArgs initArgs;
    private boolean isSearchClick = false;

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null) {
            List successIds = args.getOperationResult().getSuccessPkIds();
            ArrayList success = new ArrayList();
            for (Object successId : successIds) {
                if (success.contains(successId)) continue;
                success.add(successId);
            }
            args.getOperationResult().setSuccessPkIds(success);
        }
        if ("checkout".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            int selectSize;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            int successSize = args.getOperationResult().getSuccessPkIds().size();
            if (successSize - (selectSize = selectedRows.size()) >= 0) {
                this.getView().invokeOperation("refresh");
                if (successSize - selectSize == 0) {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u6210\u529f%s\u7b14\u3002", (String)"FinalCheckOutList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), successSize));
                } else {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u6210\u529f%s\u7b14\u3002", (String)"FinalCheckOutList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), successSize - selectSize));
                }
            } else {
                this.getView().invokeOperation("refresh");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u5931\u8d25\u3002", (String)"FinalCheckOutList_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("anticheckout".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u6210\u529f\u3002", (String)"FinalCheckOutList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        if (this.getPageCache().get("isPageOpen") != null) {
            if (this.isSearchClick) {
                for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    if (!fieldName.startsWith("period.")) continue;
                    this.setPeriodFilterColumn(commonFilterColumn);
                }
            }
            return;
        }
        this.cacheFirstSelectedOrg(args);
        this.getPageCache().put("isPageOpen", "true");
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equals("checkoutstatus")) {
                ArrayList<String> defaultValues = new ArrayList<String>();
                defaultValues.add("1");
                defaultValues.add("2");
                defaultValues.add("4");
                commonFilterColumn.setDefaultValues(defaultValues);
                commonFilterColumn.setDefValue(null);
                continue;
            }
            if (fieldName.startsWith("org.")) {
                List orgItems = commonFilterColumn.getComboItems();
                if (orgItems == null || orgItems.size() < 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u67e5\u770b\u51fa\u7eb3\u7ed3\u8d26\u6570\u636e\uff0c\u8bf7\u60a8\u786e\u8ba4\u662f\u5426\u6709\u8d44\u91d1\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u6216\u8005\u68c0\u67e5\u8be5\u8d44\u91d1\u7ec4\u7ec7\u662f\u5426\u5df2\u7ecf\u5b8c\u6210\u521d\u59cb\u5316\u3002", (String)"FinalCheckOutList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.defaultOrgId = RequestContext.get().getOrgId();
                if (!orgItems.contains(this.defaultOrgId)) {
                    List defaultVals = commonFilterColumn.getDefaultValues();
                    this.defaultOrgId = defaultVals != null && defaultVals.size() > 0 ? Long.parseLong((String)defaultVals.get(0)) : Long.parseLong(((ComboItem)orgItems.get(0)).getValue());
                }
                this.selectedOrgIdList.add(this.defaultOrgId);
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)this.defaultOrgId);
                this.getPageCache().put("periodTypeId", String.valueOf(periodTypeId));
                continue;
            }
            if (!fieldName.startsWith("period.")) continue;
            this.setPeriodFilterColumn(commonFilterColumn);
        }
    }

    private void setPeriodFilterColumn(CommonFilterColumn commonFilterColumn) {
        List<DynamicObject> periodList = new ArrayList<DynamicObject>();
        List<Long> targetOrgIds = new ArrayList<Long>();
        if (this.selectedOrgIdList.size() > 0) {
            targetOrgIds.addAll(this.selectedOrgIdList);
        } else {
            Object appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            targetOrgIds = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        }
        for (Long orgId : targetOrgIds) {
            try {
                periodList.addAll(PeriodHelper.getOriginPeriods((long)orgId));
            }
            catch (KDBizException kDBizException) {}
        }
        periodList = this.orderPeriodBydate(periodList);
        ArrayList<ComboItem> periodItemList = new ArrayList<ComboItem>(periodList.size());
        ArrayList<Long> periodIds = new ArrayList<Long>(periodList.size());
        for (DynamicObject period : periodList) {
            periodItemList.add(new ComboItem(new LocaleString(period.getString("name")), period.getString("id")));
            periodIds.add(period.getLong("id"));
        }
        List acctcomitem = commonFilterColumn.getComboItems();
        acctcomitem.clear();
        commonFilterColumn.setComboItems(periodItemList);
        if (periodItemList.size() > 0) {
            commonFilterColumn.setDefaultValue(((ComboItem)periodItemList.get(0)).getValue());
        }
        this.getPageCache().put("periodIds", SerializationUtils.toJsonString(periodIds));
    }

    private List<DynamicObject> orderPeriodBydate(List<DynamicObject> periodList) {
        ArrayList<DynamicObject> periods = new ArrayList<DynamicObject>();
        HashSet<Object> distictSet = new HashSet<Object>();
        for (DynamicObject period : periodList) {
            if (distictSet.contains(period.getPkValue())) continue;
            periods.add(period);
            distictSet.add(period.getPkValue());
        }
        Collections.sort(periods, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject arg0, DynamicObject arg1) {
                return arg0.getDate("begindate").after(arg1.getDate("begindate")) ? -1 : 1;
            }
        });
        return periods;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isSearchClick = true;
        Map filtervalue = args.getSearchClickEvent().getFilterValues();
        List filterList = (List)filtervalue.get("customfilter");
        if (filterList == null) {
            return;
        }
        for (Map filter : filterList) {
            String fieldName = (String)((List)filter.get("FieldName")).get(0);
            if (!fieldName.startsWith("org.")) continue;
            this.selectedOrgIdList = new ArrayList<Long>();
            List orgIds = (List)filter.get("Value");
            for (int i = orgIds.size() - 1; i > -1; --i) {
                if ("".equals(orgIds.get(i))) {
                    String appId = this.getView().getFormShowParameter().getAppId();
                    appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                    this.selectedOrgIdList.addAll(OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac"));
                    if (this.selectedOrgIdList.size() <= 0) continue;
                    this.defaultOrgId = this.selectedOrgIdList.get(0);
                    continue;
                }
                this.defaultOrgId = Long.parseLong((String)orgIds.get(i));
                this.selectedOrgIdList.add(this.defaultOrgId);
            }
            long periodTypeId = PeriodHelper.getPeriodTypeId((long)this.defaultOrgId);
            this.getPageCache().put("periodTypeId", String.valueOf(periodTypeId));
            List cacheOrgIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
            List<Long> collect = cacheOrgIds.stream().map(Object::toString).map(Long::parseLong).collect(Collectors.toList());
            boolean orgChange = this.isEqualList(collect, this.selectedOrgIdList);
            if (!orgChange) {
                ArrayList<Map> newFilterList = new ArrayList<Map>();
                for (Map f : filterList) {
                    String fName = (String)((List)f.get("FieldName")).get(0);
                    if (fName.startsWith("period.")) continue;
                    newFilterList.add(f);
                }
                filtervalue.put("customfilter", newFilterList);
            }
            this.cacheSelectedOrgIdList(this.selectedOrgIdList);
        }
        if (filterList != null) {
            this.filterContainerInit(this.initArgs);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        switch (args.getFieldName()) {
            case "period.id": {
                List qfilters = args.getQfilters();
                String periodIdStr = this.getPageCache().get("periodIds");
                if (StringUtils.isNotBlank((CharSequence)periodIdStr)) {
                    List periodIds = (List)SerializationUtils.fromJsonString((String)periodIdStr, List.class);
                    qfilters.add(new QFilter("id", "in", (Object)periodIds));
                }
                qfilters.add(new QFilter("isadjustperiod", "=", (Object)"0"));
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        switch (args.getFieldName()) {
            case "period.id": {
                if (this.selectedOrgIdList == null || this.selectedOrgIdList.size() <= 0) break;
                DynamicObject init = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.selectedOrgIdList.get(0))});
                args.addCustomQFilter(new QFilter("periodtype", "=", init.get("periodtype")));
            }
        }
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        String firstOrgId = null;
        if (this.isDefaultOpen()) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                List orgItems;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!commonFilterColumn.getFieldName().startsWith("org.") || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
                String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                for (int i = 0; i < orgItems.size(); ++i) {
                    ComboItem item = (ComboItem)orgItems.get(i);
                    if (!item.getValue().equals(loginOrg)) continue;
                    firstOrgId = loginOrg;
                    break;
                }
                if (firstOrgId != null) continue;
                List defaultVals = commonFilterColumn.getDefaultValues();
                if (defaultVals != null && defaultVals.size() > 0) {
                    firstOrgId = (String)defaultVals.get(0);
                    continue;
                }
                firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
            }
        } else {
            firstOrgId = this.getView().getFormShowParameter().getCustomParam("org.id").toString();
        }
        if (firstOrgId != null) {
            this.selectedOrgIdList.add(Long.valueOf(firstOrgId));
        }
        this.cacheSelectedOrgIdList(this.selectedOrgIdList);
        this.getPageCache().put("org.id", firstOrgId);
    }

    private void cacheSelectedOrgIdList(List<Long> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected boolean isDefaultOpen() {
        ListShowParameter parameters = (ListShowParameter)this.getView().getFormShowParameter();
        return parameters.getCustomParam("setDefaultFilters") == null;
    }

    private boolean isEqualList(List<Long> src, List<Long> target) {
        if (src.size() == target.size()) {
            if (src.size() == 0) {
                return true;
            }
            this.sortList(src);
            this.sortList(target);
            int sLen = src.size();
            for (int i = 0; i < sLen; ++i) {
                if (src.get(i).longValue() == target.get(i).longValue()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void sortList(List<Long> list) {
        list.sort(new Comparator<Long>(){

            @Override
            public int compare(Long arg0, Long arg1) {
                return arg0 > arg1 ? 1 : (arg0 < arg1 ? -1 : 0);
            }
        });
    }
}

