/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.JournalModel;
import kd.fi.cas.formplugin.JournalRptHandleByDate;
import kd.fi.cas.formplugin.JournalRptHandleByPeriod;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.param.JournalParam;
import kd.fi.cas.util.DataSetUtil;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class JournalBaseListDataRpt
extends AbstractReportListDataPlugin {
    protected String acctPropertyName;
    protected String journalEntity;
    protected String type;
    private JournalRptHandleByPeriod journalRptHandle;
    private JournalParam param;
    protected String[] orderBys;
    private DynamicObjectCollection resetInitBalanceData;
    private static Log log = LogFactory.getLog(JournalBaseListDataRpt.class);

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        String[] args = arg1.toString().split("%");
        DataSet dateSet = null;
        int count = 0;
        int i = 0;
        Long orgId = this.getOrgId(arg1);
        List<Object[]> datas = null;
        ArrayList<Field> fields = new ArrayList<Field>();
        log.info("====JournalBaseListDataRpt.query:{}.begin===", (Object)args.length);
        for (String arg : args) {
            JournalParam param;
            this.param = param = this.getJournalParam(arg0, arg);
            if (null != param) {
                this.resetInitBalanceData = this.queryResetInitBalanceData(param);
                if (null == datas) {
                    datas = this.getRptListDataSet(param, orgId, fields);
                } else {
                    List<Object[]> data_temp = this.getRptListDataSet(param, orgId, fields);
                    if (data_temp != null) {
                        datas.addAll(data_temp);
                    }
                }
            } else {
                ++count;
            }
            if (++i != 100) continue;
            i = 0;
            Algo.closeAllDataSet();
        }
        log.info("====JournalBaseListDataRpt.query.end");
        RowMeta field_meta = new RowMeta(fields.toArray(new Field[0]));
        dateSet = Algo.create((String)this.getAlgoKey("query")).createDataSet(datas, field_meta);
        log.info("====JournalBaseListDataRpt.createDs.end");
        return count != args.length ? dateSet : Algo.create((String)this.getAlgoKey("query")).createDataSet(new ArrayList(), field_meta);
    }

    private Long getOrgId(Object arg1) {
        String[] paramIds = arg1.toString().split("-");
        if (paramIds.length <= 1) {
            return null;
        }
        return Long.parseLong(paramIds[2]);
    }

    protected JournalParam getJournalParam(ReportQueryParam arg0, Object arg1) {
        String[] paramIds = arg1.toString().split("-");
        if (paramIds.length <= 1) {
            return null;
        }
        FilterInfo filterInfo = arg0.getFilter();
        JournalParam param = new JournalParam();
        String queryOrgType = filterInfo.getString("queryorgtype");
        if (StringUtils.isBlank((CharSequence)queryOrgType)) {
            queryOrgType = "org";
        }
        param.setQueryOrgType(queryOrgType);
        long orgId = Long.parseLong(paramIds[2].equals("null") ? "0" : paramIds[2]);
        long acctId = Long.parseLong(paramIds[1].equals("null") ? "0" : paramIds[1]);
        long currencyId = Long.parseLong(paramIds[0].equals("null") ? "0" : paramIds[0]);
        param.setOrgid(orgId);
        String acctName = "";
        if (paramIds.length >= 4) {
            StringBuilder collect = new StringBuilder();
            for (int i = 3; i < paramIds.length; ++i) {
                collect.append(paramIds[i]).append("-");
            }
            if (collect.length() > 0) {
                acctName = collect.substring(0, collect.lastIndexOf("-"));
            }
        }
        param.setAcctname(acctName);
        param.setAcctid(acctId);
        param.setAcctPropertyName(this.acctPropertyName);
        param.setJournalEntity(this.journalEntity);
        param.setType(this.type);
        param.setCurrencyid(currencyId);
        param.setCombine(filterInfo.getBoolean("iscombine"));
        param.setDateType(filterInfo.getInt("datetype"));
        QFilter journalFilter = filterInfo.getCommFilter(this.journalEntity);
        param.setJournalFilter(journalFilter);
        HashSet<Date> initStartDates = new HashSet<Date>(8);
        if ("openorg".equals(queryOrgType)) {
            Set useOrgIds = AccountBankHelper.getUserAuthorityOrgs((Long)acctId);
            if (useOrgIds == null || useOrgIds.size() <= 0) {
                return null;
            }
            boolean hasInit = false;
            for (Long useOrgId : useOrgIds) {
                param.setOrgid(useOrgId.longValue());
                if (!this.fillParam(param, filterInfo, initStartDates)) continue;
                hasInit = true;
            }
            this.setBeginDate(initStartDates, filterInfo, param);
            if (!hasInit) {
                return null;
            }
        } else if (!this.fillParam(param, filterInfo, new HashSet<Date>(2))) {
            return null;
        }
        param.setOrgid(orgId);
        return param;
    }

    private void setBeginDate(Set<Date> initStartDates, FilterInfo filterInfo, JournalParam param) {
        if (initStartDates == null || initStartDates.size() == 0) {
            return;
        }
        Date searchDate = filterInfo.getDate("begindate");
        Date minDate = null;
        for (Date date : initStartDates) {
            if (minDate == null) {
                minDate = date;
                continue;
            }
            if (!date.before(minDate)) continue;
            minDate = date;
        }
        if (minDate != null && searchDate.before(minDate)) {
            param.setBeginDate(minDate);
        } else {
            param.setBeginDate(searchDate);
        }
    }

    protected boolean fillParam(JournalParam param, FilterInfo filterInfo, Set<Date> initStartDates) {
        DynamicObject casInitInfo = PeriodHelper.getCasInitInfo((long)param.getOrgid());
        if (casInitInfo == null || !casInitInfo.getBoolean("isfinishinit")) {
            return false;
        }
        param.setFinishInit(casInitInfo.getBoolean("isfinishinit"));
        DynamicObject startPeriod = casInitInfo.getDynamicObject("startperiod");
        param.setStartPeriod(startPeriod);
        DynamicObject currentPeriod = casInitInfo.getDynamicObject("currentperiod");
        param.setCurrentPeriod(currentPeriod);
        if (param.getDateType() == 1) {
            DynamicObject beginPeriod = filterInfo.getDynamicObject("beginperiod");
            DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
            if (PeriodHelper.before((DynamicObject)endPeriod, (DynamicObject)startPeriod)) {
                return false;
            }
            if (PeriodHelper.before((DynamicObject)beginPeriod, (DynamicObject)startPeriod)) {
                beginPeriod = startPeriod;
            }
            param.setBeginPeriod(beginPeriod);
            param.setEndPeriod(endPeriod);
            this.journalRptHandle = new JournalRptHandleByPeriod(param);
        } else if (param.getDateType() == 2) {
            param.setBeginDate(filterInfo.getDate("begindate"));
            param.setEndDate(filterInfo.getDate("enddate"));
            initStartDates.add(startPeriod.getDate("begindate"));
            if (param.getBeginDate().before(startPeriod.getDate("begindate"))) {
                param.setBeginPeriod(startPeriod);
                param.setBeginDate(startPeriod.getDate("begindate"));
            } else {
                param.setBeginPeriod(PeriodHelper.getPeriodByDate((long)param.getOrgid(), (Date)param.getBeginDate()));
            }
            if (param.getEndDate().before(startPeriod.getDate("begindate"))) {
                return false;
            }
            DynamicObject endPeriod = PeriodHelper.getPeriodByDate((long)param.getOrgid(), (Date)param.getEndDate());
            if (endPeriod != null) {
                param.setEndPeriod(PeriodHelper.getPeriodByDate((long)param.getOrgid(), (Date)param.getEndDate()));
            } else {
                param.setEndPeriod(PeriodHelper.getLastPeriod((long)param.getOrgid()));
            }
            this.journalRptHandle = new JournalRptHandleByDate(param);
        }
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        Map<String, BigDecimal> beginPeriodData = !useBalanceModel ? this.journalRptHandle.getBeginPeriodData() : this.journalRptHandle.getBeginPeriodDataByBalanceModel();
        param.setBeginBalance(param.getBeginBalance().add(beginPeriodData.get("beginBalance")));
        if (param.getDateType() == 2) {
            BigDecimal periodBeginDebitAmt = beginPeriodData.get("periodBeginDebitAmt");
            BigDecimal periodBeginCreditAmt = beginPeriodData.get("periodBeginCreditAmt");
            if (periodBeginDebitAmt != null) {
                param.setPeriodBeginDebitAmt(param.getPeriodBeginDebitAmt().add(periodBeginDebitAmt));
            }
            if (periodBeginCreditAmt != null) {
                param.setPeriodBeginCreditAmt(param.getPeriodBeginCreditAmt().add(periodBeginCreditAmt));
            }
        }
        if ("org".equals(param.getQueryOrgType())) {
            Map<String, BigDecimal> beginYearData = this.journalRptHandle.getBeginYearData();
            param.setYearBeginDebitAmt(beginYearData.get("yearBeginDebitAmt"));
            param.setYearBeginCreditAmt(beginYearData.get("yearBeginCreditAmt"));
            if (EmptyUtil.isNoEmpty((DynamicObject)param.getBeginPeriod()) && param.getBeginPeriod().getLong("id") == param.getStartPeriod().getLong("id")) {
                param.setYearBeginBalance(this.journalRptHandle.getYearBeginBalance());
            }
        }
        return true;
    }

    private void dsClose(DataSet ... dss) {
        int j = dss.length;
        for (int i = 0; i < j; ++i) {
            if (dss[i] == null) continue;
            dss[i].close();
        }
    }

    private List<Object[]> getDataLists(DataSet ds, List<Field> fields) {
        if (ds == null) {
            return null;
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        while (ds.hasNext()) {
            Row row = ds.next();
            dataList.add(this.rowToData(fields, row));
        }
        return dataList;
    }

    private Object[] rowToData(List<Field> fields, Row row) {
        Object[] rowData = new Object[fields.size()];
        int i = 0;
        for (Field field : fields) {
            String name = field.getName();
            rowData[i] = row.get(name);
            ++i;
        }
        return rowData;
    }

    private List<Object[]> getRptListDataSet(JournalParam param, Long orgId, List<Field> out_Fields) {
        DataSet typeDataSet = this.getRpTypeDataset();
        DataSet detailset = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getRptListDataSet"), (String)param.getJournalEntity(), (String)this.getQueryFiled(param), (QFilter[])this.getQFilter(param), null);
        detailset = detailset.leftJoin(typeDataSet).on("rpbasetype", "entity").on("rptypeid", "id").select(detailset.getRowMeta().getFieldNames(), new String[]{"name as rptype"}).finish();
        detailset = DataSetUtil.formatDataSetInDate((DataSet)detailset, (String[])new String[]{"bookdate", "bizdate"});
        detailset = detailset.orderBy(this.getOrderBys(new String[]{"bookdate", "createtime"}, this.orderBys));
        DataSet copyDetailSet = detailset.copy();
        DataSet balanceData = "org".equals(param.getQueryOrgType()) ? this.handleDataSet(param, detailset) : this.handleDataSetForOpenOrg(param, detailset);
        copyDetailSet = copyDetailSet.select(this.getSelectedField()).addBalanceField("balance", "rowbalance").addField(param.getBeginBalance().toPlainString(), "beginBalance").addField("rowbalance+beginBalance", "actualbalance");
        Map beginBalanceMap = param.getBeginBalanceMap();
        if (!beginBalanceMap.isEmpty()) {
            Set beginBalanceDates = beginBalanceMap.keySet();
            TreeSet treeSet = new TreeSet(beginBalanceDates);
            ArrayList balanceDateList = new ArrayList(treeSet);
            ArrayList<String> splits = new ArrayList<String>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            for (int i = 0; i < balanceDateList.size(); ++i) {
                String dateStr1 = (String)balanceDateList.get(i);
                Date date1 = DateUtils.stringToDate((String)dateStr1, (String)"yyyy-MM-dd HH:mm:ss");
                if (i == 0) {
                    splits.add("bookdate < to_date('" + sdf.format(date1) + "','yyyy-MM-dd HH:mm:ss.SSS')");
                }
                if (i + 1 >= balanceDateList.size()) continue;
                String dateStr2 = (String)balanceDateList.get(i + 1);
                Date date2 = DateUtils.stringToDate((String)dateStr2, (String)"yyyy-MM-dd HH:mm:ss");
                String splitFilter = "bookdate >= to_date('" + sdf.format(date1) + "','yyyy-MM-dd HH:mm:ss.SSS') and bookdate < to_date('" + sdf.format(date2) + "','yyyy-MM-dd HH:mm:ss.SSS')";
                splits.add(splitFilter);
                if (i + 1 != balanceDateList.size() - 1) continue;
                splits.add("bookdate >= to_date('" + sdf.format(date2) + "','yyyy-MM-dd HH:mm:ss.SSS')");
            }
            DataSet[] splitDs = copyDetailSet.splitByFilter(splits.toArray(new String[0]), true);
            for (int i = 0; i < splitDs.length; ++i) {
                DataSet ds = splitDs[i];
                if (i == 0) {
                    copyDetailSet = ds;
                    continue;
                }
                if (i > balanceDateList.size()) continue;
                String dateStr1 = (String)balanceDateList.get(i - 1);
                BigDecimal beginBalance = (BigDecimal)beginBalanceMap.get(dateStr1);
                ds = ds.removeFields(new String[]{"rowbalance"}).addBalanceField("balance", "rowbalance");
                ds = ds.updateField("actualbalance", "rowbalance+" + beginBalance).select(copyDetailSet.getRowMeta().getFieldNames());
                copyDetailSet = copyDetailSet.union(ds);
            }
        }
        DataSet totalSet = this.union(copyDetailSet, balanceData) == null ? null : this.union(copyDetailSet, balanceData).orderBy(this.getOrderBys(new String[]{"bookdate", "datatype", "createtime"}, this.orderBys));
        this.dsClose(detailset, copyDetailSet, balanceData, typeDataSet);
        if (totalSet == null) {
            return null;
        }
        if (out_Fields == null || out_Fields.size() == 0) {
            Field[] fields = totalSet.getRowMeta().getFields();
            if (out_Fields == null) {
                out_Fields = new ArrayList<Field>(10);
            }
            out_Fields.addAll(Arrays.asList(fields));
        }
        return this.getDataLists(totalSet, out_Fields);
    }

    private DataSet getRpTypeDataset() {
        ArrayList inputs = new ArrayList(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.journalEntity);
        ItemClassTypeProp rpTypeProp = (ItemClassTypeProp)entityType.getProperty("rpbasetype");
        RowMeta typeRowMeta = new RowMeta(new String[]{"entity", "id", "number", "name"}, new DataType[]{DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType});
        rpTypeProp.getItemTypes().keySet().forEach(type -> inputs.add(new OrmInput(this.getAlgoKey("getRptListDataSet.ItemClassType"), type, "'" + type + "' entity,id,number,name", new QFilter("status", "=", (Object)"C").toArray(), typeRowMeta)));
        return Algo.create((String)this.getAlgoKey("getRptListDataSet.ItemClassType")).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
    }

    private String[] getOrderBys(String[] a, String[] b) {
        if (a == null) {
            a = new String[]{};
        }
        if (b == null) {
            b = new String[]{};
        }
        String[] tOrderBys = new String[a.length + b.length];
        int lastIdx = 1;
        System.arraycopy(a, 0, tOrderBys, 0, a.length - lastIdx);
        System.arraycopy(b, 0, tOrderBys, a.length - lastIdx, b.length);
        System.arraycopy(a, a.length - lastIdx, tOrderBys, b.length + a.length - lastIdx, lastIdx);
        return tOrderBys;
    }

    private DataSet handleDataSet(JournalParam param, DataSet totalDataSet) {
        Iterator it;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        BigDecimal balance = param.getBeginBalance();
        BigDecimal tmpDayDebitTotal = BigDecimal.ZERO;
        BigDecimal tmpDayCreditTotal = BigDecimal.ZERO;
        BigDecimal tmpPeriodDebitTotal = param.getPeriodBeginDebitAmt();
        BigDecimal tmpPeriodCreditTotal = param.getPeriodBeginCreditAmt();
        BigDecimal tmpYearDebitTotal = param.getYearBeginDebitAmt();
        BigDecimal tmpYearCreditTotal = param.getYearBeginCreditAmt();
        if (EmptyUtil.isNoEmpty((DynamicObject)param.getBeginPeriod()) && param.getBeginPeriod().getLong("id") == param.getStartPeriod().getLong("id")) {
            param.setYearBeginBalance(this.journalRptHandle.getYearBeginBalance());
            dataList.add(this.getObjectRow(param.getStartPeriod().getDate("begindate"), param.getYearBeginBalance(), ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), 1));
        }
        if (!(it = totalDataSet.iterator()).hasNext()) {
            if (param.getDateType() == 2) {
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpPeriodCreditTotal);
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpPeriodDebitTotal);
            }
            this.addRow4NoData(param, dataList, param.getBeginPeriod(), param.getEndPeriod(), tmpPeriodCreditTotal, tmpPeriodDebitTotal, balance, tmpYearCreditTotal, tmpYearDebitTotal);
        } else {
            DynamicObject temNextPeriodInfo;
            Pair<Boolean, BigDecimal> pair;
            Row row = (Row)it.next();
            Date bookDate = row.getDate("bookdate");
            int periodNumber = row.getInteger("periodnumber");
            int periodYear = row.getInteger("year");
            long periodId = row.getLong("periodid");
            DynamicObject period = PeriodHelper.getPeriodById((long)periodId);
            Date endDate = period.getDate("enddate");
            if (PeriodHelper.before((DynamicObject)param.getBeginPeriod(), (DynamicObject)period)) {
                if (param.getDateType() == 2) {
                    tmpYearCreditTotal = tmpYearCreditTotal.add(tmpPeriodCreditTotal);
                    tmpYearDebitTotal = tmpYearDebitTotal.add(tmpPeriodDebitTotal);
                }
                balance = this.addRow4NoData(param, dataList, param.getBeginPeriod(), PeriodHelper.getPrevPeriod((long)period.getLong("id")), tmpPeriodCreditTotal, tmpPeriodDebitTotal, balance, tmpYearCreditTotal, tmpYearDebitTotal);
                tmpPeriodDebitTotal = BigDecimal.ZERO;
                tmpPeriodCreditTotal = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty((DynamicObject)param.getBeginPeriod()) && param.getBeginPeriod().getInt("periodyear") != period.getInt("periodyear")) {
                    tmpYearCreditTotal = BigDecimal.ZERO;
                    tmpYearDebitTotal = BigDecimal.ZERO;
                    if (periodNumber == 1) {
                        dataList.add(this.getObjectRow(period.getDate("begindate"), balance, ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), 1));
                    }
                }
            }
            if (((Boolean)(pair = this.isReset(period.getDate("begindate"), balance)).getLeft()).booleanValue() && !param.getBeginBalanceMap().containsKey(this.resetFormatDate(period.getDate("begindate")))) {
                param.getBeginBalanceMap().put(this.resetFormatDate(period.getDate("begindate")), pair.getRight());
                balance = (BigDecimal)pair.getRight();
            }
            dataList.add(this.getObjectRow(period.getDate("begindate"), balance, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), 2, (Boolean)pair.getLeft() != false ? "7" : ""));
            balance = balance.add(row.getBigDecimal("balance"));
            tmpDayDebitTotal = tmpDayDebitTotal.add(row.getBigDecimal("debitamount"));
            tmpDayCreditTotal = tmpDayCreditTotal.add(row.getBigDecimal("creditamount"));
            while (it.hasNext()) {
                row = (Row)it.next();
                if (org.apache.commons.lang.time.DateUtils.isSameDay((Date)bookDate, (Date)row.getDate("bookdate"))) {
                    tmpDayDebitTotal = tmpDayDebitTotal.add(row.getBigDecimal("debitamount"));
                    tmpDayCreditTotal = tmpDayCreditTotal.add(row.getBigDecimal("creditamount"));
                } else {
                    tmpPeriodDebitTotal = tmpPeriodDebitTotal.add(tmpDayDebitTotal);
                    tmpPeriodCreditTotal = tmpPeriodCreditTotal.add(tmpDayCreditTotal);
                    if (param.isShowDayTotal()) {
                        dataList.add(this.getObjectRow(bookDate, balance, ResManager.loadKDString((String)"\u672c\u65e5\u5408\u8ba1", (String)"JournalBaseListDataRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), 4, tmpDayCreditTotal, tmpDayDebitTotal));
                    }
                    tmpDayDebitTotal = row.getBigDecimal("debitamount");
                    tmpDayCreditTotal = row.getBigDecimal("creditamount");
                }
                if (periodNumber != row.getInteger("periodnumber")) {
                    tmpYearDebitTotal = tmpYearDebitTotal.add(tmpPeriodDebitTotal);
                    tmpYearCreditTotal = tmpYearCreditTotal.add(tmpPeriodCreditTotal);
                    if (param.isShowPeriodTotal()) {
                        dataList.add(this.getObjectRow(endDate, balance, ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"JournalBaseListDataRpt_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), 5, tmpPeriodCreditTotal, tmpPeriodDebitTotal));
                    }
                    tmpPeriodDebitTotal = BigDecimal.ZERO;
                    tmpPeriodCreditTotal = BigDecimal.ZERO;
                    if (param.isShowYearTotal()) {
                        dataList.add(this.getObjectRow(endDate, balance, ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"JournalBaseListDataRpt_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), 6, tmpYearCreditTotal, tmpYearDebitTotal));
                        temNextPeriodInfo = PeriodHelper.getNextPeriod((long)periodId);
                        if (temNextPeriodInfo == null) {
                            return Algo.create((String)"cas.cashjournal.total").createDataSet(dataList, this.getRowMeta());
                        }
                        if (!PeriodHelper.after((DynamicObject)temNextPeriodInfo, (DynamicObject)param.getEndPeriod()) && periodYear < temNextPeriodInfo.getInt("periodyear")) {
                            dataList.add(this.getObjectRow(temNextPeriodInfo.getDate("begindate"), balance, ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), 1));
                            tmpYearDebitTotal = BigDecimal.ZERO;
                            tmpYearCreditTotal = BigDecimal.ZERO;
                        }
                    }
                    balance = this.addRow4NoData(param, dataList, PeriodHelper.getNextPeriod((long)period.getLong("id")), PeriodHelper.getPrevPeriod((long)row.getLong("periodid")), tmpPeriodCreditTotal, tmpPeriodDebitTotal, balance, tmpYearCreditTotal, tmpYearDebitTotal);
                    tmpPeriodDebitTotal = BigDecimal.ZERO;
                    tmpPeriodCreditTotal = BigDecimal.ZERO;
                    if (period.getInt("periodyear") != row.getInteger("year").intValue()) {
                        tmpYearCreditTotal = BigDecimal.ZERO;
                        tmpYearDebitTotal = BigDecimal.ZERO;
                        if (row.getInteger("periodnumber") == 1 && periodNumber != 12) {
                            dataList.add(this.getObjectRow(row.getDate("begindate"), balance, ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), 1));
                        }
                    }
                }
                if (periodNumber != row.getInteger("periodnumber")) {
                    pair = this.isReset(row.getDate("begindate"), balance);
                    if (((Boolean)pair.getLeft()).booleanValue() && !param.getBeginBalanceMap().containsKey(this.resetFormatDate(row.getDate("begindate")))) {
                        log.info("\u53d1\u751f\u521d\u59cb\u4f59\u989d\u91cd\u7f6e\uff0cparamMap\uff1a{}\uff0cbegindate\uff1a{}", (Object)param.getBeginBalanceMap(), (Object)row.getDate("begindate"));
                        param.getBeginBalanceMap().put(this.resetFormatDate(row.getDate("begindate")), pair.getRight());
                        balance = (BigDecimal)pair.getRight();
                    }
                    dataList.add(this.getObjectRow(row.getDate("begindate"), balance, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), 2, (Boolean)pair.getLeft() != false ? "7" : ""));
                    tmpPeriodDebitTotal = BigDecimal.ZERO;
                    tmpPeriodCreditTotal = BigDecimal.ZERO;
                }
                bookDate = row.getDate("bookdate");
                endDate = row.getDate("enddate");
                if (periodId != row.getLong("periodid")) {
                    periodNumber = row.getInteger("periodnumber");
                    periodYear = row.getInteger("year");
                    periodId = row.getLong("periodid");
                    period = PeriodHelper.getPeriodById((long)periodId);
                }
                balance = balance.add(row.getBigDecimal("balance"));
            }
            if (param.isShowDayTotal()) {
                dataList.add(this.getObjectRow(bookDate, balance, ResManager.loadKDString((String)"\u672c\u65e5\u5408\u8ba1", (String)"JournalBaseListDataRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), 4, tmpDayCreditTotal, tmpDayDebitTotal));
            }
            if (param.isShowPeriodTotal()) {
                tmpPeriodCreditTotal = tmpPeriodCreditTotal.add(tmpDayCreditTotal);
                tmpPeriodDebitTotal = tmpPeriodDebitTotal.add(tmpDayDebitTotal);
                dataList.add(this.getObjectRow(endDate, balance, ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"JournalBaseListDataRpt_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), 5, tmpPeriodCreditTotal, tmpPeriodDebitTotal));
            }
            if (param.isShowYearTotal()) {
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpPeriodCreditTotal);
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpPeriodDebitTotal);
                dataList.add(this.getObjectRow(endDate, balance, ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"JournalBaseListDataRpt_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), 6, tmpYearCreditTotal, tmpYearDebitTotal));
                tmpPeriodCreditTotal = BigDecimal.ZERO;
                tmpPeriodDebitTotal = BigDecimal.ZERO;
                temNextPeriodInfo = PeriodHelper.getNextPeriod((long)periodId);
                if (temNextPeriodInfo == null) {
                    return Algo.create((String)"cas.cashjournal.total").createDataSet(dataList, this.getRowMeta());
                }
                if (!PeriodHelper.after((DynamicObject)temNextPeriodInfo, (DynamicObject)param.getEndPeriod()) && periodYear < temNextPeriodInfo.getInt("periodyear")) {
                    dataList.add(this.getObjectRow(temNextPeriodInfo.getDate("begindate"), balance, ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"JournalBaseListDataRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), 1));
                    tmpYearDebitTotal = BigDecimal.ZERO;
                    tmpYearCreditTotal = BigDecimal.ZERO;
                }
            }
            if (PeriodHelper.before((DynamicObject)period, (DynamicObject)param.getEndPeriod())) {
                this.addRow4NoData(param, dataList, PeriodHelper.getNextPeriod((long)period.getLong("id")), param.getEndPeriod(), tmpPeriodCreditTotal, tmpPeriodDebitTotal, balance, tmpYearCreditTotal, tmpYearDebitTotal);
            }
        }
        if (param.getDateType() == 2) {
            if (dataList.size() > 0) {
                Object[] obj = (Object[])dataList.get(0);
                if (new JournalModel().DESC_YEARBEGINBALANCE().equals(obj[3])) {
                    obj[1] = param.getBeginDate();
                    Object[] obj1 = (Object[])dataList.get(1);
                    obj1[1] = param.getBeginDate();
                    obj1[3] = new JournalModel().DESC_DAYBEGINBALANCE();
                } else {
                    obj[1] = param.getBeginDate();
                    obj[3] = new JournalModel().DESC_DAYBEGINBALANCE();
                }
            }
            if (param.getEndPeriod().getDate("enddate").after(param.getEndDate()) && dataList.size() >= 2) {
                Object[] objYearTotal = (Object[])dataList.get(dataList.size() - 1);
                Object[] objPeriodTotal = (Object[])dataList.get(dataList.size() - 2);
                objYearTotal[1] = param.getEndDate();
                objPeriodTotal[1] = param.getEndDate();
            }
        }
        return Algo.create((String)"cas.cashjournal.total").createDataSet(dataList, this.getRowMeta());
    }

    private String resetFormatDate(Date begindate) {
        return DateUtils.formatString((Date)begindate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private Pair<Boolean, BigDecimal> isReset(Date begindate, BigDecimal balance) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.resetInitBalanceData)) {
            for (DynamicObject resetInitBalance : this.resetInitBalanceData) {
                Date resetDate = resetInitBalance.getDate("resetinitbalperiod.begindate");
                if (!org.apache.commons.lang.time.DateUtils.isSameDay((Date)resetDate, (Date)begindate)) continue;
                balance = resetInitBalance.getBigDecimal("entryentity.initbalance");
                return Pair.of((Object)true, (Object)balance);
            }
        }
        return Pair.of((Object)false, (Object)balance);
    }

    private DataSet handleDataSetForOpenOrg(JournalParam param, DataSet totalDataSet) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        BigDecimal balance = param.getBeginBalance();
        BigDecimal tmpDayDebitTotal = BigDecimal.ZERO;
        BigDecimal tmpDayCreditTotal = BigDecimal.ZERO;
        Iterator it = totalDataSet.iterator();
        if (!it.hasNext()) {
            this.addRow4NoData(param, dataList, param.getBeginPeriod(), param.getEndPeriod(), BigDecimal.ZERO, BigDecimal.ZERO, balance, BigDecimal.ZERO, BigDecimal.ZERO);
        } else {
            Row row = (Row)it.next();
            Date bookDate = row.getDate("bookdate");
            dataList.add(this.getObjectRow(param.getBeginDate(), balance, new JournalModel().DESC_DAYBEGINBALANCE(), 2));
            balance = balance.add(row.getBigDecimal("balance"));
            tmpDayDebitTotal = tmpDayDebitTotal.add(row.getBigDecimal("debitamount"));
            tmpDayCreditTotal = tmpDayCreditTotal.add(row.getBigDecimal("creditamount"));
            while (it.hasNext()) {
                row = (Row)it.next();
                if (org.apache.commons.lang.time.DateUtils.isSameDay((Date)bookDate, (Date)row.getDate("bookdate"))) {
                    tmpDayDebitTotal = tmpDayDebitTotal.add(row.getBigDecimal("debitamount"));
                    tmpDayCreditTotal = tmpDayCreditTotal.add(row.getBigDecimal("creditamount"));
                } else {
                    if (param.isShowDayTotal()) {
                        dataList.add(this.getObjectRow(bookDate, balance, ResManager.loadKDString((String)"\u672c\u65e5\u5408\u8ba1", (String)"JournalBaseListDataRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), 4, tmpDayCreditTotal, tmpDayDebitTotal));
                    }
                    tmpDayDebitTotal = row.getBigDecimal("debitamount");
                    tmpDayCreditTotal = row.getBigDecimal("creditamount");
                }
                bookDate = row.getDate("bookdate");
                balance = balance.add(row.getBigDecimal("balance"));
            }
            if (param.isShowDayTotal()) {
                dataList.add(this.getObjectRow(bookDate, balance, ResManager.loadKDString((String)"\u672c\u65e5\u5408\u8ba1", (String)"JournalBaseListDataRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), 4, tmpDayCreditTotal, tmpDayDebitTotal));
            }
        }
        return Algo.create((String)"cas.cashjournal.total").createDataSet(dataList, this.getRowMeta());
    }

    private BigDecimal addRow4NoData(JournalParam param, List<Object[]> dataList, DynamicObject beginPeriod, DynamicObject endPeriod, BigDecimal tmpPeriodCreditTotal, BigDecimal tmpPeriodDebitTotal, BigDecimal balance, BigDecimal tmpYearCreditTotal, BigDecimal tmpYearDebitTotal) {
        if (beginPeriod == null || endPeriod == null) {
            return balance;
        }
        DynamicObject temPeriodInfo = beginPeriod;
        DynamicObject temNextPeriodInfo = null;
        JournalModel journalModel = new JournalModel();
        while (temPeriodInfo.getInt("periodyear") < endPeriod.getInt("periodyear") || temPeriodInfo.getInt("periodyear") == endPeriod.getInt("periodyear") && endPeriod.getInt("periodnumber") >= temPeriodInfo.getInt("periodnumber")) {
            if (param.isShowBeginBalance()) {
                Pair<Boolean, BigDecimal> pair = this.isReset(temPeriodInfo.getDate("begindate"), balance);
                if (((Boolean)pair.getLeft()).booleanValue() && !param.getBeginBalanceMap().containsKey(this.resetFormatDate(temPeriodInfo.getDate("begindate")))) {
                    param.getBeginBalanceMap().put(this.resetFormatDate(temPeriodInfo.getDate("begindate")), pair.getRight());
                    balance = (BigDecimal)pair.getRight();
                }
                dataList.add(this.getObjectRow(temPeriodInfo.getDate("begindate"), balance, journalModel.DESC_BEGINBALANCE(), 2, (Boolean)pair.getLeft() != false ? "7" : ""));
            }
            if (param.isShowPeriodTotal()) {
                dataList.add(this.getObjectRow(temPeriodInfo.getDate("enddate"), balance, journalModel.DESC_PERIODTOTAL(), 5, tmpPeriodCreditTotal, tmpPeriodDebitTotal));
                tmpPeriodCreditTotal = BigDecimal.ZERO;
                tmpPeriodDebitTotal = BigDecimal.ZERO;
            }
            if (param.isShowYearTotal()) {
                dataList.add(this.getObjectRow(temPeriodInfo.getDate("enddate"), balance, journalModel.DESC_YEARTOTAL(), 6, tmpYearCreditTotal, tmpYearDebitTotal));
            }
            if ((temNextPeriodInfo = PeriodHelper.getNextPeriod((long)temPeriodInfo.getLong("id"))) == null) {
                return balance;
            }
            if (!PeriodHelper.after((DynamicObject)temNextPeriodInfo, (DynamicObject)endPeriod) && temPeriodInfo.getInt("periodyear") < temNextPeriodInfo.getInt("periodyear")) {
                dataList.add(this.getObjectRow(temNextPeriodInfo.getDate("begindate"), balance, journalModel.DESC_YEARBEGINBALANCE(), 1));
                tmpYearCreditTotal = BigDecimal.ZERO;
                tmpYearDebitTotal = BigDecimal.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
        return balance;
    }

    protected Object[] getObjectRow(Date bookdate, BigDecimal balance, String desc, int dataType) {
        return this.getObjectRow(bookdate, balance, desc, dataType, null, null, "");
    }

    protected Object[] getObjectRow(Date bookdate, BigDecimal balance, String desc, int dataType, String source) {
        return this.getObjectRow(bookdate, balance, desc, dataType, null, null, source);
    }

    protected Object[] getObjectRow(Date bookdate, BigDecimal balance, String desc, int dataType, BigDecimal totalCredit, BigDecimal totalDedit) {
        return this.getObjectRow(bookdate, balance, desc, dataType, totalCredit, totalDedit, "");
    }

    protected Object[] getObjectRow(Date bookdate, BigDecimal balance, String desc, int dataType, BigDecimal totalCredit, BigDecimal totalDedit, String source) {
        Field[] fields = this.getRowMeta().getFields();
        Object[] rowData = new Object[fields.length];
        int direction = this.getDirection(balance);
        block28: for (int i = 0; i < fields.length; ++i) {
            String name;
            switch (name = fields[i].getName()) {
                case "bookdate": {
                    rowData[i] = bookdate;
                    continue block28;
                }
                case "actualbalance": {
                    rowData[i] = balance;
                    continue block28;
                }
                case "description": {
                    rowData[i] = desc;
                    continue block28;
                }
                case "debitamount": {
                    rowData[i] = totalDedit;
                    continue block28;
                }
                case "creditamount": {
                    rowData[i] = totalCredit;
                    continue block28;
                }
                case "datatype": {
                    rowData[i] = dataType;
                    continue block28;
                }
                case "source": {
                    rowData[i] = source;
                    continue block28;
                }
                case "direction": {
                    rowData[i] = direction;
                    continue block28;
                }
                case "currencyfield": {
                    rowData[i] = this.param.getCurrencyid();
                    continue block28;
                }
                case "acctname": {
                    rowData[i] = this.param.getAcctname();
                    continue block28;
                }
                case "bankno": {
                    rowData[i] = this.param.getAcctid();
                    continue block28;
                }
                case "orgid": {
                    rowData[i] = this.param.getOrgid();
                    continue block28;
                }
                default: {
                    rowData[i] = null;
                }
            }
        }
        return rowData;
    }

    protected int getDirection(BigDecimal balance) {
        int result = balance.compareTo(BigDecimal.ZERO);
        int direction = result > 0 ? 1 : (result < 0 ? 2 : 3);
        return direction;
    }

    private DataSet union(DataSet d, DataSet ... ds) {
        DataSet left = null;
        if (d != null) {
            left = d;
        }
        for (DataSet rows : ds) {
            if (left == null) {
                left = rows;
                continue;
            }
            if (rows == null) continue;
            left = left.union(rows);
        }
        return left;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String selectedNodeIds = this.getSelectedObj().toString();
        String[] nodeIds = selectedNodeIds.split("%");
        ArrayList<Long> currencyIds = new ArrayList<Long>();
        for (String nodeId : nodeIds) {
            String currency = nodeId.split("-")[0];
            if ("null".equalsIgnoreCase(currency)) {
                currencyIds.add(0L);
                continue;
            }
            currencyIds.add(Long.valueOf(currency));
        }
        DynamicObjectCollection currency = QueryServiceHelper.query((String)"currency", (String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)}, null);
        if (currency.size() > 0) {
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String columnName = column.getFieldKey();
                if (!"creditamount".equals(columnName) && !"debitamount".equals(columnName) && !"actualbalance".equals(columnName)) continue;
                column.setScale(((DynamicObject)currency.get(0)).getInt("amtprecision"));
            }
        }
        return super.getColumns(columns);
    }

    private RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField();
        field.add(new Field("rowbalance", (DataType)DataType.BigDecimalType));
        field.add(new Field("beginbalance", (DataType)DataType.BigDecimalType));
        field.add(new Field("actualbalance", (DataType)DataType.BigDecimalType));
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>(20);
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("bookdate", (DataType)DataType.TimestampType));
        field.add(new Field("orgname", (DataType)DataType.StringType));
        field.add(new Field("description", (DataType)DataType.StringType));
        field.add(new Field("bizdate", (DataType)DataType.TimestampType));
        field.add(new Field("acctname", (DataType)DataType.StringType));
        field.add(new Field("sourcebilltype", (DataType)DataType.StringType));
        field.add(new Field("sourcebillid", (DataType)DataType.LongType));
        field.add(new Field("sourcebillnumber", (DataType)DataType.StringType));
        field.add(new Field("debitamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("creditamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("direction", (DataType)DataType.StringType));
        field.add(new Field("balance", (DataType)DataType.BigDecimalType));
        field.add(new Field("cashier", (DataType)DataType.StringType));
        field.add(new Field("source", (DataType)DataType.StringType));
        field.add(new Field("datatype", (DataType)DataType.IntegerType));
        field.add(new Field("currencyfield", (DataType)DataType.LongType));
        field.add(new Field("oppunit", (DataType)DataType.StringType));
        field.add(new Field("oppacctnumber", (DataType)DataType.StringType));
        field.add(new Field("fee", (DataType)DataType.BigDecimalType));
        field.add(new Field("rptype", (DataType)DataType.StringType));
        field.add(new Field("orgid", (DataType)DataType.LongType));
        return field;
    }

    protected String getQueryFiled(JournalParam param) {
        String queryFields = "id,bookdate,tracedate,org.name as orgname,description,bizdate," + param.getAcctPropertyName() + ".name as acctname,sourcebilltype,sourcebillid,sourcebillnumber,cashier.name as cashier,creditamount,debitamount,direction,debitamount-creditamount as balance,source,period.begindate as begindate,period.enddate as enddate,period.periodyear as year,period.id as periodid,period.periodnumber as periodnumber,currency as currencyfield,oppunit,oppacctnumber,fee,rpbasetype, rptype.id as rptypeid, org.id as orgid ";
        return queryFields;
    }

    private String[] getSelectedField() {
        return this.getShowFields().toArray(new String[0]);
    }

    protected List<String> getShowFields() {
        ArrayList<String> showFields = new ArrayList<String>(20);
        showFields.add("id");
        showFields.add("bookdate");
        showFields.add("orgname");
        showFields.add("description");
        showFields.add("bizdate");
        showFields.add("acctname");
        showFields.add("sourcebilltype");
        showFields.add("sourcebillid");
        showFields.add("sourcebillnumber");
        showFields.add("debitamount");
        showFields.add("creditamount");
        showFields.add("direction");
        showFields.add("balance");
        showFields.add("cashier");
        showFields.add("source");
        showFields.add("3 as datatype");
        showFields.add("currencyfield");
        showFields.add("oppunit");
        showFields.add("oppacctnumber");
        showFields.add("fee");
        showFields.add("rptype");
        showFields.add("orgid");
        return showFields;
    }

    private DynamicObjectCollection queryResetInitBalanceData(JournalParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (param.getQueryOrgType() != null && "org".equals(param.getQueryOrgType())) {
            filters.add(new QFilter("org", "=", (Object)param.getOrgid()));
        }
        if (param.getCurrencyid() != 0L) {
            filters.add(new QFilter("entryentity.currency", "=", (Object)param.getCurrencyid()));
        }
        if (param.getAcctid() != 0L) {
            filters.add(new QFilter("accountbank".equals(this.acctPropertyName) ? "entryentity.bank_accountbank" : "entryentity.cash_accountcash", "=", (Object)param.getAcctid()));
        }
        if (param.getDateType() == 1 && param.getBeginPeriod() != null & param.getEndPeriod() != null) {
            filters.add(new QFilter("resetinitbalperiod.begindate", ">=", (Object)param.getBeginPeriod().getDate("begindate")).and(new QFilter("resetinitbalperiod.begindate", "<=", (Object)param.getEndPeriod().getDate("enddate"))));
        } else if (param.getBeginDate() != null && param.getEndDate() != null) {
            filters.add(new QFilter("resetinitbalperiod.begindate", ">=", (Object)param.getBeginDate()).and(new QFilter("resetinitbalperiod.begindate", "<=", (Object)param.getEndDate())));
        }
        return QueryServiceHelper.query((String)"cas_resetinitbalance", (String)"id,resetinitbalperiod.begindate,entryentity.initbalance", (QFilter[])filters.toArray(new QFilter[0]), (String)"modifytime desc");
    }

    public QFilter[] getQFilter(JournalParam param) {
        String filterAmtType = param.getFilterAmtType();
        String filterType = param.getFilterType();
        BigDecimal amt = param.getAmt();
        QFilter amtFilter = null;
        if (!StringUtils.isEmpty((CharSequence)filterAmtType) && !StringUtils.isEmpty((CharSequence)filterType) && amt != null) {
            amtFilter = new QFilter(filterAmtType, filterType, (Object)amt);
            if (BigDecimal.ZERO.compareTo(amt) != 0 && !filterType.equals("=")) {
                amtFilter = amtFilter.and(new QFilter(filterAmtType, ">", (Object)BigDecimal.ZERO));
            }
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (param.getQueryOrgType() != null && "org".equals(param.getQueryOrgType())) {
            filters.add(new QFilter("org", "=", (Object)param.getOrgid()));
        }
        if (param.getCurrencyid() != 0L) {
            filters.add(new QFilter("currency", "=", (Object)param.getCurrencyid()));
        }
        if (param.getAcctid() != 0L) {
            filters.add(new QFilter(this.acctPropertyName, "=", (Object)param.getAcctid()));
        }
        if (param.getDateType() == 1 && param.getBeginPeriod() != null & param.getEndPeriod() != null) {
            filters.add(new QFilter("bookdate", ">=", (Object)param.getBeginPeriod().getDate("begindate")).and(new QFilter("bookdate", "<=", (Object)param.getEndPeriod().getDate("enddate"))));
        } else if (param.getBeginDate() != null && param.getEndDate() != null) {
            filters.add(new QFilter("bookdate", ">=", (Object)param.getBeginDate()).and(new QFilter("bookdate", "<=", (Object)param.getEndDate())));
        }
        if (amtFilter != null) {
            filters.add(amtFilter);
        }
        filters.add(param.getJournalFilter());
        filters.add(new QFilter("period", "!=", (Object)0L));
        return filters.toArray(new QFilter[0]);
    }

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }
}

