/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.fi.cas.formplugin.journalprintall.JournalPrintHelper;
import kd.fi.cas.helper.PeriodHelper;

public abstract class JournalBaseTreeRpt
extends AbstractReportTreeDataPlugin {
    protected String orgControlName;
    protected DynamicObjectCollection orgColl;
    protected DynamicObjectCollection acctColl;
    protected DynamicObjectCollection currencyColl;
    protected boolean isContainClosed;
    protected Map<Long, Set<Long>> acctAuthOrgs;
    protected String showType = "2";
    protected Date endDate = null;
    protected Date beginDate = null;

    public List<TreeNode> query(ReportQueryParam arg0, String arg1) throws Throwable {
        FilterInfo filterInfo = arg0.getFilter();
        this.orgColl = filterInfo.getDynamicObjectCollection(this.orgControlName);
        if (this.orgColl == null) {
            return new ArrayList<TreeNode>(10);
        }
        int type = filterInfo.getInt("datetype");
        if (this.orgColl.size() > 1 && type == 1) {
            DynamicObject periodType = filterInfo.getDynamicObject("periodtype");
            if (periodType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"JournalBaseTreeRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            for (int i = this.orgColl.size() - 1; i >= 0; --i) {
                DynamicObject org = (DynamicObject)this.orgColl.get(i);
                long orgId = (Long)org.getPkValue();
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                if (periodTypeId == periodType.getLong("id")) continue;
                this.orgColl.remove(i);
            }
        }
        if (type == 1) {
            DynamicObject beginPeriodDo = filterInfo.getDynamicObject("beginperiod");
            DynamicObject endPeriodDo = filterInfo.getDynamicObject("endperiod");
            if (beginPeriodDo != null) {
                this.beginDate = beginPeriodDo.getDate("begindate");
            }
            if (endPeriodDo != null) {
                this.endDate = endPeriodDo.getDate("enddate");
            }
        } else {
            this.endDate = filterInfo.getDate("enddate");
            this.beginDate = filterInfo.getDate("begindate");
        }
        this.currencyColl = filterInfo.getDynamicObjectCollection("currency");
        this.isContainClosed = filterInfo.getBoolean("iscontainclosed");
        DynamicObjectCollection acctPlainColl = this.getAcctPlainColl();
        ArrayList<TreeNode> rootNodeList = new ArrayList<TreeNode>(this.orgColl.size());
        for (int i = 0; i < this.orgColl.size(); ++i) {
            DynamicObject org = (DynamicObject)this.orgColl.get(i);
            TreeNode node = new TreeNode();
            node.setId(org.getString("id"));
            node.setText(org.getString("name"));
            node.setIsOpened(true);
            rootNodeList.add(node);
            boolean orgNodeHasChild = false;
            for (int j = 0; j < acctPlainColl.size(); ++j) {
                TreeNode nodeChild;
                DynamicObject acct = (DynamicObject)acctPlainColl.get(j);
                if (!this.isAuthOrg(acct, org.getLong("id"))) continue;
                orgNodeHasChild = true;
                if (this.currencyColl != null) {
                    if (!this.isContains(this.currencyColl, acct.getLong("currencyid"))) continue;
                    nodeChild = this.getOneNodeChild(acct, org.getString("id"));
                    rootNodeList.add(nodeChild);
                    continue;
                }
                nodeChild = this.getOneNodeChild(acct, org.getString("id"));
                rootNodeList.add(nodeChild);
            }
            if (orgNodeHasChild) continue;
            rootNodeList.remove(node);
        }
        if (rootNodeList.size() <= 0) {
            DynamicObject org = (DynamicObject)this.orgColl.get(0);
            TreeNode node = new TreeNode();
            node.setId(org.getString("id"));
            node.setText(org.getString("name"));
            node.setIsOpened(true);
            rootNodeList.add(node);
        }
        JournalPrintHelper.cacheLeftNodes(rootNodeList, arg0);
        return rootNodeList;
    }

    private TreeNode getOneNodeChild(DynamicObject acct, String orgId) {
        TreeNode nodeChild = new TreeNode();
        nodeChild.setId(acct.getString("currencyid") + "-" + acct.getString("id") + "-" + orgId + "-" + acct.getString("acctname"));
        if ("1".equalsIgnoreCase(this.showType)) {
            nodeChild.setText(acct.getString("acctname") + " " + acct.getString("currencyname"));
        } else {
            nodeChild.setText(acct.getString("acctnumber") + " " + acct.getString("currencyname"));
        }
        nodeChild.setParentid(orgId);
        return nodeChild;
    }

    public abstract DynamicObjectCollection getAcctPlainColl();

    protected boolean isContains(DynamicObjectCollection coll, long id) {
        boolean flag = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject object = (DynamicObject)coll.get(i);
            if (object.getLong("id") != id) continue;
            flag = true;
            break;
        }
        return flag;
    }

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    protected boolean isAuthOrg(DynamicObject acct, long orgId) {
        return acct.getLong("orgid") == orgId;
    }
}

