/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.ManualJournalHelper;
import kd.fi.cas.helper.RecDecInitHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;

public class ManualJournalImportPlugin
implements IImportPlugin {
    private Log logger = LogFactory.getLog(ManualJournalImportPlugin.class);
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>(2);
    private List<Long> importDataIds = new ArrayList<Long>();
    private String importType = "";
    protected String accountName = "accountbank";

    private boolean isBankJournal() {
        return "accountbank".equals(this.accountName);
    }

    private String getAccountEntity() {
        return this.isBankJournal() ? "bd_accountbanks" : "cas_accountcash";
    }

    public String getMainEntity() {
        return this.isBankJournal() ? "cas_bankjournal" : "cas_cashjournal";
    }

    private String getBillType() {
        return this.isBankJournal() ? "cas_manualbankjournal" : "cas_manualcashjournal";
    }

    private boolean checkDecimalFormat(BigDecimal decimal, String fieldName) {
        String plainString = decimal.toPlainString();
        String[] split = plainString.split("\\.");
        String msg = null;
        if (split.length == 1 && split[0].length() > 13) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u91d1\u989d\u683c\u5f0f\uff08\u793a\u4f8b\uff1a10.34\uff09\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ManualJournalImportPlugin_42", (String)"fi-cas-formplugin", (Object[])new Object[0]), fieldName);
            throw new KDBizException(msg);
        }
        if (split.length == 2 && split[1].length() > 2) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u91d1\u989d\u683c\u5f0f\uff08\u793a\u4f8b\uff1a10.34\uff09\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ManualJournalImportPlugin_42", (String)"fi-cas-formplugin", (Object[])new Object[0]), fieldName);
            throw new KDBizException(msg);
        }
        return false;
    }

    public void checkNull(Map<String, Object> data, String key, String title) throws Exception {
        Object value = data.get(key);
        if (value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"ManualJournalImportPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), title));
        }
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String msg = null;
        try {
            Date bookDate;
            HashMap orgMap;
            Object orgNumber;
            Object accountnumber;
            DynamicObject existDy;
            this.importType = (String)option.get("importtype");
            QFilter qFilter = new QFilter("billno", "=", data.get("billno"));
            qFilter.and("sourcebilltype", "=", (Object)"cas_manualbankjournal");
            String selectFields = "id,bookdate,period,period.periodyear,period.periodnumber";
            if ("cas_bankjournal".equals(this.getMainEntity())) {
                selectFields = "id,bookdate,ischeck,period,period.periodyear,period.periodnumber";
            }
            if ((existDy = QueryServiceHelper.queryOne((String)this.getMainEntity(), (String)selectFields, (QFilter[])qFilter.toArray())) != null && "cas_bankjournal".equals(this.getMainEntity()) && !"new".equals(this.importType) && existDy.getBoolean("ischeck")) {
                msg = String.format(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5df2\u52fe\u5bf9\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"ManualJournalImportPlugin_44", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(msg);
            }
            this.checkNull(data, this.accountName, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"ManualJournalImportPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            HashMap acctMap = (HashMap)JSONUtils.cast((String)data.get(this.accountName).toString(), HashMap.class);
            Object v = accountnumber = this.isBankJournal() ? acctMap.get("bankaccountnumber") : acctMap.get("number");
            if (accountnumber == null) {
                msg = ResManager.loadKDString((String)"\u8be5\u201c\u94f6\u884c\u8d26\u6237\u201d\u4e0d\u5b58\u5728\u3002", (String)"ManualJournalImportPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            QFilter acctFilter = new QFilter("number", "=", accountnumber);
            String selectProperties = this.isBankJournal() ? "id,currency,company,createorg,openorg,isvirtual,bankaccountnumber" : "id,currency,org";
            DynamicObject acct = BusinessDataServiceHelper.loadSingle((String)this.getAccountEntity(), (String)selectProperties, (QFilter[])new QFilter[]{acctFilter});
            if (acct == null) {
                msg = ResManager.loadKDString((String)"\u8be5\u201c\u94f6\u884c\u8d26\u6237\u201d\u4e0d\u5b58\u5728\u3002", (String)"ManualJournalImportPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            this.checkNull(data, "currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ManualJournalImportPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            HashMap currencyMap = (HashMap)JSONUtils.cast((String)data.get("currency").toString(), HashMap.class);
            if (currencyMap.get("number") == null) {
                msg = ResManager.loadKDString((String)"\u8be5\u201c\u5e01\u79cd\u201d\u4e0d\u5b58\u5728\u3002", (String)"ManualJournalImportPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            DynamicObjectCollection currencys = acct.getDynamicObjectCollection("currency");
            if (currencys == null || currencys.isEmpty()) {
                msg = ResManager.loadKDString((String)"\u8be5\u201c\u5e01\u79cd\u201d\u4e0d\u5b58\u5728\u3002", (String)"ManualJournalImportPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            boolean isExist = false;
            for (DynamicObject currency : currencys) {
                if (!currency.getDynamicObject(1).getString("number").equals(currencyMap.get("number"))) continue;
                isExist = true;
            }
            if (!isExist) {
                msg = ResManager.loadKDString((String)"\u201c\u94f6\u884c\u8d26\u6237\u201d\u4e2d\u4e0d\u5b58\u5728\u8be5\u5e01\u79cd\u3002", (String)"ManualJournalImportPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            if (this.isBankJournal()) {
                this.checkNull(data, "org", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ManualJournalImportPlugin_36", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                boolean isVirtual = acct.getBoolean("isvirtual");
                if (isVirtual) {
                    String bankNumber = acct.getString("bankaccountnumber");
                    msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8be5\u201c\u94f6\u884c\u8d26\u6237\u201d\u4e3a\u865a\u62df\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ManualJournalImportPlugin_43", (String)"fi-cas-formplugin", (Object[])new Object[0]), bankNumber);
                    throw new KDBizException(msg);
                }
            }
            Object orgPk = null;
            DynamicObject org = null;
            if (this.isBankJournal() && data.get("org") != null && (orgNumber = (orgMap = (HashMap)JSONUtils.cast((String)data.get("org").toString(), HashMap.class)).get("number")) != null) {
                boolean parameterBoolean;
                QFilter orgFilter = new QFilter("number", "=", orgNumber);
                org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgFilter});
                if (org == null) {
                    msg = ResManager.loadKDString((String)"\u8be5\u201c\u7ec4\u7ec7\u201d\u4e0d\u5b58\u5728\u3002", (String)"ManualJournalImportPlugin_37", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                boolean isManualJournal = SystemParameterHelper.isManualJournal((long)org.getLong("id"));
                boolean isVoucherMixBookJournal = SystemParameterHelper.isVoucherMixBookJournal((long)org.getLong("id"));
                boolean isTradeMixHandJournal = SystemParameterHelper.isTradeMixHandJournal((long)org.getLong("id"));
                if (!(isManualJournal || isVoucherMixBookJournal || isTradeMixHandJournal)) {
                    msg = ResManager.loadKDString((String)"\u8be5\u201c\u7ec4\u7ec7\u201d\u4e0d\u652f\u6301\u624b\u5de5\u767b\u8d26\u3002", (String)"ManualJournalImportPlugin_38", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                orgPk = org.get("id");
                if (!AccountBankHelper.canUseAccount((long)Long.parseLong(String.valueOf(orgPk)), (long)acct.getLong("id"))) {
                    msg = ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u201d\u6ca1\u6709\u8d26\u6237\u4f7f\u7528\u6743\u9650\u3002", (String)"ManualJournalImportPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
                DynamicObject init = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"currentperiod.periodyear,currentperiod.periodnumber", (QFilter[])new QFilter[]{filter});
                if (!(CasHelper.isEmpty((Object)init) || CasHelper.isEmpty((Object)existDy) || "new".equals(this.importType))) {
                    boolean isBefore;
                    boolean bl = isBefore = init.getInt("currentperiod.periodyear") < existDy.getInt("period.periodyear") || init.getInt("currentperiod.periodyear") == existDy.getInt("period.periodyear") && init.getInt("currentperiod.periodnumber") < existDy.getInt("period.periodnumber");
                    if (isBefore) {
                        msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"ManualJournalFromPlugin_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]);
                        throw new KDBizException(msg);
                    }
                }
                if (!((parameterBoolean = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"cs095")) || CasHelper.isEmpty((Object)existDy) || "new".equals(this.importType))) {
                    Date date;
                    Date bookDate2;
                    QFilter currencyFilter = new QFilter("number", "=", currencyMap.get("number"));
                    DynamicObject currencyDo = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{currencyFilter});
                    DynamicObject balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust((Long)org.getLong("id"), (Long)acct.getLong("id"), (Long)currencyDo.getLong("id"));
                    if (balanceAdust != null && (BillStatusEnum.AUDIT.getValue().equals(balanceAdust.getString("billstatus")) || BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus"))) && (bookDate2 = existDy.getDate("bookdate")) != null && (date = balanceAdust.getDate("bizdate")).after(bookDate2)) {
                        String billSatus = BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus")) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"ManualJournalFromPlugin_0", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ManualJournalFromPlugin_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        msg = String.format(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5df2\u751f\u6210\u201c%1$s\u201d\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868\u201c%2$s\u201d\u3002", (String)"ManualJournalFromPlugin_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), billSatus, balanceAdust.getString("billno"));
                        throw new KDBizException(msg);
                    }
                }
            }
            QFilter currencyFilter = new QFilter("number", "=", currencyMap.get("number"));
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{currencyFilter});
            List entryList = (List)JSONUtils.cast((String)data.get("manualentry").toString(), List.class);
            if (Utils.isListEmpty((List)entryList)) {
                msg = ResManager.loadKDString((String)"\u5206\u5f55\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"ManualJournalImportPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            LinkedHashMap entry = (LinkedHashMap)entryList.get(0);
            if (!this.dateFormatValidate(entry.get("bizdate"))) {
                msg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u65e5\u671f\u201d\u5bfc\u5165\u4e0d\u6210\u529f\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u683c\u5f0f\u7684\u65e5\u671f\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ManualJournalImportPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            if (!this.dateFormatValidate(entry.get("bookdate"))) {
                msg = ResManager.loadKDString((String)"\u201c\u8bb0\u8d26\u65e5\u671f\u201d\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u8bf7\u586b\u5199\u6b63\u786e\u683c\u5f0f\u7684\u65e5\u671f\uff08\u793a\u4f8b\uff1a2020-01-01\uff0c\u65e5\u671f\u683c\u5f0f\uff09\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ManualJournalImportPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            Date bizDate = this.getDateBy(entry.get("bizdate"));
            msg = ManualJournalHelper.checkDate((Date)bizDate, (Date)(bookDate = this.getDateBy(entry.get("bookdate"))));
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                return false;
            }
            BigDecimal debit = this.getAmountBy(entry.get("debitamount"));
            BigDecimal credit = this.getAmountBy(entry.get("creditamount"));
            this.checkDecimalFormat(debit, ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"ManualJournalImportPlugin_40", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.checkDecimalFormat(credit, ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"ManualJournalImportPlugin_41", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            int code = ManualJournalHelper.checkAmount((BigDecimal)debit, (BigDecimal)credit);
            if (code == -1) {
                msg = ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"ManualJournalImportPlugin_30", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            if (code == -2) {
                msg = ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u548c\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u3002", (String)"ManualJournalImportPlugin_31", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            msg = this.checkRpBase(entry);
            if (EmptyUtil.isNoEmpty((String)msg)) {
                throw new KDBizException(msg);
            }
            Date startperiodDate = null;
            Date currentperiodDate = null;
            if (orgPk == null) {
                org = this.isBankJournal() ? acct.getDynamicObject("createorg") : acct.getDynamicObject("org");
                orgPk = org.getPkValue();
            }
            HashMap<String, Object> orgMap2 = new HashMap<String, Object>(10);
            orgMap2.put("id", orgPk);
            data.put("orgid", orgMap2);
            if (SystemStatusCtrolHelper.isInitEnable((long)((Long)orgPk))) {
                BigDecimal exchangeRate;
                Object exchangerate;
                DynamicObject init = SystemStatusCtrolHelper.getSystemStatusCtrol((long)((Long)orgPk));
                startperiodDate = init.getDate("startperiod.begindate");
                DynamicObject currentperiod = init.getDynamicObject("currentperiod");
                if (currentperiod != null) {
                    currentperiodDate = currentperiod.getDate("begindate");
                }
                DynamicObject basecurrency = init.getDynamicObject("standardcurrency");
                DynamicObject exratetable = init.getDynamicObject("exratetable");
                if (currency != null && basecurrency != null && currency.getLong("id") != basecurrency.getLong("id") && (exchangerate = entry.get("exchangerate")) == null && (exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)currency.getLong("id"), (Long)basecurrency.getLong("id"), (Long)((Long)orgPk), (Date)bizDate, (Long)exratetable.getLong("id"))) == null) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5f53\u524d\u65e5\u671f\u7684\u6c47\u7387\u3002", (String)"ManualJournalImportPlugin_33", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
            } else {
                throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
            }
            if (startperiodDate != null && bookDate != null && bookDate.before(startperiodDate)) {
                msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u7ec4\u7ec7\u521d\u59cb\u5316\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u8bb0\u8d26\u3002", (String)"ManualJournalImportPlugin_32", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            if (currentperiodDate != null && bookDate != null && bookDate.before(currentperiodDate)) {
                msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u8d77\u59cb\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u8bb0\u8d26\u3002", (String)"ManualJournalImportPlugin_34", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            long orgid = this.isBankJournal() ? acct.getDynamicObject("createorg").getLong("id") : acct.getDynamicObject("org").getLong("id");
            Date balanceDate = null;
            String billNo = "";
            boolean parameterBoolean = SystemParameterHelper.getParameterBoolean((long)orgid, (String)"cs095");
            if (!parameterBoolean) {
                DynamicObject balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust((Long)orgid, (Long)acct.getLong("id"), (Long)currency.getLong("id"));
                if (balanceAdust != null && (BillStatusEnum.AUDIT.getValue().equals(balanceAdust.getString("billstatus")) || BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus")))) {
                    balanceDate = balanceAdust.getDate("bizdate");
                    billNo = balanceAdust.getString("billno");
                }
                if (balanceDate != null && balanceDate.compareTo(bookDate) > 0) {
                    msg = String.format(String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e4b\u540e\u5df2\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868[%s]\u3002", (String)"ManualJournalImportPlugin_35", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo), new Object[0]);
                    throw new KDBizException(msg);
                }
            }
            this.importDataList.add(data);
            return true;
        }
        catch (Exception exc) {
            this.throwException(exc, importlogs);
            return false;
        }
    }

    private String checkRpBase(Map<String, Object> entry) {
        Map map;
        Object rpBaseType = entry.get("rpbasetype");
        Object rpType = entry.get("rptype");
        if (EmptyUtil.isEmpty((Object)rpType) && EmptyUtil.isEmpty((Object)rpBaseType)) {
            return null;
        }
        if (this.checkRpBaseType(entry)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u7684\u501f\u65b9/\u8d37\u65b9\u91d1\u989d\u4e0e\u5bf9\u5e94\u7684\u6536\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManualJournalImportPlugin_45", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isNoEmpty((Object)rpType) && EmptyUtil.isEmpty((Object)rpBaseType)) {
            return ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5b57\u6bb5\u201c\u6536/\u4ed8\u6b3e\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualJournalImportPlugin_46", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isNoEmpty((Object)rpBaseType) && (map = (Map)rpType) != null) {
            QFilter qFilter = new QFilter("number", "=", map.get("number")).and(new QFilter("status", "=", (Object)"C"));
            boolean exist = QueryServiceHelper.exists((String)String.valueOf(rpBaseType), (QFilter[])new QFilter[]{qFilter});
            if (!exist) {
                return ResManager.loadKDString((String)"\u201c\u6536/\u4ed8\u6b3e\u7c7b\u578b\u201d\u4e0b\u201c\u7f16\u7801={0}\u201d\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001\u7f16\u7801\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u3002", (String)"ManualJournalImportPlugin_47", (String)"fi-cas-formplugin", (Object[])new Object[]{map.get("number")});
            }
        }
        return null;
    }

    private boolean checkRpBaseType(Map<String, Object> entry) {
        Object rpBaseType = entry.get("rpbasetype");
        BigDecimal debit = this.getAmountBy(entry.get("debitamount"));
        BigDecimal credit = this.getAmountBy(entry.get("creditamount"));
        boolean checkRpBaseTypeResult = false;
        if (EmptyUtil.isNoEmpty((Object)rpBaseType)) {
            if (StringUtils.equals((CharSequence)((String)rpBaseType), (CharSequence)"cas_receivingbilltype")) {
                if (EmptyUtil.isNoEmpty((BigDecimal)credit)) {
                    checkRpBaseTypeResult = true;
                }
            } else if (EmptyUtil.isNoEmpty((BigDecimal)debit)) {
                checkRpBaseTypeResult = true;
            }
        }
        return checkRpBaseTypeResult;
    }

    public void throwException(Exception exc, List<ImportLogger.ImportLog> importlogs) {
        if (exc instanceof KDBizException) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
        } else {
            importlogs.add(new ImportLogger.ImportLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)exc)));
        }
    }

    private Date getDateBy(Object item) {
        if (item instanceof Date) {
            return (Date)item;
        }
        if (item instanceof String) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return sdf.parse(item.toString());
            }
            catch (ParseException e) {
                this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                return null;
            }
        }
        return null;
    }

    private BigDecimal getAmountBy(Object item) {
        if (item == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(String.valueOf(item));
    }

    public void init(Map<String, Object> importParams) {
        super.init(importParams);
    }

    public boolean resolve(Map<String, ImportLogger> urls, BiFunction<Map<String, Object>, Map<String, Object>, List<ImportLogger.ImportLog>> dataHandler) {
        return super.resolve(urls, dataHandler);
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        if (this.importDataList.size() > 0) {
            Date time = new Date();
            if (this.importDataIds.size() > 0) {
                DynamicObject[] datas;
                for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)this.getMainEntity(), (String)"id,batchno", (QFilter[])new QFilter[]{new QFilter("id", "in", this.importDataIds)})) {
                    data.set("batchno", (Object)DateUtils.formatString((Date)time, (String)"yyyyMMddhhmmss"));
                }
                SaveServiceHelper.save((DynamicObject[])datas);
            }
            for (Map<String, Object> importData : this.importDataList) {
                DynamicObject journal = null;
                if ("new".equals(this.importType)) {
                    journal = BusinessDataServiceHelper.newDynamicObject((String)this.getMainEntity());
                } else if (EmptyUtil.isNoEmpty((Object)importData.get("billno"))) {
                    QFilter qFilter = new QFilter("billno", "=", importData.get("billno"));
                    qFilter.and("sourcebilltype", "=", (Object)"cas_manualbankjournal");
                    DynamicObject existDy = BusinessDataServiceHelper.loadSingle((String)this.getMainEntity(), (QFilter[])qFilter.toArray());
                    journal = existDy != null ? existDy : BusinessDataServiceHelper.newDynamicObject((String)this.getMainEntity());
                } else {
                    journal = BusinessDataServiceHelper.newDynamicObject((String)this.getMainEntity());
                }
                this.saveInfo(journal, importData, time);
                this.importDataIds.add(journal.getLong("id"));
            }
            this.importDataList.clear();
        }
    }

    private boolean saveInfo(DynamicObject journal, Map<String, Object> dataMap, Date time) {
        HashMap orgMap = (HashMap)dataMap.get("orgid");
        Object orgId = orgMap.get("id");
        String code = (String)dataMap.get("billno");
        if (EmptyUtil.isEmpty((String)code) || "new".equals(this.importType)) {
            code = CodeRuleHelper.generateNumber((String)this.getMainEntity(), (DynamicObject)journal, (String)String.valueOf(orgId), null);
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        journal.set("createtime", (Object)time);
        journal.set("creator", (Object)userId);
        journal.set("cashier", (Object)userId);
        journal.set("source", (Object)3);
        journal.set("sourcebilltype", (Object)this.getBillType());
        journal.set("sourcebillnumber", (Object)code);
        journal.set("billno", (Object)code);
        journal.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        journal.set("modifier", (Object)userId);
        journal.set("modifytime", (Object)new Date());
        HashMap acctMap = null;
        try {
            acctMap = (HashMap)JSONUtils.cast((String)dataMap.get(this.accountName).toString(), HashMap.class);
        }
        catch (IOException e) {
            this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        if (acctMap == null) {
            return false;
        }
        Object accountnumber = this.isBankJournal() ? acctMap.get("bankaccountnumber") : acctMap.get("number");
        QFilter numberFilter = new QFilter("number", "=", accountnumber);
        String selectFields = this.isBankJournal() ? "id,number,company,currency,openorg" : "id,number,org,currency";
        DynamicObject acct = BusinessDataServiceHelper.loadSingle((String)this.getAccountEntity(), (String)selectFields, (QFilter[])new QFilter[]{numberFilter});
        DynamicObject currency = null;
        try {
            HashMap currencyMap = (HashMap)JSONUtils.cast((String)dataMap.get("currency").toString(), HashMap.class);
            QFilter currencyFilter = new QFilter("number", "=", currencyMap.get("number"));
            currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{currencyFilter});
            journal.set("currency", currency.get("id"));
        }
        catch (IOException e) {
            this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        journal.set("batchno", (Object)DateUtils.formatString((Date)time, (String)"yyyyMMddhhmmss"));
        journal.set("org", orgId);
        if (this.isBankJournal()) {
            journal.set("openorg", acct.getDynamicObject("openorg").getPkValue());
        }
        QFilter filter = new QFilter("org", "=", orgId);
        DynamicObject initOrg = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id,standardcurrency,periodtype,exratetable", (QFilter[])filter.toArray());
        List entryList = null;
        try {
            entryList = (List)JSONUtils.cast((String)dataMap.get("manualentry").toString(), List.class);
        }
        catch (IOException e) {
            this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        BigDecimal exRate = null;
        if (entryList != null && !entryList.isEmpty()) {
            BigDecimal exchangeRate;
            QFilter setFilter;
            DynamicObject setTypeItem;
            LinkedHashMap entry = (LinkedHashMap)entryList.get(0);
            LinkedHashMap settleType = (LinkedHashMap)entry.get("settlementtype");
            if (settleType != null && (setTypeItem = QueryServiceHelper.queryOne((String)"bd_settlementtype", (String)"id", (QFilter[])new QFilter[]{setFilter = new QFilter("number", "=", settleType.get("number"))})) != null) {
                journal.set("settlementtype", setTypeItem.get("id"));
            }
            BigDecimal bizRate = this.getAmountBy(entry.get("exchangerate"));
            journal.set("description", entry.get("description"));
            Date bizDate = this.getDateBy(entry.get("bizdate"));
            Date bookDate = this.getDateBy(entry.get("bookdate"));
            BigDecimal debit = this.getAmountBy(entry.get("debitamount"));
            BigDecimal credit = this.getAmountBy(entry.get("creditamount"));
            BigDecimal localAmount = BigDecimal.ZERO;
            journal.set("bizdate", (Object)bizDate);
            journal.set("bookdate", (Object)bookDate);
            journal.set("debitamount", (Object)debit);
            journal.set("creditamount", (Object)credit);
            String rpBaseType = (String)entry.get("rpbasetype");
            if (EmptyUtil.isNoEmpty((String)rpBaseType)) {
                QFilter qFilter;
                DynamicObject rpTypeItem;
                journal.set("rpbasetype", (Object)rpBaseType);
                HashMap ryType = (HashMap)entry.get("rptype");
                if (ryType != null && EmptyUtil.isNoEmpty((DynamicObject)(rpTypeItem = QueryServiceHelper.queryOne((String)rpBaseType, (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("number", "=", ryType.get("number")).and(new QFilter("status", "=", (Object)"C"))})))) {
                    journal.set("rptype", rpTypeItem.get("id"));
                }
            }
            Long exratetable = null;
            boolean diffCurr = false;
            Long basecurrency = null;
            if (initOrg != null) {
                basecurrency = (Long)initOrg.get("standardcurrency");
                if (currency != null && basecurrency != null && currency.getLong("id") != basecurrency.longValue()) {
                    diffCurr = true;
                } else {
                    exRate = BigDecimal.ONE;
                }
                Long baseCurrency = (Long)initOrg.get("standardcurrency");
                Long periodType = (Long)initOrg.get("periodtype");
                journal.set("basecurrency", (Object)baseCurrency);
                long period = ManualJournalHelper.getPeriodIdByDate((Date)bookDate, (long)periodType);
                journal.set("period", (Object)period);
                exratetable = (Long)initOrg.get("exratetable");
            }
            if (diffCurr && basecurrency != null && exratetable != null && (bizRate == null || bizRate.compareTo(BigDecimal.ZERO) == 0) && (exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)currency.getLong("id"), (Long)basecurrency, (Long)((Long)orgId), (Date)bizDate, exratetable)) != null) {
                exRate = exchangeRate;
            }
            if (exRate == null) {
                exRate = BigDecimal.ONE;
            }
            journal.set("exchangerate", (Object)exRate);
            if (debit.doubleValue() == 0.0) {
                journal.set("direction", (Object)1);
            } else if (credit.doubleValue() == 0.0) {
                journal.set("direction", (Object)2);
            }
            if (debit.compareTo(BigDecimal.ZERO) > 0) {
                localAmount = debit.multiply(exRate);
            } else if (credit.compareTo(BigDecimal.ZERO) > 0) {
                localAmount = credit.multiply(exRate);
            }
            journal.set("localamount", (Object)localAmount);
            journal.set("oppunit", entry.get("oppunit"));
            journal.set(this.accountName, acct.get("id"));
            if (this.isBankJournal()) {
                journal.set("settlementnumber", entry.get("settlementnumber"));
                journal.set("oppbank", entry.get("oppbank"));
                journal.set("oppacctnumber", entry.get("oppacctnumber"));
                RecDecInitHelper.setValid((DynamicObject)journal, (DynamicObject)acct, (Long)((Long)orgId), (Date)bookDate);
            }
        }
        this.saveFound(journal, dataMap, (Long)orgId, exRate);
        this.extendSave(journal, dataMap);
        return true;
    }

    private boolean dateFormatValidate(Object item) {
        if (item instanceof Date) {
            return true;
        }
        if (item instanceof String) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                sdf.parse(item.toString());
            }
            catch (ParseException e) {
                this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                return false;
            }
        }
        return true;
    }

    public void saveFound(DynamicObject journal, Map<String, Object> dataMap, Long org, BigDecimal exRate) {
        LinkedHashMap foundUse;
        LinkedHashMap manulentry;
        DynamicObjectCollection entrys = journal.getDynamicObjectCollection("entry");
        DynamicObject entry = entrys.addNew();
        Object currencys = journal.get("currency");
        if (!CasHelper.isEmpty((Object)currencys)) {
            entry.set("e_currency", currencys);
        }
        List entryList = null;
        try {
            entryList = (List)JSONUtils.cast((String)dataMap.get("manualentry").toString(), List.class);
        }
        catch (IOException e) {
            this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return;
        }
        if (entryList != null && !entryList.isEmpty() && (manulentry = (LinkedHashMap)entryList.get(0)) != null && (foundUse = (LinkedHashMap)manulentry.get("fundflowitem")) != null) {
            QFilter filter = new QFilter("number", "=", foundUse.get("number"));
            DynamicObject item = QueryServiceHelper.queryOne((String)"cas_fundflowitem", (String)"id", (QFilter[])filter.toArray());
            entry.set("e_fundflowitem", item.get("id"));
        }
        entry.set("e_org", (Object)org);
        BigDecimal localAmount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal debit = journal.getBigDecimal("debitamount");
        BigDecimal credit = journal.getBigDecimal("creditamount");
        if (exRate == null) {
            exRate = BigDecimal.ONE;
        }
        if (debit.compareTo(BigDecimal.ZERO) != 0) {
            localAmount = debit.multiply(exRate);
            amount = debit;
        } else if (credit.compareTo(BigDecimal.ZERO) != 0) {
            localAmount = credit.multiply(exRate);
            amount = credit;
        }
        entry.set("e_amount", (Object)amount);
        entry.set("e_localamount", (Object)localAmount);
        entry.set("e_oppunit", (Object)journal.getString("oppunit"));
        try (TXHandle tx = TX.required((String)"manualimport");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{journal});
                BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])new DynamicObject[]{journal}, (OperateType)OperateType.ADD);
            }
            catch (Exception e) {
                tx.markRollback();
                if (tx != null) {
                    if (var14_15 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var14_15.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
            try {
                if ("cas_bankjournal".equals(this.getMainEntity())) {
                    CasBankJournalHelper.updateBillValue((DynamicObject[])new DynamicObject[]{journal});
                    CasBankJournalHelper.updateBalance((DynamicObject[])new DynamicObject[]{journal});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void extendSave(DynamicObject journal, Map<String, Object> dataMap) {
    }
}

