/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.OpenOrgHandle;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayerInfoEdit
extends DynamicFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
    }

    private void initF7() {
        this.fillOrgF7();
        this.fillPayerAcctBank();
        this.fillPayerAcctCash();
        this.fillPayerBank();
        new OpenOrgHandle(this).fillOpenOrg((BasedataEdit)this.getControl("openorg"));
    }

    private void fillOrgF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_paybill", (String)"47156aff000000ac");
            if (orgList.size() > 0) {
                showParameter.setCustomParam("range", new ArrayList(orgList));
            }
        });
    }

    private void fillPayerAcctBank() {
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("payeracctbank");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject settleType;
            boolean isDcep;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject org = this.getDynamicObject("org");
            Boolean virtual = (Boolean)this.getView().getFormShowParameter().getCustomParam("virtual");
            if (org != null) {
                showParameter.setCustomParam("org", (Object)org.getLong("id"));
                QFilter[] usableAccountFilter = AccountBankHelper.getUsableAccountFilter_new((long)((Long)org.getPkValue()));
                ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(usableAccountFilter.length + 1);
                Collections.addAll(qFilterArrayList, usableAccountFilter);
                if (virtual.booleanValue()) {
                    qFilterArrayList.add(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)virtual));
                }
                showParameter.getListFilterParameter().getQFilters().addAll(qFilterArrayList);
                showParameter.setCustomParam("filterTransferViewOrg", (Object)"1");
                showParameter.setUseOrgId(org.getLong("id"));
            } else {
                QFilter usableFilter = AccountBankHelper.getUsableFilter_new();
                if (virtual.booleanValue()) {
                    usableFilter.and(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)virtual));
                }
                showParameter.getListFilterParameter().setFilter(usableFilter);
            }
            IDataModel parentModel = this.getView().getParentView().getModel();
            IDataEntityProperty isDiffCurProp = parentModel.getProperty("isdiffcur");
            if (isDiffCurProp != null) {
                QFilter filter;
                Boolean isDiffCur = (Boolean)parentModel.getValue("isdiffcur");
                if (this.isBotpCreate() && !isDiffCur.booleanValue() && (filter = this.currencyFilter()) != null) {
                    if (virtual.booleanValue()) {
                        filter.and(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)virtual));
                    }
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                }
            }
            String filterIsElec = "0";
            if (parentModel.getDataEntity().containsProperty("businesstype") && (isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)(settleType = (DynamicObject)parentModel.getValue("settletype"))))) {
                String businessType = (String)parentModel.getValue("businesstype");
                if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                    filterIsElec = "1";
                }
                if (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                    filterIsElec = "1";
                }
            }
            QFilter filteDecp = new QFilter("iselecpayment", "=", (Object)filterIsElec);
            showParameter.getListFilterParameter().getQFilters().add(filteDecp);
        });
    }

    private void fillPayerAcctCash() {
        BasedataEdit payerAcctCashF7 = (BasedataEdit)this.getControl("payeracctcash");
        payerAcctCashF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            LspWapper lspWapper = new LspWapper(beforeF7SelectEvent);
            QFilter[] orgFilter = AccountCashHelper.getUsableAccountFilter((Long)this.getPk("org"));
            if (this.isBotpCreate()) {
                QFilter filter = this.currencyFilter();
                if (null != filter) {
                    ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(Arrays.asList(orgFilter));
                    lstFilters.add(filter);
                    lspWapper.coverFilters(lstFilters);
                }
            } else {
                lspWapper.setFilters(orgFilter);
            }
        });
    }

    private void fillPayerBank() {
        BasedataEdit payerbankF7 = (BasedataEdit)this.getControl("payerbank");
        payerbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            payerbankF7.setQFilter(qFilter);
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sourceBillType = (String)this.getView().getFormShowParameter().getCustomParam("sourceBillType");
        String sourceBillNumber = (String)this.getView().getFormShowParameter().getCustomParam("sourceBillNumber");
        Object obj = this.getView().getFormShowParameter().getCustomParam("sourceBillId");
        long sourceBillId = 0L;
        if (obj != null) {
            sourceBillId = Long.parseLong(obj.toString());
        }
        if (EmptyUtil.isNoEmpty((String)sourceBillType) && EmptyUtil.isNoEmpty((String)sourceBillNumber) && EmptyUtil.isNoEmpty((Long)sourceBillId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataEntityProperty settletypeProp;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            this.setValue(propName, parentModel.getValue(propName));
        }
        String sourceBillType = (String)parentModel.getValue("sourcebilltype");
        if ("ap_finapbill".equals(sourceBillType) || "pm_purorderbill".equals(sourceBillType) || "ap_payapply".equals(sourceBillType) || "er_vehiclecheckingbill".equals(sourceBillType) || "er_planecheckingbill".equals(sourceBillType) || "er_hotelcheckingbill".equals(sourceBillType) || "er_publicreimbursebill".equals(sourceBillType) || "fca_transupbill".equals(sourceBillType) || "cfm_repaymentbill".equals(sourceBillType) || "cfm_interestbill".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) && parentModel.getValue("applyorg") != null || "lc_arrival".equals(sourceBillType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        if ((settletypeProp = parentModel.getProperty("settletype")) != null) {
            DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            this.getView().setVisible(Boolean.valueOf(isCash), new String[]{"payeracctcash"});
            this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"payeracctbank", "payerbank"});
            if (isCash && null == this.getDynamicObject("payeracctcash")) {
                this.setValue("payeracctcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payee"));
            }
        }
        DynamicObject billType = (DynamicObject)parentModel.getValue("billtype");
        boolean isShow = false;
        if (billType != null && parentModel.getDataEntity().containsProperty("businesstype")) {
            String businessType = (String)parentModel.getValue("businesstype");
            isShow = PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"payerbank"});
        }
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"institutioncode", "institutionname"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "org": {
                this.orgF7Changed((DynamicObject)newValue);
                new OpenOrgHandle(this).setOpenOrg();
                break;
            }
            case "payeracctbank": {
                this.payerAcctBankF7Changed((DynamicObject)newValue);
                DynamicObject openOrg = (DynamicObject)this.getModel().getValue("openorg");
                if (openOrg != null) break;
                new OpenOrgHandle(this).setOpenOrg();
            }
        }
    }

    private void orgF7Changed(DynamicObject org) {
        this.getModel().setValue("payeracctcash", null);
        if (org != null) {
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            IDataEntityProperty settletypeProp = parentModel.getProperty("settletype");
            if (settletypeProp != null) {
                DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
                boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
                if (isDcep) {
                    this.setValue("payeracctbank", null);
                    return;
                }
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
                if (!isCash) {
                    DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)((Long)org.getPkValue()));
                    this.setValue("payeracctbank", defaultPayAccount);
                } else {
                    this.setValue("payeracctcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payee"));
                }
            }
        } else {
            this.setValue("payeracctbank", null);
        }
    }

    private void payerAcctBankF7Changed(DynamicObject payerAcctBank) {
        if (payerAcctBank != null) {
            this.setValue("payerbank", payerAcctBank.get("bank"));
            String institutioncode = DcepConverHelper.getInstitUtionCode((DynamicObject)payerAcctBank);
            this.setValue("institutioncode", institutioncode);
            String institutionName = DcepConverHelper.getInstitutionName((DynamicObject)payerAcctBank);
            this.setValue("institutionname", institutionName);
        } else {
            this.setValue("institutioncode", null);
            this.setValue("institutionname", null);
            this.setValue("payerbank", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                if (CasHelper.isEmpty((Object)this.getValue("org"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayerInfoEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.btnOk();
                break;
            }
        }
    }

    private void btnOk() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("org", this.getValue("org"));
        resultMap.put("payeracctbank", this.getValue("payeracctbank"));
        resultMap.put("payeracctcash", this.getValue("payeracctcash"));
        resultMap.put("payerbank", this.getValue("payerbank"));
        resultMap.put("openorg", this.getValue("openorg"));
        resultMap.put("institutioncode", this.getValue("institutioncode"));
        resultMap.put("institutionname", this.getValue("institutionname"));
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    private QFilter currencyFilter() {
        DynamicObject currency = (DynamicObject)this.getView().getParentView().getModel().getValue("currency");
        if (currency != null) {
            return AccountBankHelper.getCurrencyFilter((DynamicObject)currency);
        }
        return null;
    }
}

