/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.commitToBe.enums.TmcAppEnum;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.opservice.impl.PaymentPayImpl;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.OperateTypeEnum;
import kd.fi.cas.enums.PaymentTypeEnum;
import kd.fi.cas.enums.PriorityEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.formplugin.common.AbstractCasBillListPlugin;
import kd.fi.cas.formplugin.helper.InitCheckPluginHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.PayBillListPlugnHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.PaymentQueryHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.PluginSignHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class PaymentBillList
extends AbstractCasBillListPlugin
implements SignCallbackLisenter {
    private static final String KEY_CHANGECHG_CALLBACK = "KEY_CHANGECHG_CALLBACK";
    private static final String BAR_VIEWDIAGRAM = "barviewdiagram";
    private static final String KEY_CALLBACK_CHARGEBACK = "CALLBACK_CHARGEBACK";
    private static final String KEY_CANCELLATION = "cancellation";
    private static final String CONFIRM_DEL_CALLBACK = "CONFIRM_DEL_CALLBACK";
    private static final String KEY_DIFFPAY_CALLBACK = "KEY_DIFFPAY_CALLBACK";
    private static final String KEY_CLOSECALLBACK_CHARGEBACK = "CALLBACK_SELECTDRAFT";
    private static final String BAR_BATCH_INPUT = "batchinput";
    private FilterContainerInitArgs initArgs;
    private static Log logger = LogFactory.getLog(PaymentBillList.class);
    List<String> INTEGRATE_VALIDATE_KEYS = Arrays.asList("tblcancelpay", "paypushandsave", "cancelentrustpay", "cancelmark", "baritemap2", "deletevoucher", "previewvoucher", "exportfiles", "syncbankbillstatus", "syncreceiptstatus");
    private Set<String> settleTypes = Stream.of(SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.DRAFT.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String parentFormId = listShowParameter.getParentFormId();
        Object isFromTrack = listShowParameter.getCustomParams().getOrDefault("isFromTrack", null);
        PaymentQueryHelper.enhanceNumFilterToIdFilter((List)e.getQFilters());
        boolean isFromControlCenter = CasPluginHelper.isFromControlCenter((IFormView)this.getView());
        logger.info("\u4ed8\u6b3e\u5355-\u8c03\u5ea6\u4e2d\u5fc3 parentFormId \uff1a" + parentFormId + "; === " + isFromControlCenter);
        if (isFromControlCenter && "fca_control_index".equals(parentFormId)) {
            if (e.getMainOrgQFilter() != null) {
                e.getMainOrgQFilter().clearNests();
            }
            e.getQFilters().add(PayBillListPlugnHelper.getFcaFilter((String)((String)listShowParameter.getCustomParam("status"))));
        } else if (("cas_apphome_grid".equals(parentFormId) || "fca_apphome".equals(parentFormId) || "fs_apphome".equals(parentFormId)) && (null == isFromTrack || isFromTrack.toString().trim().equals(""))) {
            e.getQFilters().add(PayBillListPlugnHelper.getListFilter((String)listShowParameter.getBillFormId(), (String)((String)listShowParameter.getCustomParam("appid"))));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean permission = PermissionHelper.hasEntrustPayPermission((String)appId, (String)"cas_paybill");
        this.getView().setVisible(Boolean.valueOf(permission), new String[]{"paypushandsave", "cancelentrustpay"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (CasPluginHelper.isFromControlCenter((IFormView)this.getView())) {
            String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
            if (BillStatusEnum.SAVE.getValue().equals(status)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew", "tblcheck", "tblcopy", "tblpay", "barinfochg", "baritemap2", "tblprint"});
            } else if (BillStatusEnum.SUBMIT.getValue().equals(status)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew", "tblsubmit", "tblcopy", "tblpay", "barinfochg", "baritemap2", "tblprint"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew", "tblsubmit", "tblcopy", "tblcheck", "barinfochg", "baritemap2", "tblprint"});
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Set selectRowsPks;
        QFilter[] delFilters;
        Object[] paybills;
        String opKey = evt.getOperationKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        String itemKey = evt.getItemKey();
        if (this.INTEGRATE_VALIDATE_KEYS.contains(opKey) || this.INTEGRATE_VALIDATE_KEYS.contains(itemKey)) {
            this.integrateValidate(evt, selectRows);
        }
        if ("delete".equals(opKey) && selectRows.size() > 0 && EmptyUtil.isNoEmpty((Object[])(paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"billno", (QFilter[])(delFilters = new QFilter[]{new QFilter("id", "in", selectRowsPks = selectRows.parallelStream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toSet())), new QFilter("hotaccount", "!=", (Object)"2"), new QFilter("sourcebilltype", "=", (Object)"cas_recbill")}))))) {
            evt.setCancel(true);
            String billnoStr = ((Stream)Arrays.stream(paybills).parallel()).map(d -> d.getString("billno")).collect(Collectors.joining("\u3001"));
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u5355\u7531\u5185\u90e8\u6536\u4ed8\u534f\u540c\u4e1a\u52a1\u81ea\u52a8\u751f\u6210\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"PaymentBillEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), billnoStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DEL_CALLBACK, (IFormPlugin)this));
        }
        if ("commitbe".equals(opKey) && selectRows.size() > 0) {
            Object[] selectedRowPks = this.getSelectedRows().getPrimaryKeyValues();
            PluginSignHelper.signOperate((BeforeItemClickEvent)evt, (SignCallbackLisenter)this, (Object[])selectedRowPks, (IFormView)this.getView(), (String)"cas_paybill", (Boolean)true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tblnew4ap": {
                this.addNew(PaymentTypeEnum.AP, "cas_paybill");
                break;
            }
            case "tblnew4er": {
                this.addNew(PaymentTypeEnum.ER, "cas_paybill");
                break;
            }
            case "tblnew4otr": {
                this.addNew(PaymentTypeEnum.OTR, "cas_paybill");
                break;
            }
            case "tblnew4syn": {
                this.addNew(PaymentTypeEnum.SYN, "cas_paybill_synonym");
                break;
            }
            case "tblnew4cash": {
                this.addNew(PaymentTypeEnum.CASH, "cas_paybill_cash");
                break;
            }
            case "tblnew4dcep": {
                this.addNew(PaymentTypeEnum.DCEP, "cas_paybill_dcep");
                break;
            }
            case "tbloffset": {
                break;
            }
            case "tblbeforesubmit": {
                this.beforeSubmit();
                break;
            }
            case "barviewdiagram": {
                this.viewDiagram();
                break;
            }
            case "viewsettle": {
                CasPluginHelper.viewSettleForPay((BillList)((BillList)this.getControl("billlistap")), (IFormView)this.getView());
                break;
            }
            case "tblcancelpay": {
                this.cancelPay();
                break;
            }
            case "viewdrafbill": {
                CasPluginHelper.viewDrafBill((BillList)((BillList)this.getControl("billlistap")), (IFormView)this.getView(), (String)"cas_paybill");
                break;
            }
            case "tblnewspan": {
                this.addNew(PaymentTypeEnum.SPAN, "cas_paybill_spanmainpart");
            }
        }
    }

    private void openEditView(String opName) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedRowPks = selectedRows.getPrimaryKeyValues();
        if (selectedRowPks.length != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"PaymentBillList_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow currentSelectedRowInfo = selectedRows.get(0);
        String billStatus = currentSelectedRowInfo.getBillStatus();
        if (BillStatusEnum.RENOTE.getValue().equals(billStatus) || BillStatusEnum.CHARGEBANK.getValue().equals(billStatus) || BillStatusEnum.REFUND.getValue().equals(billStatus) || BillStatusEnum.DEAD.getValue().equals(billStatus) || BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b26\u5408\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PaymentBillList_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject paybillDO = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_paybill", (String)"paymenttype");
        DynamicObject paymenttype = paybillDO.getDynamicObject("paymenttype");
        boolean ispartpayment = paymenttype.getBoolean("ispartpayment");
        if (!ispartpayment) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4ed8\u6b3e\u7c7b\u578b\u672a\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PaymentBillList_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setCustomParam("op_supplecontract", (Object)opName);
        showParameter.setPkId(primaryKeyValue);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"PaymentBillList_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("cas_paybill_contract");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openChangeChg(String sourceType, String sourceAction, String openView) {
        FormShowParameter showParameter = new FormShowParameter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long sourceId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        StyleCss css = new StyleCss();
        css.setWidth("700");
        css.setHeight("400");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCustomParam("sourceId", (Object)sourceId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("sourceAction", (Object)sourceAction);
        showParameter.setCustomParam("openView", (Object)openView);
        showParameter.setFormId("cas_changemodeselection");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CHANGECHG_CALLBACK));
        this.getView().showForm(showParameter);
    }

    private void addNew(PaymentTypeEnum paymentType, String formId) {
        this.getPageCache().put("paymentType", paymentType.name());
        this.getPageCache().put("formId", formId);
        this.getView().invokeOperation("new");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        PayBillListPlugnHelper.closeCallBack((String)e.getActionId(), (IFormView)this.getView(), (Object)e.getReturnData());
        PayBillHepler.closedCallBack((String)e.getActionId(), (IFormView)this.getView(), (Object)e.getReturnData());
    }

    private void beforeSubmit() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().invokeOperation("beforesubmit");
        }
    }

    private void viewDiagram() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedRowPks = selectedRows.getPrimaryKeyValues();
        if (selectedRowPks.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow selectedRow = selectedRows.get(0);
        Long billId = (Long)selectedRow.getPrimaryKeyValue();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_viewflowchart");
        showParameter.setClientParam("billId", (Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("trackdown".equals(key)) {
            String settlementtype;
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection idList = list.getSelectedRows();
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)idList.get(0).getPrimaryKeyValue(), (String)"cas_paybill", (String)"id,settletype");
            DynamicObject settleType = info.getDynamicObject("settletype");
            if (settleType != null && EmptyUtil.isNoEmpty((String)(settlementtype = settleType.getString("settlementtype"))) && this.settleTypes.contains(settlementtype)) {
                op.getOption().setVariableValue("botp_track_edit_status", "true");
            }
        } else if ("chargeback".equals(key)) {
            FormOperate operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("strictvalidation", String.valueOf(true));
        } else if ("invalid".equals(key)) {
            boolean result = op.getOption().tryGetVariableValue(KEY_CANCELLATION, new RefObject());
            if (!result) {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection lstCollection = list.getSelectedRows();
                args.cancel = true;
                if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)lstCollection) > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"PaymentBillList_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f5c\u5e9f\u9009\u4e2d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaymentBillList_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CANCELLATION, (IFormPlugin)this));
            }
        } else if ("endorse".equals(key)) {
            this.beforeDoEndorse(args);
        } else if ("recbook".equals(key)) {
            this.beforeDoRecBook(args);
        } else if ("submit".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object[] selectedRowPks = billList.getSelectedRows().getPrimaryKeyValues();
            if (selectedRowPks != null && selectedRowPks.length > 0) {
                DynamicObject[] payBills = BusinessDataServiceHelper.load((Object[])selectedRowPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
                ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(payBills.length);
                for (DynamicObject payBill : payBills) {
                    boolean isRemove = false;
                    DynamicObjectCollection collection = payBill.getDynamicObjectCollection("entry");
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject object = (DynamicObject)iterator.next();
                        if (!CasHelper.isEmpty((Object)object.get("e_payableamt"))) continue;
                        iterator.remove();
                        isRemove = true;
                    }
                    if (!isRemove) continue;
                    updateBills.add(payBill);
                }
                if (updateBills.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
                }
            }
        } else if ("payschback".equals(key)) {
            FormOperate operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("strictvalidation", String.valueOf(true));
        } else if ("matchdetail".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ManualMatchHelper.verifySameOrg((ListSelectedRowCollection)billList.getSelectedRows(), (String)"cas_paybill", (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        } else if ("lcopen".equals(key)) {
            DynamicObject info;
            String msg;
            BillList billList = (BillList)this.getControl("billlistap");
            Object[] selectedRowPks = billList.getSelectedRows().getPrimaryKeyValues();
            if (selectedRowPks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u9009\u62e9\u4ed8\u6b3e\u5355\u4e0b\u63a8\u4fe1\u7528\u8bc1\u5f00\u7acb\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"PaymentBillList_41", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (selectedRowPks.length == 1 && StringUtils.isNotEmpty((CharSequence)(msg = PaymentBillList.checkLCOpen((info = BusinessDataServiceHelper.loadSingle((Object)selectedRowPks[0], (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"))).getDynamicObject("settletype"), info.getString("billstatus"), info.getString("settletnumber"))))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u201c%1$s\u201d\u7684%2$s", (String)"PaymentBillList_42", (String)"fi-cas-formplugin", (Object[])new Object[0]), info.getString("billno"), msg);
                this.getView().showTipNotification(errorMsg);
                args.setCancel(true);
            }
        } else if ("pay".equals(key)) {
            String payConfirm;
            op.getOption().setVariableValue("isfromview", "true");
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Set<Object> selectRowsPks = Arrays.stream(selectedRows.getPrimaryKeyValues()).collect(Collectors.toSet());
            String draftIds = op.getOption().getVariableValue("draftids", "");
            String lcBillNo = op.getOption().getVariableValue("lcBillNo", "");
            DynamicObject[] dbDatas = null;
            if (StringUtils.isEmpty((CharSequence)draftIds) || StringUtils.isEmpty((CharSequence)lcBillNo)) {
                Object[] selectRowsKeyValues = selectedRows.getPrimaryKeyValues();
                dbDatas = BusinessDataServiceHelper.load((Object[])selectRowsKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
            }
            CloseCallBack lcSelectCloseCallBack = new CloseCallBack((IFormPlugin)this, "CALLBACK_SELECTCREDIT");
            boolean cancel = PaymentBillList.letterCreditSelect(this.getView(), lcSelectCloseCallBack, lcBillNo, dbDatas);
            if (cancel) {
                args.setCancel(cancel);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)draftIds)) {
                if (selectRowsPks.size() == 1) {
                    DynamicObject dbData = dbDatas[0];
                    DynamicObject orgData = (DynamicObject)dbData.get("org");
                    Long pkValue = (Long)orgData.getPkValue();
                    boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)pkValue, (String)"cs122");
                    if (selectDraftFlag && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)dbData) && BillStatusEnum.AUDIT.getValue().equals(dbData.getString("billstatus"))) {
                        HashSet<Long> recSelectDraftProcessDySet = new HashSet<Long>(16);
                        recSelectDraftProcessDySet.add(dbData.getLong("id"));
                        PayBillListPlugnHelper.showSelectDraftForm((CloseCallBack)new CloseCallBack((IFormPlugin)this, KEY_CLOSECALLBACK_CHARGEBACK), (IFormView)this.getView(), recSelectDraftProcessDySet);
                        args.setCancel(true);
                        return;
                    }
                } else {
                    HashSet recSelectDraftProcessDySet = new HashSet(16);
                    boolean isNeedCancel = CasPluginHelper.batchDealRec(recSelectDraftProcessDySet, (DynamicObject[])dbDatas);
                    if (isNeedCancel) {
                        recSelectDraftProcessDySet.clear();
                    } else if (EmptyUtil.isNoEmpty(recSelectDraftProcessDySet) && recSelectDraftProcessDySet.size() > 0) {
                        PayBillListPlugnHelper.showSelectDraftForm((CloseCallBack)new CloseCallBack((IFormPlugin)this, KEY_CLOSECALLBACK_CHARGEBACK), (IFormView)this.getView(), recSelectDraftProcessDySet);
                        args.setCancel(true);
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)draftIds) && StringUtils.isEmpty((CharSequence)(payConfirm = op.getOption().getVariableValue("payConfirm", "")))) {
                DynamicObject payBill;
                Object pk;
                if (selectedRows.size() <= 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                Object[] pkArray = selectRowsPks.toArray(new Object[0]);
                List payIdList = Arrays.stream(pkArray).collect(Collectors.toList());
                boolean isForeignCurrency = false;
                HashMap cs1047Params = new HashMap(10);
                Set cs1047 = new HashSet();
                List payIdLists = Lists.partition(payIdList, (int)1000);
                for (List payIds : payIdLists) {
                    QFilter pkFilter = new QFilter("id", "in", (Object)payIds);
                    DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"org,dpcurrency,basecurrency,isdiffcur", (QFilter[])new QFilter[]{pkFilter});
                    HashSet<Long> orgIds = new HashSet<Long>(10);
                    boolean isSameCurrency = true;
                    boolean isSameDpCurrency = true;
                    boolean isSameParam = true;
                    Long preDpCurrencyId = 0L;
                    Long preBasecurrencyId = 0L;
                    String param = null;
                    if (payBills != null && payBills.length > 0) {
                        for (DynamicObject payBill2 : payBills) {
                            long orgId = (Long)payBill2.getDynamicObject("org").getPkValue();
                            Set cs1046 = new HashSet(1);
                            if (!orgIds.contains(orgId)) {
                                cs1046 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs1046");
                                String setParamToString = PayBillListPlugnHelper.setParamToString(cs1046);
                                if (param == null) {
                                    param = setParamToString;
                                } else if (!param.equals(setParamToString)) {
                                    isSameParam = false;
                                }
                                cs1047Params.put(orgId, cs1046);
                            } else {
                                cs1046 = (Set)cs1047Params.get(orgId);
                            }
                            orgIds.add(orgId);
                            if (payBill2.getBoolean("isdiffcur") && cs1046.contains(SysParamCs1046Enum.DIFF.getValue()) && selectRowsPks.size() > 1) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5f02\u5e01\u79cd\u9700\u8981\u786e\u8ba4\u4ed8\u6b3e\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u6279\u91cf\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentBillList_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            }
                            Long dpcurrencyId = payBill2.getDynamicObject("dpcurrency").getLong("id");
                            if (preDpCurrencyId == 0L) {
                                preDpCurrencyId = dpcurrencyId;
                            } else if (!preDpCurrencyId.equals(dpcurrencyId)) {
                                isSameDpCurrency = false;
                            }
                            Long basecurrencyId = payBill2.getDynamicObject("basecurrency").getLong("id");
                            if (preBasecurrencyId == 0L) {
                                preBasecurrencyId = basecurrencyId;
                            } else if (!preBasecurrencyId.equals(basecurrencyId)) {
                                isSameCurrency = false;
                            }
                            if (basecurrencyId.equals(dpcurrencyId)) continue;
                            isForeignCurrency = true;
                        }
                    }
                    if (!isSameParam) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u7cfb\u7edf\u53c2\u6570\u201c\u5141\u8bb8\u786e\u8ba4\u4ed8\u6b3e\u73af\u8282\u66f4\u65b0/\u8865\u5145\u4fe1\u606f\u201d\u9009\u9879\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u6279\u91cf\u786e\u8ba4\u4ed8\u6b3e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PaymentBillList_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                    cs1047 = (Set)cs1047Params.get(orgIds.iterator().next());
                    if (!cs1047.contains(SysParamCs1046Enum.FOREIGN.getValue()) || isSameDpCurrency && isSameCurrency) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u7cfb\u7edf\u53c2\u6570\u786e\u8ba4\u4ed8\u6b3e\u73af\u8282\u66f4\u65b0\u5916\u5e01\u4e1a\u52a1\u7684\u4ed8\u6b3e\u6c47\u7387\uff0c\u4f46\u6240\u9009\u5b58\u5728\u4ed8\u6b3e\u5e01\u79cd\u3001\u4e1a\u52a1\u4e3b\u5e01\u79cd\u4e0d\u4e00\u81f4\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u6279\u91cf\u786e\u8ba4\u4ed8\u6b3e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PaymentBillList_35", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                if (selectRowsPks.size() > 1) {
                    if (isForeignCurrency && cs1047.contains(SysParamCs1046Enum.FOREIGN.getValue())) {
                        pk = selectedRows.get(0).getPrimaryKeyValue();
                        payBill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"cas_paybill");
                        PayBillListPlugnHelper.showDiffPayRateForm((CloseCallBack)new CloseCallBack((IFormPlugin)this, KEY_DIFFPAY_CALLBACK), (IFormView)this.getView(), (DynamicObject)payBill);
                        args.setCancel(true);
                    } else if (cs1047.contains(SysParamCs1046Enum.PAYDATE.getValue())) {
                        PayBillListPlugnHelper.showDiffPayDateForm((CloseCallBack)new CloseCallBack((IFormPlugin)this, KEY_DIFFPAY_CALLBACK), (IFormView)this.getView());
                        args.setCancel(true);
                    }
                } else {
                    pk = selectedRows.get(0).getPrimaryKeyValue();
                    payBill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"cas_paybill");
                    if (PaymentBillPluginHelper.isShowPayConfirm((DynamicObject)payBill, cs1047)) {
                        if (!DraftHelper.isAllPayDrafBill((DynamicObjectCollection)payBill.getDynamicObjectCollection("draftbill")) && !payBill.getBoolean("feepay")) {
                            new PaymentPayImpl().validate(payBill);
                            PayBillListPlugnHelper.showDiffPayForm((CloseCallBack)new CloseCallBack((IFormPlugin)this, KEY_DIFFPAY_CALLBACK), (IFormView)this.getView(), (DynamicObject)payBill);
                            args.setCancel(true);
                        }
                    } else {
                        new PaymentPayImpl().validate(payBill);
                    }
                }
            }
        }
    }

    private void beforeDoRecBook(BeforeDoOperationEventArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ReceivingBillList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            Long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_paybill");
            if (!BillStatusEnum.AUDIT.getValue().equals(payBill.getString("billstatus"))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u5f00\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (PriorityEnum.DEFER.getValue().equals(payBill.getString("priority"))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u51bb\u7ed3\uff0c\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"PaymentBillFreezeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else {
                if (!InitCheckPluginHelper.checkInitForPlugin(this.getView(), payBill.getDynamicObject("org"), new String[0])) {
                    args.setCancel(true);
                    return;
                }
                if (PaymentBillPluginHelper.checkPayeeTypeFreeze(Collections.singletonList(payBill))) {
                    this.getView().showTipNotification(new PaymentErrorCode().CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
                    args.setCancel(true);
                    return;
                }
                if (!DraftHelper.isDraftBill((Long)primaryKeyValue, (String)"cas_paybill")) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u767b\u8bb0\u4ec5\u9002\u7528\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u662f\u627f\u5151\u6c47\u7968\u3001\u652f\u7968\u6216\u672c\u7968\u7684\u4ed8\u6b3e\u5355\uff0c\u4f60\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u5f00\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (this.isDraftBill(payBill).booleanValue()) {
                    args.setCancel(true);
                    if (DraftHelper.isHasRecDrafBill((DynamicObjectCollection)((DynamicObjectCollection)payBill.get("draftbill")))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u9009\u62e9\u76f8\u5173\u5e94\u6536\u7968\u636e\uff0c\u8bf7\u8fdb\u884c\u80cc\u4e66\u5904\u7406\u3002", (String)"PaymentBillDraftEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u9009\u62e9\u76f8\u5173\u5e94\u4ed8\u7968\u636e\uff0c\u8bf7\u8fdb\u884c\u786e\u8ba4\u4ed8\u6b3e\u5904\u7406\u3002", (String)"PaymentBillDraftEditPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                } else if (!DraftHelper.isParameterDraftOn((Long)primaryKeyValue, (String)"cas_paybill")) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3002", (String)"PaymentBillDraftEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else {
                    DynamicObject accountBank;
                    Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"cas_paybill", (Long[])new Long[]{primaryKeyValue});
                    HashSet pkValues = (HashSet)botpMap.get("cdm_payablebill");
                    boolean isExistNotDeadFlag = false;
                    if (null != pkValues && pkValues.size() > 0) {
                        DynamicObject[] payableBills;
                        for (DynamicObject payableBill : payableBills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})) {
                            if (BillStatusEnum.DEAD.getValue().equals(payableBill.getString("billstatus"))) continue;
                            isExistNotDeadFlag = true;
                        }
                    }
                    if (isExistNotDeadFlag) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u8fdb\u884c\u5f00\u7968\u767b\u8bb0\u3002", (String)"PaymentBillDraftEditPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                    if (null != (accountBank = payBill.getDynamicObject("payeracctbank")) && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
                    }
                    if (accountBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)accountBank)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u8bf7\u9009\u62e9\u5185\u90e8\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_48", (String)"fi-cas-business", (Object[])new Object[0]));
                    }
                }
            }
            String msg = WriteBackServiceImpl.getInstance().validate(payBill, WriteBackOperateEnum.ENDORSEVALIDATE, PaymentDisposeConsumer.class, payBill.getString("sourcebilltype"));
            if (EmptyUtil.isNoEmpty((String)msg)) {
                throw new KDBizException(msg);
            }
        }
    }

    private void beforeDoEndorse(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection idList = list.getSelectedRows();
        int selectedRowSize = CasHelper.getSelectedRowSize((ListSelectedRowCollection)idList);
        if (selectedRowSize > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u80cc\u4e66\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"PaymentBillList_20_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.cancel = true;
            return;
        }
        logger.info("beforeDoOperation endorse size is:" + idList.size());
        if (selectedRowSize == 1) {
            String msg;
            Pair result;
            long sourcebillid;
            DynamicObjectCollection tradeBills;
            logger.info("beforeDoOperation endorse is size");
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)idList.get(0).getPrimaryKeyValue(), (String)"cas_paybill");
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            String billStatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u80cc\u4e66\u3002", (String)"PaymentBillDraftEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            String sourcebilltype = info.getString("sourcebilltype");
            if ("cdm_drafttradebill".equals(sourcebilltype) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(tradeBills = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id,tradetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourcebillid = info.getLong("sourcebillid"))), new QFilter("tradetype", "=", (Object)"refund")}))) && tradeBills.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62d2\u6536\u9000\u7968\u751f\u6210\u7684\u4ed8\u6b3e\u5904\u7406\u53ea\u80fd\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentBillList_20_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            if (PriorityEnum.DEFER.getValue().equals(info.getString("priority"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u51bb\u7ed3\uff0c\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"PaymentBillFreezeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            if (!InitCheckPluginHelper.checkInitForPlugin(this.getView(), info.getDynamicObject("org"), new String[0])) {
                args.setCancel(true);
                return;
            }
            if (PaymentBillPluginHelper.checkPayeeTypeFreeze(Collections.singletonList(info))) {
                this.getView().showTipNotification(new PaymentErrorCode().CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
                args.setCancel(true);
                return;
            }
            DynamicObject settletype = info.getDynamicObject("settletype");
            DynamicObjectCollection draftbills = info.getDynamicObjectCollection("draftbill");
            if (settletype == null || draftbills == null || !settletype.getString("settlementtype").equals("5") && !settletype.getString("settlementtype").equals("6") || draftbills.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u80cc\u4e66\u4ec5\u9002\u5e94\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u662f\u627f\u5151\u6c47\u7968\u3001\u652f\u7968\u6216\u672c\u7968\u4e14\u7ed3\u7b97\u53f7\u9009\u62e9\u4e86\u5e93\u5b58\u7968\u636e\u7684\u4ed8\u6b3e\u5355\uff0c\u4f60\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u80cc\u4e66\u3002", (String)"PaymentBillDraftEditPlugin_3_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            if (!DraftHelper.isHasRecDrafBill((DynamicObjectCollection)draftbills)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u80cc\u4e66\u4ec5\u9002\u7528\u9009\u62e9\u4e86\u5e93\u5b58\u5e94\u6536\u7968\u636e\u7684\u4ed8\u6b3e\u5355\uff0c\u4f60\u6240\u9009\u5355\u636e\u4e0d\u652f\u6301\u80cc\u4e66\u3002", (String)"PaymentBillDraftEditPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!DraftHelper.isParameterDraftOn((Long)((Long)idList.get(0).getPrimaryKeyValue()), (String)"cas_paybill")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3002", (String)"PaymentBillDraftEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (payerAcctBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)payerAcctBank)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u8bf7\u9009\u62e9\u5185\u90e8\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_48", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (settletype != null && draftbills != null && draftbills.size() > 0 && Arrays.asList("5", "6").contains(settletype.getString("settlementtype")) && (result = (Pair)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"EBDraftAllocationService", (String)"doDraftAllocationService", (Object[])new Object[]{info})) != null) {
                if ("ING".equals(result.getLeft())) {
                    args.cancel = true;
                    info.set("billstatus", (Object)BillStatusEnum.DRAFTING.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                    this.getView().showSuccessNotification(BillStatusEnum.DRAFTING.getName());
                    this.getView().invokeOperation("refresh");
                } else if (!"S".equals(result.getLeft())) {
                    args.cancel = true;
                    this.getView().showErrorNotification(String.join((CharSequence)"\n", (Iterable)result.getRight()));
                }
            }
            if (EmptyUtil.isNoEmpty((String)(msg = WriteBackServiceImpl.getInstance().validate(info, WriteBackOperateEnum.RECBOOKVALIDATE, PaymentDisposeConsumer.class, info.getString("sourcebilltype"))))) {
                throw new KDBizException(msg);
            }
        }
    }

    private Boolean isDraftBill(DynamicObject payBill) {
        if (!CasHelper.isEmpty((Object)payBill.get("draftbill")) && ((DynamicObjectCollection)payBill.get("draftbill")).size() != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() > 0) {
                LinkedList<Long> paymentBillPks = new LinkedList<Long>();
                for (ListSelectedRow selectedRow : selectedRows) {
                    paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
                }
                QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
                DynamicObjectCollection payobjs = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno", (QFilter[])new QFilter[]{payPidFilter});
                if (!CasPluginHelper.cancelCheckSettleForPay((IFormPlugin)this, (IFormView)this.getView(), paymentBillPks, (DynamicObjectCollection)payobjs).booleanValue()) {
                    this.getView().invokeOperation("cancelpay");
                }
            }
        } else if ("CONFIRM_MANUALMATCH".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            ManualMatchHelper.confirmBizBillMatchDetail((IFormView)this.getView(), (String)"org,payeracctbank,dpcurrency");
        }
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_SETTLE_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelpay");
        }
        if (StringUtils.equals((CharSequence)id, (CharSequence)KEY_CANCELLATION) && MessageBoxResult.Yes.equals((Object)res)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(KEY_CANCELLATION, "yes");
            this.getView().invokeOperation("invalid", operateOption);
        }
        if (id.equals(CONFIRM_DEL_CALLBACK)) {
            OperateOption option = OperateOption.create();
            if (MessageBoxResult.Yes.equals((Object)res)) {
                option.setVariableValue("delrecpay", "1");
                this.getView().invokeOperation("delete", option);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean refreshFlg;
        List successPkIds;
        super.afterDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if ("pay".equals(key) && operationResult.isSuccess()) {
            this.showPayTips();
        } else if (!"cancelpay".equals(key) || !operationResult.isSuccess()) {
            if ("unitecommitbe".equals(key) && operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5408\u5e76\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"PaymentBillList_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else if (("chargeback".equals(key) || "payschback".equals(key)) && operationResult.isSuccess()) {
                List successPkIds2 = operationResult.getSuccessPkIds();
                if (!CollectionUtils.isEmpty((Collection)successPkIds2)) {
                    this.chargeBack(successPkIds2, key);
                }
            } else if ("trackdownchgbill".equals(key) && operationResult.isSuccess()) {
                CasPluginHelper.trackdownChgBill((IFormView)this.getView());
            } else if ("chargebacknoreason".equals(key)) {
                String reason = ResManager.loadKDString((String)"\u81ea\u52a8\u9000\u5355", (String)"PaymentBillList_37", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                successPkIds = operationResult.getSuccessPkIds();
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put("billid", successPkIds);
                data.put("reason", reason);
                data.put("operateKey", "chargeback");
                PayBillListPlugnHelper.closeCallBack((String)KEY_CALLBACK_CHARGEBACK, (IFormView)this.getView(), data);
            }
        }
        boolean bl = refreshFlg = !Arrays.asList("refresh", "exportbylist", "paypushchg", "recpushchg", "modify", "pay", "cancelpay", "syncbankbillstatus", "cancelmatch").contains(key);
        if (refreshFlg) {
            ((ListView)this.getView()).refresh();
        }
        if ("beforesubmit".equals(key)) {
            List pks = operationResult.getSuccessPkIds();
            if (pks != null && pks.size() > 0) {
                operationResult.setShowMessage(false);
                this.getView().invokeOperation("submit");
            }
        } else if ("chargebackwrite".equals(key) && operationResult.isSuccess()) {
            ((IEntityOperate)e.getSource()).setCancelRefresh(false);
        } else if ("supplecontract".equals(key) && operationResult.isSuccess()) {
            this.openEditView("supplecontract");
        } else if ("paypushchg".equals(key) && operationResult.isSuccess()) {
            this.openChangeChg("cas_paybill", "payAction", "cas_paychgbill_paychg");
        } else if ("recpushchg".equals(key) && operationResult.isSuccess()) {
            this.openChangeChg("cas_paybill", "recAction", "cas_paychgbill_recchg");
        } else if ("urgentpay".equals(key) && operationResult.isSuccess()) {
            successPkIds = operationResult.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u6025\u6210\u529f\u3002", (String)"PaymentBillList_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("cancelurgentpay".equals(key) && operationResult.isSuccess()) {
            successPkIds = operationResult.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u52a0\u6025\u6210\u529f\u3002", (String)"PaymentBillList_39", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("matchdetail".equals(e.getOperateKey())) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            ManualMatchHelper.bizBillMatchDetail((IFormView)this.getView(), (AfterDoOperationEventArgs)e, (ListSelectedRowCollection)selectedRows, (IFormPlugin)this, (String)list.getEntityId(), (String)"org,payeracctbank,dpcurrency");
        } else if (BAR_BATCH_INPUT.equals(key)) {
            IFormView view = this.getView();
            String title = null;
            if (view instanceof ListView && "cas_paybill_cash".equals(((ListView)view).getBillFormId())) {
                title = ResManager.loadKDString((String)"\u6279\u91cf\u5f55\u5165\u73b0\u91d1\u5b58\u53d6", (String)"PaymentBillList_47", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            CasPluginHelper.viewBatchInput((IFormView)view, (String)"cas_batchpaybill", title);
        }
        if (Arrays.asList("pay", "cancelpay", "syncbankbillstatus", "cancelmatch").contains(key) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showPayTips() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 0) {
            LinkedList<Long> paymentBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            AppParam appParam = new AppParam();
            appParam.setAppId(TmcAppEnum.CAS.getId());
            QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
            DynamicObject[] payobjs = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,bizdate,payee,billno,payeetype", (QFilter[])new QFilter[]{payPidFilter});
            List orgIds = Arrays.stream(payobjs).map(o -> o.getLong("payee")).collect(Collectors.toList());
            Set<Long> payeeIsSupplierIds = this.getNeedQueryPayeeId(payobjs, AsstActTypeEnum.SUPPLIER.getValue());
            Set<Long> payeeIsCustomerIds = this.getNeedQueryPayeeId(payobjs, AsstActTypeEnum.CUSTOMER.getValue());
            Map supplierMap = CasPluginHelper.getInternalCompanyMap((String)AsstActTypeEnum.SUPPLIER.getValue(), payeeIsSupplierIds);
            Map customerMap = CasPluginHelper.getInternalCompanyMap((String)AsstActTypeEnum.CUSTOMER.getValue(), payeeIsCustomerIds);
            HashMap<Long, DynamicObject> org_curPeriod = new HashMap<Long, DynamicObject>(10);
            HashSet<Object> orgIdSet = new HashSet<Object>(10);
            for (Map.Entry entry : supplierMap.entrySet()) {
                orgIdSet.add(entry.getValue());
            }
            for (Map.Entry entry : customerMap.entrySet()) {
                orgIdSet.add(entry.getValue());
            }
            orgIdSet.addAll(orgIds);
            Map stringMapMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, new ArrayList(orgIdSet));
            StringBuilder sb = new StringBuilder();
            for (DynamicObject payBill : payobjs) {
                boolean allow;
                boolean isCheck;
                Map sysParams;
                Long internalCompany;
                String payeeType = payBill.getString("payeetype");
                Long payee = payBill.getLong("payee");
                if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType)) {
                    internalCompany = (Long)supplierMap.get(payee);
                    if (CasHelper.isEmpty((Object)internalCompany)) {
                        logger.info("====SUPPLIER\u975e\u5185\u90e8\u5ba2\u5546\u3002");
                        continue;
                    }
                    payee = internalCompany;
                } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
                    internalCompany = (Long)customerMap.get(payee);
                    if (CasHelper.isEmpty((Object)internalCompany)) {
                        logger.info("====CUSTOMER\u975e\u5185\u90e8\u5ba2\u5546\u3002");
                        continue;
                    }
                    payee = internalCompany;
                } else if (!AsstActTypeEnum.COMPANY.getValue().equals(payeeType)) {
                    logger.info("====\u65e0\u903b\u8f91\u5206\u652f\u3002");
                    continue;
                }
                if (EmptyUtil.isNoEmpty((Long)payee)) {
                    DynamicObject currentPeriod;
                    Date bizDate = payBill.getDate("bizdate");
                    if (org_curPeriod.containsKey(payee)) {
                        currentPeriod = (DynamicObject)org_curPeriod.get(payee);
                    } else {
                        currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)payee);
                        org_curPeriod.put(payee, currentPeriod);
                    }
                    if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && !bizDate.before(currentPeriod.getDate("begindate"))) continue;
                }
                if (!EmptyUtil.isNoEmpty((Object)(sysParams = (Map)stringMapMap.get(String.valueOf(payee))))) continue;
                Object CS047 = sysParams.get("cs047");
                Object allowObj = sysParams.get("cs127");
                if (!EmptyUtil.isNoEmpty(CS047) || !(isCheck = ((Boolean)CS047).booleanValue()) || !EmptyUtil.isNoEmpty(allowObj) || (allow = ((Boolean)allowObj).booleanValue())) continue;
                String billNo = payBill.getString("billno");
                sb.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u786e\u8ba4\u4ed8\u6b3e\u6210\u529f\u3002\u56e0\u6536\u6b3e\u65b9\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u65b0\u589e\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u6536\u6b3e\u4e1a\u52a1\uff0c\u56e0\u6b64\u6536\u4ed8\u534f\u540c\u751f\u6210\u6536\u6b3e\u5355\u5931\u8d25\u3002\r\n", (String)"PaymentBillList_40", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo));
            }
            if (EmptyUtil.isNotEmpty((CharSequence)sb)) {
                this.getView().showTipNotification(sb.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"PaymentBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Set<Long> getNeedQueryPayeeId(DynamicObject[] payobjs, String type) {
        HashSet<Long> payeeIds = new HashSet(2);
        payeeIds = Arrays.stream(payobjs).map(o -> {
            String payeeType = o.getString("payeetype");
            if (type.equals(payeeType)) {
                return o.getLong("payee");
            }
            return 0L;
        }).collect(Collectors.toSet());
        return payeeIds;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        List<String> defaultValues;
        super.filterContainerInit(args);
        this.initArgs = args;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object isFromDraftBill = listShowParameter.getCustomParams().getOrDefault("isFromDraftBill", null);
        String status = (String)listShowParameter.getCustomParam("status");
        String parentFormId = listShowParameter.getParentFormId();
        if (null == this.getCachedOrgList()) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if (!"org.id".equals(filterColumn.getFieldName()) || null == (defaultValues = filterColumn.getDefaultValues()) || defaultValues.size() <= 0) continue;
                List<Long> selectedOrgIdList = defaultValues.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.toString())).map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
                this.cacheSelectedOrgIdList(selectedOrgIdList);
            }
        }
        if (CasPluginHelper.isFromControlCenter((IFormView)this.getView()) && "fca_control_index".equals(parentFormId) || CasPluginHelper.isTrack((FormShowParameter)this.getView().getFormShowParameter())) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if ("org.id".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValue("");
                }
                if ("billstatus".equals(filterColumn.getFieldName())) {
                    if (EmptyUtil.isNoEmpty((String)status)) {
                        defaultValues = Arrays.asList(status.split(","));
                        filterColumn.setDefaultValues(defaultValues);
                    } else {
                        filterColumn.setDefaultValues(new Object[]{""});
                    }
                }
                if (!"bizdate".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        } else if (EmptyUtil.isNoEmpty(isFromDraftBill) && isFromDraftBill.toString().trim().equals("Y")) {
            CasPluginHelper.getCasQFilter((ListShowParameter)listShowParameter, (FilterContainerInitArgs)args);
        }
        this.fillToolBar();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List<Object> object;
        super.filterContainerSearchClick(args);
        List selectedOrgIdList = args.getSelectMainOrgIds();
        if (!(selectedOrgIdList.size() <= 0 || null != (object = this.getCachedOrgList()) && object.toString().equals(selectedOrgIdList.toString()))) {
            this.cacheSelectedOrgIdList(selectedOrgIdList);
            this.filterContainerInit(this.initArgs);
        }
    }

    private void cacheSelectedOrgIdList(List<Long> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    private void fillToolBar() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"recbook", "endorse"});
        List<Object> object = this.getCachedOrgList();
        if (object == null || object.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"recbook", "endorse"});
            return;
        }
        List cachedOrgList = this.getCachedOrgList().stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
        for (Long orgId : cachedOrgList) {
            boolean isdraft = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"isdraft");
            boolean ischeck = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ischeck");
            boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ispromissorynote");
            if (!isdraft && !ischeck && !ispromissorynote) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"recbook", "endorse"});
            return;
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter showParameter = e.getParameter();
        Object billId = showParameter.getPkId();
        BillOperationStatus billStatus = showParameter.getBillStatus();
        OperationStatus operationStatus = showParameter.getStatus();
        if (billId != null) {
            if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
                String operateType = this.getPageCache().get("operate");
                if (operateType != null) {
                    showParameter.getCustomParams().put("operate", operateType);
                } else {
                    showParameter.getCustomParams().put("operate", OperateTypeEnum.COPY);
                }
            } else {
                DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"cas_paybill", (String)"id, billtype");
                DynamicObject billtype = info.getDynamicObject("billtype");
                if (billtype != null && BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue())) {
                    showParameter.setFormId("cas_paybill_synonym");
                    showParameter.setCaption(ResManager.loadKDString((String)"\u540c\u540d\u8f6c\u8d26", (String)"PaymentBillEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (billtype != null && BillTypeConstants.PAYBILL_SPAN.equals(billtype.getPkValue())) {
                    showParameter.setFormId("cas_paybill_spanmainpart");
                    showParameter.setCaption(ResManager.loadKDString((String)"\u8de8\u4e3b\u4f53\u8c03\u62e8", (String)"PaymentBillEdit_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
                    showParameter.setFormId("cas_paybill_cash");
                    showParameter.setCaption(ResManager.loadKDString((String)"\u73b0\u91d1\u5b58\u53d6", (String)"PaymentBillEdit_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (billtype != null && BillTypeConstants.PAYBILL_DCEP.equals(billtype.getPkValue())) {
                    showParameter.setFormId("cas_paybill_dcep");
                    showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u5e01\u5b58\u53d6", (String)"PaymentBillEdit_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                showParameter.setCustomParam("showConer", (Object)true);
            }
        } else if (BillOperationStatus.ADDNEW == billStatus) {
            showParameter.getCustomParams().put("paymentType", this.getPageCache().get("paymentType"));
            String formId = this.getPageCache().get("formId");
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                showParameter.setFormId(formId);
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void cancelPay() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            LinkedList<Long> paymentBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
            DynamicObjectCollection payobjs = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno,isvoucher,billstatus,org.id", (QFilter[])new QFilter[]{payPidFilter});
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            Map<Long, List<DynamicObject>> groupOrg = payobjs.stream().collect(Collectors.groupingBy(o -> o.getLong("org.id")));
            Set orgIds = payobjs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
            Map orgSysMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs116");
            for (Map.Entry<Long, List<DynamicObject>> entry : groupOrg.entrySet()) {
                int size;
                int CS114;
                Long orgId = entry.getKey();
                int n = CS114 = EmptyUtil.isEmpty(orgSysMap.get(String.valueOf(orgId))) ? 0 : Integer.parseInt((String)orgSysMap.get(String.valueOf(orgId)));
                if (3 != CS114) continue;
                List<DynamicObject> value = entry.getValue();
                Map<Long, String> idBillNoMap = value.stream().collect(Collectors.toMap(s -> s.getLong("id"), v -> v.getString("billno")));
                List existList = VoucherBookHelper.getVoucherExistIds(idBillNoMap.keySet(), (String)"cas_paybill");
                flag = size = existList.size();
                if (size <= 0) continue;
                for (Long id : existList) {
                    String billno = idBillNoMap.get(id);
                    sb.append(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\r\n", (String)"PaymentBillList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno));
                }
            }
            if (flag == 1) {
                this.getView().showConfirm(sb.substring(0, sb.length() - 1) + "\uff0c" + ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"PaymentBillList_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else if (flag > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%d\u4e2a\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"PaymentBillList_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), flag), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else if (!CasPluginHelper.cancelCheckSettleForPay((IFormPlugin)this, (IFormView)this.getView(), paymentBillPks, (DynamicObjectCollection)payobjs).booleanValue()) {
                this.getView().invokeOperation("cancelpay");
            }
        }
    }

    private void chargeBack(List<Object> billid, String operateKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_chargeback");
        showParameter.setCustomParam("billid", (Object)JSON.toJSONString(billid));
        showParameter.setCustomParam("operateKey", (Object)operateKey);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CALLBACK_CHARGEBACK));
        this.getView().showForm(showParameter);
    }

    public static String checkLCOpen(DynamicObject settleType, String billStatus, String settletNumber) {
        String errorMsg = null;
        if (settleType != null && SettleMentTypeEnum.CREDITOPEN.getValue().equals(settleType.getString("settlementtype"))) {
            if (!"C".equals(billStatus)) {
                errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e0d\u80fd\u5f00\u7acb\u4fe1\u7528\u8bc1\u3002", (String)"PaymentBillList_43", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)settletNumber)) {
                errorMsg = ResManager.loadKDString((String)"\u7ed3\u7b97\u53f7\u5b57\u6bb5\u9009\u62e9\u4e86\u4fe1\u7528\u8bc1\u5f00\u8bc1\u5904\u7406\u5355\uff0c\u4e0d\u80fd\u518d\u5f00\u7acb\u4fe1\u7528\u8bc1\u3002", (String)"PaymentBillList_44", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
        } else {
            errorMsg = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e0d\u662f\u201c\u4fe1\u7528\u8bc1\u5f00\u8bc1\u201d\uff0c\u4e0d\u5141\u8bb8\u5f00\u7acb\u4fe1\u7528\u8bc1\u3002", (String)"PaymentBillList_45", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    public static boolean letterCreditSelect(IFormView view, CloseCallBack closeCallBack, String lcBillNo, DynamicObject[] dbDatas) {
        if (StringUtils.isEmpty((CharSequence)lcBillNo)) {
            if (dbDatas.length == 1) {
                DynamicObject dbData = dbDatas[0];
                DynamicObject settleType = dbData.getDynamicObject("settletype");
                String settletNumber = dbData.getString("settletnumber");
                if (BillStatusEnum.AUDIT.getValue().equals(dbData.getString("billstatus")) && StringUtils.isBlank((CharSequence)settletNumber) && settleType != null && SettleMentTypeEnum.CREDITOPEN.getValue().equals(settleType.getString("settlementtype"))) {
                    PayBillListPlugnHelper.showSelectCreditForm((CloseCallBack)closeCallBack, (IFormView)view, (Object)dbData.getPkValue());
                    return true;
                }
            } else {
                List lcOpenSettleList = Arrays.stream(dbDatas).filter(info -> {
                    DynamicObject settleType = info.getDynamicObject("settletype");
                    String settletNumber = info.getString("settletnumber");
                    String billStatus = info.getString("billstatus");
                    return BillStatusEnum.AUDIT.getValue().equals(billStatus) && StringUtils.isBlank((CharSequence)settletNumber) && settleType != null && SettleMentTypeEnum.CREDITOPEN.getValue().equals(settleType.getString("settlementtype"));
                }).collect(Collectors.toList());
                if (!lcOpenSettleList.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject info2 : lcOpenSettleList) {
                        String billNo = info2.getString("billno");
                        sb.append(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u201c%s\u201d\u672a\u9009\u62e9\u4fe1\u7528\u8bc1\uff0c\u8bf7\u9010\u6761\u786e\u8ba4\u4ed8\u6b3e\u5e76\u9009\u62e9\u4fe1\u7528\u8bc1\u5f00\u8bc1\u5355\u3002\r\n", (String)"ReceivingBillList_37", (String)"fi-cas-formplugin", (Object[])new Object[0]), billNo));
                    }
                    if (StringUtils.isNotBlank((CharSequence)sb)) {
                        view.showTipNotification(sb.toString());
                        return true;
                    }
                }
            }
        } else {
            view.getFormShowParameter().setCustomParam("paySelectLcNo", (Object)lcBillNo);
        }
        return false;
    }

    public void signCallback(SignCallbackEvent evt) {
        PluginSignHelper.signCallBack((SignCallbackEvent)evt, (IFormView)this.getView(), (Boolean)true);
    }

    private void integrateValidate(BeforeItemClickEvent evt, ListSelectedRowCollection selectRows) {
        if (EmptyUtil.isEmpty((Collection)selectRows)) {
            return;
        }
        Object[] primaryKeyValues = selectRows.getPrimaryKeyValues();
        QFilter historyFilter = new QFilter("id", "in", (Object)primaryKeyValues).and("ishistory", "=", (Object)"1");
        DynamicObjectCollection historyRecBills = QueryServiceHelper.query((String)"cas_paybill", (String)"billno", (QFilter[])historyFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)historyRecBills)) {
            String payBillNoStr = historyRecBills.stream().map(payBill -> payBill.getString("billno")).collect(Collectors.joining(","));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \u4e3a\u5386\u53f2\u96c6\u6210\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\u3002", (String)"PaymentBillList_46", (String)"fi-cas-formplugin", (Object[])new Object[0]), payBillNoStr));
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }
}

