/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.fi.cas.business.util.PayeeInfoHelper;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentCashPayeeInfoEdit
extends BillEditPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.processPayeeInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "settletype": {
                DynamicObject billType = this.getDynamicObject("billtype");
                if (!PayeeInfoHelper.isPaymentBill((DynamicObject)billType)) break;
                DynamicObject oldSettleType = (DynamicObject)oldValue;
                DynamicObject newSettleType = (DynamicObject)newValue;
                boolean oldIsCash = BaseDataHelper.isSettleTypeCash((DynamicObject)oldSettleType);
                boolean newIsCash = BaseDataHelper.isSettleTypeCash((DynamicObject)newSettleType);
                if (oldIsCash && newIsCash || !oldIsCash && !newIsCash) break;
                long payeeId = EmptyUtil.isNoEmpty((Object)this.getValue("payee")) ? Long.parseLong(this.getValue("payee").toString()) : 0L;
                String payeeType = (String)this.getValue("payeetype");
                if ((!newIsCash || !PayeeInfoHelper.useCashAccount((DynamicObject)newSettleType, (long)payeeId, (String)payeeType)) && (!oldIsCash || !PayeeInfoHelper.useCashAccount((DynamicObject)oldSettleType, (long)payeeId, (String)payeeType))) break;
                this.clearPayeeValue();
                break;
            }
            case "payeetype": {
                this.processPayeeInfo();
            }
        }
    }

    private void processPayeeInfo() {
        DynamicObject billType = this.getDynamicObject("billtype");
        if (PayeeInfoHelper.isPaymentBill((DynamicObject)billType)) {
            boolean isCash = PayeeInfoHelper.useCashAccount((DynamicObject)((DynamicObject)this.getValue("settletype")), (long)(EmptyUtil.isNoEmpty((Object)this.getValue("payee")) ? Long.parseLong(this.getValue("payee").toString()) : 0L), (String)((String)this.getValue("payeetype")));
            this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"payeebanknamev", "payeebanknamelb"});
        }
    }

    private void clearPayeeValue() {
        Label payeebanknumvLable = (Label)this.getControl("payeebanknumv");
        payeebanknumvLable.setText("");
        this.setValue("payeeaccformid", null);
        this.setValue("payeeacctbank", null);
        this.setValue("payeebanknum", null);
        this.setValue("payeebank", null);
        this.setValue("payeebankname", null);
        this.setValue("recbanknumber", null);
    }
}

