/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.OpenOrgHandle;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.IfmHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivPayeeInfoEdit
extends DynamicFormPlugin {
    private static String[] temp = new String[]{"normal", "freeze", "closing", "changing"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
    }

    private void initF7() {
        this.fillOrgF7();
        this.fillPayeeAcctBank();
        this.fillPayeeAcctCash();
        this.fillPayeeBank();
        new OpenOrgHandle(this).fillOpenOrg((BasedataEdit)this.getControl("openorg"));
    }

    private void fillOrgF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Set orgIdList = null;
            if ("ifm".equals(this.getView().getParentView().getFormShowParameter().getAppId())) {
                orgIdList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)"ifm", (String)"cas_recbill", (String)"47156aff000000ac");
                List scOrgIds = IfmHelper.getSettleCenterOrgIds();
                orgIdList.retainAll(scOrgIds);
            } else {
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                orgIdList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_recbill", (String)"47156aff000000ac");
            }
            showParameter.setCustomParam("range", (Object)orgIdList);
        });
    }

    private void fillPayeeAcctBank() {
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("accountbank");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject currency;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject org = this.getDynamicObject("org");
            Boolean virtual = (Boolean)this.getView().getFormShowParameter().getCustomParam("virtual");
            Object receivingBill = this.getView().getFormShowParameter().getCustomParam("ReceivingBill");
            if (org != null) {
                showParameter.setCustomParam("org", (Object)org.getLong("id"));
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                long orgID = org.getPkValue() == null ? 0L : Long.parseLong(org.getPkValue().toString());
                QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgID);
                filters.add(accountAuthAssignFilter);
                QFilter qFilter = new QFilter("acctstatus", "in", (Object)temp);
                filters.add(qFilter);
                if (CasHelper.isNotEmpty((Object)virtual) && virtual.booleanValue()) {
                    filters.add(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)virtual));
                }
                showParameter.getListFilterParameter().setQFilters(filters);
                showParameter.setCustomParam("filterTransferViewOrg", (Object)"1");
                showParameter.setUseOrgId(org.getLong("id"));
            } else {
                QFilter tQFilter = AccountBankHelper.getUsableFilter();
                if (CasHelper.isNotEmpty((Object)virtual) && virtual.booleanValue()) {
                    tQFilter.and(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)virtual));
                }
                showParameter.getListFilterParameter().setFilter(tQFilter);
            }
            if (this.isBotpCreate() && (currency = (DynamicObject)this.getView().getParentView().getModel().getValue("currency")) != null) {
                QFilter filter = new QFilter("currency.fbasedataid.id", "=", currency.getPkValue());
                if (CasHelper.isNotEmpty((Object)virtual) && virtual.booleanValue()) {
                    filter.and(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)virtual));
                }
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
            if (null != receivingBill) {
                DynamicObject[] ifmSetCenters = BusinessDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter", (QFilter[])new QFilter[]{new QFilter("usestatus", "=", (Object)"1")});
                List CenterIds = Stream.of(ifmSetCenters).map(v -> v.get("settlecenter.id")).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{new QFilter("finorg.id", "in", CenterIds)});
                List innerAcctIds = Stream.of(dynamicObjects).map(v -> v.get("id")).collect(Collectors.toList());
                QFilter filter = new QFilter("inneracct.id", "not in", innerAcctIds);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
            String filterIsElec = "0";
            IDataModel parentModel = this.getView().getParentView().getModel();
            if (parentModel.getDataEntity().containsProperty("businesstype")) {
                DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
                boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
                String businessType = (String)parentModel.getValue("businesstype");
                if (isDcep && PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                    filterIsElec = "1";
                }
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("iselecpayment", "=", (Object)filterIsElec));
        });
    }

    private void fillPayeeAcctCash() {
        BasedataEdit payeeAcctCashF7 = (BasedataEdit)this.getControl("accountcash");
        payeeAcctCashF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            LspWapper lspWapper = new LspWapper(beforeF7SelectEvent);
            lspWapper.setFilters(AccountCashHelper.getUsableAccountFilter((Long)this.getPk("org")));
        });
    }

    private void fillPayeeBank() {
        BasedataEdit payerbankF7 = (BasedataEdit)this.getControl("payeebank");
        payerbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        String sourceBillType;
        IDataEntityProperty sourcebilltypeProp;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            this.setValue(propName, parentModel.getValue(propName));
        }
        IDataEntityProperty settletypeProp = parentModel.getProperty("settletype");
        if (settletypeProp != null) {
            DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            this.getView().setVisible(Boolean.valueOf(isCash), new String[]{"accountcash"});
            this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"accountbank", "payeebank"});
            if (isCash) {
                Object accountcash = parentModel.getValue("accountcash");
                this.setValue("accountcash", accountcash == null ? AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payee") : accountcash);
            }
        }
        if ((sourcebilltypeProp = parentModel.getProperty("sourcebilltype")) != null && ("ar_finarbill".equals(sourceBillType = (String)parentModel.getValue("sourcebilltype")) || "sm_salorder".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType) || "lc_present".equals(sourceBillType))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "org": {
                this.orgF7Changed((DynamicObject)newValue);
                new OpenOrgHandle(this).setOpenOrg();
                break;
            }
            case "accountbank": {
                this.payerAcctBankF7Changed((DynamicObject)newValue);
                DynamicObject openOrg = (DynamicObject)this.getModel().getValue("openorg");
                if (openOrg != null) break;
                new OpenOrgHandle(this).setOpenOrg();
            }
        }
    }

    private void orgF7Changed(DynamicObject org) {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataEntityProperty settletypeProp = parentModel.getProperty("settletype");
        if (settletypeProp == null) {
            return;
        }
        DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payee"));
        } else {
            DynamicObject defaultRecAccount = null;
            if (org != null) {
                QFilter qFilter = new QFilter("createorg", "in", org.getPkValue()).and(new QFilter("acctstatus", "=", (Object)"normal"));
                defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            }
            this.setValue("accountbank", defaultRecAccount);
        }
    }

    private void payerAcctBankF7Changed(DynamicObject payerAcctBank) {
        if (payerAcctBank != null) {
            this.setValue("payeebank", payerAcctBank.get("bank"));
        } else {
            this.setValue("payeebank", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                if (CasHelper.isEmpty((Object)this.getModel().getValue("org"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivPayeeInfoEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.btnOk();
            }
        }
    }

    private void btnOk() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        resultMap.put("org", model.getValue("org"));
        resultMap.put("accountbank", model.getValue("accountbank"));
        resultMap.put("accountcash", model.getValue("accountcash"));
        resultMap.put("payeebank", model.getValue("payeebank"));
        resultMap.put("openorg", model.getValue("openorg"));
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }
}

