/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;

public class RectranscompanyEdit
extends DynamicFormPlugin
implements ClickListener {
    private DynamicObject receivable;
    private long receivId;
    private BigDecimal exchangeRate;

    public void initialize() {
        this.addClickListeners(new String[]{"addrow"});
        this.addClickListeners(new String[]{"deleterow"});
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.receivId = Long.parseLong(customParams.get("receId").toString());
        this.receivable = BusinessDataServiceHelper.loadSingle((Object)this.receivId, (String)"cas_recbill");
        this.exchangeRate = this.receivable.getBigDecimal("exchangerate");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.receivId = Long.parseLong(customParams.get("receId").toString());
        this.setValue("receivableid", this.receivId);
        this.receivable = BusinessDataServiceHelper.loadSingle((Object)this.receivId, (String)"cas_recbill");
        DynamicObjectCollection entrycoll = this.receivable.getDynamicObjectCollection("entry");
        IDataModel dataModel = this.getModel();
        for (DynamicObject receivablebill : entrycoll) {
            int entryIndex = dataModel.createNewEntryRow("entry") - 1;
            this.setValue("realreccompany", receivablebill.getDynamicObject("realreccompany"), entryIndex);
            this.setValue("e_actamt", receivablebill.getBigDecimal("e_actamt"), entryIndex);
            this.setValue("e_localamt", receivablebill.getBigDecimal("e_localamt"), entryIndex);
            this.setValue("e_fundflowitem", receivablebill.getDynamicObject("e_fundflowitem"), entryIndex);
            this.setValue("e_remark", receivablebill.getString("e_remark"), entryIndex);
        }
        if (entrycoll.size() > 0) {
            int count = this.getModel().getEntryRowCount("entry");
            this.getModel().deleteEntryRow("entry", count - 1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "e_actamt": {
                this.entries_actAmtChanged(e);
            }
        }
    }

    private void entries_actAmtChanged(PropertyChangedArgs e) {
        int count = this.getModel().getEntryCurrentRowIndex("entry");
        int precision = 2;
        DynamicObject r = this.getModel().getEntryRowEntity("entry", count);
        if (r.get("e_actamt") != null) {
            BigDecimal actamt = r.getBigDecimal("e_actamt");
            BigDecimal localAmt = actamt.multiply(this.exchangeRate).setScale(precision, 4);
            this.setValue("e_localamt", localAmt, count);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "addrow": {
                this.addrow();
                break;
            }
            case "deleterow": {
                this.delrow();
            }
        }
    }

    private void addrow() {
        this.getModel().createNewEntryRow("entry");
    }

    private void delrow() {
        int currenctIndex = this.getModel().getEntryCurrentRowIndex("entry");
        this.getModel().deleteEntryRow("entry", currenctIndex);
        int count = this.getModel().getEntryRowCount("entry");
        if (count == 0) {
            this.getModel().createNewEntryRow("entry");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        int count = this.getModel().getEntryRowCount("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject rectranscompany = this.getModel().getEntryRowEntity("entry", i);
            sumAmt = sumAmt.add(rectranscompany.getBigDecimal("e_actamt"));
        }
        if (sumAmt.compareTo(this.receivable.getBigDecimal("actrecamt")) != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u91d1\u989d\u4e0d\u7b49\u4e8e\u6536\u6b3e\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u3002", (String)"RectranscompanyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("confirm".equalsIgnoreCase(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5b9e\u9645\u6536\u6b3e\u7ec4\u7ec7\u6210\u529f\u3002", (String)"RectranscompanyEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("close");
        }
    }
}

