/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class ReportConfigPlugin
extends AbstractReportFormPlugin {
    private static final String REPORTLISTAP = "reportlistap";
    private static final String CONFIGUREREPORT = "configurereport";
    private static final String REPORTCOLUMNSMAP = "reportcolumnsmap";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (CONFIGUREREPORT.equals(key)) {
            this.openForm();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void openForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_ide_reportconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityId = this.getView().getEntityId();
        String useConfigKey = entityId + "_" + REPORTLISTAP + "_" + REPORTCOLUMNSMAP;
        String userId = RequestContext.get().getUserId();
        String columnsSetting = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)useConfigKey);
        ReportList reportList = (ReportList)this.getControl(REPORTLISTAP);
        List columns = reportList.getColumns();
        if (columnsSetting != null) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)columnsSetting);
            for (AbstractReportColumn column : columns) {
                ReportColumn c;
                if (!(column instanceof ReportColumn) || map.get((c = (ReportColumn)column).getFieldKey()) == null) continue;
                c.setHide(((Boolean)map.get(c.getFieldKey())).booleanValue());
            }
        }
        showParameter.setCustomParam("reportcolumns", (Object)SerializationUtils.serializeToBase64((Object)columns));
        showParameter.setCustomParam("entityId", (Object)entityId);
        showParameter.setCustomParam("controlKey", (Object)REPORTLISTAP);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), CONFIGUREREPORT));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String action;
        Map result;
        if (CONFIGUREREPORT.equalsIgnoreCase(evt.getActionId()) && (result = (Map)evt.getReturnData()) != null && CONFIGUREREPORT.equals(action = (String)result.get("action"))) {
            String columnsStr = (String)result.get(REPORTCOLUMNSMAP);
            String userId = RequestContext.get().getUserId();
            String key = result.get("entityId") + "_" + result.get("controlKey") + "_" + REPORTCOLUMNSMAP;
            UserConfigServiceHelper.setSetting((long)Long.parseLong(userId), (String)key, (String)columnsStr);
            this.getView().refresh();
        }
    }
}

