/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;

public class WriteBackConfigEdit
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("number", (Object)this.genNumber());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("number", (Object)this.genNumber());
    }

    private String genNumber() {
        return "WBConfig-";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("targetentity".equals(key) || "sourceentity".equals(key)) {
            DynamicObject targetEntity = (DynamicObject)this.getModel().getValue("targetentity");
            DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue("sourceentity");
            if (targetEntity != null && sourceEntity != null) {
                String targetName = targetEntity.getString("name");
                String sourceName = sourceEntity.getString("name");
                String configName = String.format(ResManager.loadKDString((String)"%1$S\u53cd\u5199%2$s\u914d\u7f6e", (String)"WriteBackConfigEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), targetName, sourceName);
                this.getModel().setValue("name", (Object)configName);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "saveandnew".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entry");
            if (entryList.isEmpty()) {
                return;
            }
            Map<String, List<DynamicObject>> operationMap = entryList.stream().collect(Collectors.groupingBy(e -> e.getString("operation")));
            for (Map.Entry<String, List<DynamicObject>> entry : operationMap.entrySet()) {
                if (entry.getValue() == null || entry.getValue().size() <= 1) continue;
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"%s\uff1a\u64cd\u4f5c\u6807\u8bc6\u4e0d\u53ef\u91cd\u590d\u3002", (String)"WriteBackConfigEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msg, entry.getKey()));
                return;
            }
        }
    }
}

