/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.agentpay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.cas.helper.QuotationHelper;

public class AgentPayDiffPayPlugin
extends AbstractFormPlugin {
    private static String[] propArr = new String[]{"payamt", "agreedrate", "hasfee"};

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object currencyId = this.getView().getFormShowParameter().getCustomParam("dpcurrency");
        Object payamount = this.getView().getFormShowParameter().getCustomParam("payamount");
        Object payamt = this.getView().getFormShowParameter().getCustomParam("payamt");
        Object agreedrate = this.getView().getFormShowParameter().getCustomParam("agreedrate");
        Object agreedquotation = this.getView().getFormShowParameter().getCustomParam("agreedquotation");
        this.getModel().setValue("dpcurrency", currencyId);
        this.getModel().setValue("payamount", payamount);
        this.getModel().setValue("payamt", payamt);
        this.getModel().setValue("agreedrate", agreedrate);
        this.getModel().setValue("agreedquotation", agreedquotation);
        this.updateActualInfo();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getControl("btnok");
        btnOk.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                BigDecimal fee = (BigDecimal)AgentPayDiffPayPlugin.this.getModel().getValue("fee");
                if (fee.compareTo(new BigDecimal(0)) < 0) {
                    AgentPayDiffPayPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u7eed\u8d39\u4e0d\u53ef\u4e3a\u8d1f\u6570\u3002", (String)"AgentPayDiffPayPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("dpcurrency", AgentPayDiffPayPlugin.this.getModel().getValue("dpcurrency"));
                dataMap.put("payamt", AgentPayDiffPayPlugin.this.getModel().getValue("payamt"));
                dataMap.put("agreedrate", AgentPayDiffPayPlugin.this.getModel().getValue("agreedrate"));
                dataMap.put("dpamt", AgentPayDiffPayPlugin.this.getModel().getValue("dpamt"));
                dataMap.put("fee", AgentPayDiffPayPlugin.this.getModel().getValue("fee"));
                dataMap.put("agreedquotation", AgentPayDiffPayPlugin.this.getModel().getValue("agreedquotation"));
                AgentPayDiffPayPlugin.this.getView().returnDataToParent(dataMap);
                AgentPayDiffPayPlugin.this.getView().close();
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (Arrays.asList(propArr).contains(propName)) {
            Boolean hasfee = (Boolean)this.getModel().getValue("hasfee");
            if (hasfee.booleanValue()) {
                this.updateActualInfo();
            } else {
                this.updateActualInfo(propName);
            }
        }
    }

    private void updateActualInfo() {
        BigDecimal payAmt = (BigDecimal)this.getModel().getValue("payamt");
        BigDecimal agreeRate = (BigDecimal)this.getModel().getValue("agreedrate");
        BigDecimal payamount = (BigDecimal)this.getModel().getValue("payamount");
        String agreedquotation = (String)this.getModel().getValue("agreedquotation");
        DynamicObject cry = (DynamicObject)this.getModel().getValue("dpcurrency");
        if (payAmt != null && agreeRate != null && BigDecimal.ZERO.compareTo(payAmt) != 0 && BigDecimal.ZERO.compareTo(agreeRate) != 0) {
            int round = 10;
            if (cry != null) {
                round = cry.getInt("amtprecision");
            }
            BigDecimal dpAmt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreeRate, (String)agreedquotation, (int)round);
            this.getModel().setValue("dpamt", (Object)dpAmt);
            this.getModel().setValue("fee", (Object)payAmt.add(dpAmt.negate()));
        }
    }

    private void updateActualInfo(String propName) {
        BigDecimal payAmt = (BigDecimal)this.getModel().getValue("payamt");
        BigDecimal agreeRate = (BigDecimal)this.getModel().getValue("agreedrate");
        BigDecimal payamount = (BigDecimal)this.getModel().getValue("payamount");
        String agreedquotation = (String)this.getModel().getValue("agreedquotation");
        DynamicObject cry = (DynamicObject)this.getModel().getValue("dpcurrency");
        if (payAmt == null || agreeRate == null || BigDecimal.ZERO.compareTo(payAmt) == 0 || BigDecimal.ZERO.compareTo(agreeRate) == 0) {
            return;
        }
        int round = 10;
        if (cry != null) {
            round = cry.getInt("amtprecision");
        }
        switch (propName) {
            case "payamt": {
                this.getModel().beginInit();
                this.getModel().setValue("dpamt", (Object)payAmt);
                BigDecimal agreedRate = "0".equals(agreedquotation) ? payAmt.divide(payamount, 10, RoundingMode.HALF_UP) : payamount.divide(payAmt, 10, RoundingMode.HALF_UP);
                this.getModel().setValue("agreedrate", (Object)agreedRate);
                this.getModel().endInit();
                this.getView().updateView("dpamt");
                this.getView().updateView("agreedrate");
                break;
            }
            case "agreedrate": {
                this.getModel().setValue("agreedrate", (Object)agreeRate);
                this.dealDpAmtAndPayAmt(payamount, agreeRate, agreedquotation, round);
                break;
            }
            case "hasfee": {
                this.getModel().setValue("fee", (Object)BigDecimal.ZERO);
                this.dealDpAmtAndPayAmt(payamount, agreeRate, agreedquotation, round);
            }
        }
    }

    private void dealDpAmtAndPayAmt(BigDecimal payamount, BigDecimal agreeRate, String agreedquotation, int round) {
        BigDecimal amt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreeRate, (String)agreedquotation, (int)round);
        this.getModel().beginInit();
        this.getModel().setValue("dpamt", (Object)amt);
        this.getModel().setValue("payamt", (Object)amt);
        this.getModel().endInit();
        this.getView().updateView("dpamt");
        this.getView().updateView("payamt");
    }
}

