/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.agentpay.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;

public class AgentPayBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(AgentPayBillConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject dpCurrency;
            DynamicObject currency;
            DynamicObject org;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            targetBill.set("payeetypelist", targetBill.get("payeetype"));
            this.supplePayeeInfo(targetBill);
            DynamicObject payerAcctBank = targetBill.getDynamicObject("payeracctbank");
            if (payerAcctBank != null && CasHelper.isNotEmpty((Object)(payerAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAcctBank.getPkValue(), (String)"bd_accountbanks")))) {
                this.setValueIfAbsent(targetBill, "payerbank", payerAcctBank.getDynamicObject("bank"));
                this.setValueIfAbsent(targetBill, "openorg", payerAcctBank.getDynamicObject("openorg"));
            }
            if ((org = targetBill.getDynamicObject("org")) == null) continue;
            long orgId = org.getLong("id");
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (baseCurrency != null) {
                targetBill.set("basecurrency", (Object)baseCurrency);
            }
            if ((currency = targetBill.getDynamicObject("currency")) != null && CasHelper.isNotEmpty((Object)(currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency")))) {
                targetBill.set("currency", (Object)currency);
            }
            if ((dpCurrency = targetBill.getDynamicObject("dpcurrency")) != null && CasHelper.isNotEmpty((Object)(dpCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)dpCurrency.getPkValue(), (String)"bd_currency")))) {
                targetBill.set("dpcurrency", (Object)dpCurrency);
            }
            this.setPayCountryValue(targetBill);
            if (CasHelper.isEmpty((Object)targetBill.getDynamicObject("exratetable"))) {
                this.setDefaultExratetable(targetBill, orgId);
            }
            this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
            BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
            if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                exchangeRate = BigDecimal.ONE;
                if (currency != null && baseCurrency != null) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                targetBill.set("exchangerate", (Object)exchangeRate);
            }
            if (CasHelper.isEmpty((Object)targetBill.getString("paymentchannel"))) {
                this.setPaymentChannelValue(targetBill, payerAcctBank);
            }
            this.setDiffPayInfo(targetBill, orgId);
            this.calculateAmt(targetBill);
            this.setEncodeAmount(targetBill);
        }
    }

    private void setPaymentChannelValue(DynamicObject targetBill, DynamicObject payerAcctBank) {
        String defChannel = "";
        DynamicObject settletype = targetBill.getDynamicObject("settletype");
        if (settletype != null) {
            settletype = BusinessDataServiceHelper.loadSingleFromCache((Object)settletype.getPkValue(), (String)"bd_settlementtype", (String)"settlementtype");
        }
        defChannel = payerAcctBank == null || settletype != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settletype.getString("settlementtype")) ? PaymentChannelEnum.COUNTER.getValue() : (payerAcctBank.getBoolean("isopenbank") ? PaymentChannelEnum.ONLINEBANK.getValue() : (payerAcctBank.getBoolean("issetbankinterface") ? PaymentChannelEnum.BEI.getValue() : PaymentChannelEnum.COUNTER.getValue()));
        targetBill.set("paymentchannel", (Object)defChannel);
    }

    private void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }

    private void setDiffPayInfo(DynamicObject targetBill, Long orgId) {
        DynamicObject dpCurrency = targetBill.getDynamicObject("dpcurrency");
        if (targetBill.getBoolean("isdiffcur") && CasHelper.isNotEmpty((Object)dpCurrency)) {
            BigDecimal agreedRate;
            BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
            if (CasHelper.isEmpty((Object)dpExchangeRate) || dpExchangeRate.compareTo(BigDecimal.ONE) == 0) {
                dpExchangeRate = BigDecimal.ONE;
                DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
                if (CasHelper.isNotEmpty((Object)baseCurrency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = dpCurrency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            dpExchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                targetBill.set("dpexchangerate", (Object)dpExchangeRate);
            }
            if (CasHelper.isEmpty((Object)(agreedRate = targetBill.getBigDecimal("agreedrate"))) || agreedRate.compareTo(BigDecimal.ONE) == 0) {
                agreedRate = BigDecimal.ONE;
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (CasHelper.isNotEmpty((Object)currency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = dpCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            agreedRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                targetBill.set("agreedrate", (Object)agreedRate);
            }
        } else {
            targetBill.set("dpcurrency", targetBill.get("currency"));
            targetBill.set("dpexchangerate", targetBill.get("exchangerate"));
            targetBill.set("agreedrate", (Object)BigDecimal.ONE);
        }
    }

    private void calculateAmt(DynamicObject targetBill) {
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (DynamicObject rowInfo : entry) {
            if (rowInfo.get("e_amount") == null) continue;
            BigDecimal amount = rowInfo.getBigDecimal("e_amount");
            sumAmt = sumAmt.add(amount);
            BigDecimal localamt = BigDecimal.ZERO;
            localamt = basecurrency != null ? amount.multiply(exchangeRate).setScale(basecurrency.getInt("amtprecision"), 4) : amount.multiply(exchangeRate);
            rowInfo.set("e_localamt", (Object)localamt);
            sumLocalAmt = sumLocalAmt.add(localamt);
        }
        targetBill.set("payamount", (Object)sumAmt);
        targetBill.set("localamt", (Object)sumLocalAmt);
        this.calculateDpAmt(targetBill);
    }

    private void calculateDpAmt(DynamicObject targetBill) {
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        BigDecimal payamount = targetBill.getBigDecimal("payamount");
        if (currency != null) {
            payamount = payamount.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        BigDecimal agreedRate = targetBill.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = BigDecimal.ZERO;
        dpAmt = dpcurrency != null ? payamount.multiply(agreedRate).setScale(dpcurrency.getInt("amtprecision"), 4) : payamount.multiply(agreedRate);
        BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = BigDecimal.ZERO;
        dpLocalAmt = basecurrency != null ? dpAmt.multiply(dpExchangeRate).setScale(basecurrency.getInt("amtprecision"), 4) : dpAmt.multiply(dpExchangeRate);
        targetBill.set("dpamt", (Object)dpAmt);
        targetBill.set("dplocalamt", (Object)dpLocalAmt);
        targetBill.set("lossamt", (Object)localAmt.subtract(dpLocalAmt));
        this.calculateEntryDpAmt(targetBill);
    }

    private void calculateEntryDpAmt(DynamicObject targetBill) {
        Boolean isDiffCur = targetBill.getBoolean("isdiffcur");
        if (!isDiffCur.booleanValue()) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (DynamicObject row : entry) {
            int rowIdx = row.getInt("seq") - 1;
            BigDecimal amount = row.getBigDecimal("e_amount");
            if (amount == null || amount.compareTo(new BigDecimal(0)) <= 0) continue;
            rowIndexs.add(rowIdx);
        }
        int size = rowIndexs.size();
        if (size <= 0) {
            return;
        }
        BigDecimal dpamt = targetBill.getBigDecimal("dpamt");
        BigDecimal dplocalamt = targetBill.getBigDecimal("dplocalamt");
        BigDecimal dpexchangerate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal agreedrate = targetBill.getBigDecimal("agreedrate");
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        BigDecimal sumDpamt = BigDecimal.ZERO;
        BigDecimal sumDpLocalamt = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            int rowIdx = (Integer)rowIndexs.get(i);
            DynamicObject row = (DynamicObject)entry.get(rowIdx);
            BigDecimal edpamt = BigDecimal.ZERO;
            BigDecimal edplocalamt = BigDecimal.ZERO;
            if (i == size - 1) {
                edpamt = dpamt.subtract(sumDpamt);
                edplocalamt = dplocalamt.subtract(sumDpLocalamt);
            } else {
                BigDecimal eamount = row.getBigDecimal("e_amount");
                edpamt = dpcurrency != null ? eamount.multiply(agreedrate).setScale(dpcurrency.getInt("amtprecision"), 4) : eamount.multiply(agreedrate);
                sumDpamt = sumDpamt.add(edpamt);
                edplocalamt = basecurrency != null ? edpamt.multiply(dpexchangerate).setScale(basecurrency.getInt("amtprecision"), 4) : edpamt.multiply(dpexchangerate);
                sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
            }
            row.set("e_dpamt", (Object)edpamt);
            row.set("e_dplocalamt", (Object)edplocalamt);
        }
    }

    private void setPayCountryValue(DynamicObject targetBill) {
        DynamicObject payerBank = targetBill.getDynamicObject("payerbank");
        if (payerBank != null && CasHelper.isEmpty((Object)targetBill.getDynamicObject("paycountry")) && CasHelper.isNotEmpty((Object)(payerBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerBank.getPkValue(), (String)"bd_finorginfo", (String)"id,country")))) {
            targetBill.set("paycountry", (Object)payerBank.getDynamicObject("country"));
        }
    }

    private void supplePayeeInfo(DynamicObject targetBill) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject rowInfo : entry) {
            DynamicObject payee;
            DynamicObject bebank;
            DynamicObject payeebank = rowInfo.getDynamicObject("payeebank");
            if (CasHelper.isNotEmpty((Object)payeebank) && CasHelper.isNotEmpty((Object)(bebank = BusinessDataServiceHelper.loadSingleFromCache((Object)payeebank.getPkValue(), (String)"bd_bebank")))) {
                this.setValueIfAbsent(rowInfo, "payeebanknumber", bebank.getString("union_number"));
                this.setValueIfAbsent(rowInfo, "reccountry", bebank.getDynamicObject("country") == null ? null : bebank.getDynamicObject("country").getPkValue());
                this.setValueIfAbsent(rowInfo, "recprovince", bebank.getString("provincetxt"));
                this.setValueIfAbsent(rowInfo, "reccity", bebank.getString("citytxt"));
                this.setValueIfAbsent(rowInfo, "recswiftcode", bebank.getString("swift_code"));
                this.setValueIfAbsent(rowInfo, "recroutingnum", bebank.getString("routingnum"));
                this.setValueIfAbsent(rowInfo, "recothercode", bebank.getString("other_code"));
                this.setValueIfAbsent(rowInfo, "recbankaddress", bebank.getString("address_eng"));
            }
            if (!"other".equals(this.getPayeeType(targetBill))) {
                rowInfo.set("importpayeetype", (Object)this.getPayeeType(targetBill));
            }
            if (!CasHelper.isNotEmpty((Object)(payee = rowInfo.getDynamicObject("payee"))) || !this.isPayeeCustomer(targetBill) && !this.isPayeeSupplier(targetBill)) continue;
            Map<String, Object> resultMap = this.getPayeeInfo(payee.getPkValue(), this.getPayeeType(targetBill));
            this.setValueIfAbsent(rowInfo, "recemail", resultMap.get("payeeemail"));
            this.setValueIfAbsent(rowInfo, "recaddress", resultMap.get("payeeaddress"));
        }
    }

    private Map<String, Object> getPayeeInfo(Object payeeOrPayer, String payeeType) {
        DynamicObjectCollection addressls;
        DynamicObject supplierCustDO;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        String addressPropName = "";
        if ("bd_supplier".equals(payeeType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        } else if ("bd_customer".equals(payeeType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        } else {
            return resultMap;
        }
        if (!(CasHelper.isEmpty((Object)entityNameTemp) || CasHelper.isEmpty((Object)payeeOrPayer) || CasHelper.isEmpty((Object)(supplierCustDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeOrPayer, (String)entityNameTemp, (String)("entry_address." + addressPropName)))) || (addressls = supplierCustDO.getDynamicObjectCollection("entry_address")) == null || addressls.size() <= 0)) {
            HashSet<Object> addressIds = new HashSet<Object>();
            for (DynamicObject a : addressls) {
                addressIds.add(a.get(addressPropName + "_id"));
            }
            DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
            if (addresses != null) {
                for (DynamicObject address : addresses) {
                    if (!address.getBoolean("default")) continue;
                    resultMap.put("payeeemail", address.getString("addemail"));
                    resultMap.put("payeeaddress", address.getString("detailaddress"));
                    break;
                }
            }
        }
        return resultMap;
    }

    private void setEncodeAmount(DynamicObject targetBill) {
        if (targetBill.getBoolean("isencryption") && "BOTP".equals(targetBill.getString("source"))) {
            DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
            if (entry == null || entry.size() <= 0) {
                return;
            }
            for (DynamicObject action : entry) {
                BigDecimal loaclAmount;
                BigDecimal amount = action.getBigDecimal("e_amount");
                if (amount != null) {
                    String encrptyAmountStr = AgentPayBillHelper.encodeAmount((BigDecimal)amount);
                    action.set("e_encryptamount", (Object)encrptyAmountStr);
                }
                if ((loaclAmount = action.getBigDecimal("e_localamt")) == null) continue;
                String encrptyLocalAmountStr = AgentPayBillHelper.encodeAmount((BigDecimal)loaclAmount);
                action.set("e_encryptlocalamt", (Object)encrptyLocalAmountStr);
            }
        }
    }

    private boolean isPayeeCustomer(DynamicObject targetBill) {
        return "bd_customer".equals(this.getPayeeType(targetBill));
    }

    private boolean isPayeeSupplier(DynamicObject targetBill) {
        return "bd_supplier".equals(this.getPayeeType(targetBill));
    }

    private String getPayeeType(DynamicObject targetBill) {
        return targetBill.getString("payeetypelist");
    }

    public void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }
}

