/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.balance;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.enums.BalanceModelMeta;
import kd.fi.cas.business.balancemodel.calculate.service.CalculateBalanceServiceService;
import kd.fi.cas.business.balancemodel.check.BalanceCheckResult;
import kd.fi.cas.business.balancemodel.check.BalanceModelCheckHelper;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.util.EmptyUtil;

public class RecomputeBalancePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RecomputeBalancePlugin.class);
    private static final String BTN_ONE_OK = "btnok";
    private static final String BTN_ALL_OK = "btnallok";
    private static final String BTN_ONE_CHECK = "btncheck";
    private static final String CHECK = "check";
    private static final String RECAL = "recal";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ONE_OK});
        this.addClickListeners(new String[]{BTN_ALL_OK});
        this.addClickListeners(new String[]{BTN_ONE_CHECK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formName = (String)customParams.get("balanceFormName");
        logger.info("====RecomputeBalancePlugin====formName:{}", (Object)formName);
        if (formName != null) {
            if (formName.contains(BalanceModelMeta.JOURNAL.getMetaName())) {
                this.getModel().setValue("balanceformname", (Object)BalanceModelMeta.JOURNAL.getMetaName());
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountcash"});
            } else if (formName.contains(BalanceModelMeta.CASH.getMetaName())) {
                this.getModel().setValue("balanceformname", (Object)BalanceModelMeta.CASH.getMetaName());
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountbank"});
            } else if (formName.contains(BalanceModelMeta.STATE.getMetaName())) {
                this.getModel().setValue("balanceformname", (Object)BalanceModelMeta.STATE.getMetaName());
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountcash"});
            }
        }
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        Map showParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyUtil.isNoEmpty(showParams.get(CHECK)) && ((Boolean)showParams.get(CHECK)).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ALL_OK, BTN_ONE_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ONE_CHECK});
        }
        if (EmptyUtil.isNoEmpty(showParams.get(RECAL)) && ((Boolean)showParams.get(RECAL)).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ALL_OK, BTN_ONE_OK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ONE_CHECK});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (this.checkValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u6ca1\u6709\u5f55\u3002", (String)"RecomputeBalancePlugin_02", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        RequestBalanceParameter parameter = this.getParameter(key);
        Map showParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyUtil.isNoEmpty(showParams.get(CHECK)) && ((Boolean)showParams.get(CHECK)).booleanValue()) {
            this.doCheck(parameter);
        }
        if (EmptyUtil.isNoEmpty(showParams.get(RECAL)) && ((Boolean)showParams.get(RECAL)).booleanValue()) {
            this.doRecal(parameter);
        }
        this.getView().close();
    }

    private RequestBalanceParameter getParameter(String key) {
        if (BTN_ALL_OK.equals(key) || BTN_ONE_OK.equals(key) || BTN_ONE_CHECK.equals(key)) {
            Boolean isRecomputeCurrent = false;
            if (BTN_ALL_OK.equals(key)) {
                isRecomputeCurrent = false;
            } else if (BTN_ONE_OK.equals(key) || BTN_ONE_CHECK.equals(key)) {
                isRecomputeCurrent = true;
            }
            logger.info("====RecomputeBalancePlugin====isRecomputeCurrent:{}", (Object)isRecomputeCurrent);
            IDataModel model = this.getModel();
            RequestBalanceParameter requestBalanceParameter = new RequestBalanceParameter();
            try {
                String entityName = (String)model.getValue("balanceformname");
                DynamicObject period = (DynamicObject)model.getValue("period");
                DynamicObjectCollection accountBanks = (DynamicObjectCollection)model.getValue("accountbank");
                HashSet<Long> bankIds = new HashSet<Long>(16);
                if (accountBanks != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)accountBanks)) {
                    for (DynamicObject accountBank : accountBanks) {
                        Long accountBankId = accountBank.getLong("fbasedataid_id");
                        bankIds.add(accountBankId);
                    }
                }
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                Long currencyId = null;
                if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                    currencyId = currency.getLong("id");
                }
                DynamicObject org = (DynamicObject)model.getValue("org");
                DynamicObject createOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                createOrg.set("id", (Object)org.getLong("id"));
                requestBalanceParameter.setOrgIds(Collections.singleton(org.getLong("id")));
                if (bankIds != null && bankIds.size() > 0) {
                    requestBalanceParameter.setAccountIds(bankIds);
                }
                if (currencyId != null) {
                    requestBalanceParameter.setCurrencyIds(Collections.singleton(currencyId));
                }
                requestBalanceParameter.setStartDate(period.getDate("begindate"));
                requestBalanceParameter.setEndDate(period.getDate("enddate"));
                requestBalanceParameter.setRecomputeCurrent(isRecomputeCurrent);
                if (entityName.contains(BalanceModelMeta.JOURNAL.getMetaName())) {
                    requestBalanceParameter.setType(BalanceType.JOURNAL.getValue());
                } else if (entityName.contains(BalanceModelMeta.CASH.getMetaName())) {
                    requestBalanceParameter.setType(BalanceType.CASH.getValue());
                } else if (entityName.contains(BalanceModelMeta.STATE.getMetaName())) {
                    requestBalanceParameter.setType(BalanceType.STATE.getValue());
                }
            }
            catch (Exception ex) {
                logger.error("error:", (Throwable)ex);
            }
            return requestBalanceParameter;
        }
        return null;
    }

    private void doCheck(RequestBalanceParameter parameter) {
        BalanceCheckResult checkResult = BalanceModelCheckHelper.checkBalance((RequestBalanceParameter)parameter);
        if (!checkResult.isCheckOk()) {
            this.getPageCache().put(CHECK, JSON.toJSONString((Object)checkResult.getReCalObj()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f59\u989d\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u662f\u5426\u8fdb\u884c\u4f59\u989d\u91cd\u7b97\uff1f", (String)"RecomputeBalancePlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CHECK, (IFormPlugin)this));
        }
    }

    private void doRecal(RequestBalanceParameter parameter) {
        try {
            CalculateBalanceServiceService calculateBalanceService = CalculateBalanceServiceService.getInstance();
            calculateBalanceService.reCalculate(parameter);
        }
        catch (Exception ex) {
            logger.error("error:", (Throwable)ex);
        }
    }

    private boolean checkValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        return EmptyUtil.isEmpty((DynamicObject)org) || EmptyUtil.isEmpty((DynamicObject)period);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals(CHECK) && e.getResult() == MessageBoxResult.Yes) {
            RequestBalanceParameter reCalParam = (RequestBalanceParameter)JSON.parseObject((String)this.getPageCache().get(CHECK), RequestBalanceParameter.class);
            this.doRecal(reCalParam);
        }
        this.getPageCache().put(CHECK, null);
    }
}

