/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.calendar;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.calendar.DateUtils;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class PaymentCalendarPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final int ROW = 7;
    private static final int COL = 8;
    private static final String TIME_KEY = "datefield";
    private static final String KEY_ORG = "mulorg";
    private static final String KEY_PREVREGION = "KEY_PREVREGION";
    private static final String BTN_PREV = "prevbtn";
    private static final String BTN_NEXT = "nextbtn";
    private static final String ENTRY = "entryentity";
    private static final String BILLNAME = "billname";
    private static final String BILLNO = "billno";
    private static final String PKID = "pkId";
    private static final String BILLSTATUS = "billstatus";
    private static final String ORG = "org";
    private static final String ACCT = "acct";
    private static final String CURRENCY = "currency";
    private static final String PAYAMT = "payamt";
    private static final String DESCRIPTION = "description";
    private static final String ISPAY = "ispay";
    private static final String BG_BLUE = "rgba(85,130,243,0.1)";
    private static final String BG_WHITE = "rgb(255,255,255)";
    private static final String BG_GREY = "rgb(244,244,244)";
    private static final String LINE_SP = "&#10";

    public void afterCreateNewData(EventObject e) {
        Object currOrg = null;
        try {
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            currOrg = OrgHelper.getCurrentPermOrg((String)appId, (String)"cas_paycalendar", (String)"47150e89000000ac").getPkValue();
        }
        catch (Exception ex) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6ca1\u6709\u6709\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"PaymentCalendarPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (currOrg != null) {
            this.getModel().setValue(KEY_ORG, (Object)new Object[]{currOrg});
            this.setCalendar(new Date());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (TIME_KEY.equals(e.getProperty().getName()) || KEY_ORG.equals(e.getProperty().getName())) {
            Date datefield = (Date)this.getModel().getValue(TIME_KEY);
            if (datefield != null) {
                this.setCalendar(datefield);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PaymentCalendarPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                Container flex = (Container)this.getControl("flex_" + i + "_" + j);
                flex.addClickListener((ClickListener)this);
            }
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        Button prevBtn = (Button)this.getControl(BTN_PREV);
        prevBtn.addClickListener((ClickListener)this);
        Button nextBtn = (Button)this.getControl(BTN_NEXT);
        nextBtn.addClickListener((ClickListener)this);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl(KEY_ORG);
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_paycalendar", (String)"47150e89000000ac");
            showParameter.setCustomParam("range", new ArrayList(orgList));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            String key = ((Control)source).getKey();
            Date currMonth = (Date)this.getModel().getValue(TIME_KEY);
            if (key.startsWith("flex_")) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PaymentCalendarPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String[] region = key.replace("flex_", "").split("_");
                if (region.length == 2) {
                    Date currChooseDay = this.getDay(Integer.parseInt(region[0]), Integer.parseInt(region[1]));
                    if (!this.isCurrMonth(currChooseDay)) {
                        this.getModel().setValue(TIME_KEY, (Object)currChooseDay);
                    }
                    this.fillEntryData(currChooseDay);
                    this.markItemChosen(currChooseDay);
                }
            } else if (BTN_PREV.equals(key)) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PaymentCalendarPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date currTime = currMonth;
                this.getModel().setValue(TIME_KEY, (Object)DateUtils.addMonth(currTime, -1));
            } else if (BTN_NEXT.equals(key)) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PaymentCalendarPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date currTime = currMonth;
                this.getModel().setValue(TIME_KEY, (Object)DateUtils.addMonth(currTime, 1));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String entityName;
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRow = this.getModel().getEntryRowEntity(ENTRY, rowIndex);
        Object billName = entryRow.get(BILLNAME);
        BillShowParameter sp = new BillShowParameter();
        if (ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"PaymentCalendarPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]).equals(billName)) {
            entityName = "cas_paybill";
        } else if (ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"PaymentCalendarPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]).equals(billName)) {
            entityName = "cas_agentpaybill";
        } else {
            return;
        }
        sp.setPkId(entryRow.get(PKID));
        sp.setBillStatus(BillOperationStatus.VIEW);
        sp.setStatus(OperationStatus.VIEW);
        sp.setBillTypeId(entryRow.getString(PKID));
        sp.setFormId(entityName);
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)sp);
    }

    private void setCalendar(Date date) {
        this.resetPrevBgColor();
        this.getPageCache().remove(KEY_PREVREGION);
        this.getModel().deleteEntryData(ENTRY);
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, Map<String, String>> infoMap = this.getPayInfoMap();
        int index = 0;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                String[] split;
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                StringBuilder sb = new StringBuilder();
                String currDateStr = dfnyr.format(calendar.getTime());
                String currDayStr = dfdd.format(calendar.getTime());
                String key = String.valueOf((calendar.get(2) + 1) * 1000 + calendar.get(5));
                Map<String, String> dayInfo = infoMap.get(key);
                boolean isAllHandle = false;
                ArrayList<String> list = new ArrayList<String>();
                String unHandleAmt = "";
                String handleAmt = "";
                if (dayInfo != null) {
                    long unHandleCount = Long.parseLong(dayInfo.get("unhandle"));
                    long handleCount = Long.parseLong(dayInfo.get("handle"));
                    unHandleAmt = dayInfo.get("unhandleamt");
                    handleAmt = dayInfo.get("handleamt");
                    long count = unHandleCount + handleCount;
                    list.add(String.format(ResManager.loadKDString((String)"\u5171%s\u7b14", (String)"PaymentCalendarPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), count));
                }
                sb.append("<div title=\"").append(String.join((CharSequence)LINE_SP, list)).append("\"><div style=\"text-align:right;\">").append("<span ").append("style=\"width:28px;").append("font-size:16px;").append("height:28px;").append("color:#333333;").append("border-radius:50%;").append("display:inline-block;").append("line-height:28px;").append("text-align:center;");
                if (index < weekday - 1 || index - weekday - maxday + 2 > 0) {
                    sb.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(currDateStr)) {
                    sb.append("background:rgba(95,137,243,1);");
                    sb.append("color:#ffffff;");
                } else if (infoMap.size() != 0) {
                    for (Map.Entry<String, Map<String, String>> entry : infoMap.entrySet()) {
                        String value = entry.getKey();
                        if (!value.equals(currDateStr)) continue;
                        sb.append("background:rgba(252,133,85,1);");
                        sb.append("color:#ffffff;");
                    }
                }
                sb.append("\">").append(dfnyr.format(current.getTime()).equals(currDateStr) ? ResManager.loadKDString((String)"\u4eca", (String)"PaymentCalendarPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]) : currDayStr).append("</span>").append("</div>");
                if (EmptyUtil.isNoEmpty(list)) {
                    sb.append((CharSequence)this.getContext(list, i, j));
                }
                int existContext = 0;
                if (EmptyUtil.isNoEmpty((String)unHandleAmt)) {
                    split = unHandleAmt.split(LINE_SP);
                    Map<String, Object> context = this.getContext(split, i, j, Boolean.FALSE, 0);
                    existContext = Integer.parseInt(context.get("contextCount").toString());
                    sb.append(context.get("context"));
                }
                if (EmptyUtil.isNoEmpty((String)handleAmt)) {
                    split = handleAmt.split(LINE_SP);
                    Map<String, Object> context = this.getContext(split, i, j, Boolean.TRUE, existContext);
                    sb.append(context.get("context"));
                }
                sb.append("</div></div>");
                html.setConent(sb.toString());
                ++index;
            }
        }
        if (this.isSameMonth(date, new Date())) {
            this.fillEntryData(new Date());
            this.markItemChosen(new Date());
        } else {
            this.getModel().deleteEntryData(ENTRY);
        }
    }

    private Map<String, Object> getContext(String[] split, int i, int j, boolean isHandle, int existContext) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        StringBuilder sb = new StringBuilder();
        String backGroundColor = "<span style=\"background:%s;width:4px;height:4px;display:inline-block;margin-bottom:2px;\"></span>";
        backGroundColor = isHandle ? String.format(backGroundColor, "green") : String.format(backGroundColor, "#FC8555");
        int contextCount = 0;
        for (int k = 0; k < split.length; ++k) {
            sb.append("<div style=\"text-align:left\" id=\"item_").append(i).append("_").append(j).append("_").append(k).append("\">");
            if (existContext > 3) break;
            if (k >= 3 - existContext) {
                sb.append("<span style=\";width:4px;height:4px;display:inline-block;margin-bottom:2px;\"></span>");
                sb.append("<span style=\"margin-top:4px;color:rgba(51,51,51,1);margin-left:4px;\">......</span>");
                sb.append("</div>");
                contextCount = k + 1;
                break;
            }
            sb.append(backGroundColor);
            sb.append("<span style=\"margin-top:4px;color:rgba(51,51,51,1);margin-left:4px;\">").append(split[k]).append("</span>");
            sb.append("</div>");
            contextCount = k + 1;
        }
        result.put("context", sb.toString());
        result.put("contextCount", contextCount);
        return result;
    }

    private StringBuilder getContext(List<String> split, int i, int j) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < split.size(); ++k) {
            if (k >= 3) {
                sb.append("<div style=\"text-align:left\" id=\"item_").append(i).append("_").append(j).append("_").append(k).append("\">");
                sb.append("<span style=\";width:4px;height:4px;display:inline-block;margin-bottom:2px;\"></span>");
                sb.append("<span style=\"margin-top:4px;color:rgba(51,51,51,1);margin-left:4px;\">......</span>");
                sb.append("</div>");
                break;
            }
            sb.append("<div style=\"text-align:left\" id=\"item_").append(i).append("_").append(j).append("_").append(k).append("\">");
            sb.append("<span style=\"width:4px;height:4px;display:inline-block;margin-bottom:2px;\"></span>");
            sb.append("<span style=\"margin-top:4px;color:rgba(51,51,51,1);margin-left:4px;\">").append(split.get(k)).append("</span>");
            sb.append("</div>");
        }
        return sb;
    }

    private Map<String, Map<String, String>> getPayInfoMap() {
        Date firstDate = this.getDay(1, 1);
        Date lastDay = this.getDay(6, 7);
        QFilter orgFilter = this.getOrgFilter();
        QFilter expectDateStartFilter = new QFilter("expectdate", ">=", (Object)firstDate);
        QFilter expectDateEndFilter = new QFilter("expectdate", "<=", (Object)lastDay);
        QFilter expectDateIsNullFilter = QFilter.isNull((String)"expectdate");
        QFilter bizDateStartFilter = new QFilter("bizdate", ">=", (Object)firstDate);
        QFilter bizDateEndFilter = new QFilter("bizdate", "<=", (Object)lastDay);
        DataSet paymentBillDs1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paybill", (String)"currency as currencyid, case when billstatus in ('A','B','C','E') then 0 else 1 end as ishandle, actpayamt as amt, (MONTH(bizdate)*1000 + DAYOFMONTH(bizdate)) as datestr", (QFilter[])new QFilter[]{bizDateStartFilter, bizDateEndFilter, expectDateIsNullFilter, orgFilter}, (String)"");
        DataSet paymentBillDs2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paybill", (String)"currency as currencyid, case when billstatus in ('A','B','C','E') then 0 else 1 end as ishandle, actpayamt as amt, (MONTH(expectdate)*1000 + DAYOFMONTH(expectdate)) as datestr", (QFilter[])new QFilter[]{expectDateStartFilter, expectDateEndFilter, orgFilter}, (String)"");
        DataSet agentBillDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_agentpaybill", (String)"currency.id as currencyid, case when billstatus in ('A','B','C','E') then 0 else 1 end as ishandle, payamount as amt, (MONTH(bizdate)*1000 + DAYOFMONTH(bizdate)) as datestr", (QFilter[])new QFilter[]{bizDateStartFilter, bizDateEndFilter, orgFilter}, (String)"");
        DataSet result = paymentBillDs1.union(paymentBillDs2).union(agentBillDs).groupBy(new String[]{"datestr", "currencyid", "ishandle"}).sum("amt").count().finish();
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        for (Row row : result) {
            String day = row.getString("datestr");
            int pointIdx = day.indexOf(".");
            if (pointIdx != -1) {
                day = day.substring(0, pointIdx);
            }
            HashMap<String, String> dayInfo = (HashMap<String, String>)resultMap.get(day);
            boolean isHandle = row.getInteger("ishandle") == 1;
            long handleCnt = isHandle ? row.getLong("count") : 0L;
            long unHandleCnt = isHandle ? 0L : row.getLong("count");
            BigDecimal amt = row.getBigDecimal("amt");
            Long currencyId = row.getLong("currencyid");
            if (dayInfo == null) {
                dayInfo = new HashMap<String, String>();
                dayInfo.put("unhandle", "0");
                dayInfo.put("handle", "0");
                dayInfo.put("unhandleamt", "");
                dayInfo.put("handleamt", "");
            }
            StringBuilder unHandleAmtStr = new StringBuilder((String)dayInfo.get("unhandleamt"));
            StringBuilder handleAmtStr = new StringBuilder((String)dayInfo.get("handleamt"));
            if (isHandle) {
                handleCnt += Long.parseLong((String)dayInfo.get("handle"));
                unHandleCnt = Long.parseLong((String)dayInfo.get("unhandle"));
                if (handleAmtStr.length() > 0) {
                    handleAmtStr.append(LINE_SP);
                }
                handleAmtStr.append(this.formatAmt(currencyId, amt));
            } else {
                handleCnt = Long.parseLong((String)dayInfo.get("handle"));
                unHandleCnt += Long.parseLong((String)dayInfo.get("unhandle"));
                if (unHandleAmtStr.length() > 0) {
                    unHandleAmtStr.append(LINE_SP);
                }
                unHandleAmtStr.append(this.formatAmt(currencyId, amt));
            }
            dayInfo.put("unhandle", String.valueOf(unHandleCnt));
            dayInfo.put("handle", String.valueOf(handleCnt));
            dayInfo.put("unhandleamt", unHandleAmtStr.toString());
            dayInfo.put("handleamt", handleAmtStr.toString());
            resultMap.put(day, dayInfo);
        }
        result.close();
        return resultMap;
    }

    private void fillEntryData(Date day) {
        day = DateUtils.stringToDate(DateUtils.format(day, "yyyy-MM-dd"), "yyyy-MM-dd");
        String payBillProps = "org, payeracctbank, payeracctcash, billno, billstatus, actpayamt, currency, description";
        String agentBillProps = "org, payeracctbank, accountcash, billno, billstatus, payamount, currency, description";
        Date tomorrow = DateUtils.addDay(day, 1);
        QFilter expectDateStartFilter = new QFilter("expectdate", ">=", (Object)day);
        QFilter expectDateEndFilter = new QFilter("expectdate", "<", (Object)tomorrow);
        QFilter expectDateIsNullFilter = QFilter.isNull((String)"expectdate");
        QFilter bizDateStartFilter = new QFilter("bizdate", ">=", (Object)day);
        QFilter bizDateEndFilter = new QFilter("bizdate", "<", (Object)tomorrow);
        QFilter orgFilter = this.getOrgFilter();
        DynamicObject[] paymentBillBizDate = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"org, payeracctbank, payeracctcash, billno, billstatus, actpayamt, currency, description", (QFilter[])new QFilter[]{bizDateStartFilter, bizDateEndFilter, expectDateIsNullFilter, orgFilter});
        DynamicObject[] paymentBillExpectDate = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"org, payeracctbank, payeracctcash, billno, billstatus, actpayamt, currency, description", (QFilter[])new QFilter[]{expectDateStartFilter, expectDateEndFilter, orgFilter});
        DynamicObject[] agentBill = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"org, payeracctbank, accountcash, billno, billstatus, payamount, currency, description", (QFilter[])new QFilter[]{bizDateStartFilter, bizDateEndFilter, orgFilter});
        this.getModel().deleteEntryData(ENTRY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Stream.of(paymentBillBizDate, paymentBillExpectDate, agentBill).flatMap(Arrays::stream).sorted((a, b) -> {
            String statusA = a.getString(BILLSTATUS);
            String statusB = b.getString(BILLSTATUS);
            int sortA = 0;
            int sortB = 0;
            if (BillStatusEnum.PAY.getValue().equals(statusA)) {
                sortA = 1;
            }
            if (BillStatusEnum.PAY.getValue().equals(statusB)) {
                sortB = 1;
            }
            return sortA - sortB;
        }).forEach(o -> {
            DynamicObject cashAcct;
            String entityName = o.getDataEntityType().getName();
            DynamicObject bankAcct = o.getDynamicObject("payeracctbank");
            if ("cas_paybill".equals(entityName)) {
                vs.addField(PAYAMT, new Object[]{o.getBigDecimal("actpayamt")});
                vs.addField(BILLNAME, new Object[]{ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"PaymentCalendarPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0])});
                cashAcct = o.getDynamicObject("payeracctcash");
            } else {
                vs.addField(PAYAMT, new Object[]{o.getBigDecimal("payamount")});
                vs.addField(BILLNAME, new Object[]{ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"PaymentCalendarPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0])});
                cashAcct = o.getDynamicObject("accountcash");
            }
            List<String> unHandleStatusArr = Arrays.asList(BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), BillStatusEnum.BEING.getValue());
            boolean isHandle = !unHandleStatusArr.contains(o.getString(BILLSTATUS));
            vs.addField(BILLNO, new Object[]{o.getString(BILLNO)});
            vs.addField(BILLSTATUS, new Object[]{BillStatusEnum.getName((String)o.getString(BILLSTATUS))});
            vs.addField(ORG, new Object[]{o.getDynamicObject(ORG).getPkValue()});
            DynamicObject currency = o.getDynamicObject(CURRENCY);
            if (currency != null) {
                vs.addField(CURRENCY, new Object[]{currency.getPkValue()});
            } else {
                vs.addField(CURRENCY, new Object[]{0L});
            }
            String description = o.getString(DESCRIPTION);
            if (StringUtils.isEmpty((String)description)) {
                description = ResManager.loadKDString((String)"\u65e0", (String)"PaymentCalendarPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            vs.addField(DESCRIPTION, new Object[]{description});
            vs.addField(PKID, new Object[]{o.getPkValue().toString()});
            vs.addField(ISPAY, new Object[]{isHandle});
            if (bankAcct != null) {
                vs.addField(ACCT, new Object[]{bankAcct.getString("number")});
            } else if (cashAcct != null) {
                vs.addField(ACCT, new Object[]{cashAcct.getString("number")});
            }
        });
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRY, vs);
    }

    private void markItemChosen(Date day) {
        int[] currRegion = this.getRegion(day);
        if (currRegion == null) {
            return;
        }
        this.resetPrevBgColor();
        String currKey = "flex_" + currRegion[0] + "_" + currRegion[1];
        this.getPageCache().put(KEY_PREVREGION, SerializationUtils.toJsonString((Object)currRegion));
        this.updateBgColor(currKey, BG_BLUE);
    }

    private void resetPrevBgColor() {
        String prevRegionStr = this.getPageCache().get(KEY_PREVREGION);
        if (prevRegionStr == null) {
            return;
        }
        int[] prevRegion = (int[])SerializationUtils.fromJsonString((String)prevRegionStr, int[].class);
        String prevKey = "flex_" + prevRegion[0] + "_" + prevRegion[1];
        if (prevRegion[1] == 1 || prevRegion[1] == 7) {
            this.updateBgColor(prevKey, BG_GREY);
        } else {
            this.updateBgColor(prevKey, BG_WHITE);
        }
    }

    private void updateBgColor(String key, String color) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bc", color);
        this.getView().updateControlMetadata(key, map);
    }

    private QFilter getOrgFilter() {
        DynamicObjectCollection currOrg = (DynamicObjectCollection)this.getModel().getValue(KEY_ORG);
        return new QFilter(ORG, "in", (Object)currOrg.stream().map(o -> o.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).toArray());
    }

    private Date getDay(int row, int col) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.getModel().getValue(TIME_KEY));
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        calendar.add(5, 0 - weekday);
        calendar.add(5, (row - 1) * 7 + col);
        return calendar.getTime();
    }

    private int[] getRegion(Date day) {
        if (!this.isCurrMonth(day)) {
            return null;
        }
        Date firstDay = this.getDay(1, 1);
        long diff = (day.getTime() - firstDay.getTime()) / 86400000L;
        int dayDiff = (int)diff;
        return new int[]{dayDiff / 7 + 1, dayDiff % 7 + 1};
    }

    private boolean isCurrMonth(Date day) {
        Date currMonth = (Date)this.getModel().getValue(TIME_KEY);
        return this.isSameMonth(day, currMonth);
    }

    private boolean isSameMonth(Date date1, Date date2) {
        Calendar currMonthCal = Calendar.getInstance();
        currMonthCal.setTime(date1);
        Calendar currChooseDayCal = Calendar.getInstance();
        currChooseDayCal.setTime(date2);
        int monthDiff = currMonthCal.get(1) * 100 + currMonthCal.get(2) - (currChooseDayCal.get(1) * 100 + currChooseDayCal.get(2));
        return monthDiff == 0;
    }

    private String formatAmt(Long currencyId, BigDecimal amt) {
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        if (currency == null) {
            return amt.toString();
        }
        String sign = currency.getString("number");
        int length = currency.getInt("amtprecision");
        return sign + " " + amt.setScale(length, 1);
    }
}

