/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.facade.impl.CasServiceFacadeImpl;
import kd.fi.cas.enums.CashVerificationEnum;
import kd.fi.cas.helper.CasHelper;

public class CashInventorySheetPrintPlugin
extends AbstractPrintServicePlugin {
    private static final String SYSTEM_TYPE = "fi-cas-formplugin";
    private static final String[] NUMBERS = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"CashInventorySheetPrintPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"CashInventorySheetPrintPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"CashInventorySheetPrintPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"CashInventorySheetPrintPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"CashInventorySheetPrintPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"CashInventorySheetPrintPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"CashInventorySheetPrintPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"CashInventorySheetPrintPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"CashInventorySheetPrintPlugin_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"CashInventorySheetPrintPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0])};
    private static final String[] UNITS = new String[]{ResManager.loadKDString((String)"\u5341", (String)"CashInventorySheetPrintPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CashInventorySheetPrintPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CashInventorySheetPrintPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"CashInventorySheetPrintPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"CashInventorySheetPrintPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CashInventorySheetPrintPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CashInventorySheetPrintPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"CashInventorySheetPrintPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"CashInventorySheetPrintPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CashInventorySheetPrintPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CashInventorySheetPrintPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0])};

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs args) {
        super.customPrintDataEntities(args);
        List dyns = args.getDataEntities();
        String datasource = args.getDataSourceName();
        if (args.isMainDs()) {
            Optional.ofNullable(dyns.get(0)).ifPresent(dy -> {
                ThreadCache.put((Object)"cas_cash_verification_id", (Object)dy.getLong("id"));
                DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", dy.get("currency.id"))});
                ThreadCache.put((Object)"cas_cash_scale", (Object)currency.getInt("amtprecision"));
            });
        } else if ("cash_count_datasource".equals(datasource)) {
            this.initPrintCashCountData(dyns);
            args.setDataEntities(dyns);
        } else if ("account_verificate_datasource".equals(datasource)) {
            this.initPrintAccountVerificate(dyns);
            args.setDataEntities(dyns);
        }
    }

    private void initPrintCashCountData(List<DynamicObject> dyns) {
        Long cashVerificateId = (Long)ThreadCache.get((Object)"cas_cash_verification_id");
        Integer scale = Integer.valueOf(ThreadCache.get((Object)"cas_cash_scale").toString());
        List<DynamicObject> cashInfoLst = this.getCashCountData(cashVerificateId);
        DynamicObjectType dsDataType = new DynamicObjectType();
        dsDataType.registerProperty("denomination", String.class, (Object)"", false);
        dsDataType.registerProperty("denamount", String.class, (Object)"", false);
        dsDataType.registerProperty("denmoney", BigDecimal.class, (Object)BigDecimal.ZERO, false);
        dsDataType.registerProperty("denremark", String.class, (Object)"", false);
        DynamicObject newDynamicRow = null;
        for (DynamicObject dynamicObject : cashInfoLst) {
            if (0 == dynamicObject.getInt("cashentity")) continue;
            newDynamicRow = new DynamicObject(dsDataType);
            newDynamicRow.set("denomination", (Object)dynamicObject.getString("cashentity.denomination"));
            newDynamicRow.set("denamount", (Object)dynamicObject.getString("cashentity.denamount"));
            newDynamicRow.set("denmoney", (Object)dynamicObject.getBigDecimal("cashentity.denmoney").setScale(scale));
            newDynamicRow.set("denremark", (Object)String.format(" %s", dynamicObject.getString("cashentity.denremark")));
            dyns.add(newDynamicRow);
        }
    }

    private void initPrintAccountVerificate(List<DynamicObject> dyns) {
        Long cashVerificateId = (Long)ThreadCache.get((Object)"cas_cash_verification_id");
        Integer scale = Integer.valueOf(ThreadCache.get((Object)"cas_cash_scale").toString());
        DynamicObject acountInfoData = this.getAcountInfoData(cashVerificateId);
        DynamicObjectType dot = new DynamicObjectType();
        dot.registerProperty("signid", String.class, (Object)"", false);
        dot.registerProperty("item", String.class, (Object)"", false);
        dot.registerProperty("itemmoney", BigDecimal.class, (Object)"", false);
        dot.registerProperty("itemremark", String.class, (Object)"", false);
        ArrayList<DynamicObject> acountInfoLst = new ArrayList<DynamicObject>();
        BigDecimal dailyMoney = acountInfoData.getBigDecimal("accountBalance");
        String saveStatus = "A";
        if (saveStatus.equals(acountInfoData.getString("billstatus"))) {
            CasServiceFacadeImpl balanceService = new CasServiceFacadeImpl();
            dailyMoney = balanceService.getCashJournalDayBalanceByBookDate(Long.valueOf(acountInfoData.getLong("org.id")), Long.valueOf(acountInfoData.getLong("cashaccount.id")), Long.valueOf(acountInfoData.getLong("currency.id")), acountInfoData.getDate("checkdate"));
        }
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_DAILY_BALANCE.getValue(), CashVerificationEnum.CASH_DAILY_BALANCE.getName(), dailyMoney, acountInfoData.getString("accountbalancermk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_ADD_NO_PAYMENT_IN_ACCOUNT.getValue(), CashVerificationEnum.CASH_ADD_NO_PAYMENT_IN_ACCOUNT.getName(), acountInfoData.getBigDecimal("bookedunpaid"), acountInfoData.getString("bookedunpaidrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_ADD_YES_PAYMENT_NO_ACCOUNT.getValue(), CashVerificationEnum.CASH_ADD_YES_PAYMENT_NO_ACCOUNT.getName(), acountInfoData.getBigDecimal("unbookedreceived"), acountInfoData.getString("unbookedreceivedrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_MINUS_NO_PAYMENT_IN_ACCOUNT.getValue(), CashVerificationEnum.CASH_MINUS_NO_PAYMENT_IN_ACCOUNT.getName(), acountInfoData.getBigDecimal("bookedunreceived"), acountInfoData.getString("bookedunreceivedrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_MINUS_YES_PAYMENT_NO_ACCOUNT.getValue(), CashVerificationEnum.CASH_MINUS_YES_PAYMENT_NO_ACCOUNT.getName(), acountInfoData.getBigDecimal("unbookedpaid"), acountInfoData.getString("unbookedpaidrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_ADJUST_BALANCE.getValue(), CashVerificationEnum.CASH_ADJUST_BALANCE.getName(), acountInfoData.getBigDecimal("adjustbalance"), acountInfoData.getString("adjustbalancermk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_REAL_CASH.getValue(), CashVerificationEnum.CASH_REAL_CASH.getName(), acountInfoData.getBigDecimal("realcashamount"), acountInfoData.getString("realcashamountrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_INVENTORY_SURPLUS.getValue(), CashVerificationEnum.CASH_INVENTORY_SURPLUS.getName(), acountInfoData.getBigDecimal("inventorysurplus"), acountInfoData.getString("inventorysurplusrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_DISH_DEFICIENT.getValue(), CashVerificationEnum.CASH_DISH_DEFICIENT.getName(), acountInfoData.getBigDecimal("inventorydeficit"), acountInfoData.getString("inventorydeficitrmk"), dot));
        Map<String, List<DynamicObject>> acountInfoDetailMap = this.getAcountDetailInfoData(cashVerificateId);
        DynamicObjectType dsDataType = new DynamicObjectType();
        dsDataType.registerProperty("item", String.class, (Object)"", false);
        dsDataType.registerProperty("itemmoney", String.class, (Object)"", false);
        dsDataType.registerProperty("itemremark", String.class, (Object)"", false);
        for (DynamicObject acountInfo : acountInfoLst) {
            BigDecimal money = acountInfo.getBigDecimal("itemmoney");
            String type = acountInfo.getString("signid");
            String[] params = new String[]{ResManager.loadKDString((String)CashVerificationEnum.getName((String)type), (String)String.format("CashInventorySheetPrintPlugin_%s", type), (String)SYSTEM_TYPE, (Object[])new Object[0]), CasHelper.formatDecimal((BigDecimal)money, (int)scale), acountInfo.getString("itemremark")};
            this.fillAcountVeriPrintData(dyns, dsDataType, params);
            if (!CashVerificationEnum.CASH_ADD_NO_PAYMENT_IN_ACCOUNT.getValue().equals(type) && !CashVerificationEnum.CASH_ADD_YES_PAYMENT_NO_ACCOUNT.getValue().equals(type) && !CashVerificationEnum.CASH_MINUS_NO_PAYMENT_IN_ACCOUNT.getValue().equals(type) && !CashVerificationEnum.CASH_MINUS_YES_PAYMENT_NO_ACCOUNT.getValue().equals(type)) continue;
            Optional.ofNullable(acountInfoDetailMap.get(type)).ifPresent(detailLst -> {
                int index = 1;
                for (DynamicObject detail : detailLst) {
                    String[] detailParams = new String[]{this.arabNumToChineseNum(index++, "\uff08", "\uff09"), CasHelper.formatDecimal((BigDecimal)detail.getBigDecimal("accdetailentity.adjmoney"), (int)scale), detail.getString("accdetailentity.adjremark")};
                    this.fillAcountVeriPrintData(dyns, dsDataType, detailParams);
                }
            });
        }
    }

    private DynamicObject assemblyAccountInfoItem(String signid, String name, BigDecimal money, String remark, DynamicObjectType dot) {
        DynamicObject acountItem = new DynamicObject(dot);
        acountItem.set("signid", (Object)signid);
        acountItem.set("item", (Object)name);
        acountItem.set("itemmoney", (Object)money);
        acountItem.set("itemremark", (Object)remark);
        return acountItem;
    }

    private String arabNumToChineseNum(Integer number, String prefix, String suffix) {
        String temp = number.toString();
        int n = temp.length();
        StringBuilder chineseNum = new StringBuilder(prefix);
        for (int i = 0; i < n; ++i) {
            int num = temp.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                chineseNum.append(NUMBERS[num]).append(UNITS[n - 2 - i]);
                continue;
            }
            chineseNum.append(NUMBERS[num]);
        }
        return chineseNum.append(suffix).toString();
    }

    public void fillAcountVeriPrintData(List<DynamicObject> dyns, DynamicObjectType dsDataType, String ... args) {
        DynamicObject newDetailRow = new DynamicObject(dsDataType);
        newDetailRow.set("item", (Object)String.format(" %s", args[0]));
        newDetailRow.set("itemmoney", (Object)args[1]);
        newDetailRow.set("itemremark", (Object)String.format(" %s", args[2]));
        dyns.add(newDetailRow);
    }

    private Map<String, List<DynamicObject>> getAcountDetailInfoData(Long cashVerificateId) {
        DynamicObjectCollection acoutInfoDetailColls = QueryServiceHelper.query((String)"cas_cash_verification", (String)"id,accdetailentity.id,accdetailentity.seq,accdetailentity.adjustment,accdetailentity.adjmoney,accdetailentity.adjremark", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashVerificateId)});
        return acoutInfoDetailColls.stream().filter(dy -> null != dy.getString("accdetailentity.adjustment")).collect(Collectors.groupingBy(dy -> dy.getString("accdetailentity.adjustment")));
    }

    private DynamicObject getAcountInfoData(Long cashVerificateId) {
        DynamicObject acoutInfo = QueryServiceHelper.queryOne((String)"cas_cash_verification", (String)"id,accountbalance,bookedunpaid,unbookedreceived,bookedunreceived,unbookedpaid,adjustbalance,realcashamount,inventorysurplus,inventorydeficit,accountbalancermk,bookedunpaidrmk,unbookedreceivedrmk,bookedunreceivedrmk,unbookedpaidrmk,adjustbalancermk,realcashamountrmk,inventorysurplusrmk,inventorydeficitrmk,cashaccount.id,org.id,checkdate,billstatus,currency.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashVerificateId)});
        return acoutInfo;
    }

    private List<DynamicObject> getCashCountData(Long cashVerificateId) {
        DynamicObjectCollection cashCountColls = QueryServiceHelper.query((String)"cas_cash_verification", (String)"id,cashentity,cashentity.seq,cashentity.denomination,cashentity.denamount,cashentity.denmoney,cashentity.denremark", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashVerificateId)});
        return cashCountColls.stream().sorted((x, y) -> x.getInt("cashentity.seq") - y.getInt("cashentity.seq")).collect(Collectors.toList());
    }
}

