/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.facade.impl.CasServiceFacadeImpl;
import kd.fi.cas.enums.CashVerificationEnum;
import kd.fi.cas.helper.CasHelper;

public class CashInventorySheetPrintPluginNew
extends AbstractPrintPlugin {
    private static final String SYSTEM_TYPE = "fi-cas-formplugin";
    private static final String[] NUMBERS = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"CashInventorySheetPrintPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"CashInventorySheetPrintPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"CashInventorySheetPrintPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"CashInventorySheetPrintPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"CashInventorySheetPrintPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"CashInventorySheetPrintPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"CashInventorySheetPrintPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"CashInventorySheetPrintPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"CashInventorySheetPrintPlugin_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"CashInventorySheetPrintPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0])};
    private static final String[] UNITS = new String[]{ResManager.loadKDString((String)"\u5341", (String)"CashInventorySheetPrintPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CashInventorySheetPrintPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CashInventorySheetPrintPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"CashInventorySheetPrintPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"CashInventorySheetPrintPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CashInventorySheetPrintPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CashInventorySheetPrintPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"CashInventorySheetPrintPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"CashInventorySheetPrintPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CashInventorySheetPrintPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CashInventorySheetPrintPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0])};

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        List dyns = evt.getCustomDataRows();
        DataRowSet mainDataRow = evt.getDataSource().getMainDataRow();
        Long cashVerificateId = Long.valueOf(dataSource.getPkId().toString());
        int scale = Integer.parseInt(mainDataRow.getField("currency.amtprecision").getValue().toString());
        if ("cash_count_datasource".equals(dataSourceName)) {
            this.initPrintCashCountData(dyns, cashVerificateId, scale);
        } else if ("account_verificate_datasource".equals(dataSourceName)) {
            this.initPrintAccountVerificate(dyns, cashVerificateId, scale);
        }
    }

    private void initPrintCashCountData(List<DataRowSet> dyns, Long cashVerificateId, int scale) {
        List<DynamicObject> cashInfoLst = this.getCashCountData(cashVerificateId);
        for (DynamicObject dynamicObject : cashInfoLst) {
            if (0 == dynamicObject.getInt("cashentity")) continue;
            DataRowSet newDynamicRow = new DataRowSet();
            newDynamicRow.put("denomination", (Field)new TextField(dynamicObject.getString("cashentity.denomination")));
            newDynamicRow.put("denamount", (Field)new TextField(dynamicObject.getString("cashentity.denamount")));
            newDynamicRow.put("denmoney", (Field)new DecimalField(dynamicObject.getBigDecimal("cashentity.denmoney").setScale(scale)));
            newDynamicRow.put("denremark", (Field)new TextField(String.format(" %s", dynamicObject.getString("cashentity.denremark"))));
            dyns.add(newDynamicRow);
        }
    }

    private void initPrintAccountVerificate(List<DataRowSet> dyns, Long cashVerificateId, int scale) {
        DynamicObject acountInfoData = this.getAcountInfoData(cashVerificateId);
        DynamicObjectType dot = new DynamicObjectType();
        dot.registerProperty("signid", String.class, (Object)"", false);
        dot.registerProperty("item", String.class, (Object)"", false);
        dot.registerProperty("itemmoney", BigDecimal.class, (Object)"", false);
        dot.registerProperty("itemremark", String.class, (Object)"", false);
        ArrayList<DynamicObject> acountInfoLst = new ArrayList<DynamicObject>();
        BigDecimal dailyMoney = acountInfoData.getBigDecimal("accountBalance");
        String saveStatus = "A";
        if (saveStatus.equals(acountInfoData.getString("billstatus"))) {
            CasServiceFacadeImpl balanceService = new CasServiceFacadeImpl();
            dailyMoney = balanceService.getCashJournalDayBalanceByBookDate(Long.valueOf(acountInfoData.getLong("org.id")), Long.valueOf(acountInfoData.getLong("cashaccount.id")), Long.valueOf(acountInfoData.getLong("currency.id")), acountInfoData.getDate("checkdate"));
        }
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_DAILY_BALANCE.getValue(), CashVerificationEnum.CASH_DAILY_BALANCE.getName(), dailyMoney, acountInfoData.getString("accountbalancermk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_ADD_NO_PAYMENT_IN_ACCOUNT.getValue(), CashVerificationEnum.CASH_ADD_NO_PAYMENT_IN_ACCOUNT.getName(), acountInfoData.getBigDecimal("bookedunpaid"), acountInfoData.getString("bookedunpaidrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_ADD_YES_PAYMENT_NO_ACCOUNT.getValue(), CashVerificationEnum.CASH_ADD_YES_PAYMENT_NO_ACCOUNT.getName(), acountInfoData.getBigDecimal("unbookedreceived"), acountInfoData.getString("unbookedreceivedrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_MINUS_NO_PAYMENT_IN_ACCOUNT.getValue(), CashVerificationEnum.CASH_MINUS_NO_PAYMENT_IN_ACCOUNT.getName(), acountInfoData.getBigDecimal("bookedunreceived"), acountInfoData.getString("bookedunreceivedrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_MINUS_YES_PAYMENT_NO_ACCOUNT.getValue(), CashVerificationEnum.CASH_MINUS_YES_PAYMENT_NO_ACCOUNT.getName(), acountInfoData.getBigDecimal("unbookedpaid"), acountInfoData.getString("unbookedpaidrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_ADJUST_BALANCE.getValue(), CashVerificationEnum.CASH_ADJUST_BALANCE.getName(), acountInfoData.getBigDecimal("adjustbalance"), acountInfoData.getString("adjustbalancermk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_REAL_CASH.getValue(), CashVerificationEnum.CASH_REAL_CASH.getName(), acountInfoData.getBigDecimal("realcashamount"), acountInfoData.getString("realcashamountrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_INVENTORY_SURPLUS.getValue(), CashVerificationEnum.CASH_INVENTORY_SURPLUS.getName(), acountInfoData.getBigDecimal("inventorysurplus"), acountInfoData.getString("inventorysurplusrmk"), dot));
        acountInfoLst.add(this.assemblyAccountInfoItem(CashVerificationEnum.CASH_DISH_DEFICIENT.getValue(), CashVerificationEnum.CASH_DISH_DEFICIENT.getName(), acountInfoData.getBigDecimal("inventorydeficit"), acountInfoData.getString("inventorydeficitrmk"), dot));
        Map<String, List<DynamicObject>> acountInfoDetailMap = this.getAcountDetailInfoData(cashVerificateId);
        DynamicObjectType dsDataType = new DynamicObjectType();
        dsDataType.registerProperty("item", String.class, (Object)"", false);
        dsDataType.registerProperty("itemmoney", String.class, (Object)"", false);
        dsDataType.registerProperty("itemremark", String.class, (Object)"", false);
        for (DynamicObject acountInfo : acountInfoLst) {
            BigDecimal money = acountInfo.getBigDecimal("itemmoney");
            String type = acountInfo.getString("signid");
            String[] params = new String[]{ResManager.loadKDString((String)CashVerificationEnum.getName((String)type), (String)String.format("CashInventorySheetPrintPlugin_%s", type), (String)SYSTEM_TYPE, (Object[])new Object[0]), CasHelper.formatDecimal((BigDecimal)money, (int)scale), acountInfo.getString("itemremark")};
            this.fillAcountVeriPrintData(dyns, params);
            if (!CashVerificationEnum.CASH_ADD_NO_PAYMENT_IN_ACCOUNT.getValue().equals(type) && !CashVerificationEnum.CASH_ADD_YES_PAYMENT_NO_ACCOUNT.getValue().equals(type) && !CashVerificationEnum.CASH_MINUS_NO_PAYMENT_IN_ACCOUNT.getValue().equals(type) && !CashVerificationEnum.CASH_MINUS_YES_PAYMENT_NO_ACCOUNT.getValue().equals(type)) continue;
            Optional.ofNullable(acountInfoDetailMap.get(type)).ifPresent(detailLst -> {
                int index = 1;
                for (DynamicObject detail : detailLst) {
                    String[] detailParams = new String[]{this.arabNumToChineseNum(index++, "\uff08", "\uff09"), CasHelper.formatDecimal((BigDecimal)detail.getBigDecimal("accdetailentity.adjmoney"), (int)scale), detail.getString("accdetailentity.adjremark")};
                    this.fillAcountVeriPrintData(dyns, detailParams);
                }
            });
        }
    }

    private DynamicObject assemblyAccountInfoItem(String signid, String name, BigDecimal money, String remark, DynamicObjectType dot) {
        DynamicObject acountItem = new DynamicObject(dot);
        acountItem.set("signid", (Object)signid);
        acountItem.set("item", (Object)name);
        acountItem.set("itemmoney", (Object)money);
        acountItem.set("itemremark", (Object)remark);
        return acountItem;
    }

    private String arabNumToChineseNum(Integer number, String prefix, String suffix) {
        String temp = number.toString();
        int n = temp.length();
        StringBuilder chineseNum = new StringBuilder(prefix);
        for (int i = 0; i < n; ++i) {
            int num = temp.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                chineseNum.append(NUMBERS[num]).append(UNITS[n - 2 - i]);
                continue;
            }
            chineseNum.append(NUMBERS[num]);
        }
        return chineseNum.append(suffix).toString();
    }

    public void fillAcountVeriPrintData(List<DataRowSet> dyns, String ... args) {
        DataRowSet newDetailRow = new DataRowSet();
        newDetailRow.put("item", (Field)new TextField(String.format(" %s", args[0])));
        newDetailRow.put("itemmoney", (Field)new TextField(args[1]));
        newDetailRow.put("itemremark", (Field)new TextField(String.format(" %s", args[2])));
        dyns.add(newDetailRow);
    }

    private Map<String, List<DynamicObject>> getAcountDetailInfoData(Long cashVerificateId) {
        DynamicObjectCollection acoutInfoDetailColls = QueryServiceHelper.query((String)"cas_cash_verification", (String)"id,accdetailentity.id,accdetailentity.seq,accdetailentity.adjustment,accdetailentity.adjmoney,accdetailentity.adjremark", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashVerificateId)});
        return acoutInfoDetailColls.stream().filter(dy -> null != dy.getString("accdetailentity.adjustment")).collect(Collectors.groupingBy(dy -> dy.getString("accdetailentity.adjustment")));
    }

    private DynamicObject getAcountInfoData(Long cashVerificateId) {
        DynamicObject acoutInfo = QueryServiceHelper.queryOne((String)"cas_cash_verification", (String)"id,accountbalance,bookedunpaid,unbookedreceived,bookedunreceived,unbookedpaid,adjustbalance,realcashamount,inventorysurplus,inventorydeficit,accountbalancermk,bookedunpaidrmk,unbookedreceivedrmk,bookedunreceivedrmk,unbookedpaidrmk,adjustbalancermk,realcashamountrmk,inventorysurplusrmk,inventorydeficitrmk,cashaccount.id,org.id,checkdate,billstatus,currency.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashVerificateId)});
        return acoutInfo;
    }

    private List<DynamicObject> getCashCountData(Long cashVerificateId) {
        DynamicObjectCollection cashCountColls = QueryServiceHelper.query((String)"cas_cash_verification", (String)"id,cashentity,cashentity.seq,cashentity.denomination,cashentity.denamount,cashentity.denmoney,cashentity.denremark", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashVerificateId)});
        return cashCountColls.stream().sorted(Comparator.comparingInt(x -> x.getInt("cashentity.seq"))).collect(Collectors.toList());
    }
}

