/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.CashcheckresultEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class CashVerificationF7Plugin
extends AbstractListPlugin {
    private static final String CALLBACK_ID = "XJPD_CLOSE_WINDOW_ACTION";
    private FilterContainerInitArgs initArgs;
    private ArrayList<ComboItem> ids = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_new"});
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        List selectedOrgIdList = new ArrayList();
        if (currentCommonFilter != null && ((List)currentCommonFilter.get("FieldName")).contains("org.id")) {
            selectedOrgIdList = (List)currentCommonFilter.get("Value");
            if (this.ids == null) {
                this.ids = new ArrayList();
            } else {
                this.ids.clear();
            }
            if (selectedOrgIdList == null || selectedOrgIdList.isEmpty() || "".equals(selectedOrgIdList.get(0))) {
                DynamicObject[] accts;
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                List userOrgs = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_cash_verification", (String)"47150e89000000ac");
                QFilter companyQf = new QFilter("org", "in", (Object)userOrgs.toArray());
                companyQf.and(new QFilter("closestatus", "=", (Object)"0"));
                companyQf.and(new QFilter("enable", "=", (Object)"1"));
                companyQf.and(new QFilter("status", "=", (Object)"C"));
                DynamicObject[] dynamicObjectArray = accts = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)"id", (QFilter[])new QFilter[]{companyQf});
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject acct = dynamicObjectArray[i];
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(acct.getString("name")));
                    item.setValue(acct.getString("id"));
                    this.ids.add(item);
                }
            }
            this.getPageCache().put("selectedOrgIdList", null);
        }
        if (selectedOrgIdList != null && selectedOrgIdList.size() > 0 && !"".equals(selectedOrgIdList.get(0))) {
            DynamicObject[] accts;
            List IdList = selectedOrgIdList.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(IdList));
            QFilter companyQf = new QFilter("org", "in", IdList);
            companyQf.and(new QFilter("closestatus", "=", (Object)"0"));
            companyQf.and(new QFilter("enable", "=", (Object)"1"));
            companyQf.and(new QFilter("status", "=", (Object)"C"));
            for (DynamicObject acct : accts = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)"id", (QFilter[])new QFilter[]{companyQf})) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(acct.getString("name")));
                item.setValue(acct.getString("id"));
                this.ids.add(item);
            }
            if (accts.length < 1) {
                this.ids.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"CashVerificationF7Plugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])), ""));
            }
        }
        this.filterContainerInit(this.initArgs);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        if (this.ids == null || this.ids.size() == 0) {
            DynamicObject[] accts;
            List cacheSelectedOrgIdList;
            this.ids = new ArrayList();
            if (this.getPageCache().get("selectedOrgIdList") == null) {
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                cacheSelectedOrgIdList = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_cash_verification", (String)"47150e89000000ac");
            } else {
                cacheSelectedOrgIdList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
            }
            QFilter companyQf = new QFilter("org", "in", (Object)cacheSelectedOrgIdList);
            companyQf.and(new QFilter("closestatus", "=", (Object)"0"));
            companyQf.and(new QFilter("enable", "=", (Object)"1"));
            companyQf.and(new QFilter("status", "=", (Object)"C"));
            for (DynamicObject acct : accts = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)"id", (QFilter[])new QFilter[]{companyQf})) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(acct.getString("name")));
                item.setValue(acct.getString("id"));
                this.ids.add(item);
            }
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if ("cashaccount.name".equals(fieldName) || "org.id".equals(fieldName)) {
                commonFilter.setDefaultValue("");
            }
            if (this.ids == null || this.ids.size() <= 0 || !"cashaccount.name".equals(fieldName)) continue;
            commonFilter.setComboItems(this.ids);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String refEntityId = args.getRefEntityId();
        if ("cas_accountcashtreelistf7".equals(refEntityId)) {
            if (this.ids != null && this.ids.size() > 0) {
                List accIds = this.ids.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getValue())).map(o -> Long.valueOf(o.getValue())).collect(Collectors.toList());
                args.getQfilters().add(new QFilter("id", "in", accIds));
            } else {
                args.getQfilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.ids != null && this.ids.size() > 0) {
            this.ids.clear();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblnew".equals(key)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setShowTitle(false);
            showParameter.setLookUp(true);
            showParameter.setMultiSelect(false);
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.setBillFormId("cas_accountcashtreelistf7");
            String cachedSelectOrgStr = this.getPageCache().get("selectedOrgIdList");
            if (EmptyUtil.isNotEmpty((String)cachedSelectOrgStr)) {
                List cachedSelectOrg = (List)SerializationUtils.fromJsonString((String)cachedSelectOrgStr, List.class);
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("org.id", "in", (Object)cachedSelectOrg));
            }
            this.showForm(showParameter, "cas_cashaccounttplf7", ShowType.Modal, "cas_cash_verification", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String action = e.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"cas_cash_verification")) {
            Object returnData = e.getReturnData();
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (returnData != null && rows.size() > 1) {
                ArrayList<DynamicObject> accountObjList = new ArrayList<DynamicObject>();
                for (ListSelectedRow row : rows) {
                    Map<String, Object> accountMap = CashVerificationF7Plugin.getCashAccount(row.getPrimaryKeyValue());
                    MainEntityType cashAccountEntityType = EntityMetadataCache.getDataEntityType((String)"cas_cash_verification");
                    if (!SystemStatusCtrolHelper.isInitEnable((long)((Long)accountMap.get("org")))) {
                        this.getView().showErrorNotification(SystemStatusCtrolHelper.getNotInitMsg((String)(accountMap.get("orgname") == null ? "" : accountMap.get("orgname").toString())));
                        continue;
                    }
                    DynamicObject accountObj = new DynamicObject((DynamicObjectType)cashAccountEntityType);
                    accountObj.set("org", accountMap.get("org"));
                    accountObj.set("currency", (Object)((Long)accountMap.get("currency")));
                    accountObj.set("cashaccount", accountMap.get("cashaccount"));
                    accountObj.set("billstatus", (Object)"A");
                    accountObj.set("checkdate", (Object)DateUtils.getCurrentDate());
                    RequestContext requestContext = RequestContext.get();
                    Long currentUserID = Long.valueOf(requestContext.getUserId());
                    accountObj.set("cashier", (Object)currentUserID);
                    accountObj.set("creator", (Object)currentUserID);
                    accountObj.set("createtime", (Object)new Date());
                    accountObj.set("checkresult", (Object)CashcheckresultEnum.FOR_INVENTORY.getValue());
                    DynamicObjectCollection accountObjCol = this.creatCashEntityRow(accountMap.get("currency"));
                    accountObj.set("cashentity", (Object)accountObjCol);
                    accountObjList.add(accountObj);
                }
                SaveServiceHelper.saveOperate((String)"save", (String)"cas_cash_verification", (DynamicObject[])accountObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                ((ListView)this.getView()).refresh();
            } else if (returnData != null) {
                final Map<String, Object> cashAccountMap = CashVerificationF7Plugin.getCashAccount(rows.get(0).getPrimaryKeyValue());
                if (!SystemStatusCtrolHelper.isInitEnable((long)((Long)cashAccountMap.get("org")))) {
                    this.getView().showErrorNotification(SystemStatusCtrolHelper.getNotInitMsg((String)(cashAccountMap.get("orgname") == null ? "" : cashAccountMap.get("orgname").toString())));
                    return;
                }
                BillShowParameter bsp = new BillShowParameter();
                bsp.setStatus(OperationStatus.ADDNEW);
                this.showForm(bsp, "cas_cash_verification", ShowType.MainNewTabPage, CALLBACK_ID, (Map<String, Object>)new HashMap<String, Object>(){
                    private static final long serialVersionUID = -6083290301235260517L;
                    {
                        this.put("org", cashAccountMap.get("org"));
                        this.put("currency", cashAccountMap.get("currency"));
                        this.put("cashaccount", cashAccountMap.get("cashaccount"));
                    }
                });
            }
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)CALLBACK_ID)) {
            ((ListView)this.getView()).refresh();
        }
    }

    private <T extends FormShowParameter> void showForm(T fsp, String formId, ShowType showType, String callbackId, Map<String, Object> customeParams) {
        fsp.getOpenStyle().setShowType(showType);
        fsp.setFormId(formId);
        if (null != customeParams && !customeParams.isEmpty()) {
            for (Map.Entry<String, Object> entry : customeParams.entrySet()) {
                Optional.ofNullable(entry.getKey()).ifPresent(consumer -> fsp.getCustomParams().put(consumer, entry.getValue()));
            }
        }
        Optional.ofNullable(callbackId).ifPresent(consumer -> fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, consumer)));
        this.getView().showForm(fsp);
    }

    public static Map<String, Object> getCashAccount(Object pkValue) {
        DynamicObject cashAccountDyObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cas_accountcash");
        Object org = cashAccountDyObj.get("org.id");
        DynamicObject defaultAccountDyObj = (DynamicObject)cashAccountDyObj.get("defaultcurrency");
        Object currency = defaultAccountDyObj.get("id");
        Object cashAccount = cashAccountDyObj.getPkValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", org);
        map.put("currency", currency);
        map.put("cashaccount", cashAccount);
        map.put("orgname", CasHelper.getLocalValue((DynamicObject)cashAccountDyObj.getDynamicObject("org"), (String)"name"));
        return map;
    }

    public DynamicObjectCollection creatCashEntityRow(Object currency) {
        DynamicObjectCollection entryCurrencyCol = this.getEntryCurrencyCol(currency);
        DynamicObject casVerEntityObj = BusinessDataServiceHelper.newDynamicObject((String)"cas_cash_verification");
        DynamicObjectCollection cashEntityObj = casVerEntityObj.getDynamicObjectCollection("cashentity");
        DynamicObjectCollection accountObjCol = new DynamicObjectCollection();
        for (int i = 0; i < entryCurrencyCol.size(); ++i) {
            DynamicObject cashEntity = cashEntityObj.addNew();
            cashEntity.set("denomination", ((DynamicObject)entryCurrencyCol.get(i)).get("denomination"));
            cashEntity.set("conversionratio", ((DynamicObject)entryCurrencyCol.get(i)).get("conversionratio"));
            cashEntity.set("denominationid", (Object)String.valueOf(((DynamicObject)entryCurrencyCol.get(i)).getPkValue()));
            cashEntity.set("Seq", (Object)i);
            accountObjCol.add((Object)cashEntity);
        }
        return accountObjCol;
    }

    public DynamicObjectCollection getEntryCurrencyCol(Object currency) {
        QFilter qFilter = new QFilter("currency", "=", currency);
        DynamicObject cashAccountObj = BusinessDataServiceHelper.loadSingle((String)"cas_currencyfacevalue", (String)"id,denomination,conversionratio,usestatus", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection entryCurrencyCol = new DynamicObjectCollection();
        if (null != cashAccountObj) {
            entryCurrencyCol = cashAccountObj.getDynamicObjectCollection("entryentity");
            entryCurrencyCol = entryCurrencyCol.stream().filter(dy -> (Boolean)dy.get("usestatus")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        return entryCurrencyCol;
    }
}

