/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.cashcount;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CurrencyFaceValueListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("delete".equals(op.getOperateKey())) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection currencyFaceCollection = listView.getSelectedRows();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)currencyFaceCollection.getPrimaryKeyValues())};
            DynamicObject[] currencyFaceObjs = BusinessDataServiceHelper.load((String)"cas_currencyfacevalue", (String)"id,currency", (QFilter[])qFilters);
            ArrayList<Object> currencyFaceList = new ArrayList<Object>(currencyFaceObjs.length);
            for (DynamicObject currencyFace : currencyFaceObjs) {
                currencyFaceList.add(currencyFace.get("currency.id"));
            }
            DynamicObject[] cashObjs = BusinessDataServiceHelper.load((String)"cas_cash_verification", (String)"id", (QFilter[])new QFilter[]{new QFilter("currency", "in", currencyFaceList)});
            if (cashObjs.length > 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u6a21\u677f\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"CurrencyFaceValueListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    static class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"enableddenomination")) {
                return rows;
            }
            rows.stream().forEach(row -> row.set("enableddenomination", (Object)this.assemblyEnabledDenominationText(row.getLong("id"))));
            return rows;
        }

        private String assemblyEnabledDenominationText(Long id) {
            DynamicObjectCollection cashCountColls = QueryServiceHelper.query((String)"cas_currencyfacevalue", (String)"id,entryentity,entryentity.facevalue,entryentity.unit,entryentity.denomination,entryentity.conversionratio,entryentity.usestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            StringBuilder temp = new StringBuilder();
            for (DynamicObject dynamicObject : cashCountColls) {
                if (Boolean.TRUE.booleanValue() != dynamicObject.getBoolean("entryentity.usestatus")) continue;
                temp = temp.append(dynamicObject.getString("entryentity.denomination")).append(";");
            }
            return temp.length() > 0 ? temp.replace(temp.length() - 1, temp.length(), "").toString() : temp.toString();
        }
    }
}

