/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.changebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cas.enums.ChgTypeEnum;
import kd.fi.cas.enums.SBillTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayInfoChgList
extends AbstractListPlugin
implements HyperLinkClickListener {
    private static final String KEY_CHANGECHG_CALLBACK = "KEY_CHANGECHG_CALLBACK";
    private static final String[] operationArr = new String[]{"save", "submit", "unsubmit", "audit", "unaudit", "delete", "confirm", "autoconfirm"};
    private static Log logger = LogFactory.getLog(PayInfoChgList.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String curAppId = this.getView().getFormShowParameter().getAppId();
        if (curAppId != null && curAppId.equals("tr")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblconfirm"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        String appId;
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)userPK, (boolean)Boolean.FALSE);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
            QFilter filter = new QFilter("applyuser", "=", (Object)userPK).or(new QFilter("alterationuser", "=", (Object)userPK));
            logger.info("hasPermOrgIds: {}", (Object)hasPermOrgIds);
            if (EmptyUtil.isNoEmpty((Object)hasPermOrgIds)) {
                QFilter orgFilter = new QFilter("org", "in", (Object)hasPermOrgIds);
                filter.or(orgFilter);
            }
            filterList.add(filter);
        }
        String qFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("qFilterStr");
        if (StringUtils.isNotEmpty((CharSequence)qFilterStr)) {
            QFilter qFilter = QFilter.fromSerializedString((String)qFilterStr);
            filterList.add(qFilter);
        }
        if (Objects.equals(appId = (String)this.getView().getFormShowParameter().getCustomParam("appid"), "cas") || Objects.equals(appId, "fs")) {
            filterList.add(new QFilter("sbilltype", "!=", (Object)SBillTypeEnum.SPAN.getValue()));
        } else if (Objects.equals(appId, "fca")) {
            filterList.add(new QFilter("sbilltype", "in", Arrays.asList(SBillTypeEnum.SPAN.getValue(), SBillTypeEnum.TRANSFER_SAME.getValue())));
        }
        e.setCustomQFilters(filterList);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection lstCollection = list.getSelectedRows();
        boolean isAllowOperation = Arrays.stream(operationArr).anyMatch(o -> o.equalsIgnoreCase(key));
        if (isAllowOperation) {
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            QFilter filter = new QFilter("applyuser", "=", (Object)userPK).or(new QFilter("alterationuser", "=", (Object)userPK));
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)"cas_paychgbill", (String)"id", (QFilter[])filter.toArray());
            if (queryData != null && queryData.size() > 0) {
                Set idSet = queryData.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                for (ListSelectedRow row : lstCollection) {
                    if (idSet.contains(row.getPrimaryKeyValue())) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53d8\u66f4\u4eba\u6216\u53d8\u66f4\u7533\u8bf7\u4eba\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PayInfoChgList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53d8\u66f4\u4eba\u6216\u53d8\u66f4\u7533\u8bf7\u4eba\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PayInfoChgList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("deliver".equals(key)) {
            args.cancel = true;
            if (CasHelper.getSelectedRowSize((ListSelectedRowCollection)lstCollection) > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8f6c\u4ea4\u3002", (String)"PayInfoChgList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object id = lstCollection.get(0).getPrimaryKeyValue();
            DynamicObject paychgbill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paychgbill", (String)"id,chgtype,billstatus,sourcebillid,sourcetype");
            if (!"A".equals(paychgbill.get("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8f6c\u4ea4\u6682\u5b58\u7684\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u6570\u636e\u3002", (String)"PayInfoChgList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ChgTypeEnum.RECCHG.getValue().equals(paychgbill.getString("chgtype"))) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setShowTitle(false);
                StyleCss css = new StyleCss();
                css.setWidth("700");
                css.setHeight("400");
                showParameter.getOpenStyle().setInlineStyleCss(css);
                showParameter.setCustomParam("id", id);
                showParameter.setCustomParam("sourceId", (Object)paychgbill.getLong("sourcebillid"));
                showParameter.setCustomParam("sourceType", (Object)paychgbill.getString("sourcetype"));
                showParameter.setFormId("cas_paychgdeliver");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CHANGECHG_CALLBACK));
                this.getView().showForm(showParameter);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8f6c\u4ea4\u6682\u5b58\u7684\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u6570\u636e\u3002", (String)"PayInfoChgList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"save".equals(key)) {
            if (!"submit".equals(key)) return;
        }
        Object[] ids = lstCollection.getPrimaryKeyValues();
        DynamicObject[] paychgbills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paychgbill"));
        StringBuilder errorMsg = new StringBuilder();
        DynamicObject[] dynamicObjectArray = paychgbills;
        int n = dynamicObjectArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (!EmptyUtil.isNotEmpty((String)errorMsg.toString())) return;
                args.setCancel(true);
                this.getView().showTipNotification(errorMsg.toString());
                return;
            }
            DynamicObject paychgbill = dynamicObjectArray[n2];
            boolean ischange = PayInfoChgHelper.payInfoChanged((DynamicObject)paychgbill);
            if (!ischange) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"%s \uff1a\u652f\u4ed8\u4fe1\u606f\u65e0\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PayInfoChgList_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), paychgbill.getString("billno"))).append("\n");
            }
            ++n2;
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (KEY_CHANGECHG_CALLBACK.equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
            Map data = (Map)e.getReturnData();
            if (null != data && null != data.get("messageId")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u4ea4\u6210\u529f", (String)"PayInfoChgList_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection lstCollection = list.getSelectedRows();
        Object id = lstCollection.get(0).getPrimaryKeyValue();
        DynamicObject paychgbill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paychgbill", (String)"id,chgtype,billstatus,sourcebillid,sourcetype");
        String key = evt.getFieldName();
        if ("sourcebillno".equals(key)) {
            evt.setCancel(true);
            QFilter billno = new QFilter("id", "=", paychgbill.get("sourcebillid"));
            String billType = paychgbill.getString("sourcetype");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)billType, (String)"id", (QFilter[])new QFilter[]{billno});
            if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u4ed8\u6b3e\u5355\u6570\u636e\u672a\u627e\u5230,\u8bf7\u68c0\u67e5\u8be5\u4ed8\u6b3e\u5355\u662f\u5426\u88ab\u5220\u9664.", (String)"ClaimNoticeEditPlugin_2_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(billType);
                showParameter.setPkId(paychgbill.get("sourcebillid"));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long id = (Long)e.getParameter().getPkId();
        DynamicObject paychgbill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paychgbill", (String)"id,chgtype,sourcetype");
        if (ChgTypeEnum.RECCHG.getValue().equals(paychgbill.getString("chgtype"))) {
            if (paychgbill.getString("sourcetype").equals("cas_payapplybill")) {
                e.getParameter().setFormId("cas_paychgbill_payapply");
            } else {
                e.getParameter().setFormId("cas_paychgbill_recchg");
            }
        } else {
            e.getParameter().setFormId("cas_paychgbill_paychg");
        }
        super.beforeShowBill(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }
}

