/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.common;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.util.FormUtils;

public abstract class CasBillEdit
extends BillEditPlugin {
    protected static final String CONFIRM_DELBOTP_CALLBACK = "CONFIRM_DELBOTP_CALLBACK";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"hide"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (("save".equals(operateKey) || "submit".equals(operateKey) || "beforesubmit".equals(operateKey)) && ("cas_recbill".equals(formId) || "cas_paybill".equals(formId) || "cas_agentpaybill".equals(formId) || "cas_paybill_synonym".equals(formId) || "cas_paybill_dcep".equals(formId))) {
            DynamicObject[] bizBills;
            if ("cas_paybill_synonym".equals(formId) || "cas_paybill_dcep".equals(formId)) {
                formId = "cas_paybill";
            }
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter idQf = new QFilter("id", "=", pkValue);
            Set propertys = EntityPropertyHelper.getPropertys((String)formId);
            String fileds = propertys.stream().reduce((a, b) -> a + ',' + b).orElse("id");
            if ("cas_agentpaybill".equals(formId)) {
                fileds = fileds + "entry,entry.entrymatchflag";
            }
            if ((bizBills = BusinessDataServiceHelper.load((String)formId, (String)fileds, (QFilter[])new QFilter[]{idQf})).length < 1) {
                return;
            }
            DynamicObject bizBill = bizBills[0];
            DynamicObject oldcurrency = bizBill.getDynamicObject("currency");
            DynamicObject newcurrency = (DynamicObject)this.getModel().getValue("currency");
            Boolean changed = HandLinkBillHelper.recognitionBillChange((DynamicObject)newcurrency, (DynamicObject)oldcurrency);
            boolean changedMatchBool = false;
            switch (formId) {
                case "cas_recbill": {
                    changedMatchBool = this.recBillChange(bizBill, changed);
                    break;
                }
                case "cas_paybill": {
                    changedMatchBool = this.payBillChange(bizBill, changed);
                    break;
                }
                case "cas_agentpaybill": {
                    changedMatchBool = this.agentBillChange(bizBill, changed);
                }
            }
            if (changedMatchBool) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u5df2\u5339\u914d\u4e86\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u53f7\u3001\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u3001\u91d1\u989d\u7b49\u5173\u952e\u4fe1\u606f\u3002", (String)"CasBillEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (callBackId.startsWith("ConfirmForEmptyRow")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.setIgnoreEmptyRow(true);
                String entryAmountField = this.getPageCache().get(callBackId);
                if (entryAmountField != null) {
                    FormUtils.deleteEmptyRows((IDataModel)this.getModel(), (String[])new String[]{entryAmountField});
                    this.getPageCache().remove(callBackId);
                    String operateKey = callBackId.split("[.]")[1];
                    this.getView().invokeOperation(operateKey, this.getOperteOption(operateKey));
                    this.setIgnoreEmptyRow(false);
                }
            }
        } else if (StringUtils.equals((CharSequence)callBackId, (CharSequence)CONFIRM_DELBOTP_CALLBACK) && ("cas_recbill".equals(formId) || "cas_paybill".equals(formId) || "cas_agentpaybill".equals(formId) || "cas_paybill_synonym".equals(formId)) && MessageBoxResult.Yes.equals((Object)res)) {
            String handlink = this.getPageCache().get("handlink");
            String matchlink = this.getPageCache().get("matchlink");
            HandLinkBillHelper.dealHandLinkAndMatchAndAccount((String)handlink, (String)matchlink, (String)("cas_paybill_synonym".equals(formId) ? "cas_paybill" : formId), (Object)this.getModel().getDataEntity().getPkValue());
            this.getView().invokeOperation("save");
        }
    }

    protected void setIgnoreEmptyRow(boolean ignore) {
        this.getPageCache().put("IgnoreEmptyRow", String.valueOf(ignore));
    }

    protected boolean ignoreEmptyRow() {
        String value = this.getPageCache().get("IgnoreEmptyRow");
        return value != null && Boolean.parseBoolean(value);
    }

    protected OperateOption getOperteOption(String operateKey) {
        return OperateOption.create();
    }

    protected boolean isBotpNew() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return this.isBotpCreate() && CasHelper.isEmpty((Object)billShowParameter.getPkId());
    }

    protected boolean isBotpCreate() {
        String sourceBillType = this.getString("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }

    protected void setSettlementTypeFilter() {
        BasedataEdit settletypeF7 = (BasedataEdit)this.getControl("settletype");
        settletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (kd.fi.cas.util.StringUtils.isNotEmpty((String)this.getControlBankAcctForSettleType())) {
                DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue(this.getControlBankAcctForSettleType());
                if (payerAcctBank != null) {
                    DynamicObjectCollection settlementypes = payerAcctBank.getDynamicObjectCollection("settlementtype");
                    if (settlementypes != null && settlementypes.size() > 0) {
                        HashSet<Long> idSet = new HashSet<Long>();
                        for (DynamicObject settlementype : settlementypes) {
                            idSet.add(((DynamicObject)settlementype.get("fbasedataid")).getLong("id"));
                        }
                        QFilter qFilter = new QFilter("id", "in", idSet);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    }
                } else {
                    showParameter.getListFilterParameter().setFilter(null);
                }
            }
        });
    }

    protected void setVirtualSettlementTypeFilter() {
        BasedataEdit settletypeF7 = (BasedataEdit)this.getControl("settletype");
        settletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (kd.fi.cas.util.StringUtils.isNotEmpty((String)this.getControlBankAcctForSettleType())) {
                DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue(this.getControlBankAcctForSettleType());
                if (payerAcctBank != null) {
                    DynamicObjectCollection settlementypes = payerAcctBank.getDynamicObjectCollection("settlementtype");
                    if (settlementypes != null && settlementypes.size() > 0) {
                        HashSet<Long> idSet = new HashSet<Long>();
                        for (DynamicObject settlementype : settlementypes) {
                            idSet.add(((DynamicObject)settlementype.get("fbasedataid")).getLong("id"));
                        }
                        QFilter qFilter = new QFilter("id", "in", idSet);
                        qFilter.and(new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.VIRTUAL.getValue()));
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    }
                } else {
                    QFilter filter = new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.VIRTUAL.getValue());
                    showParameter.getListFilterParameter().setFilter(filter);
                }
            }
        });
    }

    private boolean recBillChange(DynamicObject bizBill, Boolean changed) {
        BigDecimal oldctrecamt;
        BigDecimal newactrecamt = (BigDecimal)this.getModel().getValue("actrecamt");
        Boolean recamount = HandLinkBillHelper.recognitionBillChange((BigDecimal)newactrecamt, (BigDecimal)(oldctrecamt = bizBill.getBigDecimal("actrecamt")));
        if (recamount.booleanValue()) {
            changed = recamount;
        }
        Boolean acctChange = this.compareDynamicObjectId(bizBill, "accountbank");
        String matchFlag = bizBill.getString("matchflag");
        return (changed != false || acctChange != false) && !AutoMatchFlagEnum.NONE.getValue().equals(matchFlag) && !AutoMatchFlagEnum.NONEED.getValue().equals(matchFlag);
    }

    private boolean payBillChange(DynamicObject bizBill, Boolean changed) {
        BigDecimal newactpayamt = (BigDecimal)this.getModel().getValue("dpamt");
        BigDecimal newFee = (BigDecimal)this.getModel().getValue("fee");
        newactpayamt = newactpayamt.add(newFee);
        BigDecimal oldctrecamt = bizBill.getBigDecimal("dpamt");
        BigDecimal oldFee = bizBill.getBigDecimal("fee");
        Boolean payamount = HandLinkBillHelper.recognitionBillChange((BigDecimal)newactpayamt, (BigDecimal)(oldctrecamt = oldctrecamt.add(oldFee)));
        if (payamount.booleanValue()) {
            changed = payamount;
        }
        Boolean orgChange = this.compareDynamicObjectId(bizBill, "org");
        Boolean acctChange = this.compareDynamicObjectId(bizBill, "payeracctbank");
        Boolean isChange = Boolean.FALSE;
        if (changed.booleanValue() || orgChange.booleanValue() || acctChange.booleanValue()) {
            isChange = Boolean.TRUE;
        }
        String matchFlag = bizBill.getString("matchflag");
        return isChange != false && !AutoMatchFlagEnum.NONE.getValue().equals(matchFlag) && !AutoMatchFlagEnum.NONEED.getValue().equals(matchFlag);
    }

    private boolean agentBillChange(DynamicObject bizBill, Boolean changed) {
        BigDecimal oldctrecamt;
        BigDecimal newpayamount = (BigDecimal)this.getModel().getValue("payamount");
        Boolean agentamount = HandLinkBillHelper.recognitionBillChange((BigDecimal)newpayamount, (BigDecimal)(oldctrecamt = bizBill.getBigDecimal("payamount")));
        if (agentamount.booleanValue()) {
            changed = agentamount;
        }
        Boolean orgChange = this.compareDynamicObjectId(bizBill, "openorg");
        Boolean acctChange = this.compareDynamicObjectId(bizBill, "payeracctbank");
        Boolean isChange = Boolean.FALSE;
        if (changed.booleanValue() || orgChange.booleanValue() || acctChange.booleanValue()) {
            isChange = Boolean.TRUE;
        }
        return isChange != false && AgentPayBillHelper.isMatched((DynamicObject)bizBill);
    }

    private Boolean compareDynamicObjectId(DynamicObject bizBill, String propertyName) {
        Boolean isChange = Boolean.FALSE;
        DynamicObject openOrg = (DynamicObject)this.getModel().getValue(propertyName);
        DynamicObject oldOrg = bizBill.getDynamicObject(propertyName);
        long newId = 0L;
        long oldId = 0L;
        if (openOrg != null) {
            newId = openOrg.getLong("id");
        }
        if (oldOrg != null) {
            oldId = oldOrg.getLong("id");
        }
        if (newId != oldId) {
            isChange = Boolean.TRUE;
        }
        return isChange;
    }

    protected String getControlBankAcctForSettleType() {
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("hide".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_dcepinfo"});
        }
    }
}

