/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public abstract class CasCommonFilterListPlugin
extends AbstractListPlugin {
    protected List<Object> selectedOrgIdList = new ArrayList<Object>();
    protected List<Object> selectedAcctIdList = new ArrayList<Object>();
    protected DynamicObject[] acctsShow;
    private FilterContainerInitArgs initArgs;
    protected boolean isSearchClick;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        if (this.getPageCache().get("isPageOpen") == null) {
            this.getPageCache().put("isPageOpen", "true");
            this.cacheFirstSelectedOrg(args);
            this.initFilterItems(args);
        } else if (this.isSearchClick) {
            this.initFilterItems(args);
        }
    }

    protected void initFilterItems(FilterContainerInitArgs args) {
        if (this.selectedOrgIdList.size() < 1) {
            this.selectedOrgIdList.addAll(this.getAllOrgIdList(args));
        }
        this.acctsShow = this.getAcctsShowByOrg(this.selectedOrgIdList);
        List<ComboItem> acctItems = this.getAcctItems();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List listcomitem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (this.isOrgFilterColumn(fieldName)) {
                commonFilterColumn.setDefaultValue("");
            }
            if (!"accountbank.acctstatus".equals(fieldName) && this.isBankAccountFilterColumn(commonFilterColumn.getFieldName())) {
                if (!this.isSearchClick) {
                    acctItems = this.getAllAcctItems(args);
                }
                listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                commonFilterColumn.setComboItems(acctItems);
                commonFilterColumn.setDefValue("");
            }
            if (fieldName.startsWith("accountcash.")) {
                listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                commonFilterColumn.setComboItems(acctItems);
                commonFilterColumn.setDefValue("");
            }
            if (!fieldName.startsWith("currency.")) continue;
            List<ComboItem> currencyItems = this.getCurrencyItems();
            List listcomitem2 = commonFilterColumn.getComboItems();
            listcomitem2.clear();
            commonFilterColumn.setComboItems(currencyItems);
            commonFilterColumn.setDefValue("");
        }
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        String firstOrgId = null;
        if (this.isDefaultOpen()) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                List orgItems;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!this.isOrgFilterColumn(commonFilterColumn.getFieldName()) || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
                String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                for (int i = 0; i < orgItems.size(); ++i) {
                    ComboItem item = (ComboItem)orgItems.get(i);
                    if (!item.getValue().equals(loginOrg)) continue;
                    firstOrgId = loginOrg;
                    break;
                }
                if (firstOrgId != null) continue;
                List defaultVals = commonFilterColumn.getDefaultValues();
                if (defaultVals != null && defaultVals.size() > 0) {
                    firstOrgId = (String)defaultVals.get(0);
                    continue;
                }
                firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
            }
        } else {
            firstOrgId = this.getView().getFormShowParameter().getCustomParam("org.id").toString();
        }
        if (firstOrgId != null) {
            this.selectedOrgIdList.add(firstOrgId);
        }
        this.cacheSelectedOrgIdList(this.selectedOrgIdList);
        this.getPageCache().put("org.id", firstOrgId);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isSearchClick = true;
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            this.cacheCommonFilter(this.getPageCache(), args.getSearchClickEvent());
            this.filterContainerInit(this.initArgs);
        }
    }

    protected List<Long> getAllOrgIdList(FilterContainerInitArgs args) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!this.isOrgFilterColumn(commonFilterColumn.getFieldName())) continue;
            List orgItems = commonFilterColumn.getComboItems();
            for (int i = 0; i < orgItems.size(); ++i) {
                ComboItem item = (ComboItem)orgItems.get(i);
                if (item.getValue().equals("")) continue;
                orgIdList.add(Long.valueOf(item.getValue()));
            }
        }
        return orgIdList;
    }

    protected boolean isBankAccountFilterColumn(String filterColumnName) {
        return (filterColumnName.startsWith("accountbank.") || filterColumnName.startsWith("bankaccount.")) && this.containsOnePoint(filterColumnName);
    }

    private boolean containsOnePoint(String filterColumnName) {
        int count = 0;
        for (int i = 0; i < filterColumnName.length() && (filterColumnName.charAt(i) != '.' || ++count <= 1); ++i) {
        }
        return count <= 1;
    }

    protected boolean isOrgFilterColumn(String filterColumnName) {
        return filterColumnName.startsWith("org.");
    }

    protected List<ComboItem> getAcctItems() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (this.acctsShow != null && this.acctsShow.length > 0) {
            for (int i = 0; i < this.acctsShow.length; ++i) {
                DynamicObject cashAcct = this.acctsShow[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("name")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(""), "0"));
        }
        return acctItems;
    }

    protected List<ComboItem> getAllAcctItems(FilterContainerInitArgs args) {
        ComboItem item;
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List orgItems;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!this.isOrgFilterColumn(commonFilterColumn.getFieldName()) || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
            for (int i = 0; i < orgItems.size(); ++i) {
                item = (ComboItem)orgItems.get(i);
                orgIdList.add(Long.parseLong(item.getValue()));
            }
        }
        QFilter[] accountFilter = AccountBankHelper.getAccountFilter(orgIdList);
        if ("bd_accountbanks".equals(this.getAcctEntity())) {
            ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
            Collections.addAll(qFilterArrayList, accountFilter);
            qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        }
        DynamicObject[] acctsData = BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,number,ismulcurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])accountFilter);
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (acctsData != null && acctsData.length > 0) {
            for (int i = 0; i < acctsData.length; ++i) {
                DynamicObject cashAcct = acctsData[i];
                item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("name")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(""), "0"));
        }
        return acctItems;
    }

    protected List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currencyItems = new ArrayList<ComboItem>();
        DynamicObject[] coll = null;
        coll = this.selectedAcctIdList.isEmpty() ? this.acctsShow : this.getAcctsShow(this.selectedAcctIdList);
        if (coll != null && coll.length > 0) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject cashAcct = coll[i];
                if ("cas_accountcash".equals(cashAcct.getDataEntityType().getName())) continue;
                if (!cashAcct.getBoolean("ismulcurrency")) {
                    DynamicObject defaultCurrency = cashAcct.getDynamicObject("defaultcurrency");
                    if (defaultCurrency == null) continue;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(defaultCurrency.getString("name")));
                    item.setValue(defaultCurrency.getString("id"));
                    if (currencyItems.contains(item)) continue;
                    currencyItems.add(item);
                    continue;
                }
                DynamicObjectCollection currencyList = cashAcct.getDynamicObjectCollection("currency");
                if (currencyList.size() <= 0) continue;
                for (DynamicObject currency : currencyList) {
                    ComboItem item = new ComboItem();
                    if (!EmptyUtil.isNoEmpty((DynamicObject)currency.getDynamicObject("fbasedataid"))) continue;
                    item.setCaption(new LocaleString(currency.getDynamicObject("fbasedataid").getString("name")));
                    item.setValue(currency.getDynamicObject("fbasedataid").getString("id"));
                    if (currencyItems.contains(item)) continue;
                    currencyItems.add(item);
                }
            }
        } else {
            currencyItems.add(new ComboItem(new LocaleString(""), "0"));
        }
        return currencyItems;
    }

    private void cacheCommonFilter(IPageCache pageCache, SearchClickEvent searchClickEvent) {
        if (pageCache != null && searchClickEvent.getFilterValues() != null) {
            this.selectedOrgIdList.clear();
            this.selectedAcctIdList.clear();
            pageCache.remove("org.id");
            Map orgFilter = null;
            Map acctFilter = null;
            List customfilter = (List)searchClickEvent.getFilterValues().get("customfilter");
            if (customfilter != null) {
                for (Map filteritem : customfilter) {
                    String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                    List item = (List)filteritem.get("Value");
                    if (this.isOrgFilterColumn(fieldName)) {
                        orgFilter = filteritem;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        String fieldValue = item.get(0).toString();
                        pageCache.put(fieldName, fieldValue);
                        this.selectedOrgIdList = item;
                        continue;
                    }
                    if ("accountbank.acctstatus".equals(fieldName) || !this.isBankAccountFilterColumn(fieldName)) continue;
                    acctFilter = filteritem;
                    if (item.isEmpty() || "".equals(item.get(0))) continue;
                    this.selectedAcctIdList = item;
                }
                if (orgFilter == null) {
                    if (this.getCachedOrgList() != null) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList(null);
                } else {
                    List values = (List)orgFilter.get("Value");
                    List cacheOrg = CollectionUtils.isEmpty(this.getCachedOrgList()) ? Collections.emptyList() : this.getCachedOrgList().stream().filter(v -> null != v && !v.toString().equals("")).collect(Collectors.toList());
                    List orgs = values.stream().filter(v -> null != v && !v.toString().equals("")).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(cacheOrg) && !cacheOrg.equals(orgs)) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList(values);
                }
            }
        }
    }

    protected void orgCommonFilterChange(Map<String, List<Object>> acctFilter) {
        if (acctFilter != null) {
            ArrayList<String> acctList = new ArrayList<String>();
            acctList.add("");
            acctFilter.put("Value", acctList);
            this.selectedAcctIdList.clear();
        }
    }

    protected DynamicObject[] getAcctsShowByOrg(List<Object> selectedOrgIdList) {
        DynamicObject[] acctsShow = null;
        List orgPks = selectedOrgIdList.stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
        if ("cas_accountcash".equals(this.getAcctEntity())) {
            acctsShow = BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,number,isbycurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])new QFilter[]{new QFilter("org", "in", orgPks)});
        } else {
            String billType = ((AbstractListView)this.getView()).getEntityTypeId();
            QFilter[] accountFilter = null;
            if (billType.equals("cas_bankvccheck") || billType.equals("cas_bankstatement")) {
                QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg(orgPks);
                accountFilter = new QFilter[]{accountAuthAssignFilter};
            } else {
                accountFilter = AccountBankHelper.getAccountFilterForOwn(orgPks);
            }
            if ("bd_accountbanks".equals(this.getAcctEntity())) {
                ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
                Collections.addAll(qFilterArrayList, accountFilter);
                qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
            }
            acctsShow = BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,number,ismulcurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])accountFilter);
        }
        return acctsShow;
    }

    protected DynamicObject[] getAcctsShow(Collection<Object> acctIds) {
        DynamicObject[] acctsShow = null;
        if (acctIds != null && acctIds.size() > 0) {
            List<Long> acctIdsNew = acctIds.stream().map(o -> Long.parseLong(String.valueOf(o).trim())).collect(Collectors.toList());
            acctsShow = "cas_accountcash".equals(this.getAcctEntity()) ? BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,number,isbycurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])this.getAcctFilter(acctIdsNew)) : BusinessDataServiceHelper.load((String)this.getAcctEntity(), (String)"id,name,acctname,number,ismulcurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])this.getAcctFilter(acctIdsNew));
        }
        return acctsShow;
    }

    protected QFilter[] getAcctFilter(List<Long> acctIds) {
        return new QFilter[]{new QFilter("id", "in", acctIds)};
    }

    protected void cacheSelectedOrgIdList(List<Object> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    protected boolean isDefaultOpen() {
        ListShowParameter parameters = (ListShowParameter)this.getView().getFormShowParameter();
        return parameters.getCustomParam("setDefaultFilters") == null;
    }

    protected abstract String getAcctEntity();

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        String refEntityId = args.getRefEntityId();
        if ("bd_accountbanks".equals(refEntityId) || "cas_accountcash".equals(refEntityId)) {
            String orgIdsStr = this.getPageCache().get("selectedOrgIdList");
            if (orgIdsStr != null && !"[\"\"]".equals(orgIdsStr)) {
                List orgIds = (List)SerializationUtils.fromJsonString((String)orgIdsStr, List.class);
                List orgIdList = orgIds.stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
                args.getQfilters().add(new QFilter("org", "in", orgIdList));
            } else {
                ListShowParameter listParam = (ListShowParameter)this.getView().getFormShowParameter();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)listParam.getBillFormId(), (String)"47150e89000000ac");
                args.getQfilters().add(new QFilter("org", "in", (Object)orgIds));
            }
        }
        if (StringUtils.startsWith((CharSequence)(fieldName = args.getFieldName()), (CharSequence)"accountbank")) {
            args.getQfilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        args.getQFilters();
    }
}

